/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.time.TimeZones;

abstract class AbstractFormatCache<F extends Format> {
    static final int NONE = -1;
    private static final ConcurrentMap<ArrayKey, String> cDateTimeInstanceCache = new ConcurrentHashMap<ArrayKey, String>(7);
    private final ConcurrentMap<ArrayKey, F> cInstanceCache = new ConcurrentHashMap<ArrayKey, F>(7);

    AbstractFormatCache() {
    }

    /*
     * WARNING - void declaration
     */
    static String getPatternForStyle(Integer dateStyle, Integer timeStyle, Locale locale) {
        void var2_2;
        void var1_1;
        Integer n2;
        void var3_3;
        Locale safeLocale = LocaleUtils.toLocale(locale);
        ArrayKey key = new ArrayKey(dateStyle, timeStyle, safeLocale);
        return cDateTimeInstanceCache.computeIfAbsent((ArrayKey)var3_3, arg_0 -> AbstractFormatCache.lambda$getPatternForStyle$0(n2, (Integer)var1_1, (Locale)var2_2, arg_0));
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    /*
     * WARNING - void declaration
     */
    F getDateInstance(int dateStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance((Integer)((int)var1_1), null, (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    F getDateTimeInstance(int dateStyle, int timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance((Integer)((int)var1_1), (Integer)((int)var2_2), (TimeZone)var3_3, locale);
    }

    /*
     * WARNING - void declaration
     */
    private F getDateTimeInstance(Integer dateStyle, Integer timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var1_1;
        void var2_2;
        locale = LocaleUtils.toLocale(locale);
        String pattern = AbstractFormatCache.getPatternForStyle(dateStyle, (Integer)var2_2, locale);
        return this.getInstance((String)var1_1, (TimeZone)var3_3, locale);
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public F getInstance(String pattern, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(pattern, "pattern");
        TimeZone actualTimeZone = TimeZones.toTimeZone(timeZone);
        Locale actualLocale = LocaleUtils.toLocale(locale);
        ArrayKey key = new ArrayKey(pattern, actualTimeZone, actualLocale);
        return (F)this.cInstanceCache.computeIfAbsent(key, arg_0 -> this.lambda$getInstance$1((String)var1_1, (TimeZone)var2_2, (Locale)var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    F getTimeInstance(int timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance(null, (Integer)((int)var1_1), (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Format lambda$getInstance$1(String pattern, TimeZone actualTimeZone, Locale actualLocale, ArrayKey k2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.createInstance((String)var1_1, (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ String lambda$getPatternForStyle$0(Integer dateStyle, Integer timeStyle, Locale safeLocale, ArrayKey k2) {
        try {
            Serializable serializable;
            void var1_1;
            Serializable formatter;
            formatter = dateStyle == null ? DateFormat.getTimeInstance(timeStyle, safeLocale) : (timeStyle == null ? DateFormat.getDateInstance(formatter, safeLocale) : DateFormat.getDateTimeInstance(formatter, var1_1.intValue(), safeLocale));
            return ((SimpleDateFormat)serializable).toPattern();
        }
        catch (ClassCastException classCastException) {
            void var2_2;
            throw new IllegalArgumentException("No date time pattern for locale: " + var2_2);
        }
    }

    private static final class ArrayKey {
        private final Object[] keys;
        private final int hashCode;

        private static int computeHashCode(Object[] result) {
            Object[] objectArray;
            int n2 = 31 + Arrays.hashCode(objectArray);
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        ArrayKey(Object ... keys2) {
            void var1_1;
            this.keys = keys2;
            this.hashCode = ArrayKey.computeHashCode((Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayKey other = (ArrayKey)obj;
            return Arrays.deepEquals(this.keys, var1_1.keys);
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

