/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrMatcher;

@Deprecated
public class StrTokenizer
implements Cloneable,
ListIterator<String> {
    private static final StrTokenizer CSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
    private static final StrTokenizer TSV_TOKENIZER_PROTOTYPE;
    private char[] chars;
    private String[] tokens;
    private int tokenPos;
    private StrMatcher delimMatcher = StrMatcher.splitMatcher();
    private StrMatcher quoteMatcher = StrMatcher.noneMatcher();
    private StrMatcher ignoredMatcher = StrMatcher.noneMatcher();
    private StrMatcher trimmerMatcher = StrMatcher.noneMatcher();
    private boolean emptyAsNull;
    private boolean ignoreEmptyTokens = true;

    private static StrTokenizer getCSVClone() {
        return (StrTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getCSVInstance() {
        return StrTokenizer.getCSVClone();
    }

    /*
     * WARNING - void declaration
     */
    public static StrTokenizer getCSVInstance(char[] input) {
        void var1_1;
        char[] cArray;
        StrTokenizer tok = StrTokenizer.getCSVClone();
        tok.reset(cArray);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static StrTokenizer getCSVInstance(String input) {
        void var1_1;
        String string;
        StrTokenizer tok = StrTokenizer.getCSVClone();
        tok.reset(string);
        return var1_1;
    }

    private static StrTokenizer getTSVClone() {
        return (StrTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getTSVInstance() {
        return StrTokenizer.getTSVClone();
    }

    /*
     * WARNING - void declaration
     */
    public static StrTokenizer getTSVInstance(char[] input) {
        void var1_1;
        char[] cArray;
        StrTokenizer tok = StrTokenizer.getTSVClone();
        tok.reset(cArray);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static StrTokenizer getTSVInstance(String input) {
        void var1_1;
        String string;
        StrTokenizer tok = StrTokenizer.getTSVClone();
        tok.reset(string);
        return var1_1;
    }

    public StrTokenizer() {
        this.chars = null;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(char[] input) {
        void var1_1;
        this.chars = ArrayUtils.clone((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(char[] input, char delim) {
        this((char[])var1_1);
        void var2_2;
        void var1_1;
        this.setDelimiterChar((char)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(char[] input, char delim, char quote) {
        this((char[])var1_1, (char)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setQuoteChar((char)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(char[] input, String delim) {
        this((char[])var1_1);
        void var2_2;
        void var1_1;
        this.setDelimiterString((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(char[] input, StrMatcher delim) {
        this((char[])var1_1);
        void var2_2;
        void var1_1;
        this.setDelimiterMatcher((StrMatcher)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(char[] input, StrMatcher delim, StrMatcher quote) {
        this((char[])var1_1, (StrMatcher)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setQuoteMatcher((StrMatcher)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(String input) {
        if (input != null) {
            void var1_1;
            this.chars = var1_1.toCharArray();
            return;
        }
        this.chars = null;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(String input, char delim) {
        this((String)var1_1);
        void var2_2;
        void var1_1;
        this.setDelimiterChar((char)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(String input, char delim, char quote) {
        this((String)var1_1, (char)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setQuoteChar((char)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(String input, String delim) {
        this((String)var1_1);
        void var2_2;
        void var1_1;
        this.setDelimiterString((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(String input, StrMatcher delim) {
        this((String)var1_1);
        void var2_2;
        void var1_1;
        this.setDelimiterMatcher((StrMatcher)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer(String input, StrMatcher delim, StrMatcher quote) {
        this((String)var1_1, (StrMatcher)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setQuoteMatcher((StrMatcher)var3_3);
    }

    @Override
    public void add(String obj) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    /*
     * WARNING - void declaration
     */
    private void addToken(List<String> list, String tok) {
        void var2_2;
        void var1_1;
        if (StringUtils.isEmpty(tok)) {
            if (this.isIgnoreEmptyTokens()) {
                return;
            }
            if (this.isEmptyTokenAsNull()) {
                tok = null;
            }
        }
        var1_1.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void checkTokenized() {
        if (this.tokens == null) {
            void var1_2;
            if (this.chars == null) {
                List<String> split = this.tokenize(null, 0, 0);
                this.tokens = split.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
                return;
            }
            StrTokenizer strTokenizer = this;
            List<String> split = strTokenizer.tokenize(strTokenizer.chars, 0, this.chars.length);
            this.tokens = var1_2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }
    }

    public Object clone() {
        try {
            return this.cloneReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    Object cloneReset() throws CloneNotSupportedException {
        void var1_1;
        StrTokenizer cloned = (StrTokenizer)super.clone();
        if (cloned.chars != null) {
            cloned.chars = (char[])cloned.chars.clone();
        }
        cloned.reset();
        return var1_1;
    }

    public String getContent() {
        if (this.chars == null) {
            return null;
        }
        return new String(this.chars);
    }

    public StrMatcher getDelimiterMatcher() {
        return this.delimMatcher;
    }

    public StrMatcher getIgnoredMatcher() {
        return this.ignoredMatcher;
    }

    public StrMatcher getQuoteMatcher() {
        return this.quoteMatcher;
    }

    public String[] getTokenArray() {
        this.checkTokenized();
        return (String[])this.tokens.clone();
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getTokenList() {
        void var1_1;
        this.checkTokenized();
        ArrayList<String> list = new ArrayList<String>(this.tokens.length);
        list.addAll(Arrays.asList(this.tokens));
        return var1_1;
    }

    public StrMatcher getTrimmerMatcher() {
        return this.trimmerMatcher;
    }

    @Override
    public boolean hasNext() {
        this.checkTokenized();
        return this.tokenPos < this.tokens.length;
    }

    @Override
    public boolean hasPrevious() {
        this.checkTokenized();
        return this.tokenPos > 0;
    }

    public boolean isEmptyTokenAsNull() {
        return this.emptyAsNull;
    }

    public boolean isIgnoreEmptyTokens() {
        return this.ignoreEmptyTokens;
    }

    private boolean isQuote(char[] srcChars, int pos, int len, int quoteStart, int quoteLen) {
        for (int i2 = 0; i2 < quoteLen; ++i2) {
            if (pos + i2 < len && srcChars[pos + i2] == srcChars[quoteStart + i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.tokenPos;
    }

    public String nextToken() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        return null;
    }

    @Override
    public String previous() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.tokenPos - 1;
    }

    public String previousToken() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int readNextToken(char[] srcChars, int start, int len, StrBuilder workArea, List<String> tokenList) {
        void var3_3;
        void var2_2;
        void var1_1;
        while (start < len) {
            int n2 = start;
            int n3 = start;
            int removeLen = Math.max(this.getIgnoredMatcher().isMatch(srcChars, n2, n2, len), this.getTrimmerMatcher().isMatch(srcChars, n3, n3, len));
            if (removeLen == 0) break;
            int n4 = start;
            if (this.getDelimiterMatcher().isMatch(srcChars, n4, n4, len) > 0) break;
            int n5 = start;
            if (this.getQuoteMatcher().isMatch(srcChars, n5, n5, len) > 0) break;
            start += removeLen;
        }
        if (start >= len) {
            this.addToken(tokenList, "");
            return -1;
        }
        int n6 = start;
        int delimLen = this.getDelimiterMatcher().isMatch(srcChars, n6, n6, len);
        if (delimLen > 0) {
            this.addToken(tokenList, "");
            return start + delimLen;
        }
        int n7 = start;
        int quoteLen = this.getQuoteMatcher().isMatch(srcChars, n7, n7, len);
        if (quoteLen > 0) {
            return this.readWithQuotes(srcChars, start + quoteLen, len, workArea, tokenList, start, quoteLen);
        }
        return this.readWithQuotes((char[])var1_1, (int)var2_2, (int)var3_3, workArea, tokenList, 0, 0);
    }

    private int readWithQuotes(char[] srcChars, int start, int len, StrBuilder workArea, List<String> tokenList, int quoteStart, int quoteLen) {
        workArea.clear();
        int pos = start;
        boolean quoting = quoteLen > 0;
        int trimStart = 0;
        while (pos < len) {
            if (quoting) {
                if (this.isQuote(srcChars, pos, len, quoteStart, quoteLen)) {
                    if (this.isQuote(srcChars, pos + quoteLen, len, quoteStart, quoteLen)) {
                        workArea.append(srcChars, pos, quoteLen);
                        pos += quoteLen << 1;
                        trimStart = workArea.size();
                        continue;
                    }
                    quoting = false;
                    pos += quoteLen;
                    continue;
                }
            } else {
                int delimLen = this.getDelimiterMatcher().isMatch(srcChars, pos, start, len);
                if (delimLen > 0) {
                    this.addToken(tokenList, workArea.substring(0, trimStart));
                    return pos + delimLen;
                }
                if (quoteLen > 0 && this.isQuote(srcChars, pos, len, quoteStart, quoteLen)) {
                    quoting = true;
                    pos += quoteLen;
                    continue;
                }
                int ignoredLen = this.getIgnoredMatcher().isMatch(srcChars, pos, start, len);
                if (ignoredLen > 0) {
                    pos += ignoredLen;
                    continue;
                }
                int trimmedLen = this.getTrimmerMatcher().isMatch(srcChars, pos, start, len);
                if (trimmedLen > 0) {
                    workArea.append(srcChars, pos, trimmedLen);
                    pos += trimmedLen;
                    continue;
                }
            }
            workArea.append(srcChars[pos++]);
            trimStart = workArea.size();
        }
        this.addToken(tokenList, workArea.substring(0, trimStart));
        return -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    public StrTokenizer reset() {
        this.tokenPos = 0;
        this.tokens = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer reset(char[] input) {
        void var1_1;
        this.reset();
        this.chars = ArrayUtils.clone((char[])var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer reset(String input) {
        void var1_1;
        this.reset();
        this.chars = (char[])(input != null ? var1_1.toCharArray() : null);
        return this;
    }

    @Override
    public void set(String obj) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setDelimiterChar(char delim) {
        void var1_1;
        return this.setDelimiterMatcher(StrMatcher.charMatcher((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setDelimiterMatcher(StrMatcher delim) {
        void var1_1;
        this.delimMatcher = delim == null ? StrMatcher.noneMatcher() : var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setDelimiterString(String delim) {
        void var1_1;
        return this.setDelimiterMatcher(StrMatcher.stringMatcher((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setEmptyTokenAsNull(boolean emptyAsNull) {
        void var1_1;
        this.emptyAsNull = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setIgnoredChar(char ignored) {
        void var1_1;
        return this.setIgnoredMatcher(StrMatcher.charMatcher((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setIgnoredMatcher(StrMatcher ignored) {
        if (ignored != null) {
            void var1_1;
            this.ignoredMatcher = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setIgnoreEmptyTokens(boolean ignoreEmptyTokens) {
        void var1_1;
        this.ignoreEmptyTokens = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setQuoteChar(char quote) {
        void var1_1;
        return this.setQuoteMatcher(StrMatcher.charMatcher((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setQuoteMatcher(StrMatcher quote) {
        if (quote != null) {
            void var1_1;
            this.quoteMatcher = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrTokenizer setTrimmerMatcher(StrMatcher trimmer) {
        if (trimmer != null) {
            void var1_1;
            this.trimmerMatcher = var1_1;
        }
        return this;
    }

    public int size() {
        this.checkTokenized();
        return this.tokens.length;
    }

    protected List<String> tokenize(char[] srcChars, int offset, int count) {
        int pos;
        if (ArrayUtils.isEmpty(srcChars)) {
            return Collections.emptyList();
        }
        StrBuilder buf = new StrBuilder();
        ArrayList<String> tokenList = new ArrayList<String>();
        while (pos >= 0 && pos < count) {
            if ((pos = this.readNextToken(srcChars, pos, count, buf, tokenList)) < count) continue;
            this.addToken(tokenList, "");
        }
        return tokenList;
    }

    public String toString() {
        if (this.tokens == null) {
            return "StrTokenizer[not tokenized yet]";
        }
        return "StrTokenizer" + this.getTokenList();
    }

    static {
        CSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StrMatcher.commaMatcher());
        CSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        CSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StrMatcher.noneMatcher());
        CSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StrMatcher.trimMatcher());
        CSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        CSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
        TSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
        TSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StrMatcher.tabMatcher());
        TSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        TSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StrMatcher.noneMatcher());
        TSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StrMatcher.trimMatcher());
        TSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        TSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
    }
}

