/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.Arrays;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public abstract class StrMatcher {
    private static final StrMatcher COMMA_MATCHER = new CharMatcher(',');
    private static final StrMatcher TAB_MATCHER = new CharMatcher('\t');
    private static final StrMatcher SPACE_MATCHER = new CharMatcher(' ');
    private static final StrMatcher SPLIT_MATCHER = new CharSetMatcher(" \t\n\r\f".toCharArray());
    private static final StrMatcher TRIM_MATCHER = new TrimMatcher();
    private static final StrMatcher SINGLE_QUOTE_MATCHER = new CharMatcher('\'');
    private static final StrMatcher DOUBLE_QUOTE_MATCHER = new CharMatcher('\"');
    private static final StrMatcher QUOTE_MATCHER = new CharSetMatcher("'\"".toCharArray());
    private static final StrMatcher NONE_MATCHER = new NoMatcher();

    public static StrMatcher charMatcher(char ch) {
        char c2;
        return new CharMatcher(c2);
    }

    public static StrMatcher charSetMatcher(char ... chars) {
        char[] cArray;
        if (ArrayUtils.isEmpty(chars)) {
            return NONE_MATCHER;
        }
        if (chars.length == 1) {
            return new CharMatcher(chars[0]);
        }
        return new CharSetMatcher(cArray);
    }

    public static StrMatcher charSetMatcher(String chars) {
        String string;
        if (StringUtils.isEmpty(chars)) {
            return NONE_MATCHER;
        }
        if (chars.length() == 1) {
            return new CharMatcher(chars.charAt(0));
        }
        return new CharSetMatcher(string.toCharArray());
    }

    public static StrMatcher commaMatcher() {
        return COMMA_MATCHER;
    }

    public static StrMatcher doubleQuoteMatcher() {
        return DOUBLE_QUOTE_MATCHER;
    }

    public static StrMatcher noneMatcher() {
        return NONE_MATCHER;
    }

    public static StrMatcher quoteMatcher() {
        return QUOTE_MATCHER;
    }

    public static StrMatcher singleQuoteMatcher() {
        return SINGLE_QUOTE_MATCHER;
    }

    public static StrMatcher spaceMatcher() {
        return SPACE_MATCHER;
    }

    public static StrMatcher splitMatcher() {
        return SPLIT_MATCHER;
    }

    public static StrMatcher stringMatcher(String str) {
        String string;
        if (StringUtils.isEmpty(str)) {
            return NONE_MATCHER;
        }
        return new StringMatcher(string);
    }

    public static StrMatcher tabMatcher() {
        return TAB_MATCHER;
    }

    public static StrMatcher trimMatcher() {
        return TRIM_MATCHER;
    }

    protected StrMatcher() {
    }

    /*
     * WARNING - void declaration
     */
    public int isMatch(char[] buffer, int pos) {
        void var1_1;
        void var2_2;
        return this.isMatch(buffer, (int)var2_2, 0, ((void)var1_1).length);
    }

    public abstract int isMatch(char[] var1, int var2, int var3, int var4);

    static final class CharMatcher
    extends StrMatcher {
        private final char ch;

        /*
         * WARNING - void declaration
         */
        CharMatcher(char ch) {
            void var1_1;
            this.ch = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            void var2_2;
            void var1_1;
            if (this.ch == var1_1[var2_2]) {
                return 1;
            }
            return 0;
        }
    }

    static final class CharSetMatcher
    extends StrMatcher {
        private final char[] chars;

        /*
         * WARNING - void declaration
         */
        CharSetMatcher(char[] chars) {
            void var1_1;
            this.chars = ArraySorter.sort((char[])var1_1.clone());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            void var2_2;
            void var1_1;
            if (Arrays.binarySearch(this.chars, (char)var1_1[var2_2]) >= 0) {
                return 1;
            }
            return 0;
        }
    }

    static final class StringMatcher
    extends StrMatcher {
        private final char[] chars;

        /*
         * WARNING - void declaration
         */
        StringMatcher(String str) {
            void var1_1;
            this.chars = var1_1.toCharArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            void var3_3;
            int len = this.chars.length;
            if (pos + len > bufferEnd) {
                return 0;
            }
            int i2 = 0;
            while (i2 < this.chars.length) {
                if (this.chars[i2] != buffer[pos]) {
                    return 0;
                }
                ++i2;
                ++pos;
            }
            return (int)var3_3;
        }

        public final String toString() {
            return super.toString() + ' ' + Arrays.toString(this.chars);
        }
    }

    static final class TrimMatcher
    extends StrMatcher {
        TrimMatcher() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            void var2_2;
            if (buffer[var2_2] <= ' ') {
                return 1;
            }
            return 0;
        }
    }

    static final class NoMatcher
    extends StrMatcher {
        NoMatcher() {
        }

        @Override
        public final int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            return 0;
        }
    }
}

