/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.commons.lang3.text.StrMatcher;

@Deprecated
public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final int HASH_SEED = 31;
    private static final String DUMMY_PATTERN = "";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map<String, ? extends FormatFactory> registry;

    /*
     * WARNING - void declaration
     */
    public ExtendedMessageFormat(String pattern) {
        this((String)var1_1, Locale.getDefault());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedMessageFormat(String pattern, Locale locale) {
        this((String)var1_1, (Locale)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedMessageFormat(String pattern, Locale locale, Map<String, ? extends FormatFactory> registry) {
        super(DUMMY_PATTERN);
        void var1_1;
        void var3_3;
        void var2_2;
        this.setLocale(LocaleUtils.toLocale((Locale)var2_2));
        this.registry = var3_3;
        this.applyPattern((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedMessageFormat(String pattern, Map<String, ? extends FormatFactory> registry) {
        this((String)var1_1, Locale.getDefault(), (Map<String, ? extends FormatFactory>)var2_2);
        void var2_2;
        void var1_1;
    }

    private StringBuilder appendQuotedString(String pattern, ParsePosition pos, StringBuilder appendTo) {
        assert (pattern.toCharArray()[pos.getIndex()] == '\'') : "Quoted string must start with quote character";
        if (appendTo != null) {
            appendTo.append('\'');
        }
        this.next(pos);
        int start = pos.getIndex();
        char[] c2 = pattern.toCharArray();
        for (int i2 = pos.getIndex(); i2 < pattern.length(); ++i2) {
            if (c2[pos.getIndex()] == '\'') {
                this.next(pos);
                if (appendTo == null) {
                    return null;
                }
                return appendTo.append(c2, start, pos.getIndex() - start);
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + start);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyPattern(String pattern) {
        void var3_3;
        if (this.registry == null) {
            super.applyPattern(pattern);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList<Format> foundFormats = new ArrayList<Format>();
        ArrayList<String> foundDescriptions = new ArrayList<String>();
        StringBuilder stripCustom = new StringBuilder(pattern.length());
        ParsePosition pos = new ParsePosition(0);
        char[] c2 = pattern.toCharArray();
        int fmtCount = 0;
        block4: while (pos.getIndex() < pattern.length()) {
            switch (c2[pos.getIndex()]) {
                case '\'': {
                    this.appendQuotedString(pattern, pos, stripCustom);
                    continue block4;
                }
                case '{': {
                    ++fmtCount;
                    this.seekNonWs(pattern, pos);
                    int start = pos.getIndex();
                    int index = this.readArgumentIndex(pattern, this.next(pos));
                    stripCustom.append('{').append(index);
                    this.seekNonWs(pattern, pos);
                    Format format = null;
                    String formatDescription = null;
                    if (c2[pos.getIndex()] == ',' && (format = this.getFormat(formatDescription = this.parseFormatDescription(pattern, this.next(pos)))) == null) {
                        stripCustom.append(',').append(formatDescription);
                    }
                    foundFormats.add(format);
                    foundDescriptions.add(format == null ? null : formatDescription);
                    Validate.isTrue(foundFormats.size() == fmtCount);
                    Validate.isTrue(foundDescriptions.size() == fmtCount);
                    if (c2[pos.getIndex()] == '}') break;
                    throw new IllegalArgumentException("Unreadable format element at position " + start);
                }
            }
            stripCustom.append(c2[pos.getIndex()]);
            this.next(pos);
        }
        super.applyPattern(stripCustom.toString());
        this.toPattern = this.insertFormats(super.toPattern(), (ArrayList<String>)var3_3);
        if (this.containsElements(foundFormats)) {
            void var2_2;
            Format[] origFormats = this.getFormats();
            int i2 = 0;
            for (Format f2 : var2_2) {
                if (f2 != null) {
                    origFormats[i2] = f2;
                }
                ++i2;
            }
            super.setFormats(origFormats);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean containsElements(Collection<?> coll) {
        void var1_1;
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        return var1_1.stream().anyMatch(Objects::nonNull);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (ObjectUtils.notEqual(this.getClass(), obj.getClass())) {
            return false;
        }
        ExtendedMessageFormat rhs = (ExtendedMessageFormat)obj;
        if (ObjectUtils.notEqual(this.toPattern, rhs.toPattern)) {
            return false;
        }
        return !ObjectUtils.notEqual(this.registry, var1_1.registry);
    }

    /*
     * WARNING - void declaration
     */
    private Format getFormat(String desc) {
        if (this.registry != null) {
            FormatFactory factory2;
            String name = desc;
            String args2 = null;
            int i2 = desc.indexOf(44);
            if (i2 > 0) {
                name = desc.substring(0, i2).trim();
                args2 = desc.substring(i2 + 1).trim();
            }
            if ((factory2 = this.registry.get(name)) != null) {
                void var3_3;
                void var2_2;
                void var1_1;
                return var1_1.getFormat((String)var2_2, (String)var3_3, this.getLocale());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void getQuotedString(String pattern, ParsePosition pos) {
        void var2_2;
        void var1_1;
        this.appendQuotedString((String)var1_1, (ParsePosition)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = super.hashCode();
        result = result * 31 + Objects.hashCode(this.registry);
        var1_1 = var1_1 * 31 + Objects.hashCode(this.toPattern);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String insertFormats(String pattern, ArrayList<String> customPatterns) {
        void var3_3;
        if (!this.containsElements(customPatterns)) {
            return pattern;
        }
        StringBuilder sb = new StringBuilder(pattern.length() << 1);
        ParsePosition pos = new ParsePosition(0);
        int fe = -1;
        int depth = 0;
        block5: while (pos.getIndex() < pattern.length()) {
            void var7_7;
            char c2 = pattern.charAt(pos.getIndex());
            switch (c2) {
                case '\'': {
                    this.appendQuotedString(pattern, pos, sb);
                    continue block5;
                }
                case '{': {
                    String customPattern;
                    sb.append('{').append(this.readArgumentIndex(pattern, this.next(pos)));
                    if (++depth != 1 || (customPattern = customPatterns.get(++fe)) == null) continue block5;
                    sb.append(',').append(customPattern);
                    continue block5;
                }
                case '}': {
                    --depth;
                }
            }
            sb.append((char)var7_7);
            this.next(pos);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private ParsePosition next(ParsePosition pos) {
        void var1_1;
        ParsePosition parsePosition = pos;
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String parseFormatDescription(String pattern, ParsePosition pos) {
        void var3_3;
        int start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        int text = pos.getIndex();
        int depth = 1;
        while (pos.getIndex() < pattern.length()) {
            switch (pattern.charAt(pos.getIndex())) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth != 0) break;
                    return pattern.substring(text, pos.getIndex());
                }
                case '\'': {
                    this.getQuotedString(pattern, pos);
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated format element at position " + (int)var3_3);
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String pattern, ParsePosition pos) {
        start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        result = new StringBuilder();
        error = false;
        while (!error && pos.getIndex() < pattern.length()) {
            c = pattern.charAt(pos.getIndex());
            if (!Character.isWhitespace(c)) ** GOTO lbl-1000
            this.seekNonWs(pattern, pos);
            c = pattern.charAt(pos.getIndex());
            if (c != ',' && c != '}') {
                error = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((c == ',' || c == '}') && result.length() > 0) {
                    try {
                        return Integer.parseInt(result.toString());
                    }
                    catch (NumberFormatException v0) {}
                }
                error = Character.isDigit(c) == false;
                result.append(c);
            }
            this.next(pos);
        }
        if (error) {
            throw new IllegalArgumentException("Invalid format argument index at position " + start + ": " + var1_1.substring(start, var2_2.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void seekNonWs(String pattern, ParsePosition pos) {
        void var3_4;
        char[] buffer = pattern.toCharArray();
        do {
            int len = StrMatcher.splitMatcher().isMatch(buffer, pos.getIndex());
            ParsePosition parsePosition = pos;
            parsePosition.setIndex(parsePosition.getIndex() + len);
        } while (var3_4 > 0 && pos.getIndex() < pattern.length());
    }

    @Override
    public void setFormat(int formatElementIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormats(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatsByArgumentIndex(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toPattern() {
        return this.toPattern;
    }
}

