/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailablePredicate;

public class Streams {
    public static <T> FailableStream<T> failableStream(Collection<T> stream) {
        return Streams.failableStream(Streams.of(stream));
    }

    public static <T> FailableStream<T> failableStream(Stream<T> stream) {
        Stream<T> stream2;
        return new FailableStream<T>(stream2);
    }

    public static <T> FailableStream<T> failableStream(T value) {
        return Streams.failableStream(Streams.streamOf(value));
    }

    @SafeVarargs
    public static <T> FailableStream<T> failableStream(T ... values2) {
        return Streams.failableStream(Streams.of(values2));
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Stream<E> instancesOf(Class<? super E> clazz, Collection<? super E> collection) {
        void var1_1;
        return Streams.instancesOf(clazz, Streams.of(var1_1));
    }

    private static <E> Stream<E> instancesOf(Class<? super E> clazz, Stream<?> stream) {
        Class<? super E> clazz2;
        return Streams.of(stream).filter(clazz2::isInstance);
    }

    public static <E> Stream<E> nonNull(Collection<E> collection) {
        return Streams.of(collection).filter(Objects::nonNull);
    }

    public static <E> Stream<E> nonNull(E array) {
        return Streams.nonNull(Streams.streamOf(array));
    }

    @SafeVarargs
    public static <E> Stream<E> nonNull(E ... array) {
        return Streams.nonNull(Streams.of(array));
    }

    public static <E> Stream<E> nonNull(Stream<E> stream) {
        return Streams.of(stream).filter(Objects::nonNull);
    }

    public static <E> Stream<E> of(Collection<E> collection) {
        Collection<E> collection2;
        if (collection == null) {
            return Stream.empty();
        }
        return collection2.stream();
    }

    public static <E> Stream<E> of(Enumeration<E> enumeration) {
        Enumeration<E> enumeration2;
        return StreamSupport.stream(new EnumerationSpliterator<E>(Long.MAX_VALUE, 16, enumeration2), false);
    }

    public static <E> Stream<E> of(Iterable<E> iterable) {
        Iterable<E> iterable2;
        if (iterable == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable2.spliterator(), false);
    }

    public static <E> Stream<E> of(Iterator<E> iterator2) {
        Iterator<E> iterator3;
        if (iterator2 == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator3, 16), false);
    }

    private static <E> Stream<E> of(Stream<E> stream) {
        Stream<E> stream2;
        if (stream == null) {
            return Stream.empty();
        }
        return stream2;
    }

    @SafeVarargs
    public static <T> Stream<T> of(T ... values2) {
        T[] TArray;
        if (values2 == null) {
            return Stream.empty();
        }
        return Stream.of(TArray);
    }

    @Deprecated
    public static <E> FailableStream<E> stream(Collection<E> collection) {
        return Streams.failableStream(collection);
    }

    @Deprecated
    public static <T> FailableStream<T> stream(Stream<T> stream) {
        return Streams.failableStream(stream);
    }

    private static <T> Stream<T> streamOf(T value) {
        T t2;
        if (value == null) {
            return Stream.empty();
        }
        return Stream.of(t2);
    }

    public static <T> Collector<T, ?, T[]> toArray(Class<T> elementType) {
        Class<T> clazz;
        return new ArrayCollector<T>(clazz);
    }

    @Deprecated
    public Streams() {
    }

    public static class FailableStream<T> {
        private Stream<T> stream;
        private boolean terminated;

        /*
         * WARNING - void declaration
         */
        public FailableStream(Stream<T> stream) {
            void var1_1;
            this.stream = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean allMatch(FailablePredicate<T, ?> predicate) {
            void var1_1;
            this.assertNotTerminated();
            return this.stream().allMatch(Failable.asPredicate(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public boolean anyMatch(FailablePredicate<T, ?> predicate) {
            void var1_1;
            this.assertNotTerminated();
            return this.stream().anyMatch(Failable.asPredicate(var1_1));
        }

        protected void assertNotTerminated() {
            if (this.terminated) {
                throw new IllegalStateException("This stream is already terminated.");
            }
        }

        /*
         * WARNING - void declaration
         */
        public <A, R> R collect(Collector<? super T, A, R> collector) {
            void var1_1;
            this.makeTerminated();
            return this.stream().collect(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public <A, R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.makeTerminated();
            return this.stream().collect(var1_1, var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public FailableStream<T> filter(FailablePredicate<T, ?> predicate) {
            void var1_1;
            this.assertNotTerminated();
            this.stream = this.stream.filter(Failable.asPredicate(var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public void forEach(FailableConsumer<T, ?> action) {
            void var1_1;
            this.makeTerminated();
            this.stream().forEach(Failable.asConsumer(var1_1));
        }

        protected void makeTerminated() {
            this.assertNotTerminated();
            this.terminated = true;
        }

        /*
         * WARNING - void declaration
         */
        public <R> FailableStream<R> map(FailableFunction<T, R, ?> mapper) {
            void var1_1;
            this.assertNotTerminated();
            return new FailableStream(this.stream.map(Failable.asFunction(var1_1)));
        }

        /*
         * WARNING - void declaration
         */
        public T reduce(T identity, BinaryOperator<T> accumulator) {
            void var2_2;
            void var1_1;
            this.makeTerminated();
            return this.stream().reduce(var1_1, (BinaryOperator<void>)var2_2);
        }

        public Stream<T> stream() {
            return this.stream;
        }
    }

    private static final class EnumerationSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Enumeration<T> enumeration;

        /*
         * WARNING - void declaration
         */
        protected EnumerationSpliterator(long estimatedSize, int additionalCharacteristics, Enumeration<T> enumeration) {
            super((long)var1_1, (int)var3_2);
            void var3_2;
            void var1_1;
            this.enumeration = Objects.requireNonNull(enumeration, "enumeration");
        }

        @Override
        public final void forEachRemaining(Consumer<? super T> action) {
            while (this.enumeration.hasMoreElements()) {
                this.next(action);
            }
        }

        private boolean next(Consumer<? super T> action) {
            action.accept(this.enumeration.nextElement());
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean tryAdvance(Consumer<? super T> action) {
            void var1_1;
            return this.enumeration.hasMoreElements() && this.next((Consumer<? super T>)var1_1);
        }
    }

    public static class ArrayCollector<E>
    implements Collector<E, List<E>, E[]> {
        private static final Set<Collector.Characteristics> characteristics = Collections.emptySet();
        private final Class<E> elementType;

        /*
         * WARNING - void declaration
         */
        public ArrayCollector(Class<E> elementType) {
            void var1_1;
            this.elementType = (Class)Objects.requireNonNull(var1_1, "elementType");
        }

        @Override
        public BiConsumer<List<E>, E> accumulator() {
            return List::add;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return characteristics;
        }

        @Override
        public BinaryOperator<List<E>> combiner() {
            return (left, right) -> {
                List list;
                void var1_1;
                left.addAll(var1_1);
                return list;
            };
        }

        @Override
        public Function<List<E>, E[]> finisher() {
            return list -> {
                void var1_1;
                return list.toArray(ArrayUtils.newInstance(this.elementType, var1_1.size()));
            };
        }

        @Override
        public Supplier<List<E>> supplier() {
            return ArrayList::new;
        }
    }
}

