/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.AppendableJoiner;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.reflect.Typed;

public class TypeUtils {
    private static final AppendableJoiner<Type> AMP_JOINER = AppendableJoiner.builder().setDelimiter(" & ").setElementAppender((a2, e2) -> {
        void var1_1;
        a2.append(TypeUtils.toString((Type)var1_1));
    }).get();
    private static final AppendableJoiner<TypeVariable<Class<?>>> CTJ_JOINER = AppendableJoiner.builder().setDelimiter(", ").setElementAppender((a2, e2) -> {
        void var1_1;
        a2.append(TypeUtils.anyToString(var1_1));
    }).get();
    private static final AppendableJoiner<Object> GT_JOINER = AppendableJoiner.builder().setPrefix("<").setSuffix(">").setDelimiter(", ").setElementAppender((a2, e2) -> {
        void var1_1;
        a2.append(TypeUtils.anyToString(var1_1));
    }).get();
    public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();

    private static <T> String anyToString(T object) {
        T t2;
        if (object instanceof Type) {
            return TypeUtils.toString((Type)object);
        }
        return t2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void appendRecursiveTypes(StringBuilder builder, int[] recursiveTypeIndexes, Type[] argumentTypes) {
        void var1_1;
        void var2_2;
        for (int i2 = 0; i2 < recursiveTypeIndexes.length; ++i2) {
            GT_JOINER.join(builder, (Object[])new Object[]{argumentTypes[i2].toString()});
        }
        Type[] argumentsFiltered = (Type[])ArrayUtils.removeAll(var2_2, (int[])var1_1);
        if (argumentsFiltered.length > 0) {
            void var3_4;
            StringBuilder stringBuilder;
            GT_JOINER.join(stringBuilder, (Object[])((Object[])var3_4));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T> String classToString(Class<T> cls) {
        void var1_1;
        if (cls.isArray()) {
            return TypeUtils.toString(cls.getComponentType()) + "[]";
        }
        if (TypeUtils.isCyclical(cls)) {
            return cls.getSimpleName() + "(cycle)";
        }
        StringBuilder buf = new StringBuilder();
        if (cls.getEnclosingClass() != null) {
            buf.append(TypeUtils.classToString(cls.getEnclosingClass())).append('.').append(cls.getSimpleName());
        } else {
            buf.append(cls.getName());
        }
        if (cls.getTypeParameters().length > 0) {
            Class<T> clazz;
            CTJ_JOINER.join(buf, clazz.getTypeParameters());
        }
        return var1_1.toString();
    }

    public static boolean containsTypeVariables(Type type) {
        while (true) {
            Type type2;
            if (type instanceof TypeVariable) {
                return true;
            }
            if (type instanceof Class) {
                return ((Class)type).getTypeParameters().length > 0;
            }
            if (type instanceof ParameterizedType) {
                for (Type type3 : ((ParameterizedType)type).getActualTypeArguments()) {
                    if (!TypeUtils.containsTypeVariables(type3)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof WildcardType) {
                Type wild = (WildcardType)type;
                return TypeUtils.containsTypeVariables(TypeUtils.getImplicitLowerBounds((WildcardType)wild)[0]) || TypeUtils.containsTypeVariables(TypeUtils.getImplicitUpperBounds((WildcardType)type2)[0]);
            }
            if (!(type2 instanceof GenericArrayType)) break;
            type2 = ((GenericArrayType)type2).getGenericComponentType();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean containsVariableTypeSameParametrizedTypeBound(TypeVariable<?> typeVariable, ParameterizedType parameterizedType) {
        void var1_1;
        return ArrayUtils.contains(typeVariable.getBounds(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> cls, ParameterizedType superParameterizedType) {
        void var1_1;
        void var2_2;
        Class<?> clazz;
        Type midType;
        while (true) {
            Objects.requireNonNull(cls, "cls");
            Objects.requireNonNull(superParameterizedType, "superParameterizedType");
            Class<?> superClass = TypeUtils.getRawType(superParameterizedType);
            if (!TypeUtils.isAssignable(cls, superClass)) {
                return null;
            }
            if (cls.equals(superClass)) {
                return TypeUtils.getTypeArguments(superParameterizedType, superClass, null);
            }
            midType = TypeUtils.getClosestParentType(cls, superClass);
            if (!(midType instanceof Class)) break;
            cls = (Class)midType;
        }
        ParameterizedType midParameterizedType = (ParameterizedType)midType;
        Class<?> clazz2 = TypeUtils.getRawType(midParameterizedType);
        Map<TypeVariable<?>, Type> typeVarAssigns = TypeUtils.determineTypeArguments(clazz2, superParameterizedType);
        TypeUtils.mapTypeVariablesToArguments(clazz, (ParameterizedType)var2_2, typeVarAssigns);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equals(GenericArrayType genericArrayType, Type type) {
        void var1_1;
        GenericArrayType genericArrayType2;
        return type instanceof GenericArrayType && TypeUtils.equals(genericArrayType2.getGenericComponentType(), ((GenericArrayType)var1_1).getGenericComponentType());
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equals(ParameterizedType parameterizedType, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType other = (ParameterizedType)type;
            if (TypeUtils.equals(parameterizedType.getRawType(), other.getRawType()) && TypeUtils.equals(parameterizedType.getOwnerType(), other.getOwnerType())) {
                void var1_1;
                ParameterizedType parameterizedType2;
                return TypeUtils.equals(parameterizedType2.getActualTypeArguments(), var1_1.getActualTypeArguments());
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(Type type1, Type type2) {
        if (Objects.equals(type1, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType) {
            return TypeUtils.equals((ParameterizedType)type1, type2);
        }
        if (type1 instanceof GenericArrayType) {
            return TypeUtils.equals((GenericArrayType)type1, type2);
        }
        if (type1 instanceof WildcardType) {
            void var1_1;
            Type type;
            return TypeUtils.equals((WildcardType)type, (Type)var1_1);
        }
        return false;
    }

    private static boolean equals(Type[] type1, Type[] type2) {
        if (type1.length == type2.length) {
            for (int i2 = 0; i2 < type1.length; ++i2) {
                if (TypeUtils.equals(type1[i2], type2[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equals(WildcardType wildcardType, Type type) {
        if (type instanceof WildcardType) {
            void var1_1;
            WildcardType wildcardType2;
            WildcardType other = (WildcardType)type;
            return TypeUtils.equals(TypeUtils.getImplicitLowerBounds(wildcardType), TypeUtils.getImplicitLowerBounds(other)) && TypeUtils.equals(TypeUtils.getImplicitUpperBounds(wildcardType2), TypeUtils.getImplicitUpperBounds((WildcardType)var1_1));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Type[] extractTypeArgumentsFrom(Map<TypeVariable<?>, Type> mappings, TypeVariable<?>[] variables) {
        void var2_2;
        void var1_1;
        Type[] result = new Type[variables.length];
        int index = 0;
        for (void var : var1_1) {
            Validate.isTrue(mappings.containsKey(var), "missing argument mapping for %s", TypeUtils.toString((Type)var));
            result[index++] = mappings.get(var);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] findRecursiveTypes(ParameterizedType parameterizedType) {
        void var2_2;
        Type[] filteredArgumentTypes = Arrays.copyOf(parameterizedType.getActualTypeArguments(), parameterizedType.getActualTypeArguments().length);
        int[] indexesToRemove = new int[]{};
        for (int i2 = 0; i2 < filteredArgumentTypes.length; ++i2) {
            if (!(filteredArgumentTypes[i2] instanceof TypeVariable) || !TypeUtils.containsVariableTypeSameParametrizedTypeBound((TypeVariable)filteredArgumentTypes[i2], parameterizedType)) continue;
            indexesToRemove = ArrayUtils.add(indexesToRemove, i2);
        }
        return var2_2;
    }

    public static GenericArrayType genericArrayType(Type componentType) {
        Type type;
        return new GenericArrayTypeImpl(Objects.requireNonNull(type, "componentType"));
    }

    private static String genericArrayTypeToString(GenericArrayType genericArrayType) {
        GenericArrayType genericArrayType2;
        return String.format("%s[]", TypeUtils.toString(genericArrayType2.getGenericComponentType()));
    }

    public static Type getArrayComponentType(Type type) {
        Type type2;
        if (type instanceof Class) {
            Type cls = (Class)type;
            if (((Class)cls).isArray()) {
                return ((Class)type2).getComponentType();
            }
            return null;
        }
        if (type2 instanceof GenericArrayType) {
            return ((GenericArrayType)type2).getGenericComponentType();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Type getClosestParentType(Class<?> cls, Class<?> superClass) {
        Class<?> clazz;
        if (superClass.isInterface()) {
            void var2_2;
            Type[] interfaceTypes = cls.getGenericInterfaces();
            Type genericInterface = null;
            for (void midType : var2_2) {
                Class midClass;
                if (midType instanceof ParameterizedType) {
                    midClass = TypeUtils.getRawType((ParameterizedType)midType);
                } else if (midType instanceof Class) {
                    midClass = (Class)midType;
                } else {
                    throw new IllegalStateException("Unexpected generic interface type found: " + midType);
                }
                if (!TypeUtils.isAssignable((Type)midClass, superClass) || !TypeUtils.isAssignable(genericInterface, (Type)midClass)) continue;
                genericInterface = midType;
            }
            if (genericInterface != null) {
                void var3_3;
                return var3_3;
            }
        }
        return clazz.getGenericSuperclass();
    }

    public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
        Type[] typeArray;
        Objects.requireNonNull(typeVariable, "typeVariable");
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    public static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Objects.requireNonNull(wildcardType, "wildcardType");
        Type[] bounds = wildcardType.getLowerBounds();
        if (bounds.length == 0) {
            return new Type[]{null};
        }
        return typeArray;
    }

    public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Objects.requireNonNull(wildcardType, "wildcardType");
        Type[] bounds = wildcardType.getUpperBounds();
        if (bounds.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    private static Class<?> getRawType(ParameterizedType parameterizedType) {
        Type type;
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new IllegalStateException("Wait... What!? Type of rawType: " + rawType);
        }
        return (Class)type;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getRawType(Type type, Type assigningType) {
        Type type2;
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.getRawType((ParameterizedType)type);
            }
            if (!(type instanceof TypeVariable)) break;
            if (assigningType == null) {
                return null;
            }
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (!(genericDeclaration instanceof Class)) {
                return null;
            }
            Map<TypeVariable<?>, Type> typeVarAssigns = TypeUtils.getTypeArguments(assigningType, (Class)genericDeclaration);
            if (typeVarAssigns == null) {
                return null;
            }
            Type typeArgument = typeVarAssigns.get(type);
            if (typeArgument != null) continue;
            return null;
        }
        if (type2 instanceof GenericArrayType) {
            void var1_1;
            Class<?> rawComponentType = TypeUtils.getRawType(((GenericArrayType)type2).getGenericComponentType(), (Type)var1_1);
            if (rawComponentType != null) {
                void var2_2;
                return Array.newInstance(var2_2, 0).getClass();
            }
            return null;
        }
        if (type2 instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + type2);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> cls, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        void var2_2;
        void var1_1;
        Class<?> clazz;
        HashMap typeVarAssigns;
        if (!TypeUtils.isAssignable(cls, toClass)) {
            return null;
        }
        if (cls.isPrimitive()) {
            if (toClass.isPrimitive()) {
                return new HashMap();
            }
            cls = ClassUtils.primitiveToWrapper(cls);
        }
        HashMap hashMap = typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(clazz, toClass), var1_1, var2_2);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType type) {
        ParameterizedType parameterizedType = type;
        return TypeUtils.getTypeArguments(parameterizedType, TypeUtils.getRawType(parameterizedType), null);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        void var2_2;
        void var1_1;
        void var3_3;
        Map<TypeVariable<?>, Type> map;
        Class<?> cls = TypeUtils.getRawType(parameterizedType);
        if (!TypeUtils.isAssignable(cls, toClass)) {
            return null;
        }
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            ParameterizedType parameterizedOwnerType = (ParameterizedType)ownerType;
            map = TypeUtils.getTypeArguments(parameterizedOwnerType, TypeUtils.getRawType(parameterizedOwnerType), subtypeVarAssigns);
        } else {
            map = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        }
        HashMap typeVarAssigns = map;
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeParams = cls.getTypeParameters();
        for (int i2 = 0; i2 < typeParams.length; ++i2) {
            Type typeArg;
            Type type = typeArg = typeArgs[i2];
            typeVarAssigns.put(typeParams[i2], typeVarAssigns.getOrDefault(type, type));
        }
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(var3_3, toClass), var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
        void var1_1;
        return TypeUtils.getTypeArguments(type, var1_1, null);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        Type type2;
        block7: {
            block0: while (true) {
                Type bound;
                int n2;
                int n3;
                if (type instanceof Class) {
                    return TypeUtils.getTypeArguments((Class)type, toClass, subtypeVarAssigns);
                }
                if (type instanceof ParameterizedType) {
                    return TypeUtils.getTypeArguments((ParameterizedType)type, toClass, subtypeVarAssigns);
                }
                if (type instanceof GenericArrayType) {
                    toClass = toClass.isArray() ? toClass.getComponentType() : toClass;
                    type = ((GenericArrayType)type).getGenericComponentType();
                    continue;
                }
                if (type instanceof WildcardType) {
                    type = TypeUtils.getImplicitUpperBounds((WildcardType)type);
                    n3 = ((Type[])type).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        bound = type[n2];
                        if (!TypeUtils.isAssignable(bound, toClass)) continue;
                        type = bound;
                        continue block0;
                    }
                    return null;
                }
                if (!(type instanceof TypeVariable)) break block7;
                type = TypeUtils.getImplicitBounds((TypeVariable)type);
                n3 = ((Type[])type).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    bound = type[n2];
                    if (!TypeUtils.isAssignable(bound, toClass)) continue;
                    type = bound;
                    continue block0;
                }
                break;
            }
            return null;
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    public static boolean isArrayType(Type type) {
        Type type2;
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type2).isArray();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignable(Type type, Class<?> toClass) {
        Type type2;
        while (true) {
            if (type == null) {
                return toClass == null || !toClass.isPrimitive();
            }
            if (toClass == null) {
                return false;
            }
            if (toClass.equals(type)) {
                return true;
            }
            if (type instanceof Class) {
                return ClassUtils.isAssignable((Class)type, toClass);
            }
            if (!(type instanceof ParameterizedType)) break;
            type = TypeUtils.getRawType((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            for (Type type3 : ((TypeVariable)type).getBounds()) {
                if (!TypeUtils.isAssignable(type3, toClass)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            void var1_1;
            return toClass.equals(Object.class) || toClass.isArray() && TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), var1_1.getComponentType());
        }
        if (type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignable(Type type, GenericArrayType toGenericArrayType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type object;
        if (type == null) {
            return true;
        }
        if (toGenericArrayType == null) {
            return false;
        }
        if (toGenericArrayType.equals(type)) {
            return true;
        }
        Type toComponentType = toGenericArrayType.getGenericComponentType();
        if (type instanceof Class) {
            void var0_1;
            Class cls = (Class)type;
            return cls.isArray() && TypeUtils.isAssignable(var0_1.getComponentType(), toComponentType, typeVarAssigns);
        }
        if (object instanceof GenericArrayType) {
            void var2_5;
            void var3_8;
            return TypeUtils.isAssignable(((GenericArrayType)object).getGenericComponentType(), (Type)var3_8, var2_5);
        }
        if (object instanceof WildcardType) {
            for (Type type2 : TypeUtils.getImplicitUpperBounds((WildcardType)object)) {
                if (!TypeUtils.isAssignable(type2, (Type)toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof TypeVariable) {
            for (Type type3 : TypeUtils.getImplicitBounds((TypeVariable)object)) {
                if (!TypeUtils.isAssignable(type3, (Type)toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof ParameterizedType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + object);
    }

    private static boolean isAssignable(Type type, ParameterizedType toParameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Iterator<TypeVariable<?>> iterator2;
        if (type == null) {
            return true;
        }
        if (toParameterizedType == null) {
            return false;
        }
        if (type instanceof GenericArrayType) {
            return false;
        }
        if (toParameterizedType.equals(type)) {
            return true;
        }
        Class<?> toClass = TypeUtils.getRawType(toParameterizedType);
        Map<TypeVariable<?>, Type> fromTypeVarAssigns = TypeUtils.getTypeArguments(type, toClass, null);
        if (fromTypeVarAssigns == null) {
            return false;
        }
        if (fromTypeVarAssigns.isEmpty()) {
            return true;
        }
        Map<TypeVariable<?>, Type> toTypeVarAssigns = TypeUtils.getTypeArguments(toParameterizedType, iterator2, typeVarAssigns);
        for (TypeVariable<?> var : toTypeVarAssigns.keySet()) {
            Type toTypeArg = TypeUtils.unrollVariableAssignments(var, toTypeVarAssigns);
            Type fromTypeArg = TypeUtils.unrollVariableAssignments(var, fromTypeVarAssigns);
            if (toTypeArg == null && fromTypeArg instanceof Class || fromTypeArg == null || toTypeArg == null || toTypeArg.equals(fromTypeArg) || toTypeArg instanceof WildcardType && TypeUtils.isAssignable(fromTypeArg, toTypeArg, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Type type, Type toType) {
        void var1_1;
        return TypeUtils.isAssignable(type, (Type)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        void var1_1;
        if (toType == null || toType instanceof Class) {
            return TypeUtils.isAssignable(type, (Class)toType);
        }
        if (toType instanceof ParameterizedType) {
            return TypeUtils.isAssignable(type, (ParameterizedType)toType, typeVarAssigns);
        }
        if (toType instanceof GenericArrayType) {
            return TypeUtils.isAssignable(type, (GenericArrayType)toType, typeVarAssigns);
        }
        if (toType instanceof WildcardType) {
            return TypeUtils.isAssignable(type, (WildcardType)toType, typeVarAssigns);
        }
        if (toType instanceof TypeVariable) {
            void var2_2;
            Type type2;
            return TypeUtils.isAssignable(type2, (TypeVariable)toType, var2_2);
        }
        throw new IllegalStateException("found an unhandled type: " + var1_1);
    }

    private static boolean isAssignable(Type type, TypeVariable<?> toTypeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type type2;
        if (type == null) {
            return true;
        }
        if (toTypeVariable == null) {
            return false;
        }
        if (toTypeVariable.equals(type)) {
            return true;
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = TypeUtils.getImplicitBounds((TypeVariable)type);
            Type[] typeArray2 = typeArray;
            typeArray2 = typeArray;
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type3 = typeArray2[i2];
                if (!TypeUtils.isAssignable(type3, toTypeVariable, typeVarAssigns)) continue;
                return true;
            }
        }
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignable(Type type22, WildcardType toWildcardType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        void var1_2;
        Type type22;
        if (type22 == null) {
            return true;
        }
        if (toWildcardType == null) {
            return false;
        }
        if (toWildcardType.equals(type22)) {
            return true;
        }
        Type[] toUpperBounds = TypeUtils.getImplicitUpperBounds(toWildcardType);
        Type[] toLowerBounds = TypeUtils.getImplicitLowerBounds(toWildcardType);
        if (type22 instanceof WildcardType) {
            int n2;
            int n3;
            Type[] typeArray;
            Type toBound;
            WildcardType wildcardType = (WildcardType)type22;
            Type[] upperBounds = TypeUtils.getImplicitUpperBounds(wildcardType);
            Type[] lowerBounds = TypeUtils.getImplicitLowerBounds(wildcardType);
            for (Type type3 : toUpperBounds) {
                toBound = TypeUtils.substituteTypeVariables(type3, typeVarAssigns);
                typeArray = upperBounds;
                n3 = upperBounds.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Type type4 = typeArray[n2];
                    if (TypeUtils.isAssignable(type4, toBound, typeVarAssigns)) continue;
                    return false;
                }
            }
            toUpperBounds = toLowerBounds;
            int type22 = toLowerBounds.length;
            for (int i2 = 0; i2 < type22; ++i2) {
                toBound = toUpperBounds[i2];
                toBound = TypeUtils.substituteTypeVariables(toBound, typeVarAssigns);
                typeArray = lowerBounds;
                n3 = lowerBounds.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Type bound = typeArray[n2];
                    if (TypeUtils.isAssignable(toBound, bound, typeVarAssigns)) continue;
                    return false;
                }
            }
            return true;
        }
        Type[] typeArray = toUpperBounds;
        int n4 = toUpperBounds.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            Type type5;
            Type toBound = typeArray[i3];
            if (TypeUtils.isAssignable(type22, TypeUtils.substituteTypeVariables(type5, typeVarAssigns), typeVarAssigns)) continue;
            return false;
        }
        for (Type type5 : var1_2) {
            if (TypeUtils.isAssignable(TypeUtils.substituteTypeVariables(type5, typeVarAssigns), type22, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCyclical(Class<?> cls) {
        for (TypeVariable<Class<?>> typeVariable : cls.getTypeParameters()) {
            for (AnnotatedType annotatedType : typeVariable.getAnnotatedBounds()) {
                if (!annotatedType.getType().getTypeName().contains(cls.getName())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isInstance(Object value, Type type) {
        void var1_1;
        Object object;
        if (type == null) {
            return false;
        }
        if (value == null) {
            return !(type instanceof Class) || !((Class)type).isPrimitive();
        }
        return TypeUtils.isAssignable(object.getClass(), (Type)var1_1, null);
    }

    private static <T> void mapTypeVariablesToArguments(Class<T> cls, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            TypeUtils.mapTypeVariablesToArguments(cls, (ParameterizedType)ownerType, typeVarAssigns);
        }
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVars = TypeUtils.getRawType(parameterizedType).getTypeParameters();
        List<TypeVariable<Class<T>>> typeVarList = Arrays.asList(cls.getTypeParameters());
        for (int i2 = 0; i2 < typeArgs.length; ++i2) {
            TypeVariable<Class<?>> typeVar = typeVars[i2];
            Type typeArg = typeArgs[i2];
            if (!typeVarList.contains(typeArg) || !typeVarAssigns.containsKey(typeVar)) continue;
            typeVarAssigns.put((TypeVariable)typeArg, typeVarAssigns.get(typeVar));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Type[] normalizeUpperBounds(Type[] bounds) {
        void var1_1;
        Objects.requireNonNull(bounds, "bounds");
        if (bounds.length < 2) {
            return bounds;
        }
        HashSet<Type> types = new HashSet<Type>(bounds.length);
        Type[] typeArray = bounds;
        int n2 = bounds.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type1 = typeArray[i2];
            boolean subtypeFound = false;
            Type[] typeArray2 = bounds;
            int n3 = bounds.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Type type2 = typeArray2[i3];
                if (type1 == type2 || !TypeUtils.isAssignable(type2, type1, null)) continue;
                subtypeFound = true;
                break;
            }
            if (subtypeFound) continue;
            types.add(type1);
        }
        return var1_1.toArray(ArrayUtils.EMPTY_TYPE_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static final ParameterizedType parameterize(Class<?> rawClass, Map<TypeVariable<?>, Type> typeVariableMap) {
        Class<?> clazz;
        void var1_1;
        Objects.requireNonNull(rawClass, "rawClass");
        Objects.requireNonNull(typeVariableMap, "typeVariableMap");
        return TypeUtils.parameterizeWithOwner(null, rawClass, TypeUtils.extractTypeArgumentsFrom(var1_1, clazz.getTypeParameters()));
    }

    /*
     * WARNING - void declaration
     */
    public static final ParameterizedType parameterize(Class<?> rawClass, Type ... typeArguments) {
        void var1_1;
        Class<?> clazz;
        return TypeUtils.parameterizeWithOwner(null, clazz, (Type[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String parameterizedTypeToString(ParameterizedType parameterizedType) {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        Type useOwner = parameterizedType.getOwnerType();
        Class raw = (Class)parameterizedType.getRawType();
        if (useOwner == null) {
            builder.append(raw.getName());
        } else {
            void var3_3;
            if (useOwner instanceof Class) {
                builder.append(((Class)useOwner).getName());
            } else {
                builder.append(useOwner);
            }
            builder.append('.').append(var3_3.getSimpleName());
        }
        int[] recursiveTypeIndexes = TypeUtils.findRecursiveTypes(parameterizedType);
        if (recursiveTypeIndexes.length > 0) {
            void var2_2;
            TypeUtils.appendRecursiveTypes(builder, (int[])var2_2, parameterizedType.getActualTypeArguments());
        } else {
            ParameterizedType parameterizedType2;
            GT_JOINER.join(builder, (Object[])parameterizedType2.getActualTypeArguments());
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> rawClass, Map<TypeVariable<?>, Type> typeVariableMap) {
        void var1_1;
        void var2_2;
        Type type;
        Objects.requireNonNull(rawClass, "rawClass");
        Objects.requireNonNull(typeVariableMap, "typeVariableMap");
        return TypeUtils.parameterizeWithOwner(type, rawClass, TypeUtils.extractTypeArgumentsFrom(var2_2, var1_1.getTypeParameters()));
    }

    /*
     * WARNING - void declaration
     */
    public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> rawClass, Type ... typeArguments) {
        void var2_2;
        Class<?> clazz;
        void var1_1;
        Class<?> useOwner;
        Objects.requireNonNull(rawClass, "rawClass");
        if (rawClass.getEnclosingClass() == null) {
            Validate.isTrue(owner == null, "no owner allowed for top-level %s", rawClass);
            useOwner = null;
        } else if (useOwner == null) {
            useOwner = rawClass.getEnclosingClass();
        } else {
            Validate.isTrue(TypeUtils.isAssignable(useOwner, rawClass.getEnclosingClass()), "%s is invalid owner type for parameterized %s", useOwner, rawClass);
        }
        Validate.noNullElements(typeArguments, "null type argument at index %s", new Object[0]);
        Validate.isTrue(rawClass.getTypeParameters().length == typeArguments.length, "invalid number of type parameters specified: expected %d, got %d", rawClass.getTypeParameters().length, typeArguments.length);
        return new ParameterizedTypeImpl((Class)var1_1, clazz, (Type[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type type2;
        if (type instanceof TypeVariable && typeVarAssigns != null) {
            void var1_1;
            Type replacementType = typeVarAssigns.get(type);
            if (replacementType == null) {
                throw new IllegalArgumentException("missing assignment type for type variable " + type);
            }
            return var1_1;
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    public static String toLongString(TypeVariable<?> typeVariable) {
        TypeVariable<?> typeVariable2;
        void var1_1;
        block5: {
            void var2_2;
            Objects.requireNonNull(typeVariable, "typeVariable");
            StringBuilder buf = new StringBuilder();
            Object d2 = typeVariable.getGenericDeclaration();
            if (d2 instanceof Class) {
                Class<?> c2 = (Class<?>)d2;
                while (true) {
                    if (c2.getEnclosingClass() == null) {
                        buf.insert(0, c2.getName());
                        break block5;
                    }
                    buf.insert(0, c2.getSimpleName()).insert(0, '.');
                    c2 = c2.getEnclosingClass();
                }
            }
            if (var2_2 instanceof Type) {
                buf.append(TypeUtils.toString((Type)var2_2));
            } else {
                buf.append(var2_2);
            }
        }
        return var1_1.append(':').append(TypeUtils.typeVariableToString(typeVariable2)).toString();
    }

    public static String toString(Type type) {
        Type type2;
        Objects.requireNonNull(type, "type");
        if (type instanceof Class) {
            return TypeUtils.classToString((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.parameterizedTypeToString((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.wildcardTypeToString((WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.typeVariableToString((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.genericArrayTypeToString((GenericArrayType)type);
        }
        throw new IllegalArgumentException(ObjectUtils.identityToString(type2));
    }

    public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> typeVariableMap) {
        Objects.requireNonNull(typeVariableMap, "typeVariableMap");
        for (Map.Entry<TypeVariable<?>, Type> entry : typeVariableMap.entrySet()) {
            Type[] typeArray;
            TypeVariable<?> typeVar = entry.getKey();
            Type type = entry.getValue();
            for (Type bound : TypeUtils.getImplicitBounds(typeArray)) {
                if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(bound, typeVariableMap), typeVariableMap)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static String typeVariableToString(TypeVariable<?> typeVariable) {
        void var1_1;
        void var2_2;
        StringBuilder builder = new StringBuilder(typeVariable.getName());
        Type[] bounds = typeVariable.getBounds();
        if (!(bounds.length <= 0 || bounds.length == 1 && Object.class.equals((Object)var2_2[0]))) {
            TypeVariable<?> typeVariable2;
            builder.append(" extends ");
            AMP_JOINER.join(builder, (Type[])typeVariable2.getBounds());
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static Type[] unrollBounds(Map<TypeVariable<?>, Type> typeArguments, Type[] bounds) {
        void var1_1;
        Type[] result = bounds;
        for (int i2 = 0; i2 < result.length; ++i2) {
            void var3_3;
            Type unrolled = TypeUtils.unrollVariables(typeArguments, result[i2]);
            if (unrolled == null) {
                result = ArrayUtils.remove(result, i2--);
                continue;
            }
            result[i2] = var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Type unrollVariableAssignments(TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
        void var2_2;
        Type result;
        while ((result = typeVarAssigns.get(typeVariable)) instanceof TypeVariable && !result.equals(typeVariable)) {
            typeVariable = (TypeVariable)result;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Type unrollVariables(Map<TypeVariable<?>, Type> typeArguments, Type type) {
        void var1_1;
        block6: {
            ParameterizedType p2;
            while (true) {
                if (typeArguments == null) {
                    typeArguments = Collections.emptyMap();
                }
                if (!TypeUtils.containsTypeVariables(type)) break block6;
                if (!(type instanceof TypeVariable)) break;
                type = typeArguments.get(type);
            }
            if (type instanceof ParameterizedType) {
                void var2_2;
                Map<TypeVariable<?>, Type> parameterizedTypeArguments;
                p2 = (ParameterizedType)type;
                if (p2.getOwnerType() != null) {
                    parameterizedTypeArguments = new HashMap(parameterizedTypeArguments);
                    parameterizedTypeArguments.putAll(TypeUtils.getTypeArguments(p2));
                }
                Type[] args2 = p2.getActualTypeArguments();
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    Type unrolled = TypeUtils.unrollVariables(parameterizedTypeArguments, args2[i2]);
                    if (unrolled == null) continue;
                    args2[i2] = unrolled;
                }
                return TypeUtils.parameterizeWithOwner(p2.getOwnerType(), (Class)p2.getRawType(), (Type[])var2_2);
            }
            if (p2 instanceof WildcardType) {
                Map<TypeVariable<?>, Type> map;
                WildcardType wild = (WildcardType)((Object)p2);
                return TypeUtils.wildcardType().withUpperBounds(TypeUtils.unrollBounds(map, wild.getUpperBounds())).withLowerBounds(TypeUtils.unrollBounds(map, var1_1.getLowerBounds())).build();
            }
        }
        return var1_1;
    }

    public static WildcardTypeBuilder wildcardType() {
        return new WildcardTypeBuilder();
    }

    /*
     * WARNING - void declaration
     */
    private static String wildcardTypeToString(WildcardType wildcardType) {
        void var1_1;
        StringBuilder builder = new StringBuilder("?");
        Type[] lowerBounds = wildcardType.getLowerBounds();
        Type[] upperBounds = wildcardType.getUpperBounds();
        if (lowerBounds.length > 1 || lowerBounds.length == 1 && lowerBounds[0] != null) {
            void var2_2;
            AMP_JOINER.join(builder.append(" super "), (Type[])var2_2);
        } else if (upperBounds.length > 1 || upperBounds.length == 1 && !Object.class.equals((Object)upperBounds[0])) {
            Type[] typeArray;
            AMP_JOINER.join(builder.append(" extends "), (Type[])typeArray);
        }
        return var1_1.toString();
    }

    public static <T> Typed<T> wrap(Class<T> type) {
        return TypeUtils.wrap(type);
    }

    public static <T> Typed<T> wrap(Type type) {
        return () -> type;
    }

    @Deprecated
    public TypeUtils() {
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(GenericArrayType x0, Type x1) {
        void var1_1;
        return TypeUtils.equals(x0, (Type)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(ParameterizedType x0, Type x1) {
        void var1_1;
        return TypeUtils.equals(x0, (Type)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$300(WildcardType x0, Type x1) {
        void var1_1;
        return TypeUtils.equals(x0, (Type)var1_1);
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        /*
         * WARNING - void declaration
         */
        private GenericArrayTypeImpl(Type componentType) {
            void var1_1;
            this.componentType = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            return obj == this || obj instanceof GenericArrayType && TypeUtils.access$000(this, (GenericArrayType)var1_1);
        }

        @Override
        public final Type getGenericComponentType() {
            return this.componentType;
        }

        public final int hashCode() {
            int n2 = 0x430 | this.componentType.hashCode();
            return n2;
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> raw;
        private final Type useOwner;
        private final Type[] typeArguments;

        /*
         * WARNING - void declaration
         */
        private ParameterizedTypeImpl(Class<?> rawClass, Type useOwner, Type[] typeArguments) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.raw = var1_1;
            this.useOwner = var2_2;
            void v0 = var3_3;
            this.typeArguments = (Type[])Arrays.copyOf(v0, ((void)v0).length, Type[].class);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            return obj == this || obj instanceof ParameterizedType && TypeUtils.access$100(this, (ParameterizedType)var1_1);
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public final Type getOwnerType() {
            return this.useOwner;
        }

        @Override
        public final Type getRawType() {
            return this.raw;
        }

        public final int hashCode() {
            int n2 = 0x470 | this.raw.hashCode();
            n2 <<= 4;
            n2 |= Objects.hashCode(this.useOwner);
            n2 <<= 8;
            return n2 |= Arrays.hashCode(this.typeArguments);
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }
    }

    public static class WildcardTypeBuilder
    implements Builder<WildcardType> {
        private Type[] upperBounds;
        private Type[] lowerBounds;

        private WildcardTypeBuilder() {
        }

        @Override
        public WildcardType build() {
            return new WildcardTypeImpl(this.upperBounds, this.lowerBounds);
        }

        /*
         * WARNING - void declaration
         */
        public WildcardTypeBuilder withLowerBounds(Type ... bounds) {
            void var1_1;
            this.lowerBounds = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public WildcardTypeBuilder withUpperBounds(Type ... bounds) {
            void var1_1;
            this.upperBounds = var1_1;
            return this;
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        private final Type[] upperBounds;
        private final Type[] lowerBounds;

        /*
         * WARNING - void declaration
         */
        private WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            void var2_2;
            void var1_1;
            this.upperBounds = ObjectUtils.defaultIfNull(var1_1, ArrayUtils.EMPTY_TYPE_ARRAY);
            this.lowerBounds = ObjectUtils.defaultIfNull(var2_2, ArrayUtils.EMPTY_TYPE_ARRAY);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            return obj == this || obj instanceof WildcardType && TypeUtils.access$300(this, (WildcardType)var1_1);
        }

        @Override
        public final Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        @Override
        public final Type[] getUpperBounds() {
            return (Type[])this.upperBounds.clone();
        }

        public final int hashCode() {
            int n2 = 0x4900 | Arrays.hashCode(this.upperBounds);
            n2 <<= 8;
            return n2 |= Arrays.hashCode(this.lowerBounds);
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }
    }
}

