/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class MethodUtils {
    private static final Comparator<Method> METHOD_BY_SIGNATURE = Comparator.comparing(Method::toString);

    /*
     * WARNING - void declaration
     */
    private static int distance(Class<?>[] fromClassArray, Class<?>[] toClassArray) {
        void var2_2;
        int answer = 0;
        if (!ClassUtils.isAssignable(fromClassArray, toClassArray, true)) {
            return -1;
        }
        for (int offset = 0; offset < fromClassArray.length; ++offset) {
            Class<?> aClass = fromClassArray[offset];
            Class<?> toClass = toClassArray[offset];
            if (aClass == null || aClass.equals(toClass)) continue;
            if (ClassUtils.isAssignable(aClass, toClass, true) && !ClassUtils.isAssignable(aClass, toClass, false)) {
                ++answer;
                continue;
            }
            answer += 2;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        void var2_2;
        void var1_1;
        return MethodUtils.getAccessibleMethod(MethodUtils.getMethodObject(cls, (String)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static Method getAccessibleMethod(Method method) {
        Method method2;
        Class<?>[] parameterTypes;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> cls = method.getDeclaringClass();
        if (ClassUtils.isPublic(cls)) {
            return method;
        }
        String methodName = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(cls, methodName, parameterTypes = method.getParameterTypes())) == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            method = MethodUtils.getAccessibleMethodFromSuperclass(var1_1, (String)var2_2, var3_3);
        }
        return method2;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        while (cls != null) {
            Class<?>[] classArray = cls.getInterfaces();
            Class<?>[] classArray2 = classArray;
            classArray2 = classArray;
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> anInterface = classArray2[i2];
                if (!ClassUtils.isPublic(anInterface)) continue;
                try {
                    return anInterface.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(anInterface, methodName, parameterTypes);
                    if (method == null) continue;
                    return method;
                }
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> parentClass = cls.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            if (!ClassUtils.isPublic(parentClass)) continue;
            return MethodUtils.getMethodObject(parentClass, methodName, parameterTypes);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> cls) {
        void var1_1;
        if (cls == null) {
            return null;
        }
        ArrayList<Class> allSuperClassesAndInterfaces = new ArrayList<Class>();
        List<Class<?>> allSuperclasses = ClassUtils.getAllSuperclasses(cls);
        int superClassIndex = 0;
        List<Class<?>> allInterfaces = ClassUtils.getAllInterfaces(cls);
        int interfaceIndex = 0;
        while (interfaceIndex < allInterfaces.size() || superClassIndex < allSuperclasses.size()) {
            Class acls = interfaceIndex < allInterfaces.size() && (superClassIndex >= allSuperclasses.size() || superClassIndex >= interfaceIndex) ? (Class)allInterfaces.get(interfaceIndex++) : allSuperclasses.get(superClassIndex++);
            allSuperClassesAndInterfaces.add(acls);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        void var2_2;
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(annotationCls, "annotationCls");
        if (!ignoreAccess && !MemberUtils.isAccessible(method)) {
            return null;
        }
        A annotation = method.getAnnotation(annotationCls);
        if (annotation == null && var2_2 != false) {
            Iterator<Class<?>> iterator2 = method.getDeclaringClass();
            iterator2 = MethodUtils.getAllSuperclassesAndInterfaces(iterator2);
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Class<?> acls = iterator2.next();
                Method equivalentMethod = ignoreAccess ? MethodUtils.getMatchingMethod(acls, method.getName(), method.getParameterTypes()) : MethodUtils.getMatchingAccessibleMethod(acls, method.getName(), method.getParameterTypes());
                if (equivalentMethod == null || (annotation = equivalentMethod.getAnnotation(annotationCls)) == null) continue;
            }
        }
        return annotation;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMatchingAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        void var1_1;
        GenericDeclaration accessibleMethod;
        Method candidate = MethodUtils.getMethodObject(cls, methodName, parameterTypes);
        if (candidate != null) {
            return MemberUtils.setAccessibleWorkaround(candidate);
        }
        cls = cls.getMethods();
        Class<?> matchingMethods = Stream.of(cls).filter(method -> {
            void var1_1;
            void var2_2;
            String string;
            return method.getName().equals(string) && MemberUtils.isMatchingMethod((Method)var2_2, var1_1);
        }).collect(Collectors.toList());
        matchingMethods.sort(METHOD_BY_SIGNATURE);
        Method bestMatch = null;
        matchingMethods = matchingMethods.iterator();
        while (matchingMethods.hasNext()) {
            candidate = (Method)matchingMethods.next();
            accessibleMethod = MethodUtils.getAccessibleMethod(candidate);
            if (accessibleMethod == null || bestMatch != null && MemberUtils.compareMethodFit(accessibleMethod, bestMatch, parameterTypes) >= 0) continue;
            bestMatch = accessibleMethod;
        }
        if (bestMatch != null) {
            MemberUtils.setAccessibleWorkaround(bestMatch);
        }
        if (bestMatch != null && bestMatch.isVarArgs() && bestMatch.getParameterTypes().length > 0 && parameterTypes.length > 0) {
            Class<?> clazz;
            void var3_3;
            void var2_2;
            Class<?> parameterTypeSuperClassName;
            Class<?> methodParameterTypes = bestMatch.getParameterTypes();
            accessibleMethod = methodParameterTypes[((Class<?>[])methodParameterTypes).length - 1].getComponentType();
            String methodParameterComponentTypeName = ClassUtils.primitiveToWrapper(accessibleMethod).getName();
            Class<?> lastParameterType = parameterTypes[parameterTypes.length - 1];
            String parameterTypeName = lastParameterType == null ? null : lastParameterType.getName();
            Object object = parameterTypeSuperClassName = lastParameterType == null ? null : lastParameterType.getSuperclass().getName();
            if (parameterTypeName != null && parameterTypeSuperClassName != null && !methodParameterComponentTypeName.equals(var2_2) && !var3_3.equals(clazz)) {
                return null;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMatchingMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Class<?> clazz;
        void var2_2;
        void var1_1;
        void var3_3;
        Objects.requireNonNull(cls, "cls");
        Validate.notEmpty(methodName, "methodName", new Object[0]);
        List methods = Stream.of(cls.getDeclaredMethods()).filter(method -> {
            String string;
            return method.getName().equals(string);
        }).collect(Collectors.toList());
        ClassUtils.getAllSuperclasses(cls).stream().map(Class::getDeclaredMethods).flatMap(Stream::of).filter(method -> {
            String string;
            return method.getName().equals(string);
        }).forEach(methods::add);
        for (Method method2 : methods) {
            if (!Arrays.deepEquals(method2.getParameterTypes(), parameterTypes)) continue;
            return method2;
        }
        TreeMap candidates = new TreeMap();
        var3_3.stream().filter(method -> {
            void var1_1;
            return ClassUtils.isAssignable(parameterTypes, var1_1.getParameterTypes(), true);
        }).forEach(method -> {
            void var2_4;
            void var0_1;
            void var1_3;
            int distance = MethodUtils.distance(parameterTypes, method.getParameterTypes());
            List list = var1_3.computeIfAbsent((int)var0_1, k2 -> new ArrayList());
            list.add(var2_4);
        });
        if (candidates.isEmpty()) {
            return null;
        }
        List bestCandidates = (List)candidates.values().iterator().next();
        if (bestCandidates.size() == 1 || !Objects.equals(((Method)bestCandidates.get(0)).getDeclaringClass(), ((Method)bestCandidates.get(1)).getDeclaringClass())) {
            return (Method)bestCandidates.get(0);
        }
        throw new IllegalStateException(String.format("Found multiple candidates for method %s on class %s : %s", (String)var1_1 + Stream.of(var2_2).map(String::valueOf).collect(Collectors.joining(",", "(", ")")), clazz.getName(), bestCandidates.stream().map(Method::toString).collect(Collectors.joining(",", "[", "]"))));
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethodObject(Class<?> cls, String name, Class<?> ... parameterTypes) {
        try {
            void var2_2;
            void var1_1;
            return cls.getMethod((String)var1_1, (Class<?>)var2_2);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        void var1_1;
        return MethodUtils.getMethodsListWithAnnotation(cls, (Class<? extends Annotation>)var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        Serializable serializable;
        void var1_1;
        void var3_4;
        void var2_3;
        Objects.requireNonNull(cls, "cls");
        Objects.requireNonNull(annotationCls, "annotationCls");
        ArrayList classes = searchSupers ? MethodUtils.getAllSuperclassesAndInterfaces(cls) : new ArrayList();
        classes.add(0, cls);
        Serializable annotatedMethods = new ArrayList();
        var2_3.forEach(arg_0 -> MethodUtils.lambda$getMethodsListWithAnnotation$7((boolean)var3_4, (Class)var1_1, annotatedMethods, arg_0));
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        void var1_1;
        return MethodUtils.getMethodsWithAnnotation(cls, (Class<? extends Annotation>)var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MethodUtils.getMethodsListWithAnnotation(cls, (Class<? extends Annotation>)var1_1, (boolean)var2_2, (boolean)var3_3).toArray(ArrayUtils.EMPTY_METHOD_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils.Interfaces interfacesBehavior) {
        void var2_2;
        Objects.requireNonNull(method, "method");
        LinkedHashSet<Method> result = new LinkedHashSet<Method>();
        result.add(method);
        Object[] parameterTypes = method.getParameterTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        Iterator<Class<?>> hierarchy = ClassUtils.hierarchy(declaringClass, interfacesBehavior).iterator();
        hierarchy.next();
        block0: while (hierarchy.hasNext()) {
            Class<?> clazz = hierarchy.next();
            Method m2 = MethodUtils.getMatchingAccessibleMethod(clazz, method.getName(), parameterTypes);
            if (m2 == null) continue;
            if (Arrays.equals(m2.getParameterTypes(), parameterTypes)) {
                result.add(m2);
                continue;
            }
            Map<TypeVariable<?>, Type> typeArguments = TypeUtils.getTypeArguments(declaringClass, m2.getDeclaringClass());
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                Type parentType;
                Type childType = TypeUtils.unrollVariables(typeArguments, method.getGenericParameterTypes()[i2]);
                if (!TypeUtils.equals(childType, parentType = TypeUtils.unrollVariables(typeArguments, m2.getGenericParameterTypes()[i2]))) continue block0;
            }
            result.add(m2);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static Object[] getVarArgs(Object[] args2, Class<?>[] methodParameterTypes) {
        void var2_2;
        Object object;
        void var3_3;
        if (args2.length == methodParameterTypes.length && (args2[args2.length - 1] == null || args2[args2.length - 1].getClass().equals(methodParameterTypes[methodParameterTypes.length - 1]))) {
            return args2;
        }
        Object[] newArgs = ArrayUtils.arraycopy(args2, 0, 0, methodParameterTypes.length - 1, () -> new Object[methodParameterTypes.length]);
        Class<?> varArgComponentType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
        int varArgLength = args2.length - methodParameterTypes.length + 1;
        Object varArgsArray = ArrayUtils.arraycopy(args2, methodParameterTypes.length - 1, 0, varArgLength, s2 -> {
            void var1_1;
            return Array.newInstance(ClassUtils.primitiveToWrapper(varArgComponentType), (int)var1_1);
        });
        if (var3_3.isPrimitive()) {
            varArgsArray = ArrayUtils.toPrimitive(varArgsArray);
        }
        newArgs[((void)var1_1).length - 1] = object;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var1_1;
        return MethodUtils.invokeExactMethod(object, (String)var1_1, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactMethod(Object object, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var1_1;
        Object object2;
        void var2_2;
        args2 = ArrayUtils.nullToEmpty(args2);
        void v0 = var2_2;
        return MethodUtils.invokeExactMethod(object2, (String)var1_1, (Object[])v0, ClassUtils.toClass((Object[])v0));
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactMethod(Object object, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        Object object2;
        void var3_3;
        Objects.requireNonNull(object, "object");
        args2 = ArrayUtils.nullToEmpty(args2);
        parameterTypes = ArrayUtils.nullToEmpty(parameterTypes);
        Class<?> cls = object.getClass();
        Method method = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes);
        if (method == null) {
            void var1_1;
            throw new NoSuchMethodException("No such accessible method: " + (String)var1_1 + "() on object: " + cls.getName());
        }
        return var3_3.invoke(object2, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var1_1;
        Class<?> clazz;
        void var2_2;
        args2 = ArrayUtils.nullToEmpty(args2);
        void v0 = var2_2;
        return MethodUtils.invokeExactStaticMethod(clazz, (String)var1_1, (Object[])v0, ClassUtils.toClass((Object[])v0));
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        void var3_3;
        args2 = ArrayUtils.nullToEmpty(args2);
        Method method = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (method == null) {
            Class<?> clazz;
            void var1_1;
            throw new NoSuchMethodException("No such accessible method: " + (String)var1_1 + "() on class: " + clazz.getName());
        }
        return var3_3.invoke(null, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, boolean forceAccess, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        void var1_1;
        return MethodUtils.invokeMethod(object, (boolean)var1_1, (String)var2_2, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        void var1_1;
        Object object2;
        void var3_3;
        args2 = ArrayUtils.nullToEmpty(args2);
        void v0 = var3_3;
        return MethodUtils.invokeMethod(object2, (boolean)var1_1, (String)var2_2, (Object[])v0, ClassUtils.toClass((Object[])v0));
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_4;
        Object object2;
        Method method;
        String messagePrefix;
        Objects.requireNonNull(object, "object");
        parameterTypes = ArrayUtils.nullToEmpty(parameterTypes);
        args2 = ArrayUtils.nullToEmpty(args2);
        Class<?> cls = object.getClass();
        if (forceAccess) {
            messagePrefix = "No such method: ";
            method = MethodUtils.getMatchingMethod(cls, methodName, parameterTypes);
            if (method != null && !method.isAccessible()) {
                method.setAccessible(true);
            }
        } else {
            messagePrefix = "No such accessible method: ";
            method = MethodUtils.getMatchingAccessibleMethod(cls, methodName, method);
        }
        if (method == null) {
            void var2_3;
            void var1_2;
            throw new NoSuchMethodException((String)var1_2 + (String)var2_3 + "() on object: " + cls.getName());
        }
        args2 = MethodUtils.toVarArgs(method, args2);
        return method.invoke(object2, (Object[])var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var1_1;
        return MethodUtils.invokeMethod(object, (String)var1_1, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var1_1;
        Object object2;
        void var2_2;
        args2 = ArrayUtils.nullToEmpty(args2);
        void v0 = var2_2;
        return MethodUtils.invokeMethod(object2, (String)var1_1, (Object[])v0, ClassUtils.toClass((Object[])v0));
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_3;
        void var2_2;
        void var1_1;
        return MethodUtils.invokeMethod(object, false, (String)var1_1, (Object[])var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var1_1;
        Class<?> clazz;
        void var2_2;
        args2 = ArrayUtils.nullToEmpty(args2);
        void v0 = var2_2;
        return MethodUtils.invokeStaticMethod(clazz, (String)var1_1, (Object[])v0, ClassUtils.toClass((Object[])v0));
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        void var3_3;
        args2 = ArrayUtils.nullToEmpty(args2);
        Method method = MethodUtils.getMatchingAccessibleMethod(cls, methodName, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (method == null) {
            Class<?> clazz;
            void var1_1;
            throw new NoSuchMethodException("No such accessible method: " + (String)var1_1 + "() on class: " + clazz.getName());
        }
        args2 = MethodUtils.toVarArgs(method, args2);
        return var3_3.invoke(null, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] toVarArgs(Method method, Object[] args2) {
        void var1_1;
        if (method.isVarArgs()) {
            Class<?>[] classArray;
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            args2 = MethodUtils.getVarArgs(args2, classArray);
        }
        return var1_1;
    }

    @Deprecated
    public MethodUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$getMethodsListWithAnnotation$7(boolean ignoreAccess, Class annotationCls, List annotatedMethods, Class acls) {
        void var2_3;
        void var1_2;
        void var3_4;
        Method[] methodArray = ignoreAccess ? acls.getDeclaredMethods() : var3_4.getMethods();
        Stream.of(methodArray).filter(arg_0 -> MethodUtils.lambda$getMethodsListWithAnnotation$6((Class)var1_2, arg_0)).forEachOrdered(((List)var2_3)::add);
    }

    private static /* synthetic */ boolean lambda$getMethodsListWithAnnotation$6(Class annotationCls, Method method) {
        Class clazz;
        return method.isAnnotationPresent(clazz);
    }
}

