/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ExceptionUtils {
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
    private static final int NOT_FOUND = -1;
    static final String WRAPPED_MARKER = " [wrapped] ";

    public static <T extends RuntimeException> T asRuntimeException(Throwable throwable) {
        return (T)((RuntimeException)ExceptionUtils.eraseType(throwable));
    }

    private static <R, T extends Throwable> R eraseType(Throwable throwable) throws T {
        throw throwable;
    }

    /*
     * WARNING - void declaration
     */
    public static void forEach(Throwable throwable, Consumer<Throwable> consumer) {
        void var1_1;
        ExceptionUtils.stream(throwable).forEach((Consumer<Throwable>)var1_1);
    }

    @Deprecated
    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, null);
    }

    @Deprecated
    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        Throwable throwable2;
        String[] stringArray;
        if (throwable == null) {
            return null;
        }
        if (methodNames == null) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                return stringArray;
            }
            stringArray = CAUSE_METHOD_NAMES;
        }
        return Stream.of(stringArray).map(m2 -> {
            void var1_1;
            return ExceptionUtils.getCauseUsingMethodName(throwable2, (String)var1_1);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method;
        if (methodName != null && (method = MethodUtils.getMethodObject(throwable.getClass(), methodName, new Class[0])) != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                Throwable throwable2;
                void var1_1;
                return (Throwable)var1_1.invoke((Object)throwable2, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
        return null;
    }

    @Deprecated
    public static String[] getDefaultCauseMethodNames() {
        return ArrayUtils.clone(CAUSE_METHOD_NAMES);
    }

    /*
     * WARNING - void declaration
     */
    public static String getMessage(Throwable th) {
        Throwable throwable;
        void var1_1;
        if (th == null) {
            return "";
        }
        String clsName = ClassUtils.getShortClassName(th, null);
        return (String)var1_1 + ": " + StringUtils.defaultString(throwable.getMessage());
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list;
        List<Throwable> list2 = ExceptionUtils.getThrowableList(throwable);
        if (list2.isEmpty()) {
            return null;
        }
        List<Throwable> list3 = list;
        return (Throwable)list3.get(list3.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getRootCauseMessage(Throwable throwable) {
        void var1_1;
        Throwable throwable2;
        Throwable root = ExceptionUtils.getRootCause(throwable);
        return ExceptionUtils.getMessage((Throwable)(root == null ? throwable2 : var1_1));
    }

    public static String[] getRootCauseStackTrace(Throwable throwable) {
        return ExceptionUtils.getRootCauseStackTraceList(throwable).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getRootCauseStackTraceList(Throwable throwable) {
        void var2_2;
        if (throwable == null) {
            return Collections.emptyList();
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(throwable);
        int count = throwables.length;
        ArrayList<String> frames = new ArrayList<String>();
        List<String> nextTrace = ExceptionUtils.getStackFrameList(throwables[count - 1]);
        int i2 = count;
        while (--i2 >= 0) {
            List<String> trace = nextTrace;
            if (i2 != 0) {
                nextTrace = ExceptionUtils.getStackFrameList(throwables[i2 - 1]);
                ExceptionUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i2 == count - 1) {
                frames.add(throwables[i2].toString());
            } else {
                frames.add(WRAPPED_MARKER + throwables[i2].toString());
            }
            frames.addAll(trace);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static List<String> getStackFrameList(Throwable throwable) {
        void var1_1;
        String stackTrace = ExceptionUtils.getStackTrace(throwable);
        String linebreak = System.lineSeparator();
        String frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<void> list = new ArrayList<void>();
        boolean traceStarted = false;
        while (((StringTokenizer)((Object)frames)).hasMoreTokens()) {
            String token = ((StringTokenizer)((Object)frames)).nextToken();
            int at = token.indexOf("at");
            if (at != -1 && token.substring(0, at).trim().isEmpty()) {
                void var3_3;
                traceStarted = true;
                list.add(var3_3);
                continue;
            }
            if (!traceStarted) continue;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static String[] getStackFrames(String stackTrace) {
        void var1_1;
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return var1_1.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] getStackFrames(Throwable throwable) {
        Throwable throwable2;
        if (throwable == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable2));
    }

    /*
     * WARNING - void declaration
     */
    public static String getStackTrace(Throwable throwable) {
        void var1_1;
        Throwable throwable2;
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        throwable2.printStackTrace(new PrintWriter((Writer)sw, true));
        return var1_1.toString();
    }

    public static int getThrowableCount(Throwable throwable) {
        return ExceptionUtils.getThrowableList(throwable).size();
    }

    /*
     * WARNING - void declaration
     */
    public static List<Throwable> getThrowableList(Throwable throwable) {
        void var1_1;
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return var1_1;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        return ExceptionUtils.getThrowableList(throwable).toArray(ArrayUtils.EMPTY_THROWABLE_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasCause(Throwable chain, Class<? extends Throwable> type) {
        Throwable throwable;
        void var1_1;
        if (chain instanceof UndeclaredThrowableException) {
            chain = chain.getCause();
        }
        return var1_1.isInstance(throwable);
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOf(Throwable throwable, Class<? extends Throwable> type, int fromIndex, boolean subclass) {
        void i2;
        void var3_3;
        Throwable[] throwables;
        if (throwable == null || type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = ExceptionUtils.getThrowables(throwable)).length) {
            return -1;
        }
        if (var3_3 != false) {
            while (i2 < throwables.length) {
                if (type.isAssignableFrom(throwables[i2].getClass())) {
                    return (int)i2;
                }
                ++i2;
            }
        } else {
            while (i2 < throwables.length) {
                if (type.equals(throwables[i2].getClass())) {
                    return (int)i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfThrowable(Throwable throwable, Class<? extends Throwable> clazz) {
        void var1_1;
        return ExceptionUtils.indexOf(throwable, (Class<? extends Throwable>)var1_1, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfThrowable(Throwable throwable, Class<? extends Throwable> clazz, int fromIndex) {
        void var2_2;
        void var1_1;
        return ExceptionUtils.indexOf(throwable, (Class<? extends Throwable>)var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfType(Throwable throwable, Class<? extends Throwable> type) {
        void var1_1;
        return ExceptionUtils.indexOf(throwable, (Class<? extends Throwable>)var1_1, 0, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfType(Throwable throwable, Class<? extends Throwable> type, int fromIndex) {
        void var2_2;
        void var1_1;
        return ExceptionUtils.indexOf(throwable, (Class<? extends Throwable>)var1_1, (int)var2_2, true);
    }

    public static boolean isChecked(Throwable throwable) {
        Throwable throwable2;
        return throwable != null && !(throwable instanceof Error) && !(throwable2 instanceof RuntimeException);
    }

    public static boolean isUnchecked(Throwable throwable) {
        Throwable throwable2;
        return throwable != null && (throwable instanceof Error || throwable2 instanceof RuntimeException);
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace(throwable, System.err);
    }

    /*
     * WARNING - void declaration
     */
    public static void printRootCauseStackTrace(Throwable throwable, PrintStream printStream) {
        void var1_1;
        Throwable throwable2;
        if (throwable == null) {
            return;
        }
        Objects.requireNonNull(printStream, "printStream");
        ExceptionUtils.getRootCauseStackTraceList(throwable2).forEach(printStream::println);
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter printWriter) {
        void var1_1;
        Throwable throwable2;
        if (throwable == null) {
            return;
        }
        Objects.requireNonNull(printWriter, "printWriter");
        ExceptionUtils.getRootCauseStackTraceList(throwable2).forEach(printWriter::println);
        var1_1.flush();
    }

    public static void removeCommonFrames(List<String> causeFrames, List<String> wrapperFrames) {
        Objects.requireNonNull(causeFrames, "causeFrames");
        Objects.requireNonNull(wrapperFrames, "wrapperFrames");
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }

    public static <T> T rethrow(Throwable throwable) {
        return (T)ExceptionUtils.eraseType(throwable);
    }

    public static Stream<Throwable> stream(Throwable throwable) {
        return ExceptionUtils.getThrowableList(throwable).stream();
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Throwable> T throwableOf(Throwable throwable, Class<T> type, int fromIndex, boolean subclass) {
        void i2;
        void var3_3;
        Throwable[] throwables;
        if (throwable == null || type == null) {
            return null;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = ExceptionUtils.getThrowables(throwable)).length) {
            return null;
        }
        if (var3_3 != false) {
            while (i2 < throwables.length) {
                if (type.isAssignableFrom(throwables[i2].getClass())) {
                    return (T)((Throwable)type.cast(throwables[i2]));
                }
                ++i2;
            }
        } else {
            while (i2 < throwables.length) {
                if (type.equals(throwables[i2].getClass())) {
                    return (T)((Throwable)type.cast(throwables[i2]));
                }
                ++i2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T throwableOfThrowable(Throwable throwable, Class<T> clazz) {
        void var1_1;
        return ExceptionUtils.throwableOf(throwable, var1_1, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T throwableOfThrowable(Throwable throwable, Class<T> clazz, int fromIndex) {
        void var2_2;
        void var1_1;
        return ExceptionUtils.throwableOf(throwable, var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T throwableOfType(Throwable throwable, Class<T> type) {
        void var1_1;
        return ExceptionUtils.throwableOf(throwable, var1_1, 0, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T throwableOfType(Throwable throwable, Class<T> type, int fromIndex) {
        void var2_2;
        void var1_1;
        return ExceptionUtils.throwableOf(throwable, var1_1, (int)var2_2, true);
    }

    @Deprecated
    public static <T> T throwUnchecked(T throwable) {
        T t2;
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return t2;
    }

    public static <T extends Throwable> T throwUnchecked(T throwable) {
        T t2;
        if (ExceptionUtils.isUnchecked(throwable)) {
            throw ExceptionUtils.asRuntimeException(throwable);
        }
        return t2;
    }

    public static <R> R wrapAndThrow(Throwable throwable) {
        Throwable throwable2;
        throw new UndeclaredThrowableException(ExceptionUtils.throwUnchecked(throwable2));
    }

    @Deprecated
    public ExceptionUtils() {
    }
}

