/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.FailableConsumer;

public class EventListenerSupport<L>
implements Serializable {
    private static final long serialVersionUID = 3593265990380473632L;
    private List<L> listeners = new CopyOnWriteArrayList<L>();
    private transient L proxy;
    private transient L[] prototypeArray;

    public static <T> EventListenerSupport<T> create(Class<T> listenerInterface) {
        Class<T> clazz;
        return new EventListenerSupport<T>(clazz);
    }

    private EventListenerSupport() {
    }

    /*
     * WARNING - void declaration
     */
    public EventListenerSupport(Class<L> listenerInterface) {
        this((Class<L>)var1_1, Thread.currentThread().getContextClassLoader());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EventListenerSupport(Class<L> listenerInterface, ClassLoader classLoader) {
        this();
        void var2_2;
        void var1_1;
        Objects.requireNonNull(listenerInterface, "listenerInterface");
        Objects.requireNonNull(classLoader, "classLoader");
        Validate.isTrue(listenerInterface.isInterface(), "Class %s is not an interface", listenerInterface.getName());
        super.initializeTransientFields((Class<L>)var1_1, (ClassLoader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(L listener) {
        void var1_1;
        this.addListener(var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(L listener, boolean allowDuplicate) {
        void var2_2;
        Objects.requireNonNull(listener, "listener");
        if (var2_2 != false || !this.listeners.contains(listener)) {
            void var1_1;
            this.listeners.add(var1_1);
        }
    }

    protected InvocationHandler createInvocationHandler() {
        return new ProxyInvocationHandler(this);
    }

    /*
     * WARNING - void declaration
     */
    private void createProxy(Class<L> listenerInterface, ClassLoader classLoader) {
        void var1_1;
        void var2_2;
        this.proxy = listenerInterface.cast(Proxy.newProxyInstance((ClassLoader)var2_2, new Class[]{var1_1}, this.createInvocationHandler()));
    }

    public L fire() {
        return this.proxy;
    }

    int getListenerCount() {
        return this.listeners.size();
    }

    public L[] getListeners() {
        return this.listeners.toArray(this.prototypeArray);
    }

    /*
     * WARNING - void declaration
     */
    private void initializeTransientFields(Class<L> listenerInterface, ClassLoader classLoader) {
        void var2_2;
        void var1_1;
        this.prototypeArray = ArrayUtils.newInstance(listenerInterface, 0);
        this.createProxy((Class<L>)var1_1, (ClassLoader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        void var1_1;
        Object[] srcListeners = (Object[])objectInputStream.readObject();
        this.listeners = new CopyOnWriteArrayList<Object>(srcListeners);
        Class<Object> listenerInterface = ArrayUtils.getComponentType(srcListeners);
        this.initializeTransientFields((Class<L>)var1_1, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    public void removeListener(L listener) {
        void var1_1;
        Objects.requireNonNull(listener, "listener");
        this.listeners.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        void var2_2;
        void var1_1;
        ArrayList<L> serializableListeners = new ArrayList<L>();
        ObjectOutputStream testObjectOutputStream = new ObjectOutputStream(new ByteArrayOutputStream());
        for (L listener : this.listeners) {
            try {
                testObjectOutputStream.writeObject(listener);
                serializableListeners.add(listener);
            }
            catch (IOException iOException) {
                testObjectOutputStream = new ObjectOutputStream(new ByteArrayOutputStream());
            }
        }
        var1_1.writeObject(var2_2.toArray(this.prototypeArray));
    }

    protected class ProxyInvocationHandler
    implements InvocationHandler {
        private final FailableConsumer<Throwable, IllegalAccessException> handler;
        final /* synthetic */ EventListenerSupport this$0;

        /*
         * WARNING - void declaration
         */
        public ProxyInvocationHandler(EventListenerSupport this$0) {
            this((EventListenerSupport)var1_1, ExceptionUtils::rethrow);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ProxyInvocationHandler(EventListenerSupport this$0, FailableConsumer<Throwable, IllegalAccessException> handler) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.handler = (FailableConsumer)Objects.requireNonNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected void handle(Throwable t2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            void var1_1;
            this.handler.accept((Throwable)var1_1);
        }

        @Override
        public Object invoke(Object unusedProxy, Method method, Object[] args2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            for (Object listener : this.this$0.listeners) {
                try {
                    method.invoke(listener, args2);
                }
                catch (Throwable t2) {
                    this.handle(t2);
                }
            }
            return null;
        }
    }
}

