/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ConcurrentUtils {
    static Throwable checkedException(Throwable ex) {
        Throwable throwable;
        Validate.isTrue(ExceptionUtils.isChecked(ex), "Not a checked exception: " + ex, new Object[0]);
        return throwable;
    }

    public static <T> Future<T> constantFuture(T value) {
        T t2;
        return new ConstantFuture<T>(t2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> V createIfAbsent(ConcurrentMap<K, V> map, K key, ConcurrentInitializer<V> init) throws ConcurrentException {
        void var3_3;
        if (map == null || init == null) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            void var2_2;
            void var1_1;
            ConcurrentMap<K, V> concurrentMap;
            return ConcurrentUtils.putIfAbsent(concurrentMap, var1_1, var2_2.get());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> V createIfAbsentUnchecked(ConcurrentMap<K, V> map, K key, ConcurrentInitializer<V> init) {
        try {
            void var2_3;
            void var1_2;
            return ConcurrentUtils.createIfAbsent(map, var1_2, var2_3);
        }
        catch (ConcurrentException cex) {
            void var0_1;
            throw new ConcurrentRuntimeException(var0_1.getCause());
        }
    }

    public static ConcurrentException extractCause(ExecutionException ex) {
        ExecutionException executionException;
        if (ex == null || ex.getCause() == null) {
            return null;
        }
        ExceptionUtils.throwUnchecked(ex.getCause());
        return new ConcurrentException(ex.getMessage(), executionException.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException ex) {
        ExecutionException executionException;
        if (ex == null || ex.getCause() == null) {
            return null;
        }
        ExceptionUtils.throwUnchecked(ex.getCause());
        return new ConcurrentRuntimeException(ex.getMessage(), executionException.getCause());
    }

    public static void handleCause(ExecutionException ex) throws ConcurrentException {
        Exception cause = ConcurrentUtils.extractCause(ex);
        if (cause != null) {
            Exception exception;
            throw exception;
        }
    }

    public static void handleCauseUnchecked(ExecutionException ex) {
        Exception cause = ConcurrentUtils.extractCauseUnchecked(ex);
        if (cause != null) {
            Exception exception;
            throw exception;
        }
    }

    public static <T> T initialize(ConcurrentInitializer<T> initializer) throws ConcurrentException {
        if (initializer != null) {
            ConcurrentInitializer<T> concurrentInitializer;
            return concurrentInitializer.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T initializeUnchecked(ConcurrentInitializer<T> initializer) {
        try {
            return ConcurrentUtils.initialize(initializer);
        }
        catch (ConcurrentException cex) {
            void var0_1;
            throw new ConcurrentRuntimeException(var0_1.getCause());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map, K key, V value) {
        void var2_2;
        void var1_1;
        if (map == null) {
            return null;
        }
        ConcurrentMap<K, V> result = map.putIfAbsent(var1_1, value);
        if (result != null) {
            ConcurrentMap<K, V> concurrentMap;
            return (V)concurrentMap;
        }
        return var2_2;
    }

    private ConcurrentUtils() {
    }

    static final class ConstantFuture<T>
    implements Future<T> {
        private final T value;

        /*
         * WARNING - void declaration
         */
        ConstantFuture(T value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public final T get() {
            return this.value;
        }

        @Override
        public final T get(long timeout2, TimeUnit unit) {
            return this.value;
        }

        @Override
        public final boolean isCancelled() {
            return false;
        }

        @Override
        public final boolean isDone() {
            return true;
        }
    }
}

