/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.CircuitBreaker;

public abstract class AbstractCircuitBreaker<T>
implements CircuitBreaker<T> {
    public static final String PROPERTY_NAME = "open";
    protected final AtomicReference<State> state = new AtomicReference<State>(State.CLOSED);
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    protected static boolean isOpen(State state) {
        return state == State.OPEN;
    }

    /*
     * WARNING - void declaration
     */
    public void addChangeListener(PropertyChangeListener listener) {
        void var1_1;
        this.changeSupport.addPropertyChangeListener((PropertyChangeListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void changeState(State newState) {
        if (this.state.compareAndSet(newState.oppositeState(), newState)) {
            void var1_1;
            this.changeSupport.firePropertyChange(PROPERTY_NAME, !AbstractCircuitBreaker.isOpen(newState), AbstractCircuitBreaker.isOpen((State)var1_1));
        }
    }

    @Override
    public abstract boolean checkState();

    @Override
    public void close() {
        this.changeState(State.CLOSED);
    }

    @Override
    public abstract boolean incrementAndCheckState(T var1);

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public boolean isOpen() {
        return AbstractCircuitBreaker.isOpen(this.state.get());
    }

    @Override
    public void open() {
        this.changeState(State.OPEN);
    }

    /*
     * WARNING - void declaration
     */
    public void removeChangeListener(PropertyChangeListener listener) {
        void var1_1;
        this.changeSupport.removePropertyChangeListener((PropertyChangeListener)var1_1);
    }

    protected static enum State {
        CLOSED{

            @Override
            public final State oppositeState() {
                return OPEN;
            }
        }
        ,
        OPEN{

            @Override
            public final State oppositeState() {
                return CLOSED;
            }
        };


        public abstract State oppositeState();
    }
}

