/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.EqualsExclude;
import org.apache.commons.lang3.builder.IDKey;
import org.apache.commons.lang3.builder.Reflection;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class EqualsBuilder
implements Builder<Boolean> {
    private static final ThreadLocal<Set<Pair<IDKey, IDKey>>> REGISTRY = ThreadLocal.withInitial(HashSet::new);
    private boolean isEquals = true;
    private boolean testTransients;
    private boolean testRecursive;
    private List<Class<?>> bypassReflectionClasses = new ArrayList(1);
    private Class<?> reflectUpToClass;
    private String[] excludeFields;

    /*
     * WARNING - void declaration
     */
    static Pair<IDKey, IDKey> getRegisterPair(Object lhs, Object rhs) {
        void var1_1;
        Object object;
        return Pair.of(new IDKey(object), new IDKey(var1_1));
    }

    static Set<Pair<IDKey, IDKey>> getRegistry() {
        return REGISTRY.get();
    }

    /*
     * WARNING - void declaration
     */
    static boolean isRegistered(Object lhs, Object rhs) {
        void var1_1;
        void var2_2;
        Pair<IDKey, IDKey> pair;
        Set<Pair<IDKey, IDKey>> registry = EqualsBuilder.getRegistry();
        Pair<IDKey, IDKey> pair2 = EqualsBuilder.getRegisterPair(lhs, rhs);
        Pair<IDKey, IDKey> swappedPair = Pair.of(pair2.getRight(), pair2.getLeft());
        return registry != null && (registry.contains(pair) || var2_2.contains(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients) {
        void var2_2;
        void var1_1;
        return EqualsBuilder.reflectionEquals(lhs, (Object)var1_1, (boolean)var2_2, null, new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients, Class<?> reflectUpToClass, boolean testRecursive, String ... excludeFields) {
        void var1_1;
        Object object;
        void var2_2;
        void var3_3;
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return new EqualsBuilder().setExcludeFields(excludeFields).setReflectUpToClass((Class<?>)var3_3).setTestTransients((boolean)var2_2).setTestRecursive(testRecursive).reflectionAppend(object, var1_1).isEquals();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients, Class<?> reflectUpToClass, String ... excludeFields) {
        void var3_3;
        void var2_2;
        void var1_1;
        return EqualsBuilder.reflectionEquals(lhs, (Object)var1_1, (boolean)var2_2, var3_3, false, excludeFields);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean reflectionEquals(Object lhs, Object rhs, Collection<String> excludeFields) {
        void var2_2;
        void var1_1;
        return EqualsBuilder.reflectionEquals(lhs, (Object)var1_1, ReflectionToStringBuilder.toNoNullStringArray((Collection<String>)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean reflectionEquals(Object lhs, Object rhs, String ... excludeFields) {
        void var2_2;
        void var1_1;
        return EqualsBuilder.reflectionEquals(lhs, (Object)var1_1, false, null, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void register(Object lhs, Object rhs) {
        void var1_1;
        Object object;
        EqualsBuilder.getRegistry().add(EqualsBuilder.getRegisterPair(object, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static void unregister(Object lhs, Object rhs) {
        void var2_2;
        void var1_1;
        Object object;
        Set<Pair<IDKey, IDKey>> registry = EqualsBuilder.getRegistry();
        registry.remove(EqualsBuilder.getRegisterPair(object, var1_1));
        if (var2_2.isEmpty()) {
            REGISTRY.remove();
        }
    }

    public EqualsBuilder() {
        this.bypassReflectionClasses.add(String.class);
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(boolean lhs, boolean rhs) {
        void var2_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1 == var2_2;
        return this;
    }

    public EqualsBuilder append(boolean[] lhs, boolean[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(byte lhs, byte rhs) {
        if (this.isEquals) {
            void var2_2;
            void var1_1;
            this.isEquals = var1_1 == var2_2;
        }
        return this;
    }

    public EqualsBuilder append(byte[] lhs, byte[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(char lhs, char rhs) {
        if (this.isEquals) {
            void var2_2;
            void var1_1;
            this.isEquals = var1_1 == var2_2;
        }
        return this;
    }

    public EqualsBuilder append(char[] lhs, char[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(double lhs, double rhs) {
        if (this.isEquals) {
            void var3_2;
            void var1_1;
            return this.append(Double.doubleToLongBits((double)var1_1), Double.doubleToLongBits((double)var3_2));
        }
        return this;
    }

    public EqualsBuilder append(double[] lhs, double[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(float lhs, float rhs) {
        if (this.isEquals) {
            void var2_2;
            void var1_1;
            return this.append(Float.floatToIntBits((float)var1_1), Float.floatToIntBits((float)var2_2));
        }
        return this;
    }

    public EqualsBuilder append(float[] lhs, float[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(int lhs, int rhs) {
        if (this.isEquals) {
            void var2_2;
            void var1_1;
            this.isEquals = var1_1 == var2_2;
        }
        return this;
    }

    public EqualsBuilder append(int[] lhs, int[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(long lhs, long rhs) {
        if (this.isEquals) {
            void var3_2;
            void var1_1;
            this.isEquals = var1_1 == var3_2;
        }
        return this;
    }

    public EqualsBuilder append(long[] lhs, long[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(Object lhs, Object rhs) {
        void var3_3;
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        Class<?> lhsClass = lhs.getClass();
        if (lhsClass.isArray()) {
            this.appendArray(lhs, rhs);
        } else if (this.testRecursive && !ClassUtils.isPrimitiveOrWrapper(var3_3)) {
            this.reflectionAppend(lhs, rhs);
        } else {
            void var2_2;
            void var1_1;
            this.isEquals = var1_1.equals(var2_2);
        }
        return this;
    }

    public EqualsBuilder append(Object[] lhs, Object[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(short lhs, short rhs) {
        if (this.isEquals) {
            void var2_2;
            void var1_1;
            this.isEquals = var1_1 == var2_2;
        }
        return this;
    }

    public EqualsBuilder append(short[] lhs, short[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void appendArray(Object lhs, Object rhs) {
        void var2_2;
        void var1_1;
        if (lhs.getClass() != rhs.getClass()) {
            this.setEquals(false);
            return;
        }
        if (lhs instanceof long[]) {
            this.append((long[])lhs, (long[])rhs);
            return;
        }
        if (lhs instanceof int[]) {
            this.append((int[])lhs, (int[])rhs);
            return;
        }
        if (lhs instanceof short[]) {
            this.append((short[])lhs, (short[])rhs);
            return;
        }
        if (lhs instanceof char[]) {
            this.append((char[])lhs, (char[])rhs);
            return;
        }
        if (lhs instanceof byte[]) {
            this.append((byte[])lhs, (byte[])rhs);
            return;
        }
        if (lhs instanceof double[]) {
            this.append((double[])lhs, (double[])rhs);
            return;
        }
        if (lhs instanceof float[]) {
            this.append((float[])lhs, (float[])rhs);
            return;
        }
        if (lhs instanceof boolean[]) {
            this.append((boolean[])lhs, (boolean[])rhs);
            return;
        }
        this.append((Object[])var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder appendSuper(boolean superEquals) {
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1;
        return this;
    }

    @Override
    public Boolean build() {
        return this.isEquals();
    }

    public boolean isEquals() {
        return this.isEquals;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder reflectionAppend(Object lhs, Object rhs) {
        block15: {
            Class<?> testClass;
            if (!this.isEquals) {
                return this;
            }
            if (lhs == rhs) {
                return this;
            }
            if (lhs == null || rhs == null) {
                this.isEquals = false;
                return this;
            }
            Class<?> lhsClass = lhs.getClass();
            Class<?> rhsClass = rhs.getClass();
            if (lhsClass.isInstance(rhs)) {
                testClass = lhsClass;
                if (!rhsClass.isInstance(lhs)) {
                    testClass = rhsClass;
                }
            } else if (rhsClass.isInstance(lhs)) {
                testClass = rhsClass;
                if (!lhsClass.isInstance(rhs)) {
                    testClass = lhsClass;
                }
            } else {
                this.isEquals = false;
                return this;
            }
            try {
                void var3_3;
                if (testClass.isArray()) {
                    this.append(lhs, rhs);
                    break block15;
                }
                if (this.bypassReflectionClasses != null && (this.bypassReflectionClasses.contains(var3_3) || this.bypassReflectionClasses.contains(rhsClass))) {
                    this.isEquals = lhs.equals(rhs);
                    break block15;
                }
                while (true) {
                    this.reflectionAppend(lhs, rhs, testClass);
                    if (testClass.getSuperclass() != null && testClass != this.reflectUpToClass) {
                        testClass = testClass.getSuperclass();
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.isEquals = false;
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void reflectionAppend(Object lhs, Object rhs, Class<?> clazz) {
        if (EqualsBuilder.isRegistered(lhs, rhs)) {
            return;
        }
        try {
            EqualsBuilder.register(lhs, rhs);
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i2 = 0; i2 < fields.length && this.isEquals; ++i2) {
                AccessibleObject field = fields[i2];
                if (ArrayUtils.contains(this.excludeFields, ((Field)field).getName()) || ((Field)field).getName().contains("$") || !this.testTransients && Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers()) || field.isAnnotationPresent(EqualsExclude.class)) continue;
                this.append(Reflection.getUnchecked((Field)field, lhs), Reflection.getUnchecked((Field)field, rhs));
            }
        }
        catch (Throwable throwable) {
            void var2_2;
            void var1_1;
            EqualsBuilder.unregister(var1_1, var2_2);
            throw throwable;
        }
        EqualsBuilder.unregister(lhs, rhs);
    }

    public void reset() {
        this.isEquals = true;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder setBypassReflectionClasses(List<Class<?>> bypassReflectionClasses) {
        void var1_1;
        this.bypassReflectionClasses = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected void setEquals(boolean isEquals) {
        void var1_1;
        this.isEquals = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder setExcludeFields(String ... excludeFields) {
        void var1_1;
        this.excludeFields = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder setReflectUpToClass(Class<?> reflectUpToClass) {
        void var1_1;
        this.reflectUpToClass = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder setTestRecursive(boolean testRecursive) {
        void var1_1;
        this.testRecursive = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder setTestTransients(boolean testTransients) {
        void var1_1;
        this.testTransients = var1_1;
        return this;
    }
}

