/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffBuilder<T>
implements org.apache.commons.lang3.builder.Builder<DiffResult<T>> {
    static final String TO_STRING_FORMAT = "%s differs from %s";
    private final List<Diff<?>> diffs;
    private final boolean equals;
    private final T left;
    private final T right;
    private final ToStringStyle style;
    private final String toStringFormat;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DiffBuilder(T left, T right, ToStringStyle style) {
        this(var1_1, var2_2, (ToStringStyle)var3_3, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DiffBuilder(T left, T right, ToStringStyle style, boolean testObjectsEquals) {
        this(var1_1, var2_2, (ToStringStyle)var3_3, testObjectsEquals, TO_STRING_FORMAT);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private DiffBuilder(T left, T right, ToStringStyle style, boolean testObjectsEquals, String toStringFormat) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
        this.diffs = new ArrayList();
        this.toStringFormat = toStringFormat;
        this.style = style != null ? var3_3 : ToStringStyle.DEFAULT_STYLE;
        this.equals = testObjectsEquals && Objects.equals(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private <F> DiffBuilder<T> add(String fieldName, Supplier<F> left, Supplier<F> right, Class<F> type) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.diffs.add(new SDiff((String)var1_1, (Supplier)var2_2, (Supplier)var3_3, type));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, boolean lhs, boolean rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || lhs == rhs) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$0((boolean)var2_2), () -> DiffBuilder.lambda$append$1((boolean)var3_3), Boolean.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, boolean[] lhs, boolean[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$2((boolean[])var2_2), () -> DiffBuilder.lambda$append$3((boolean[])var3_3), Boolean[].class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, byte lhs, byte rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || lhs == rhs) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$4((byte)var2_2), () -> DiffBuilder.lambda$append$5((byte)var3_3), Byte.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, byte[] lhs, byte[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$6((byte[])var2_2), () -> DiffBuilder.lambda$append$7((byte[])var3_3), Byte[].class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, char lhs, char rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || lhs == rhs) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$8((char)var2_2), () -> DiffBuilder.lambda$append$9((char)var3_3), Character.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, char[] lhs, char[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$10((char[])var2_2), () -> DiffBuilder.lambda$append$11((char[])var3_3), Character[].class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, DiffResult<?> diffResult) {
        void var1_1;
        void var2_2;
        Objects.requireNonNull(diffResult, "diffResult");
        if (this.equals) {
            return this;
        }
        var2_2.getDiffs().forEach(arg_0 -> this.lambda$append$12((String)var1_1, arg_0));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, double lhs, double rhs) {
        void var2_2;
        void var1_1;
        if (this.equals || Double.doubleToLongBits(lhs) == Double.doubleToLongBits(rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$13((double)var2_2), () -> rhs, Double.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, double[] lhs, double[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$15((double[])var2_2), () -> DiffBuilder.lambda$append$16((double[])var3_3), Double[].class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, float lhs, float rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Float.floatToIntBits(lhs) == Float.floatToIntBits(rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$17((float)var2_2), () -> DiffBuilder.lambda$append$18((float)var3_3), Float.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, float[] lhs, float[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$19((float[])var2_2), () -> DiffBuilder.lambda$append$20((float[])var3_3), Float[].class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, int lhs, int rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || lhs == rhs) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$21((int)var2_2), () -> DiffBuilder.lambda$append$22((int)var3_3), Integer.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, int[] lhs, int[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$23((int[])var2_2), () -> DiffBuilder.lambda$append$24((int[])var3_3), Integer[].class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, long lhs, long rhs) {
        void var2_2;
        void var1_1;
        if (this.equals || lhs == rhs) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$25((long)var2_2), () -> rhs, Long.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, long[] lhs, long[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$27((long[])var2_2), () -> DiffBuilder.lambda$append$28((long[])var3_3), Long[].class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, Object lhs, Object rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || lhs == rhs) {
            return this;
        }
        Object test = lhs != null ? lhs : rhs;
        if (ObjectUtils.isArray(test)) {
            if (test instanceof boolean[]) {
                return this.append(fieldName, (boolean[])lhs, (boolean[])rhs);
            }
            if (test instanceof byte[]) {
                return this.append(fieldName, (byte[])lhs, (byte[])rhs);
            }
            if (test instanceof char[]) {
                return this.append(fieldName, (char[])lhs, (char[])rhs);
            }
            if (test instanceof double[]) {
                return this.append(fieldName, (double[])lhs, (double[])rhs);
            }
            if (test instanceof float[]) {
                return this.append(fieldName, (float[])lhs, (float[])rhs);
            }
            if (test instanceof int[]) {
                return this.append(fieldName, (int[])lhs, (int[])rhs);
            }
            if (test instanceof long[]) {
                return this.append(fieldName, (long[])lhs, (long[])rhs);
            }
            if (test instanceof short[]) {
                return this.append(fieldName, (short[])lhs, (short[])rhs);
            }
            return this.append(fieldName, (Object[])lhs, (Object[])rhs);
        }
        if (Objects.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> var2_2, () -> var3_3, Object.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, Object[] lhs, Object[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$31((Object[])var2_2), () -> DiffBuilder.lambda$append$32((Object[])var3_3), Object[].class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, short lhs, short rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || lhs == rhs) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$33((short)var2_2), () -> DiffBuilder.lambda$append$34((short)var3_3), Short.class);
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, short[] lhs, short[] rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.equals || Arrays.equals(lhs, rhs)) {
            return this;
        }
        return this.add((String)var1_1, () -> DiffBuilder.lambda$append$35((short[])var2_2), () -> DiffBuilder.lambda$append$36((short[])var3_3), Short[].class);
    }

    @Override
    public DiffResult<T> build() {
        return new DiffResult<T>(this.left, this.right, this.diffs, this.style, this.toStringFormat);
    }

    T getLeft() {
        return this.left;
    }

    T getRight() {
        return this.right;
    }

    private static /* synthetic */ Short[] lambda$append$36(short[] rhs) {
        return ArrayUtils.toObject(rhs);
    }

    private static /* synthetic */ Short[] lambda$append$35(short[] lhs) {
        return ArrayUtils.toObject(lhs);
    }

    private static /* synthetic */ Short lambda$append$34(short rhs) {
        return rhs;
    }

    private static /* synthetic */ Short lambda$append$33(short lhs) {
        return lhs;
    }

    private static /* synthetic */ Object[] lambda$append$32(Object[] rhs) {
        return rhs;
    }

    private static /* synthetic */ Object[] lambda$append$31(Object[] lhs) {
        return lhs;
    }

    private static /* synthetic */ Long[] lambda$append$28(long[] rhs) {
        return ArrayUtils.toObject(rhs);
    }

    private static /* synthetic */ Long[] lambda$append$27(long[] lhs) {
        return ArrayUtils.toObject(lhs);
    }

    private static /* synthetic */ Long lambda$append$25(long lhs) {
        return lhs;
    }

    private static /* synthetic */ Integer[] lambda$append$24(int[] rhs) {
        return ArrayUtils.toObject(rhs);
    }

    private static /* synthetic */ Integer[] lambda$append$23(int[] lhs) {
        return ArrayUtils.toObject(lhs);
    }

    private static /* synthetic */ Integer lambda$append$22(int rhs) {
        return rhs;
    }

    private static /* synthetic */ Integer lambda$append$21(int lhs) {
        return lhs;
    }

    private static /* synthetic */ Float[] lambda$append$20(float[] rhs) {
        return ArrayUtils.toObject(rhs);
    }

    private static /* synthetic */ Float[] lambda$append$19(float[] lhs) {
        return ArrayUtils.toObject(lhs);
    }

    private static /* synthetic */ Float lambda$append$18(float rhs) {
        return Float.valueOf(rhs);
    }

    private static /* synthetic */ Float lambda$append$17(float lhs) {
        return Float.valueOf(lhs);
    }

    private static /* synthetic */ Double[] lambda$append$16(double[] rhs) {
        return ArrayUtils.toObject(rhs);
    }

    private static /* synthetic */ Double[] lambda$append$15(double[] lhs) {
        return ArrayUtils.toObject(lhs);
    }

    private static /* synthetic */ Double lambda$append$13(double lhs) {
        return lhs;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$append$12(String fieldName, Diff diff) {
        void var2_2;
        void var1_1;
        this.append((String)var1_1 + "." + diff.getFieldName(), diff.getLeft(), var2_2.getRight());
    }

    private static /* synthetic */ Character[] lambda$append$11(char[] rhs) {
        return ArrayUtils.toObject(rhs);
    }

    private static /* synthetic */ Character[] lambda$append$10(char[] lhs) {
        return ArrayUtils.toObject(lhs);
    }

    private static /* synthetic */ Character lambda$append$9(char rhs) {
        return Character.valueOf(rhs);
    }

    private static /* synthetic */ Character lambda$append$8(char lhs) {
        return Character.valueOf(lhs);
    }

    private static /* synthetic */ Byte[] lambda$append$7(byte[] rhs) {
        return ArrayUtils.toObject(rhs);
    }

    private static /* synthetic */ Byte[] lambda$append$6(byte[] lhs) {
        return ArrayUtils.toObject(lhs);
    }

    private static /* synthetic */ Byte lambda$append$5(byte rhs) {
        return rhs;
    }

    private static /* synthetic */ Byte lambda$append$4(byte lhs) {
        return lhs;
    }

    private static /* synthetic */ Boolean[] lambda$append$3(boolean[] rhs) {
        return ArrayUtils.toObject(rhs);
    }

    private static /* synthetic */ Boolean[] lambda$append$2(boolean[] lhs) {
        return ArrayUtils.toObject(lhs);
    }

    private static /* synthetic */ Boolean lambda$append$1(boolean rhs) {
        return rhs;
    }

    private static /* synthetic */ Boolean lambda$append$0(boolean lhs) {
        return lhs;
    }

    public static final class Builder<T> {
        private T left;
        private T right;
        private ToStringStyle style;
        private boolean testObjectsEquals = true;
        private String toStringFormat = "%s differs from %s";

        public final DiffBuilder<T> build() {
            return new DiffBuilder(this.left, this.right, this.style, this.testObjectsEquals, this.toStringFormat);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setLeft(T left) {
            void var1_1;
            this.left = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setRight(T right) {
            void var1_1;
            this.right = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setStyle(ToStringStyle style) {
            void var1_1;
            this.style = style != null ? var1_1 : ToStringStyle.DEFAULT_STYLE;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setTestObjectsEquals(boolean testObjectsEquals) {
            void var1_1;
            this.testObjectsEquals = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setToStringFormat(String toStringFormat) {
            void var1_1;
            this.toStringFormat = toStringFormat != null ? var1_1 : DiffBuilder.TO_STRING_FORMAT;
            return this;
        }
    }

    private static final class SDiff<T>
    extends Diff<T> {
        private static final long serialVersionUID = 1L;
        private final transient Supplier<T> leftSupplier;
        private final transient Supplier<T> rightSupplier;

        /*
         * WARNING - void declaration
         */
        private SDiff(String fieldName, Supplier<T> leftSupplier, Supplier<T> rightSupplier, Class<T> type) {
            super((String)var1_1, type);
            void var3_3;
            void var2_2;
            void var1_1;
            this.leftSupplier = (Supplier)Objects.requireNonNull(var2_2);
            this.rightSupplier = (Supplier)Objects.requireNonNull(var3_3);
        }

        @Override
        public final T getLeft() {
            return this.leftSupplier.get();
        }

        @Override
        public final T getRight() {
            return this.rightSupplier.get();
        }
    }
}

