/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.DurationUtils;

public class ThreadUtils {
    @Deprecated
    public static final AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new AlwaysTruePredicate();
    private static final Predicate<?> ALWAYS_TRUE = t2 -> true;

    private static <T> Predicate<T> alwaysTruePredicate() {
        return ALWAYS_TRUE;
    }

    /*
     * WARNING - void declaration
     */
    public static Thread findThreadById(long threadId) {
        void var0_1;
        if (threadId <= 0L) {
            throw new IllegalArgumentException("The thread id must be greater than zero");
        }
        Collection<Thread> result = ThreadUtils.findThreads((Thread t2) -> {
            long l2;
            void var2_1;
            return t2 != null && var2_1.getId() == l2;
        });
        if (result.isEmpty()) {
            return null;
        }
        return (Thread)var0_1.iterator().next();
    }

    /*
     * WARNING - void declaration
     */
    public static Thread findThreadById(long threadId, String threadGroupName) {
        void var2_2;
        Objects.requireNonNull(threadGroupName, "threadGroupName");
        Thread thread2 = ThreadUtils.findThreadById(threadId);
        if (thread2 != null && thread2.getThreadGroup() != null && thread2.getThreadGroup().getName().equals(var2_2)) {
            void var0_1;
            return var0_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Thread findThreadById(long threadId, ThreadGroup threadGroup) {
        void var2_2;
        Objects.requireNonNull(threadGroup, "threadGroup");
        Thread thread2 = ThreadUtils.findThreadById(threadId);
        if (thread2 != null && var2_2.equals(thread2.getThreadGroup())) {
            void var0_1;
            return var0_1;
        }
        return null;
    }

    public static Collection<ThreadGroup> findThreadGroups(Predicate<ThreadGroup> predicate) {
        Predicate<ThreadGroup> predicate2;
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, predicate2);
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup threadGroup, boolean recurse, Predicate<ThreadGroup> predicate) {
        void var2_2;
        void var3_3;
        int n2;
        ThreadGroup[] threadGroups;
        Objects.requireNonNull(threadGroup, "threadGroup");
        Objects.requireNonNull(predicate, "predicate");
        int count = threadGroup.activeGroupCount();
        do {
            n2 = count;
        } while ((count = threadGroup.enumerate(threadGroups = new ThreadGroup[n2 + n2 / 2 + 1], recurse)) >= threadGroups.length);
        return Collections.unmodifiableCollection(Stream.of(threadGroups).limit((long)var3_3).filter((Predicate<ThreadGroup>)var2_2).collect(Collectors.toList()));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup threadGroup, boolean recurse, ThreadGroupPredicate predicate) {
        void var2_2;
        void var1_1;
        return ThreadUtils.findThreadGroups(threadGroup, (boolean)var1_1, ((ThreadGroupPredicate)var2_2)::test);
    }

    @Deprecated
    public static Collection<ThreadGroup> findThreadGroups(ThreadGroupPredicate predicate) {
        ThreadGroupPredicate threadGroupPredicate;
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, threadGroupPredicate);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String threadGroupName) {
        return ThreadUtils.findThreadGroups(ThreadUtils.predicateThreadGroup(threadGroupName));
    }

    public static Collection<Thread> findThreads(Predicate<Thread> predicate) {
        Predicate<Thread> predicate2;
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, predicate2);
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<Thread> findThreads(ThreadGroup threadGroup, boolean recurse, Predicate<Thread> predicate) {
        void var2_2;
        void var3_3;
        int n2;
        Thread[] threads;
        Objects.requireNonNull(threadGroup, "The group must not be null");
        Objects.requireNonNull(predicate, "The predicate must not be null");
        int count = threadGroup.activeCount();
        do {
            n2 = count;
        } while ((count = threadGroup.enumerate(threads = new Thread[n2 + n2 / 2 + 1], recurse)) >= threads.length);
        return Collections.unmodifiableCollection(Stream.of(threads).limit((long)var3_3).filter((Predicate<Thread>)var2_2).collect(Collectors.toList()));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Collection<Thread> findThreads(ThreadGroup threadGroup, boolean recurse, ThreadPredicate predicate) {
        void var2_2;
        void var1_1;
        return ThreadUtils.findThreads(threadGroup, (boolean)var1_1, ((ThreadPredicate)var2_2)::test);
    }

    @Deprecated
    public static Collection<Thread> findThreads(ThreadPredicate predicate) {
        ThreadPredicate threadPredicate;
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, threadPredicate);
    }

    public static Collection<Thread> findThreadsByName(String threadName) {
        return ThreadUtils.findThreads(ThreadUtils.predicateThread(threadName));
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<Thread> findThreadsByName(String threadName, String threadGroupName) {
        String string;
        void var1_1;
        Objects.requireNonNull(threadName, "threadName");
        Objects.requireNonNull(threadGroupName, "threadGroupName");
        return Collections.unmodifiableCollection(ThreadUtils.findThreadGroups(ThreadUtils.predicateThreadGroup((String)var1_1)).stream().flatMap(group -> {
            String string;
            return ThreadUtils.findThreads(group, false, ThreadUtils.predicateThread(string)).stream();
        }).collect(Collectors.toList()));
    }

    public static Collection<Thread> findThreadsByName(String threadName, ThreadGroup threadGroup) {
        String string;
        return ThreadUtils.findThreads(threadGroup, false, ThreadUtils.predicateThread(string));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(ThreadUtils.alwaysTruePredicate());
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(ThreadUtils.alwaysTruePredicate());
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadGroup getSystemThreadGroup() {
        void var0;
        for (ThreadGroup threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null && threadGroup.getParent() != null; threadGroup = threadGroup.getParent()) {
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static void join(Thread thread2, Duration duration) throws InterruptedException {
        void var1_1;
        DurationUtils.accept(thread2::join, (Duration)var1_1);
    }

    private static <T> Predicate<T> namePredicate(String name, Function<T, String> nameGetter) {
        String string;
        return t2 -> {
            void var1_1;
            void var2_2;
            Function function;
            return t2 != null && Objects.equals(function.apply(var2_2), Objects.requireNonNull(var1_1));
        };
    }

    private static Predicate<Thread> predicateThread(String threadName) {
        return ThreadUtils.namePredicate(threadName, Thread::getName);
    }

    private static Predicate<ThreadGroup> predicateThreadGroup(String threadGroupName) {
        return ThreadUtils.namePredicate(threadGroupName, ThreadGroup::getName);
    }

    public static void sleep(Duration duration) throws InterruptedException {
        Duration duration2;
        DurationUtils.accept(Thread::sleep, duration2);
    }

    public static void sleepQuietly(Duration duration) {
        try {
            ThreadUtils.sleep(duration);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Deprecated
    public ThreadUtils() {
    }

    @Deprecated
    @FunctionalInterface
    public static interface ThreadGroupPredicate {
        public boolean test(ThreadGroup var1);
    }

    @Deprecated
    @FunctionalInterface
    public static interface ThreadPredicate {
        public boolean test(Thread var1);
    }

    @Deprecated
    private static final class AlwaysTruePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private AlwaysTruePredicate() {
        }

        @Override
        public final boolean test(Thread thread2) {
            return true;
        }

        @Override
        public final boolean test(ThreadGroup threadGroup) {
            return true;
        }
    }

    @Deprecated
    public static class ThreadIdPredicate
    implements ThreadPredicate {
        private final long threadId;

        /*
         * WARNING - void declaration
         */
        public ThreadIdPredicate(long threadId) {
            void var1_1;
            if (threadId <= 0L) {
                throw new IllegalArgumentException("The thread id must be greater than zero");
            }
            this.threadId = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean test(Thread thread2) {
            void var1_1;
            return thread2 != null && var1_1.getId() == this.threadId;
        }
    }

    @Deprecated
    public static class NamePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private final String name;

        /*
         * WARNING - void declaration
         */
        public NamePredicate(String name) {
            void var1_1;
            Objects.requireNonNull(name, "name");
            this.name = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean test(Thread thread2) {
            void var1_1;
            return thread2 != null && var1_1.getName().equals(this.name);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean test(ThreadGroup threadGroup) {
            void var1_1;
            return threadGroup != null && var1_1.getName().equals(this.name);
        }
    }
}

