/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationException;

public class SerializationUtils {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T clone(T object) {
        if (object == null) {
            return null;
        }
        byte[] objectData = SerializationUtils.serialize(object);
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        Class<T> cls = ObjectUtils.getClass(object);
        try (ClassLoaderAwareObjectInputStream in222 = new ClassLoaderAwareObjectInputStream(bais, cls.getClassLoader());){
            Class<T> clazz;
            clazz = (Serializable)clazz.cast(in222.readObject());
            return (T)clazz;
        }
        catch (IOException | ClassNotFoundException ex) {
            void var1_4;
            throw new SerializationException(String.format("%s while reading cloned object data", ex.getClass().getSimpleName()), (Throwable)var1_4);
        }
    }

    public static <T> T deserialize(byte[] objectData) {
        byte[] byArray;
        Objects.requireNonNull(objectData, "objectData");
        return SerializationUtils.deserialize(new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream2) {
        Objects.requireNonNull(inputStream2, "inputStream");
        try (InputStream in = new ObjectInputStream(inputStream2);){
            Object object;
            Object object2 = object = ((ObjectInputStream)in).readObject();
            return (T)object2;
        }
        catch (IOException | ClassNotFoundException | NegativeArraySizeException ex) {
            void var0_1;
            throw new SerializationException((Throwable)var0_1);
        }
    }

    public static <T extends Serializable> T roundtrip(T obj) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(obj)));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] serialize(Serializable obj) {
        void var1_1;
        Serializable serializable;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, baos);
        return var1_1.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static void serialize(Serializable obj, OutputStream outputStream2) {
        Objects.requireNonNull(outputStream2, "outputStream");
        try (ObjectOutputStream out = new ObjectOutputStream(outputStream2);){
            Serializable serializable;
            out.writeObject(serializable);
        }
        catch (IOException ex) {
            void var1_4;
            throw new SerializationException((Throwable)var1_4);
        }
    }

    @Deprecated
    public SerializationUtils() {
    }

    static final class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        /*
         * WARNING - void declaration
         */
        ClassLoaderAwareObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super((InputStream)var1_1);
            void var2_2;
            void var1_1;
            this.classLoader = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    void var2_2;
                    Class<?> cls = ClassUtils.getPrimitiveClass(name);
                    if (cls != null) {
                        void var1_1;
                        return var1_1;
                    }
                    throw var2_2;
                }
            }
        }
    }
}

