/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class Range<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> comparator;
    private transient int hashCode;
    private final T maximum;
    private final T minimum;
    private transient String toString;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T extends Comparable<? super T>> Range<T> between(T fromInclusive, T toInclusive) {
        void var1_1;
        return Range.of(fromInclusive, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> Range<T> between(T fromInclusive, T toInclusive, Comparator<T> comparator) {
        void var2_2;
        void var1_1;
        T t2;
        return new Range<void>((void)t2, var1_1, (Comparator<void>)var2_2);
    }

    public static <T extends Comparable<? super T>> Range<T> is(T element) {
        T t2 = element;
        return Range.of(t2, t2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Range<T> is(T element, Comparator<T> comparator) {
        void var1_1;
        T t2 = element;
        return Range.of(t2, t2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> Range<T> of(T fromInclusive, T toInclusive) {
        void var1_1;
        return Range.of(fromInclusive, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Range<T> of(T fromInclusive, T toInclusive, Comparator<T> comparator) {
        void var2_2;
        void var1_1;
        T t2;
        return new Range<void>((void)t2, var1_1, (Comparator<void>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Range(T element1, T element2, Comparator<T> comp) {
        void var1_1;
        void var2_2;
        void var3_3;
        Objects.requireNonNull(element1, "element1");
        Objects.requireNonNull(element2, "element2");
        this.comparator = comp == null ? ComparableComparator.INSTANCE : var3_3;
        if (this.comparator.compare(element1, element2) <= 0) {
            this.minimum = element1;
            this.maximum = element2;
            return;
        }
        this.minimum = var2_2;
        this.maximum = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(T element) {
        void var1_1;
        if (element == null) {
            return false;
        }
        return this.comparator.compare(element, this.minimum) >= 0 && this.comparator.compare(var1_1, (void)this.maximum) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsRange(Range<T> otherRange) {
        void var1_1;
        if (otherRange == null) {
            return false;
        }
        return this.contains(otherRange.minimum) && this.contains(var1_1.maximum);
    }

    /*
     * WARNING - void declaration
     */
    public int elementCompareTo(T element) {
        void var1_1;
        Objects.requireNonNull(element, "element");
        if (this.isAfter(element)) {
            return -1;
        }
        if (this.isBefore(var1_1)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Range range = (Range)obj;
        return this.minimum.equals(range.minimum) && this.maximum.equals(var1_1.maximum);
    }

    /*
     * WARNING - void declaration
     */
    public T fit(T element) {
        void var1_1;
        Objects.requireNonNull(element, "element");
        if (this.isAfter(element)) {
            return this.minimum;
        }
        if (this.isBefore(element)) {
            return this.maximum;
        }
        return var1_1;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public T getMaximum() {
        return this.maximum;
    }

    public T getMinimum() {
        return this.minimum;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.hashCode;
        if (this.hashCode == 0) {
            result = 629 + this.getClass().hashCode();
            result = result * 37 + this.minimum.hashCode();
            this.hashCode = result = result * 37 + this.maximum.hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Range<T> intersectionWith(Range<T> other) {
        void var1_1;
        void var2_2;
        if (!this.isOverlappedBy(other)) {
            throw new IllegalArgumentException(String.format("Cannot calculate intersection with non-overlapping range %s", other));
        }
        if (this.equals(other)) {
            return this;
        }
        T min = this.getComparator().compare(this.minimum, other.minimum) < 0 ? other.minimum : this.minimum;
        T max = this.getComparator().compare(this.maximum, other.maximum) < 0 ? this.maximum : other.maximum;
        return Range.of(var2_2, var1_1, this.getComparator());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAfter(T element) {
        void var1_1;
        if (element == null) {
            return false;
        }
        return this.comparator.compare(var1_1, (void)this.minimum) < 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAfterRange(Range<T> otherRange) {
        void var1_1;
        if (otherRange == null) {
            return false;
        }
        return this.isAfter(var1_1.maximum);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isBefore(T element) {
        void var1_1;
        if (element == null) {
            return false;
        }
        return this.comparator.compare(var1_1, (void)this.maximum) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isBeforeRange(Range<T> otherRange) {
        void var1_1;
        if (otherRange == null) {
            return false;
        }
        return this.isBefore(var1_1.minimum);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEndedBy(T element) {
        void var1_1;
        if (element == null) {
            return false;
        }
        return this.comparator.compare(var1_1, (void)this.maximum) == 0;
    }

    public boolean isNaturalOrdering() {
        return this.comparator == ComparableComparator.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isOverlappedBy(Range<T> otherRange) {
        void var1_1;
        if (otherRange == null) {
            return false;
        }
        return otherRange.contains(this.minimum) || otherRange.contains(this.maximum) || this.contains(var1_1.minimum);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isStartedBy(T element) {
        void var1_1;
        if (element == null) {
            return false;
        }
        return this.comparator.compare(var1_1, (void)this.minimum) == 0;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "[" + this.minimum + ".." + this.maximum + "]";
        }
        return this.toString;
    }

    public String toString(String format) {
        return String.format(format, this.minimum, this.maximum, this.comparator);
    }

    private static enum ComparableComparator implements Comparator
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        public final int compare(Object obj1, Object obj2) {
            void var2_2;
            return ((Comparable)obj1).compareTo(var2_2);
        }
    }
}

