/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.UncheckedException;

public class RandomUtils {
    private static RandomUtils INSECURE = new RandomUtils(ThreadLocalRandom::current);
    private static RandomUtils SECURE = new RandomUtils(SecureRandom::new);
    private static final Supplier<Random> SECURE_STRONG_SUPPLIER = () -> SECURE_RANDOM_STRONG.get();
    private static RandomUtils SECURE_STRONG = new RandomUtils(SECURE_STRONG_SUPPLIER);
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM_STRONG = ThreadLocal.withInitial(() -> {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e2) {
            void var0;
            throw new UncheckedException((Throwable)var0);
        }
    });
    private final Supplier<Random> random;

    public static RandomUtils insecure() {
        return INSECURE;
    }

    @Deprecated
    public static boolean nextBoolean() {
        return RandomUtils.secure().randomBoolean();
    }

    @Deprecated
    public static byte[] nextBytes(int count) {
        int n2;
        return RandomUtils.secure().randomBytes(n2);
    }

    @Deprecated
    public static double nextDouble() {
        return RandomUtils.secure().randomDouble();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double nextDouble(double startInclusive, double endExclusive) {
        void var2_1;
        double d2;
        return RandomUtils.secure().randomDouble(d2, (double)var2_1);
    }

    @Deprecated
    public static float nextFloat() {
        return RandomUtils.secure().randomFloat();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static float nextFloat(float startInclusive, float endExclusive) {
        void var1_1;
        float f2;
        return RandomUtils.secure().randomFloat(f2, (float)var1_1);
    }

    @Deprecated
    public static int nextInt() {
        return RandomUtils.secure().randomInt();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int nextInt(int startInclusive, int endExclusive) {
        void var1_1;
        int n2;
        return RandomUtils.secure().randomInt(n2, (int)var1_1);
    }

    @Deprecated
    public static long nextLong() {
        return RandomUtils.secure().randomLong();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static long nextLong(long startInclusive, long endExclusive) {
        void var2_1;
        long l2;
        return RandomUtils.secure().randomLong(l2, (long)var2_1);
    }

    public static RandomUtils secure() {
        return SECURE;
    }

    static SecureRandom secureRandom() {
        return SECURE_RANDOM_STRONG.get();
    }

    public static RandomUtils secureStrong() {
        return SECURE_STRONG;
    }

    @Deprecated
    public RandomUtils() {
        this(SECURE_STRONG_SUPPLIER);
    }

    /*
     * WARNING - void declaration
     */
    private RandomUtils(Supplier<Random> random) {
        void var1_1;
        this.random = var1_1;
    }

    Random random() {
        return this.random.get();
    }

    public boolean randomBoolean() {
        return this.random().nextBoolean();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] randomBytes(int count) {
        void var1_2;
        Validate.isTrue(count >= 0, "Count cannot be negative.", new Object[0]);
        byte[] result = new byte[count];
        this.random().nextBytes(result);
        return var1_2;
    }

    public double randomDouble() {
        return this.randomDouble(0.0, Double.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public double randomDouble(double startInclusive, double endExclusive) {
        void var1_1;
        void var3_2;
        Validate.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(startInclusive >= 0.0, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + (var3_2 - var1_1) * this.random().nextDouble();
    }

    public float randomFloat() {
        return this.randomFloat(0.0f, Float.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public float randomFloat(float startInclusive, float endExclusive) {
        void var1_1;
        void var2_2;
        Validate.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(startInclusive >= 0.0f, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + (var2_2 - var1_1) * this.random().nextFloat();
    }

    public int randomInt() {
        return this.randomInt(0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public int randomInt(int startInclusive, int endExclusive) {
        void var1_1;
        void var2_2;
        Validate.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(startInclusive >= 0, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + this.random().nextInt((int)(var2_2 - var1_1));
    }

    public long randomLong() {
        return this.randomLong(Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    private long randomLong(long n2) {
        long bits;
        long val;
        void var3_2;
        while (var3_2 - (val = (bits = this.random().nextLong() >>> 1) % n2) + n2 - 1L < 0L) {
        }
        return val;
    }

    /*
     * WARNING - void declaration
     */
    public long randomLong(long startInclusive, long endExclusive) {
        void var1_1;
        void var3_2;
        Validate.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(startInclusive >= 0L, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + this.randomLong((long)(var3_2 - var1_1));
    }

    public String toString() {
        return "RandomUtils [random=" + this.random() + "]";
    }
}

