/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.function.Suppliers;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.stream.Streams;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.time.DurationUtils;

public class ObjectUtils {
    private static final char AT_SIGN = '@';
    public static final Null NULL = new Null();

    public static boolean allNotNull(Object ... values2) {
        Object[] objectArray;
        return values2 != null && Stream.of(objectArray).noneMatch(Objects::isNull);
    }

    public static boolean allNull(Object ... values2) {
        return !ObjectUtils.anyNotNull(values2);
    }

    public static boolean anyNotNull(Object ... values2) {
        return ObjectUtils.firstNonNull(values2) != null;
    }

    public static boolean anyNull(Object ... values2) {
        return !ObjectUtils.allNotNull(values2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T clone(T obj) {
        if (obj instanceof Cloneable) {
            void var1_3;
            Object result;
            Class<?> objClass = obj.getClass();
            if (ObjectUtils.isArray(obj)) {
                Class<?> componentType = objClass.getComponentType();
                if (componentType.isPrimitive()) {
                    int length = Array.getLength(obj);
                    result = Array.newInstance(componentType, length);
                    while (length-- > 0) {
                        Array.set(result, length, Array.get(obj, length));
                    }
                } else {
                    result = ((Object[])obj).clone();
                }
            } else {
                void var2_1;
                try {
                    T t2;
                    result = var2_1.getMethod("clone", new Class[0]).invoke(t2, new Object[0]);
                }
                catch (ReflectiveOperationException e2) {
                    throw new CloneFailedException("Exception cloning Cloneable type " + var2_1.getName(), e2);
                }
            }
            return var1_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T cloneIfPossible(T obj) {
        void var1_1;
        T clone = ObjectUtils.clone(obj);
        if (clone == null) {
            T t2;
            return t2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        void var1_1;
        return ObjectUtils.compare(c1, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean nullGreater) {
        void var1_1;
        Object object;
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            if (nullGreater) {
                return 1;
            }
            return -1;
        }
        if (c2 == null) {
            void var2_2;
            if (var2_2 != false) {
                return -1;
            }
            return 1;
        }
        return object.compareTo(var1_1);
    }

    public static boolean CONST(boolean v2) {
        return v2;
    }

    public static byte CONST(byte v2) {
        return v2;
    }

    public static char CONST(char v2) {
        return v2;
    }

    public static double CONST(double v2) {
        return v2;
    }

    public static float CONST(float v2) {
        return v2;
    }

    public static int CONST(int v2) {
        return v2;
    }

    public static long CONST(long v2) {
        return v2;
    }

    public static short CONST(short v2) {
        return v2;
    }

    public static <T> T CONST(T v2) {
        return v2;
    }

    public static byte CONST_BYTE(int v2) {
        int n2;
        if (v2 < -128 || v2 > 127) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -128 and 127: [" + v2 + "]");
        }
        return (byte)n2;
    }

    public static short CONST_SHORT(int v2) {
        int n2;
        if (v2 < Short.MIN_VALUE || v2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -32768 and 32767: [" + v2 + "]");
        }
        return (short)n2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T defaultIfNull(T object, T defaultValue) {
        void var1_1;
        if (object != null) {
            T t2;
            return t2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean equals(Object object1, Object object2) {
        void var1_1;
        return Objects.equals(object1, var1_1);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... values2) {
        return Streams.of(values2).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static <T> Class<T> getClass(T object) {
        T t2;
        if (object == null) {
            return null;
        }
        return t2.getClass();
    }

    @SafeVarargs
    public static <T> T getFirstNonNull(Supplier<T> ... suppliers) {
        return Streams.of(suppliers).filter(Objects::nonNull).map(Supplier::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getIfNull(T object, Supplier<T> defaultSupplier) {
        void var1_1;
        if (object != null) {
            T t2;
            return t2;
        }
        return Suppliers.get(var1_1);
    }

    @Deprecated
    public static int hashCode(Object obj) {
        return Objects.hashCode(obj);
    }

    public static String hashCodeHex(Object object) {
        return Integer.toHexString(Objects.hashCode(object));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int hashCodeMulti(Object ... objects) {
        void var1_1;
        int hash = 1;
        if (objects != null) {
            Object[] objectArray;
            for (Object object : objectArray) {
                int tmpHash = Objects.hashCode(object);
                hash = hash * 31 + tmpHash;
            }
        }
        return (int)var1_1;
    }

    public static String identityHashCodeHex(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    /*
     * WARNING - void declaration
     */
    public static void identityToString(Appendable appendable, Object object) throws IOException {
        void var1_1;
        Appendable appendable2;
        Objects.requireNonNull(object, "object");
        appendable2.append(object.getClass().getName()).append('@').append(ObjectUtils.identityHashCodeHex(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String identityToString(Object object) {
        void var2_2;
        Object object2;
        void var1_1;
        if (object == null) {
            return null;
        }
        String name = object.getClass().getName();
        Object hexString = ObjectUtils.identityHashCodeHex(object);
        StringBuilder builder = new StringBuilder(name.length() + 1 + ((String)hexString).length());
        builder.append((String)var1_1).append('@').append((String)object2);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void identityToString(StrBuilder builder, Object object) {
        void var1_1;
        void var2_2;
        StrBuilder strBuilder;
        Objects.requireNonNull(object, "object");
        String name = object.getClass().getName();
        String hexString = ObjectUtils.identityHashCodeHex(object);
        StrBuilder strBuilder2 = builder;
        strBuilder2.ensureCapacity(strBuilder2.length() + name.length() + 1 + hexString.length());
        strBuilder.append((String)var2_2).append('@').append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void identityToString(StringBuffer buffer, Object object) {
        void var1_1;
        void var2_2;
        StringBuffer stringBuffer;
        Objects.requireNonNull(object, "object");
        String name = object.getClass().getName();
        String hexString = ObjectUtils.identityHashCodeHex(object);
        StringBuffer stringBuffer2 = buffer;
        stringBuffer2.ensureCapacity(stringBuffer2.length() + name.length() + 1 + hexString.length());
        stringBuffer.append((String)var2_2).append('@').append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void identityToString(StringBuilder builder, Object object) {
        void var1_1;
        void var2_2;
        StringBuilder stringBuilder;
        Objects.requireNonNull(object, "object");
        String name = object.getClass().getName();
        String hexString = ObjectUtils.identityHashCodeHex(object);
        StringBuilder stringBuilder2 = builder;
        stringBuilder2.ensureCapacity(stringBuilder2.length() + name.length() + 1 + hexString.length());
        stringBuilder.append((String)var2_2).append('@').append((String)var1_1);
    }

    public static boolean isArray(Object object) {
        Object object2;
        return object != null && object2.getClass().isArray();
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length() == 0;
        }
        if (ObjectUtils.isArray(object)) {
            return Array.getLength(object) == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Optional) {
            Object object2;
            return !((Optional)object2).isPresent();
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectUtils.isEmpty(object);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends Comparable<? super T>> T max(T ... values2) {
        void var1_1;
        T result = null;
        if (values2 != null) {
            T[] TArray;
            for (T value : TArray) {
                if (ObjectUtils.compare(value, result, false) <= 0) continue;
                result = value;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T median(Comparator<T> comparator, T ... items) {
        TreeSet<T> treeSet;
        void var1_1;
        Validate.notEmpty(items, "null/empty items", new Object[0]);
        Validate.noNullElements(items);
        Objects.requireNonNull(comparator, "comparator");
        TreeSet<T> treeSet2 = new TreeSet<T>(comparator);
        Collections.addAll(treeSet2, var1_1);
        return (T)treeSet2.toArray()[(treeSet.size() - 1) / 2];
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends Comparable<? super T>> T median(T ... items) {
        void var1_1;
        T[] TArray;
        Validate.notEmpty(items);
        Validate.noNullElements(items);
        TreeSet sort = new TreeSet();
        Collections.addAll(sort, TArray);
        return (T)((Comparable)sort.toArray()[(var1_1.size() - 1) / 2]);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends Comparable<? super T>> T min(T ... values2) {
        void var1_1;
        T result = null;
        if (values2 != null) {
            T[] TArray;
            for (T value : TArray) {
                if (ObjectUtils.compare(value, result, true) >= 0) continue;
                result = value;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T mode(T ... items) {
        if (ArrayUtils.isNotEmpty(items)) {
            Object object;
            void var1_1;
            HashMap<T, MutableInt> occurrences = new HashMap<T, MutableInt>(items.length);
            for (T t2 : items) {
                MutableInt count = (MutableInt)occurrences.get(t2);
                if (count == null) {
                    occurrences.put(t2, new MutableInt(1));
                    continue;
                }
                count.increment();
            }
            Object result = null;
            int max = 0;
            for (Map.Entry e2 : var1_1.entrySet()) {
                int cmp = ((MutableInt)e2.getValue()).intValue();
                if (cmp == max) {
                    result = null;
                    continue;
                }
                if (cmp <= max) continue;
                max = cmp;
                result = e2.getKey();
            }
            return (T)object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean notEqual(Object object1, Object object2) {
        void var1_1;
        return !Objects.equals(object1, var1_1);
    }

    public static <T> T requireNonEmpty(T obj) {
        return ObjectUtils.requireNonEmpty(obj, "object");
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T requireNonEmpty(T obj, String message) {
        T t2;
        Objects.requireNonNull(obj, message);
        if (ObjectUtils.isEmpty(obj)) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1);
        }
        return t2;
    }

    @Deprecated
    public static String toString(Object obj) {
        return Objects.toString(obj, "");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String toString(Object obj, String nullStr) {
        void var1_1;
        return Objects.toString(obj, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Supplier<Object> obj, Supplier<String> supplier) {
        void var1_1;
        Supplier<Object> supplier2;
        if (obj == null) {
            return Suppliers.get(supplier);
        }
        return ObjectUtils.toString(supplier2.get(), (Supplier<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String toString(T obj, Supplier<String> supplier) {
        T t2;
        if (obj == null) {
            void var1_1;
            return (String)Suppliers.get(var1_1);
        }
        return t2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void wait(Object obj, Duration duration) throws InterruptedException {
        void var1_1;
        DurationUtils.accept(obj::wait, DurationUtils.zeroIfNull((Duration)var1_1));
    }

    @Deprecated
    public ObjectUtils() {
    }

    public static class Null
    implements Serializable {
        private static final long serialVersionUID = 7092611880189329093L;

        Null() {
        }

        private Object readResolve() {
            return NULL;
        }
    }
}

