/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.math.NumberUtils;

public enum JavaVersion {
    JAVA_0_9(1.5f, "0.9"),
    JAVA_1_1(1.1f, "1.1"),
    JAVA_1_2(1.2f, "1.2"),
    JAVA_1_3(1.3f, "1.3"),
    JAVA_1_4(1.4f, "1.4"),
    JAVA_1_5(1.5f, "1.5"),
    JAVA_1_6(1.6f, "1.6"),
    JAVA_1_7(1.7f, "1.7"),
    JAVA_1_8(1.8f, "1.8"),
    JAVA_1_9(9.0f, "9"),
    JAVA_9(9.0f, "9"),
    JAVA_10(10.0f, "10"),
    JAVA_11(11.0f, "11"),
    JAVA_12(12.0f, "12"),
    JAVA_13(13.0f, "13"),
    JAVA_14(14.0f, "14"),
    JAVA_15(15.0f, "15"),
    JAVA_16(16.0f, "16"),
    JAVA_17(17.0f, "17"),
    JAVA_18(18.0f, "18"),
    JAVA_19(19.0f, "19"),
    JAVA_20(20.0f, "20"),
    JAVA_21(21.0f, "21"),
    JAVA_22(22.0f, "22"),
    JAVA_RECENT(JavaVersion.maxVersion(), Float.toString(JavaVersion.maxVersion()));

    private static final String VERSION_SPLIT_REGEX = "\\.";
    private final float value;
    private final String name;

    /*
     * WARNING - void declaration
     */
    static JavaVersion get(String versionStr) {
        void var1_2;
        float f2;
        if (versionStr == null) {
            return null;
        }
        String string = versionStr;
        int n2 = -1;
        switch (string.hashCode()) {
            case 47611: {
                if (!string.equals("0.9")) break;
                n2 = 0;
                break;
            }
            case 48564: {
                if (!string.equals("1.1")) break;
                n2 = 1;
                break;
            }
            case 48565: {
                if (!string.equals("1.2")) break;
                n2 = 2;
                break;
            }
            case 48566: {
                if (!string.equals("1.3")) break;
                n2 = 3;
                break;
            }
            case 48567: {
                if (!string.equals("1.4")) break;
                n2 = 4;
                break;
            }
            case 48568: {
                if (!string.equals("1.5")) break;
                n2 = 5;
                break;
            }
            case 48569: {
                if (!string.equals("1.6")) break;
                n2 = 6;
                break;
            }
            case 48570: {
                if (!string.equals("1.7")) break;
                n2 = 7;
                break;
            }
            case 48571: {
                if (!string.equals("1.8")) break;
                n2 = 8;
                break;
            }
            case 57: {
                if (!string.equals("9")) break;
                n2 = 9;
                break;
            }
            case 1567: {
                if (!string.equals("10")) break;
                n2 = 10;
                break;
            }
            case 1568: {
                if (!string.equals("11")) break;
                n2 = 11;
                break;
            }
            case 1569: {
                if (!string.equals("12")) break;
                n2 = 12;
                break;
            }
            case 1570: {
                if (!string.equals("13")) break;
                n2 = 13;
                break;
            }
            case 1571: {
                if (!string.equals("14")) break;
                n2 = 14;
                break;
            }
            case 1572: {
                if (!string.equals("15")) break;
                n2 = 15;
                break;
            }
            case 1573: {
                if (!string.equals("16")) break;
                n2 = 16;
                break;
            }
            case 1574: {
                if (!string.equals("17")) break;
                n2 = 17;
                break;
            }
            case 1575: {
                if (!string.equals("18")) break;
                n2 = 18;
                break;
            }
            case 1576: {
                if (!string.equals("19")) break;
                n2 = 19;
                break;
            }
            case 1598: {
                if (!string.equals("20")) break;
                n2 = 20;
                break;
            }
            case 1599: {
                if (!string.equals("21")) break;
                n2 = 21;
                break;
            }
            case 1600: {
                if (!string.equals("22")) break;
                n2 = 22;
            }
        }
        switch (n2) {
            case 0: {
                return JAVA_0_9;
            }
            case 1: {
                return JAVA_1_1;
            }
            case 2: {
                return JAVA_1_2;
            }
            case 3: {
                return JAVA_1_3;
            }
            case 4: {
                return JAVA_1_4;
            }
            case 5: {
                return JAVA_1_5;
            }
            case 6: {
                return JAVA_1_6;
            }
            case 7: {
                return JAVA_1_7;
            }
            case 8: {
                return JAVA_1_8;
            }
            case 9: {
                return JAVA_9;
            }
            case 10: {
                return JAVA_10;
            }
            case 11: {
                return JAVA_11;
            }
            case 12: {
                return JAVA_12;
            }
            case 13: {
                return JAVA_13;
            }
            case 14: {
                return JAVA_14;
            }
            case 15: {
                return JAVA_15;
            }
            case 16: {
                return JAVA_16;
            }
            case 17: {
                return JAVA_17;
            }
            case 18: {
                return JAVA_18;
            }
            case 19: {
                return JAVA_19;
            }
            case 20: {
                return JAVA_20;
            }
            case 21: {
                return JAVA_21;
            }
            case 22: {
                return JAVA_22;
            }
        }
        float v2 = JavaVersion.toFloatVersion(versionStr);
        if ((double)f2 - 1.0 < 1.0) {
            void var1_3;
            String string2;
            int firstComma = Math.max(versionStr.indexOf(46), versionStr.indexOf(44));
            int end = Math.max(versionStr.length(), versionStr.indexOf(44, firstComma));
            if (Float.parseFloat(string2.substring((int)(var1_3 + true), n2)) > 0.9f) {
                return JAVA_RECENT;
            }
        } else if (var1_2 > 10.0f) {
            return JAVA_RECENT;
        }
        return null;
    }

    static JavaVersion getJavaVersion(String versionStr) {
        return JavaVersion.get(versionStr);
    }

    /*
     * WARNING - void declaration
     */
    private static float maxVersion() {
        float f2;
        float v2 = JavaVersion.toFloatVersion(SystemProperties.getJavaSpecificationVersion("99.0"));
        if (f2 > 0.0f) {
            void var0;
            return (float)var0;
        }
        return 99.0f;
    }

    static String[] split(String value) {
        return value.split(VERSION_SPLIT_REGEX);
    }

    private static float toFloatVersion(String value) {
        if (!value.contains(".")) {
            return NumberUtils.toFloat(value, -1.0f);
        }
        String[] toParse = JavaVersion.split(value);
        if (toParse.length >= 2) {
            String[] stringArray;
            return NumberUtils.toFloat(toParse[0] + '.' + stringArray[1], -1.0f);
        }
        return -1.0f;
    }

    /*
     * WARNING - void declaration
     */
    private JavaVersion(float value, String name) {
        void var3_3;
        this.value = var3_3;
        this.name = name;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean atLeast(JavaVersion requiredVersion) {
        void var1_1;
        return this.value >= var1_1.value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean atMost(JavaVersion requiredVersion) {
        void var1_1;
        return this.value <= var1_1.value;
    }

    public final String toString() {
        return this.name;
    }
}

