/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.UUID;

public class Conversion {
    private static final boolean[] TTTT = new boolean[]{true, true, true, true};
    private static final boolean[] FTTT = new boolean[]{false, true, true, true};
    private static final boolean[] TFTT = new boolean[]{true, false, true, true};
    private static final boolean[] FFTT = new boolean[]{false, false, true, true};
    private static final boolean[] TTFT = new boolean[]{true, true, false, true};
    private static final boolean[] FTFT = new boolean[]{false, true, false, true};
    private static final boolean[] TFFT = new boolean[]{true, false, false, true};
    private static final boolean[] FFFT = new boolean[]{false, false, false, true};
    private static final boolean[] TTTF = new boolean[]{true, true, true, false};
    private static final boolean[] FTTF = new boolean[]{false, true, true, false};
    private static final boolean[] TFTF = new boolean[]{true, false, true, false};
    private static final boolean[] FFTF = new boolean[]{false, false, true, false};
    private static final boolean[] TTFF = new boolean[]{true, true, false, false};
    private static final boolean[] FTFF = new boolean[]{false, true, false, false};
    private static final boolean[] TFFF = new boolean[]{true, false, false, false};
    private static final boolean[] FFFF = new boolean[]{false, false, false, false};

    public static char binaryBeMsb0ToHexDigit(boolean[] src) {
        return Conversion.binaryBeMsb0ToHexDigit(src, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static char binaryBeMsb0ToHexDigit(boolean[] src, int srcPos) {
        void var1_1;
        boolean[] blArray;
        if (Integer.compareUnsigned(srcPos, src.length) >= 0) {
            if (src.length == 0) {
                throw new IllegalArgumentException("Cannot convert an empty array.");
            }
            throw new IndexOutOfBoundsException(srcPos + " is not within array length " + src.length);
        }
        int pos = src.length - 1 - srcPos;
        if (3 <= pos && src[pos - 3]) {
            if (src[pos - 2]) {
                if (src[pos - 1]) {
                    if (src[pos]) {
                        return 'f';
                    }
                    return 'e';
                }
                if (src[pos]) {
                    return 'd';
                }
                return 'c';
            }
            if (src[pos - 1]) {
                if (src[pos]) {
                    return 'b';
                }
                return 'a';
            }
            if (src[pos]) {
                return '9';
            }
            return '8';
        }
        if (2 <= pos && src[pos - 2]) {
            if (src[pos - 1]) {
                if (src[pos]) {
                    return '7';
                }
                return '6';
            }
            if (src[pos]) {
                return '5';
            }
            return '4';
        }
        if (pos > 0 && src[pos - 1]) {
            if (src[pos]) {
                return '3';
            }
            return '2';
        }
        if (blArray[var1_1]) {
            return '1';
        }
        return '0';
    }

    /*
     * WARNING - void declaration
     */
    public static byte binaryToByte(boolean[] src, int srcPos, byte dstInit, int dstPos, int nBools) {
        void var2_2;
        if (src.length == 0 && srcPos == 0 || nBools == 0) {
            return dstInit;
        }
        if (nBools - 1 + dstPos >= 8) {
            throw new IllegalArgumentException("nBools-1+dstPos is greater or equal to than 8");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            byte out;
            int shift = i2 + dstPos;
            int bits = (src[i2 + srcPos] ? 1 : 0) << shift;
            int mask = 1 << shift;
            out = (byte)(out & ~mask | bits);
        }
        return (byte)var2_2;
    }

    public static char binaryToHexDigit(boolean[] src) {
        return Conversion.binaryToHexDigit(src, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static char binaryToHexDigit(boolean[] src, int srcPos) {
        void var1_1;
        boolean[] blArray;
        if (src.length == 0) {
            throw new IllegalArgumentException("Cannot convert an empty array.");
        }
        if (src.length > srcPos + 3 && src[srcPos + 3]) {
            if (src[srcPos + 2]) {
                if (src[srcPos + 1]) {
                    if (src[srcPos]) {
                        return 'f';
                    }
                    return 'e';
                }
                if (src[srcPos]) {
                    return 'd';
                }
                return 'c';
            }
            if (src[srcPos + 1]) {
                if (src[srcPos]) {
                    return 'b';
                }
                return 'a';
            }
            if (src[srcPos]) {
                return '9';
            }
            return '8';
        }
        if (src.length > srcPos + 2 && src[srcPos + 2]) {
            if (src[srcPos + 1]) {
                if (src[srcPos]) {
                    return '7';
                }
                return '6';
            }
            if (src[srcPos]) {
                return '5';
            }
            return '4';
        }
        if (src.length > srcPos + 1 && src[srcPos + 1]) {
            if (src[srcPos]) {
                return '3';
            }
            return '2';
        }
        if (blArray[var1_1]) {
            return '1';
        }
        return '0';
    }

    public static char binaryToHexDigitMsb0_4bits(boolean[] src) {
        return Conversion.binaryToHexDigitMsb0_4bits(src, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static char binaryToHexDigitMsb0_4bits(boolean[] src, int srcPos) {
        void var1_1;
        boolean[] blArray;
        if (src.length > 8) {
            throw new IllegalArgumentException("src.length>8: src.length=" + src.length);
        }
        if (src.length - srcPos < 4) {
            throw new IllegalArgumentException("src.length-srcPos<4: src.length=" + src.length + ", srcPos=" + srcPos);
        }
        if (src[srcPos + 3]) {
            if (src[srcPos + 2]) {
                if (src[srcPos + 1]) {
                    if (src[srcPos]) {
                        return 'f';
                    }
                    return '7';
                }
                if (src[srcPos]) {
                    return 'b';
                }
                return '3';
            }
            if (src[srcPos + 1]) {
                if (src[srcPos]) {
                    return 'd';
                }
                return '5';
            }
            if (src[srcPos]) {
                return '9';
            }
            return '1';
        }
        if (src[srcPos + 2]) {
            if (src[srcPos + 1]) {
                if (src[srcPos]) {
                    return 'e';
                }
                return '6';
            }
            if (src[srcPos]) {
                return 'a';
            }
            return '2';
        }
        if (src[srcPos + 1]) {
            if (src[srcPos]) {
                return 'c';
            }
            return '4';
        }
        if (blArray[var1_1]) {
            return '8';
        }
        return '0';
    }

    /*
     * WARNING - void declaration
     */
    public static int binaryToInt(boolean[] src, int srcPos, int dstInit, int dstPos, int nBools) {
        void var2_2;
        if (src.length == 0 && srcPos == 0 || nBools == 0) {
            return dstInit;
        }
        if (nBools - 1 + dstPos >= 32) {
            throw new IllegalArgumentException("nBools-1+dstPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            int out;
            int shift = i2 + dstPos;
            int bits = (src[i2 + srcPos] ? 1 : 0) << shift;
            int mask = 1 << shift;
            out = out & ~mask | bits;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long binaryToLong(boolean[] src, int srcPos, long dstInit, int dstPos, int nBools) {
        if (src.length == 0 && srcPos == 0 || nBools == 0) {
            return dstInit;
        }
        if (nBools - 1 + dstPos >= 64) {
            throw new IllegalArgumentException("nBools-1+dstPos is greater or equal to than 64");
        }
        long out = dstInit;
        for (int i2 = 0; i2 < nBools; ++i2) {
            void var3_7;
            int shift = i2 + dstPos;
            long bits = (src[i2 + srcPos] ? 1L : 0L) << shift;
            long mask = 1L << var3_7;
            out = out & (mask ^ 0xFFFFFFFFFFFFFFFFL) | bits;
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public static short binaryToShort(boolean[] src, int srcPos, short dstInit, int dstPos, int nBools) {
        void var2_2;
        if (src.length == 0 && srcPos == 0 || nBools == 0) {
            return dstInit;
        }
        if (nBools - 1 + dstPos >= 16) {
            throw new IllegalArgumentException("nBools-1+dstPos is greater or equal to than 16");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            short out;
            int shift = i2 + dstPos;
            int bits = (src[i2 + srcPos] ? 1 : 0) << shift;
            int mask = 1 << shift;
            out = (short)(out & ~mask | bits);
        }
        return (short)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int byteArrayToInt(byte[] src, int srcPos, int dstInit, int dstPos, int nBytes) {
        void var2_2;
        if (src.length == 0 && srcPos == 0 || nBytes == 0) {
            return dstInit;
        }
        if ((nBytes - 1 << 3) + dstPos >= 32) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int out;
            int shift = (i2 << 3) + dstPos;
            int bits = (0xFF & src[i2 + srcPos]) << shift;
            int mask = 255 << shift;
            out = out & ~mask | bits;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long byteArrayToLong(byte[] src, int srcPos, long dstInit, int dstPos, int nBytes) {
        if (src.length == 0 && srcPos == 0 || nBytes == 0) {
            return dstInit;
        }
        if ((nBytes - 1 << 3) + dstPos >= 64) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greater or equal to than 64");
        }
        long out = dstInit;
        for (int i2 = 0; i2 < nBytes; ++i2) {
            void var3_7;
            int shift = (i2 << 3) + dstPos;
            long bits = (0xFFL & (long)src[i2 + srcPos]) << shift;
            long mask = 255L << var3_7;
            out = out & (mask ^ 0xFFFFFFFFFFFFFFFFL) | bits;
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public static short byteArrayToShort(byte[] src, int srcPos, short dstInit, int dstPos, int nBytes) {
        void var2_2;
        if (src.length == 0 && srcPos == 0 || nBytes == 0) {
            return dstInit;
        }
        if ((nBytes - 1 << 3) + dstPos >= 16) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greater or equal to than 16");
        }
        for (int i2 = 0; i2 < nBytes; ++i2) {
            short out;
            int shift = (i2 << 3) + dstPos;
            int bits = (0xFF & src[i2 + srcPos]) << shift;
            int mask = 255 << shift;
            out = (short)(out & ~mask | bits);
        }
        return (short)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static UUID byteArrayToUuid(byte[] src, int srcPos) {
        void var1_1;
        byte[] byArray;
        if (src.length - srcPos < 16) {
            throw new IllegalArgumentException("Need at least 16 bytes for UUID");
        }
        return new UUID(Conversion.byteArrayToLong(src, srcPos, 0L, 0, 8), Conversion.byteArrayToLong(byArray, (int)(var1_1 + 8), 0L, 0, 8));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] byteToBinary(byte src, int srcPos, boolean[] dst, int dstPos, int nBools) {
        void var2_2;
        if (nBools == 0) {
            return dst;
        }
        if (nBools - 1 + srcPos >= 8) {
            throw new IllegalArgumentException("nBools-1+srcPos is greater or equal to than 8");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            int shift = i2 + srcPos;
            dst[dstPos + i2] = (1 & src >> shift) != 0;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String byteToHex(byte src, int srcPos, String dstInit, int dstPos, int nHexs) {
        void var2_2;
        if (nHexs == 0) {
            return dstInit;
        }
        if ((nHexs - 1 << 2) + srcPos >= 8) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greater or equal to than 8");
        }
        StringBuilder sb = new StringBuilder(dstInit);
        int append = sb.length();
        for (int i2 = 0; i2 < nHexs; ++i2) {
            int shift = (i2 << 2) + srcPos;
            int bits = 0xF & src >> shift;
            if (dstPos + i2 == append) {
                ++append;
                sb.append(Conversion.intToHexDigit(bits));
                continue;
            }
            sb.setCharAt(dstPos + i2, Conversion.intToHexDigit(bits));
        }
        return var2_2.toString();
    }

    public static boolean[] hexDigitMsb0ToBinary(char hexDigit) {
        char c2;
        switch (hexDigit) {
            case '0': {
                return (boolean[])FFFF.clone();
            }
            case '1': {
                return (boolean[])FFFT.clone();
            }
            case '2': {
                return (boolean[])FFTF.clone();
            }
            case '3': {
                return (boolean[])FFTT.clone();
            }
            case '4': {
                return (boolean[])FTFF.clone();
            }
            case '5': {
                return (boolean[])FTFT.clone();
            }
            case '6': {
                return (boolean[])FTTF.clone();
            }
            case '7': {
                return (boolean[])FTTT.clone();
            }
            case '8': {
                return (boolean[])TFFF.clone();
            }
            case '9': {
                return (boolean[])TFFT.clone();
            }
            case 'A': 
            case 'a': {
                return (boolean[])TFTF.clone();
            }
            case 'B': 
            case 'b': {
                return (boolean[])TFTT.clone();
            }
            case 'C': 
            case 'c': {
                return (boolean[])TTFF.clone();
            }
            case 'D': 
            case 'd': {
                return (boolean[])TTFT.clone();
            }
            case 'E': 
            case 'e': {
                return (boolean[])TTTF.clone();
            }
            case 'F': 
            case 'f': {
                return (boolean[])TTTT.clone();
            }
        }
        throw new IllegalArgumentException("Cannot interpret '" + c2 + "' as a hexadecimal digit");
    }

    public static int hexDigitMsb0ToInt(char hexDigit) {
        char c2;
        switch (hexDigit) {
            case '0': {
                return 0;
            }
            case '1': {
                return 8;
            }
            case '2': {
                return 4;
            }
            case '3': {
                return 12;
            }
            case '4': {
                return 2;
            }
            case '5': {
                return 10;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 14;
            }
            case '8': {
                return 1;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 5;
            }
            case 'B': 
            case 'b': {
                return 13;
            }
            case 'C': 
            case 'c': {
                return 3;
            }
            case 'D': 
            case 'd': {
                return 11;
            }
            case 'E': 
            case 'e': {
                return 7;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Cannot interpret '" + c2 + "' as a hexadecimal digit");
    }

    public static boolean[] hexDigitToBinary(char hexDigit) {
        char c2;
        switch (hexDigit) {
            case '0': {
                return (boolean[])FFFF.clone();
            }
            case '1': {
                return (boolean[])TFFF.clone();
            }
            case '2': {
                return (boolean[])FTFF.clone();
            }
            case '3': {
                return (boolean[])TTFF.clone();
            }
            case '4': {
                return (boolean[])FFTF.clone();
            }
            case '5': {
                return (boolean[])TFTF.clone();
            }
            case '6': {
                return (boolean[])FTTF.clone();
            }
            case '7': {
                return (boolean[])TTTF.clone();
            }
            case '8': {
                return (boolean[])FFFT.clone();
            }
            case '9': {
                return (boolean[])TFFT.clone();
            }
            case 'A': 
            case 'a': {
                return (boolean[])FTFT.clone();
            }
            case 'B': 
            case 'b': {
                return (boolean[])TTFT.clone();
            }
            case 'C': 
            case 'c': {
                return (boolean[])FFTT.clone();
            }
            case 'D': 
            case 'd': {
                return (boolean[])TFTT.clone();
            }
            case 'E': 
            case 'e': {
                return (boolean[])FTTT.clone();
            }
            case 'F': 
            case 'f': {
                return (boolean[])TTTT.clone();
            }
        }
        throw new IllegalArgumentException("Cannot interpret '" + c2 + "' as a hexadecimal digit");
    }

    /*
     * WARNING - void declaration
     */
    public static int hexDigitToInt(char hexDigit) {
        void var1_1;
        int digit = Character.digit(hexDigit, 16);
        if (digit < 0) {
            char c2;
            throw new IllegalArgumentException("Cannot interpret '" + c2 + "' as a hexadecimal digit");
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte hexToByte(String src, int srcPos, byte dstInit, int dstPos, int nHex) {
        void var2_2;
        if (nHex == 0) {
            return dstInit;
        }
        if ((nHex - 1 << 2) + dstPos >= 8) {
            throw new IllegalArgumentException("(nHex-1)*4+dstPos is greater than or equal to 8");
        }
        for (int i2 = 0; i2 < nHex; ++i2) {
            byte out;
            int shift = (i2 << 2) + dstPos;
            int bits = (0xF & Conversion.hexDigitToInt(src.charAt(i2 + srcPos))) << shift;
            int mask = 15 << shift;
            out = (byte)(out & ~mask | bits);
        }
        return (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int hexToInt(String src, int srcPos, int dstInit, int dstPos, int nHex) {
        void var2_2;
        if (nHex == 0) {
            return dstInit;
        }
        if ((nHex - 1 << 2) + dstPos >= 32) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nHex; ++i2) {
            int out;
            int shift = (i2 << 2) + dstPos;
            int bits = (0xF & Conversion.hexDigitToInt(src.charAt(i2 + srcPos))) << shift;
            int mask = 15 << shift;
            out = out & ~mask | bits;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long hexToLong(String src, int srcPos, long dstInit, int dstPos, int nHex) {
        if (nHex == 0) {
            return dstInit;
        }
        if ((nHex - 1 << 2) + dstPos >= 64) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greater or equal to than 64");
        }
        long out = dstInit;
        for (int i2 = 0; i2 < nHex; ++i2) {
            void var3_7;
            int shift = (i2 << 2) + dstPos;
            long bits = (0xFL & (long)Conversion.hexDigitToInt(src.charAt(i2 + srcPos))) << shift;
            long mask = 15L << var3_7;
            out = out & (mask ^ 0xFFFFFFFFFFFFFFFFL) | bits;
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public static short hexToShort(String src, int srcPos, short dstInit, int dstPos, int nHex) {
        void var2_2;
        if (nHex == 0) {
            return dstInit;
        }
        if ((nHex - 1 << 2) + dstPos >= 16) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greater or equal to than 16");
        }
        for (int i2 = 0; i2 < nHex; ++i2) {
            short out;
            int shift = (i2 << 2) + dstPos;
            int bits = (0xF & Conversion.hexDigitToInt(src.charAt(i2 + srcPos))) << shift;
            int mask = 15 << shift;
            out = (short)(out & ~mask | bits);
        }
        return (short)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long intArrayToLong(int[] src, int srcPos, long dstInit, int dstPos, int nInts) {
        if (src.length == 0 && srcPos == 0 || nInts == 0) {
            return dstInit;
        }
        if ((nInts - 1 << 5) + dstPos >= 64) {
            throw new IllegalArgumentException("(nInts-1)*32+dstPos is greater or equal to than 64");
        }
        long out = dstInit;
        for (int i2 = 0; i2 < nInts; ++i2) {
            void var3_7;
            int shift = (i2 << 5) + dstPos;
            long bits = (0xFFFFFFFFL & (long)src[i2 + srcPos]) << shift;
            long mask = 0xFFFFFFFFL << var3_7;
            out = out & (mask ^ 0xFFFFFFFFFFFFFFFFL) | bits;
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] intToBinary(int src, int srcPos, boolean[] dst, int dstPos, int nBools) {
        void var2_2;
        if (nBools == 0) {
            return dst;
        }
        if (nBools - 1 + srcPos >= 32) {
            throw new IllegalArgumentException("nBools-1+srcPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            int shift = i2 + srcPos;
            dst[dstPos + i2] = (1 & src >> shift) != 0;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] intToByteArray(int src, int srcPos, byte[] dst, int dstPos, int nBytes) {
        void var2_2;
        if (nBytes == 0) {
            return dst;
        }
        if ((nBytes - 1 << 3) + srcPos >= 32) {
            throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int shift = (i2 << 3) + srcPos;
            dst[dstPos + i2] = (byte)(0xFF & src >> shift);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String intToHex(int src, int srcPos, String dstInit, int dstPos, int nHexs) {
        void var2_2;
        if (nHexs == 0) {
            return dstInit;
        }
        if ((nHexs - 1 << 2) + srcPos >= 32) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greater or equal to than 32");
        }
        StringBuilder sb = new StringBuilder(dstInit);
        int append = sb.length();
        for (int i2 = 0; i2 < nHexs; ++i2) {
            int shift = (i2 << 2) + srcPos;
            int bits = 0xF & src >> shift;
            if (dstPos + i2 == append) {
                ++append;
                sb.append(Conversion.intToHexDigit(bits));
                continue;
            }
            sb.setCharAt(dstPos + i2, Conversion.intToHexDigit(bits));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static char intToHexDigit(int nibble) {
        void var1_1;
        char c2 = Character.forDigit(nibble, 16);
        if (c2 == '\u0000') {
            int n2;
            throw new IllegalArgumentException("nibble value not between 0 and 15: " + n2);
        }
        return (char)var1_1;
    }

    public static char intToHexDigitMsb0(int nibble) {
        int n2;
        switch (nibble) {
            case 0: {
                return '0';
            }
            case 1: {
                return '8';
            }
            case 2: {
                return '4';
            }
            case 3: {
                return 'c';
            }
            case 4: {
                return '2';
            }
            case 5: {
                return 'a';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return 'e';
            }
            case 8: {
                return '1';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return '5';
            }
            case 11: {
                return 'd';
            }
            case 12: {
                return '3';
            }
            case 13: {
                return 'b';
            }
            case 14: {
                return '7';
            }
            case 15: {
                return 'f';
            }
        }
        throw new IllegalArgumentException("nibble value not between 0 and 15: " + n2);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] intToShortArray(int src, int srcPos, short[] dst, int dstPos, int nShorts) {
        void var2_2;
        if (nShorts == 0) {
            return dst;
        }
        if ((nShorts - 1 << 4) + srcPos >= 32) {
            throw new IllegalArgumentException("(nShorts-1)*16+srcPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nShorts; ++i2) {
            int shift = (i2 << 4) + srcPos;
            dst[dstPos + i2] = (short)(0xFFFF & src >> shift);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] longToBinary(long src, int srcPos, boolean[] dst, int dstPos, int nBools) {
        void var3_2;
        if (nBools == 0) {
            return dst;
        }
        if (nBools - 1 + srcPos >= 64) {
            throw new IllegalArgumentException("nBools-1+srcPos is greater or equal to than 64");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            int shift = i2 + srcPos;
            dst[dstPos + i2] = (1L & src >> shift) != 0L;
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] longToByteArray(long src, int srcPos, byte[] dst, int dstPos, int nBytes) {
        void var3_2;
        if (nBytes == 0) {
            return dst;
        }
        if ((nBytes - 1 << 3) + srcPos >= 64) {
            throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greater or equal to than 64");
        }
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int shift = (i2 << 3) + srcPos;
            dst[dstPos + i2] = (byte)(0xFFL & src >> shift);
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String longToHex(long src, int srcPos, String dstInit, int dstPos, int nHexs) {
        void var3_2;
        if (nHexs == 0) {
            return dstInit;
        }
        if ((nHexs - 1 << 2) + srcPos >= 64) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greater or equal to than 64");
        }
        StringBuilder sb = new StringBuilder(dstInit);
        int append = sb.length();
        for (int i2 = 0; i2 < nHexs; ++i2) {
            int shift = (i2 << 2) + srcPos;
            int bits = (int)(0xFL & src >> shift);
            if (dstPos + i2 == append) {
                ++append;
                sb.append(Conversion.intToHexDigit(bits));
                continue;
            }
            sb.setCharAt(dstPos + i2, Conversion.intToHexDigit(bits));
        }
        return var3_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static int[] longToIntArray(long src, int srcPos, int[] dst, int dstPos, int nInts) {
        void var3_2;
        if (nInts == 0) {
            return dst;
        }
        if ((nInts - 1 << 5) + srcPos >= 64) {
            throw new IllegalArgumentException("(nInts-1)*32+srcPos is greater or equal to than 64");
        }
        for (int i2 = 0; i2 < nInts; ++i2) {
            int shift = (i2 << 5) + srcPos;
            dst[dstPos + i2] = (int)(0xFFFFFFFFFFFFFFFFL & src >> shift);
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] longToShortArray(long src, int srcPos, short[] dst, int dstPos, int nShorts) {
        void var3_2;
        if (nShorts == 0) {
            return dst;
        }
        if ((nShorts - 1 << 4) + srcPos >= 64) {
            throw new IllegalArgumentException("(nShorts-1)*16+srcPos is greater or equal to than 64");
        }
        for (int i2 = 0; i2 < nShorts; ++i2) {
            int shift = (i2 << 4) + srcPos;
            dst[dstPos + i2] = (short)(0xFFFFL & src >> shift);
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int shortArrayToInt(short[] src, int srcPos, int dstInit, int dstPos, int nShorts) {
        void var2_2;
        if (src.length == 0 && srcPos == 0 || nShorts == 0) {
            return dstInit;
        }
        if ((nShorts - 1 << 4) + dstPos >= 32) {
            throw new IllegalArgumentException("(nShorts-1)*16+dstPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nShorts; ++i2) {
            int out;
            int shift = (i2 << 4) + dstPos;
            int bits = (0xFFFF & src[i2 + srcPos]) << shift;
            int mask = 65535 << shift;
            out = out & ~mask | bits;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long shortArrayToLong(short[] src, int srcPos, long dstInit, int dstPos, int nShorts) {
        if (src.length == 0 && srcPos == 0 || nShorts == 0) {
            return dstInit;
        }
        if ((nShorts - 1 << 4) + dstPos >= 64) {
            throw new IllegalArgumentException("(nShorts-1)*16+dstPos is greater or equal to than 64");
        }
        long out = dstInit;
        for (int i2 = 0; i2 < nShorts; ++i2) {
            void var3_7;
            int shift = (i2 << 4) + dstPos;
            long bits = (0xFFFFL & (long)src[i2 + srcPos]) << shift;
            long mask = 65535L << var3_7;
            out = out & (mask ^ 0xFFFFFFFFFFFFFFFFL) | bits;
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] shortToBinary(short src, int srcPos, boolean[] dst, int dstPos, int nBools) {
        void var2_2;
        if (nBools == 0) {
            return dst;
        }
        if (nBools - 1 + srcPos >= 16) {
            throw new IllegalArgumentException("nBools-1+srcPos is greater or equal to than 16");
        }
        assert (nBools - 1 < 16 - srcPos);
        for (int i2 = 0; i2 < nBools; ++i2) {
            int shift = i2 + srcPos;
            dst[dstPos + i2] = (1 & src >> shift) != 0;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] shortToByteArray(short src, int srcPos, byte[] dst, int dstPos, int nBytes) {
        void var2_2;
        if (nBytes == 0) {
            return dst;
        }
        if ((nBytes - 1 << 3) + srcPos >= 16) {
            throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greater or equal to than 16");
        }
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int shift = (i2 << 3) + srcPos;
            dst[dstPos + i2] = (byte)(0xFF & src >> shift);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String shortToHex(short src, int srcPos, String dstInit, int dstPos, int nHexs) {
        void var2_2;
        if (nHexs == 0) {
            return dstInit;
        }
        if ((nHexs - 1 << 2) + srcPos >= 16) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greater or equal to than 16");
        }
        StringBuilder sb = new StringBuilder(dstInit);
        int append = sb.length();
        for (int i2 = 0; i2 < nHexs; ++i2) {
            int shift = (i2 << 2) + srcPos;
            int bits = 0xF & src >> shift;
            if (dstPos + i2 == append) {
                ++append;
                sb.append(Conversion.intToHexDigit(bits));
                continue;
            }
            sb.setCharAt(dstPos + i2, Conversion.intToHexDigit(bits));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] uuidToByteArray(UUID src, byte[] dst, int dstPos, int nBytes) {
        void var1_1;
        if (nBytes == 0) {
            return dst;
        }
        if (nBytes > 16) {
            throw new IllegalArgumentException("nBytes is greater than 16");
        }
        Conversion.longToByteArray(src.getMostSignificantBits(), 0, dst, dstPos, Math.min(nBytes, 8));
        if (nBytes >= 8) {
            void var3_3;
            void var2_2;
            UUID uUID;
            Conversion.longToByteArray(uUID.getLeastSignificantBits(), 0, dst, (int)(var2_2 + 8), (int)(var3_3 - 8));
        }
        return var1_1;
    }

    @Deprecated
    public Conversion() {
    }
}

