/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class CharUtils {
    private static final String[] CHAR_STRING_ARRAY = new String[128];
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char NUL = '\u0000';

    /*
     * WARNING - void declaration
     */
    public static int compare(char x, char y) {
        void var1_1;
        return x - var1_1;
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiAlpha(char ch) {
        char c2;
        return CharUtils.isAsciiAlphaUpper(ch) || CharUtils.isAsciiAlphaLower(c2);
    }

    public static boolean isAsciiAlphaLower(char ch) {
        char c2;
        return ch >= 'a' && c2 <= 'z';
    }

    public static boolean isAsciiAlphanumeric(char ch) {
        char c2;
        return CharUtils.isAsciiAlpha(ch) || CharUtils.isAsciiNumeric(c2);
    }

    public static boolean isAsciiAlphaUpper(char ch) {
        char c2;
        return ch >= 'A' && c2 <= 'Z';
    }

    public static boolean isAsciiControl(char ch) {
        char c2;
        return ch < ' ' || c2 == '\u007f';
    }

    public static boolean isAsciiNumeric(char ch) {
        char c2;
        return ch >= '0' && c2 <= '9';
    }

    public static boolean isAsciiPrintable(char ch) {
        char c2;
        return ch >= ' ' && c2 < '\u007f';
    }

    public static char toChar(Character ch) {
        return Objects.requireNonNull(ch, "ch").charValue();
    }

    /*
     * WARNING - void declaration
     */
    public static char toChar(Character ch, char defaultValue) {
        void var1_1;
        if (ch != null) {
            Character c2;
            return c2.charValue();
        }
        return (char)var1_1;
    }

    public static char toChar(String str) {
        String string;
        Validate.notEmpty(str, "The String must not be empty", new Object[0]);
        return string.charAt(0);
    }

    /*
     * WARNING - void declaration
     */
    public static char toChar(String str, char defaultValue) {
        String string;
        if (StringUtils.isEmpty(str)) {
            void var1_1;
            return (char)var1_1;
        }
        return string.charAt(0);
    }

    @Deprecated
    public static Character toCharacterObject(char c2) {
        return Character.valueOf(c2);
    }

    public static Character toCharacterObject(String str) {
        String string;
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        return Character.valueOf(string.charAt(0));
    }

    public static int toIntValue(char ch) {
        char c2;
        if (!CharUtils.isAsciiNumeric(ch)) {
            throw new IllegalArgumentException("The character " + ch + " is not in the range '0' - '9'");
        }
        return c2 - 48;
    }

    /*
     * WARNING - void declaration
     */
    public static int toIntValue(char ch, int defaultValue) {
        void var1_1;
        if (CharUtils.isAsciiNumeric(ch)) {
            char c2;
            return c2 - 48;
        }
        return (int)var1_1;
    }

    public static int toIntValue(Character ch) {
        return CharUtils.toIntValue(CharUtils.toChar(ch));
    }

    /*
     * WARNING - void declaration
     */
    public static int toIntValue(Character ch, int defaultValue) {
        void var1_1;
        if (ch != null) {
            Character c2;
            return CharUtils.toIntValue(c2.charValue(), defaultValue);
        }
        return (int)var1_1;
    }

    public static String toString(char ch) {
        char c2;
        if (ch < CHAR_STRING_ARRAY.length) {
            return CHAR_STRING_ARRAY[ch];
        }
        return String.valueOf(c2);
    }

    public static String toString(Character ch) {
        if (ch != null) {
            Character c2;
            return CharUtils.toString(c2.charValue());
        }
        return null;
    }

    public static String unicodeEscaped(char ch) {
        char c2;
        return "\\u" + HEX_DIGITS[ch >> 12 & 0xF] + HEX_DIGITS[ch >> 8 & 0xF] + HEX_DIGITS[ch >> 4 & 0xF] + HEX_DIGITS[c2 & 0xF];
    }

    public static String unicodeEscaped(Character ch) {
        if (ch != null) {
            Character c2;
            return CharUtils.unicodeEscaped(c2.charValue());
        }
        return null;
    }

    @Deprecated
    public CharUtils() {
    }

    static {
        ArrayUtils.setAll(CHAR_STRING_ARRAY, i2 -> String.valueOf((char)i2));
    }
}

