/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.stream.Streams;

public class CharSetUtils {
    public static boolean containsAny(String str, String ... set) {
        Object object;
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return false;
        }
        CharSet chars = CharSet.getInstance(set);
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object c2 = object[i2];
            if (!chars.contains((char)c2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int count(String str, String ... set) {
        void var2_2;
        Object object;
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return 0;
        }
        CharSet chars = CharSet.getInstance(set);
        int count = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object c2 = object[i2];
            if (!chars.contains((char)c2)) continue;
            ++count;
        }
        return (int)var2_2;
    }

    private static boolean deepEmpty(String[] strings) {
        return Streams.of(strings).allMatch(StringUtils::isEmpty);
    }

    /*
     * WARNING - void declaration
     */
    public static String delete(String str, String ... set) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return str;
        }
        return CharSetUtils.modify(string, (String[])var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String keep(String str, String ... set) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (str.isEmpty() || CharSetUtils.deepEmpty(set)) {
            return "";
        }
        return CharSetUtils.modify(string, (String[])var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private static String modify(String str, String[] set, boolean expect) {
        void var3_3;
        Object object;
        CharSet chars = CharSet.getInstance(set);
        StringBuilder buffer = new StringBuilder(str.length());
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object chr = object[i2];
            if (chars.contains((char)chr) != expect) continue;
            buffer.append((char)chr);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String squeeze(String str, String ... set) {
        void var2_2;
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return str;
        }
        CharSet chars = CharSet.getInstance(set);
        StringBuilder buffer = new StringBuilder(str.length());
        char[] cArray = str.toCharArray();
        Object chrs = cArray;
        int sz = cArray.length;
        Object lastChar = chrs[0];
        Character inChars = null;
        Character notInChars = null;
        buffer.append((char)lastChar);
        for (int i2 = 1; i2 < sz; ++i2) {
            Object ch = chrs[i2];
            if (ch == lastChar) {
                if (inChars != null && ch == inChars.charValue()) continue;
                if (notInChars == null || ch != notInChars.charValue()) {
                    if (chars.contains((char)ch)) {
                        inChars = Character.valueOf((char)ch);
                        continue;
                    }
                    notInChars = Character.valueOf((char)ch);
                }
            }
            buffer.append((char)ch);
            lastChar = ch;
        }
        return var2_2.toString();
    }

    @Deprecated
    public CharSetUtils() {
    }
}

