/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;
import java.util.Random;

final class CachedRandomBits {
    private final Random random;
    private final byte[] cache;
    private int bitIndex;

    /*
     * WARNING - void declaration
     */
    CachedRandomBits(int cacheSize, Random random) {
        void var2_2;
        void var1_1;
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("cacheSize must be positive");
        }
        this.cache = new byte[var1_1];
        this.random = (Random)Objects.requireNonNull(var2_2, "random");
        this.random.nextBytes(this.cache);
        this.bitIndex = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int nextBits(int bits) {
        void var2_2;
        if (bits > 32 || bits <= 0) {
            throw new IllegalArgumentException("number of bits must be between 1 and 32");
        }
        int result = 0;
        int generatedBits = 0;
        while (generatedBits < bits) {
            if (this.bitIndex >> 3 >= this.cache.length) {
                assert (this.bitIndex == this.cache.length << 3);
                this.random.nextBytes(this.cache);
                this.bitIndex = 0;
            }
            int generatedBitsInIteration = Math.min(8 - (this.bitIndex & 7), bits - generatedBits);
            result <<= generatedBitsInIteration;
            result |= this.cache[this.bitIndex >> 3] >> (this.bitIndex & 7) & (1 << generatedBitsInIteration) - 1;
            generatedBits += generatedBitsInIteration;
            this.bitIndex += generatedBitsInIteration;
        }
        return (int)var2_2;
    }
}

