/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.UncheckedException;
import org.apache.commons.lang3.function.FailableBiConsumer;

public final class AppendableJoiner<T> {
    private final CharSequence prefix;
    private final CharSequence suffix;
    private final CharSequence delimiter;
    private final FailableBiConsumer<Appendable, T, IOException> appender;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    static <A extends Appendable, T> A joinA(A appendable, CharSequence prefix, CharSequence suffix, CharSequence delimiter, FailableBiConsumer<Appendable, T, IOException> appender, T ... elements) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return AppendableJoiner.joinArray(appendable, (CharSequence)var1_1, (CharSequence)var2_2, (CharSequence)var3_3, appender, elements);
    }

    /*
     * WARNING - void declaration
     */
    private static <A extends Appendable, T> A joinArray(A appendable, CharSequence prefix, CharSequence suffix, CharSequence delimiter, FailableBiConsumer<Appendable, T, IOException> appender, T[] elements) throws IOException {
        A a2;
        void var2_3;
        appendable.append(prefix);
        if (elements != null) {
            if (elements.length > 0) {
                appender.accept(appendable, (A)elements[0]);
            }
            for (int i2 = 1; i2 < elements.length; ++i2) {
                appendable.append(delimiter);
                appender.accept(appendable, (A)elements[i2]);
            }
        }
        appendable.append((CharSequence)var2_3);
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    static <T> StringBuilder joinI(StringBuilder stringBuilder, CharSequence prefix, CharSequence suffix, CharSequence delimiter, FailableBiConsumer<Appendable, T, IOException> appender, Iterable<T> elements) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            return AppendableJoiner.joinIterable(stringBuilder, (CharSequence)var1_2, (CharSequence)var2_3, (CharSequence)var3_4, appender, elements);
        }
        catch (IOException e2) {
            void var0_1;
            throw new UncheckedException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <A extends Appendable, T> A joinIterable(A appendable, CharSequence prefix, CharSequence suffix, CharSequence delimiter, FailableBiConsumer<Appendable, T, IOException> appender, Iterable<T> elements) throws IOException {
        A a2;
        void var2_2;
        appendable.append(prefix);
        if (elements != null) {
            Iterator<T> iterator2 = elements.iterator();
            if (iterator2.hasNext()) {
                appender.accept(appendable, (A)iterator2.next());
            }
            while (iterator2.hasNext()) {
                appendable.append(delimiter);
                appender.accept(appendable, (A)iterator2.next());
            }
        }
        appendable.append((CharSequence)var2_2);
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    static <T> StringBuilder joinSB(StringBuilder stringBuilder, CharSequence prefix, CharSequence suffix, CharSequence delimiter, FailableBiConsumer<Appendable, T, IOException> appender, T ... elements) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            return AppendableJoiner.joinArray(stringBuilder, (CharSequence)var1_2, (CharSequence)var2_3, (CharSequence)var3_4, appender, elements);
        }
        catch (IOException e2) {
            void var0_1;
            throw new UncheckedException((Throwable)var0_1);
        }
    }

    private static CharSequence nonNull(CharSequence value) {
        if (value != null) {
            CharSequence charSequence;
            return charSequence;
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private AppendableJoiner(CharSequence prefix, CharSequence suffix, CharSequence delimiter, FailableBiConsumer<Appendable, T, IOException> appender) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.prefix = AppendableJoiner.nonNull((CharSequence)var1_1);
        this.suffix = AppendableJoiner.nonNull((CharSequence)var2_2);
        this.delimiter = AppendableJoiner.nonNull((CharSequence)var3_3);
        this.appender = appender != null ? appender : (a2, e2) -> {
            void var1_1;
            a2.append(String.valueOf(var1_1));
        };
    }

    /*
     * WARNING - void declaration
     */
    public final StringBuilder join(StringBuilder stringBuilder, Iterable<T> elements) {
        void var2_2;
        return AppendableJoiner.joinI(stringBuilder, this.prefix, this.suffix, this.delimiter, this.appender, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final StringBuilder join(StringBuilder stringBuilder, T ... elements) {
        void var2_2;
        return AppendableJoiner.joinSB(stringBuilder, this.prefix, this.suffix, this.delimiter, this.appender, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Appendable> A joinA(A appendable, Iterable<T> elements) throws IOException {
        void var2_2;
        return AppendableJoiner.joinIterable(appendable, this.prefix, this.suffix, this.delimiter, this.appender, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Appendable> A joinA(A appendable, T ... elements) throws IOException {
        void var2_2;
        return AppendableJoiner.joinA(appendable, this.prefix, this.suffix, this.delimiter, this.appender, var2_2);
    }

    public static final class Builder<T>
    implements Supplier<AppendableJoiner<T>> {
        private CharSequence prefix;
        private CharSequence suffix;
        private CharSequence delimiter;
        private FailableBiConsumer<Appendable, T, IOException> appender;

        Builder() {
        }

        @Override
        public final AppendableJoiner<T> get() {
            return new AppendableJoiner(this.prefix, this.suffix, this.delimiter, this.appender);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setDelimiter(CharSequence delimiter) {
            void var1_1;
            this.delimiter = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setElementAppender(FailableBiConsumer<Appendable, T, IOException> appender) {
            void var1_1;
            this.appender = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setPrefix(CharSequence prefix) {
            void var1_1;
            this.prefix = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setSuffix(CharSequence suffix) {
            void var1_1;
            this.suffix = var1_1;
            return this;
        }
    }
}

