/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.ZipFileSystem;
import okio.internal.EocdRecord;
import okio.internal.ZipEntry;
import okio.internal.ZipFilesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002\u001a\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#0\"H\u0000\u001a\f\u0010$\u001a\u00020\u0015*\u00020%H\u0000\u001a\f\u0010&\u001a\u00020'*\u00020%H\u0002\u001a.\u0010(\u001a\u00020)*\u00020%2\u0006\u0010*\u001a\u00020\u00012\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020)0,H\u0002\u001a\u0014\u0010-\u001a\u00020.*\u00020%2\u0006\u0010/\u001a\u00020.H\u0000\u001a\u0018\u00100\u001a\u0004\u0018\u00010.*\u00020%2\b\u0010/\u001a\u0004\u0018\u00010.H\u0002\u001a\u0014\u00101\u001a\u00020'*\u00020%2\u0006\u00102\u001a\u00020'H\u0002\u001a\f\u00103\u001a\u00020)*\u00020%H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00064"}, d2={"BIT_FLAG_ENCRYPTED", "", "BIT_FLAG_UNSUPPORTED_MASK", "CENTRAL_FILE_HEADER_SIGNATURE", "COMPRESSION_METHOD_DEFLATED", "COMPRESSION_METHOD_STORED", "END_OF_CENTRAL_DIRECTORY_SIGNATURE", "HEADER_ID_EXTENDED_TIMESTAMP", "HEADER_ID_ZIP64_EXTENDED_INFO", "LOCAL_FILE_HEADER_SIGNATURE", "MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE", "", "ZIP64_EOCD_RECORD_SIGNATURE", "ZIP64_LOCATOR_SIGNATURE", "hex", "", "getHex", "(I)Ljava/lang/String;", "buildIndex", "", "Lokio/Path;", "Lokio/internal/ZipEntry;", "entries", "", "dosDateTimeToEpochMillis", "date", "time", "(II)Ljava/lang/Long;", "openZip", "Lokio/ZipFileSystem;", "zipPath", "fileSystem", "Lokio/FileSystem;", "predicate", "Lkotlin/Function1;", "", "readEntry", "Lokio/BufferedSource;", "readEocdRecord", "Lokio/internal/EocdRecord;", "readExtra", "", "extraSize", "block", "Lkotlin/Function2;", "readLocalHeader", "Lokio/FileMetadata;", "basicMetadata", "readOrSkipLocalHeader", "readZip64EocdRecord", "regularRecord", "skipLocalHeader", "okio"})
@SourceDebugExtension(value={"SMAP\nZipFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFiles.kt\nokio/internal/ZipFilesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,459:1\n1045#2:460\n*S KotlinDebug\n*F\n+ 1 ZipFiles.kt\nokio/internal/ZipFilesKt\n*L\n156#1:460\n*E\n"})
public final class ZipFilesKt {
    private static final int LOCAL_FILE_HEADER_SIGNATURE = 67324752;
    private static final int CENTRAL_FILE_HEADER_SIGNATURE = 33639248;
    private static final int END_OF_CENTRAL_DIRECTORY_SIGNATURE = 101010256;
    private static final int ZIP64_LOCATOR_SIGNATURE = 117853008;
    private static final int ZIP64_EOCD_RECORD_SIGNATURE = 101075792;
    public static final int COMPRESSION_METHOD_DEFLATED = 8;
    public static final int COMPRESSION_METHOD_STORED = 0;
    private static final int BIT_FLAG_ENCRYPTED = 1;
    private static final int BIT_FLAG_UNSUPPORTED_MASK = 1;
    private static final long MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE = 0xFFFFFFFFL;
    private static final int HEADER_ID_ZIP64_EXTENDED_INFO = 1;
    private static final int HEADER_ID_EXTENDED_TIMESTAMP = 21589;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ZipFileSystem openZip(@NotNull Path zipPath, @NotNull FileSystem fileSystem, @NotNull Function1<? super ZipEntry, Boolean> predicate) throws IOException {
        ZipFileSystem zipFileSystem;
        Intrinsics.checkNotNullParameter(zipPath, "");
        Intrinsics.checkNotNullParameter(fileSystem, "");
        Intrinsics.checkNotNullParameter(predicate, "");
        Closeable closeable = fileSystem.openReadOnly(zipPath);
        Throwable throwable = null;
        try {
            void var1_2;
            Object object;
            String comment;
            EocdRecord record;
            long eocdOffset;
            FileHandle fileHandle;
            block26: {
                fileHandle = (FileHandle)closeable;
                long scanOffset = fileHandle.size() - 22L;
                if (scanOffset < 0L) {
                    throw new IOException("not a zip: size=" + fileHandle.size());
                }
                long stopOffset = Math.max(scanOffset - 65536L, 0L);
                do {
                    try (BufferedSource source2 = Okio.buffer(fileHandle.source(scanOffset));){
                        if (source2.readIntLe() != 101010256) continue;
                        eocdOffset = scanOffset;
                        record = ZipFilesKt.readEocdRecord(source2);
                        comment = source2.readUtf8(record.getCommentByteCount());
                        break block26;
                    }
                } while ((record += -1L) >= stopOffset);
                throw new IOException("not a zip: end of central directory signature not found");
            }
            long zip64LocatorOffset = eocdOffset - 20L;
            if (zip64LocatorOffset > 0L) {
                Closeable stopOffset;
                block27: {
                    stopOffset = Okio.buffer(fileHandle.source(zip64LocatorOffset));
                    object = null;
                    try {
                        BufferedSource zip64LocatorSource = (BufferedSource)stopOffset;
                        if (zip64LocatorSource.readIntLe() != 117853008) break block27;
                        int diskWithCentralDir22 = zip64LocatorSource.readIntLe();
                        long zip64EocdRecordOffset = zip64LocatorSource.readLongLe();
                        int n2 = zip64LocatorSource.readIntLe();
                        if (n2 != 1 || diskWithCentralDir22 != 0) {
                            throw new IOException("unsupported zip: spanned");
                        }
                        Closeable closeable2 = Okio.buffer(fileHandle.source(zip64EocdRecordOffset));
                        Throwable diskWithCentralDir22 = null;
                        try {
                            BufferedSource zip64EocdSource = (BufferedSource)closeable2;
                            int zip64EocdSignature = zip64EocdSource.readIntLe();
                            if (zip64EocdSignature != 101075792) {
                                throw new IOException("bad zip: expected " + ZipFilesKt.getHex(101075792) + " but was " + ZipFilesKt.getHex(zip64EocdSignature));
                            }
                            record = ZipFilesKt.readZip64EocdRecord(zip64EocdSource, record);
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                diskWithCentralDir22 = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                CloseableKt.closeFinally(closeable2, diskWithCentralDir22);
                                throw throwable4;
                            }
                        }
                        CloseableKt.closeFinally(closeable2, null);
                    }
                    catch (Throwable throwable5) {
                        try {
                            Throwable throwable6 = throwable5;
                            object = throwable5;
                            throw throwable6;
                        }
                        catch (Throwable throwable7) {
                            CloseableKt.closeFinally(stopOffset, (Throwable)object);
                            throw throwable7;
                        }
                    }
                }
                CloseableKt.closeFinally(stopOffset, null);
            }
            List entries = new ArrayList();
            object = Okio.buffer(fileHandle.source(record.getCentralDirectoryOffset()));
            Throwable throwable8 = null;
            try {
                BufferedSource source3 = (BufferedSource)object;
                long l2 = record.getEntryCount();
                for (long i2 = 0L; i2 < l2; ++i2) {
                    ZipEntry entry = ZipFilesKt.readEntry(source3);
                    if (entry.getOffset() >= record.getCentralDirectoryOffset()) {
                        throw new IOException("bad zip: local file header offset >= central directory offset");
                    }
                    if (!predicate.invoke(entry).booleanValue()) continue;
                    ((Collection)entries).add(entry);
                }
            }
            catch (Throwable throwable9) {
                try {
                    Throwable throwable10 = throwable9;
                    throwable8 = throwable9;
                    throw throwable10;
                }
                catch (Throwable throwable11) {
                    CloseableKt.closeFinally((Closeable)object, throwable8);
                    throw throwable11;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            Map<Path, ZipEntry> index = ZipFilesKt.buildIndex(entries);
            zipFileSystem = new ZipFileSystem((Path)((Object)zipFileSystem), (FileSystem)var1_2, index, comment);
        }
        catch (Throwable throwable12) {
            try {
                Throwable throwable13 = throwable12;
                throwable = throwable12;
                throw throwable13;
            }
            catch (Throwable throwable14) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable14;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return zipFileSystem;
    }

    public static /* synthetic */ ZipFileSystem openZip$default(Path path, FileSystem fileSystem, Function1 function1, int n2, Object object) throws IOException {
        if ((n2 & 4) != 0) {
            function1 = openZip.1.INSTANCE;
        }
        return ZipFilesKt.openZip(path, fileSystem, function1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Path, ZipEntry> buildIndex(List<ZipEntry> entries) {
        void var1_1;
        Path root = Path.Companion.get$default(Path.Companion, "/", false, 1, null);
        Pair[] pairArray = new Pair[1];
        Pair[] pairArray2 = pairArray;
        pairArray[0] = TuplesKt.to(root, new ZipEntry(root, true, null, 0L, 0L, 0L, 0, null, 0L, 508, null));
        Map<Object, Object> result = MapsKt.mutableMapOf(pairArray2);
        block0: for (ZipEntry entry : CollectionsKt.sortedWith(entries, new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a2, T b2) {
                void var1_1;
                Comparable comparable;
                a2 = (ZipEntry)a2;
                ZipEntry it = (ZipEntry)((Object)comparable);
                comparable = ((ZipEntry)a2).getCanonicalPath();
                return ComparisonsKt.compareValues(comparable, (Comparable)var1_1.getCanonicalPath());
            }
        })) {
            ZipEntry child;
            ZipEntry zipEntry = (ZipEntry)result.put(entry.getCanonicalPath(), entry);
            if (zipEntry != null) continue;
            while (child.getCanonicalPath().parent() != null) {
                Path parentPath;
                ZipEntry parentEntry = (ZipEntry)result.get(parentPath);
                if (parentEntry != null) {
                    ((Collection)parentEntry.getChildren()).add(child.getCanonicalPath());
                    continue block0;
                }
                parentEntry = new ZipEntry(parentPath, true, null, 0L, 0L, 0L, 0, null, 0L, 508, null);
                result.put(zipEntry, parentEntry);
                ((Collection)parentEntry.getChildren()).add(child.getCanonicalPath());
                child = parentEntry;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ZipEntry readEntry(@NotNull BufferedSource $this$readEntry) throws IOException {
        void var2_3;
        void var1_1;
        void var3_5;
        String string;
        Intrinsics.checkNotNullParameter($this$readEntry, "");
        int signature = $this$readEntry.readIntLe();
        if (signature != 33639248) {
            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(33639248) + " but was " + ZipFilesKt.getHex(signature));
        }
        $this$readEntry.skip(4L);
        int bitFlag = $this$readEntry.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipFilesKt.getHex(bitFlag));
        }
        int compressionMethod = $this$readEntry.readShortLe() & 0xFFFF;
        int time = $this$readEntry.readShortLe() & 0xFFFF;
        int n2 = $this$readEntry.readShortLe() & 0xFFFF;
        Long lastModifiedAtMillis = ZipFilesKt.dosDateTimeToEpochMillis(n2, time);
        long crc = (long)$this$readEntry.readIntLe() & 0xFFFFFFFFL;
        Ref.LongRef compressedSize = new Ref.LongRef();
        new Ref.LongRef().element = (long)$this$readEntry.readIntLe() & 0xFFFFFFFFL;
        Ref.LongRef size = new Ref.LongRef();
        new Ref.LongRef().element = (long)$this$readEntry.readIntLe() & 0xFFFFFFFFL;
        int nameSize = $this$readEntry.readShortLe() & 0xFFFF;
        int extraSize = $this$readEntry.readShortLe() & 0xFFFF;
        int commentByteCount = $this$readEntry.readShortLe() & 0xFFFF;
        $this$readEntry.skip(8L);
        Ref.LongRef offset = new Ref.LongRef();
        new Ref.LongRef().element = (long)$this$readEntry.readIntLe() & 0xFFFFFFFFL;
        String name = $this$readEntry.readUtf8(nameSize);
        if (StringsKt.contains$default((CharSequence)name, '\u0000', false, 2, null)) {
            throw new IOException("bad zip: filename contains 0x00");
        }
        long result = 0L;
        if (size.element == 0xFFFFFFFFL) {
            result = 8L;
        }
        if (compressedSize.element == 0xFFFFFFFFL) {
            result += 8L;
        }
        if (offset.element == 0xFFFFFFFFL) {
            result += 8L;
        }
        long requiredZip64ExtraSize = result;
        Ref.BooleanRef hasZip64Extra = new Ref.BooleanRef();
        ZipFilesKt.readExtra($this$readEntry, extraSize, (Function2<? super Integer, ? super Long, Unit>)new Function2<Integer, Long, Unit>(hasZip64Extra, requiredZip64ExtraSize, size, $this$readEntry, compressedSize, offset){
            final /* synthetic */ Ref.BooleanRef $hasZip64Extra;
            final /* synthetic */ long $requiredZip64ExtraSize;
            final /* synthetic */ Ref.LongRef $size;
            final /* synthetic */ BufferedSource $this_readEntry;
            final /* synthetic */ Ref.LongRef $compressedSize;
            final /* synthetic */ Ref.LongRef $offset;
            {
                void var2_2;
                void var1_1;
                this.$hasZip64Extra = var1_1;
                this.$requiredZip64ExtraSize = var2_2;
                this.$size = $size;
                this.$this_readEntry = $receiver;
                this.$compressedSize = $compressedSize;
                this.$offset = $offset;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(int headerId, long dataSize) {
                if (headerId == 1) {
                    void var2_2;
                    if (this.$hasZip64Extra.element) {
                        throw new IOException("bad zip: zip64 extra repeated");
                    }
                    this.$hasZip64Extra.element = true;
                    if (var2_2 < this.$requiredZip64ExtraSize) {
                        throw new IOException("bad zip: zip64 extra too short");
                    }
                    this.$size.element = this.$size.element == 0xFFFFFFFFL ? this.$this_readEntry.readLongLe() : this.$size.element;
                    this.$compressedSize.element = this.$compressedSize.element == 0xFFFFFFFFL ? this.$this_readEntry.readLongLe() : 0L;
                    this.$offset.element = this.$offset.element == 0xFFFFFFFFL ? this.$this_readEntry.readLongLe() : 0L;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final /* synthetic */ Object invoke(Object p1, Object p2) {
                void var2_2;
                void var1_1;
                this.invoke(((Number)var1_1).intValue(), ((Number)var2_2).longValue());
                return Unit.INSTANCE;
            }
        });
        if (requiredZip64ExtraSize > 0L && !hasZip64Extra.element) {
            throw new IOException("bad zip: zip64 extra required but absent");
        }
        String comment = $this$readEntry.readUtf8(commentByteCount);
        Path canonicalPath = Path.Companion.get$default(Path.Companion, "/", false, 1, null).resolve(name);
        boolean isDirectory = StringsKt.endsWith$default(name, "/", false, 2, null);
        return new ZipEntry(canonicalPath, isDirectory, string, crc, var3_5.element, size.element, (int)var1_1, (Long)var2_3, offset.element);
    }

    /*
     * WARNING - void declaration
     */
    private static final EocdRecord readEocdRecord(BufferedSource $this$readEocdRecord) throws IOException {
        void var0_1;
        void var3_4;
        void var2_3;
        void var1_2;
        long totalEntryCount;
        int diskNumber = $this$readEocdRecord.readShortLe() & 0xFFFF;
        int diskWithCentralDir = $this$readEocdRecord.readShortLe() & 0xFFFF;
        long entryCount = $this$readEocdRecord.readShortLe() & 0xFFFF;
        if (entryCount != (totalEntryCount = (long)($this$readEocdRecord.readShortLe() & 0xFFFF)) || var1_2 != false || var2_3 != false) {
            throw new IOException("unsupported zip: spanned");
        }
        $this$readEocdRecord.skip(4L);
        long centralDirectoryOffset = (long)$this$readEocdRecord.readIntLe() & 0xFFFFFFFFL;
        int commentByteCount = $this$readEocdRecord.readShortLe() & 0xFFFF;
        return new EocdRecord((long)var3_4, centralDirectoryOffset, (int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final EocdRecord readZip64EocdRecord(BufferedSource $this$readZip64EocdRecord, EocdRecord regularRecord) throws IOException {
        void var1_1;
        BufferedSource bufferedSource;
        void var3_3;
        void var2_2;
        $this$readZip64EocdRecord.skip(12L);
        int diskNumber = $this$readZip64EocdRecord.readIntLe();
        int diskWithCentralDirStart = $this$readZip64EocdRecord.readIntLe();
        long entryCount = $this$readZip64EocdRecord.readLongLe();
        long totalEntryCount = $this$readZip64EocdRecord.readLongLe();
        if (entryCount != totalEntryCount || var2_2 != false || var3_3 != false) {
            throw new IOException("unsupported zip: spanned");
        }
        $this$readZip64EocdRecord.skip(8L);
        long centralDirectoryOffset = bufferedSource.readLongLe();
        return new EocdRecord(entryCount, centralDirectoryOffset, var1_1.getCommentByteCount());
    }

    /*
     * WARNING - void declaration
     */
    private static final void readExtra(BufferedSource $this$readExtra, int extraSize, Function2<? super Integer, ? super Long, Unit> block) {
        long dataSize;
        for (long remaining = (long)extraSize; remaining != 0L; remaining -= dataSize) {
            if (remaining < 4L) {
                throw new IOException("bad zip: truncated header in extra field");
            }
            int headerId = $this$readExtra.readShortLe() & 0xFFFF;
            dataSize = (long)$this$readExtra.readShortLe() & 0xFFFFL;
            if ((remaining -= 4L) < dataSize) {
                throw new IOException("bad zip: truncated value in extra field");
            }
            $this$readExtra.require(dataSize);
            long sizeBefore = $this$readExtra.getBuffer().size();
            block.invoke((Integer)headerId, (Long)dataSize);
            long fieldRemaining = dataSize + $this$readExtra.getBuffer().size() - sizeBefore;
            if (fieldRemaining < 0L) {
                void var1_1;
                throw new IOException("unsupported zip: too many bytes processed for " + (int)var1_1);
            }
            if (fieldRemaining <= 0L) continue;
            $this$readExtra.getBuffer().skip(fieldRemaining);
        }
    }

    public static final void skipLocalHeader(@NotNull BufferedSource $this$skipLocalHeader) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter($this$skipLocalHeader, "");
        ZipFilesKt.readOrSkipLocalHeader(bufferedSource, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FileMetadata readLocalHeader(@NotNull BufferedSource $this$readLocalHeader, @NotNull FileMetadata basicMetadata) {
        void var1_1;
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter($this$readLocalHeader, "");
        Intrinsics.checkNotNullParameter(basicMetadata, "");
        FileMetadata fileMetadata = ZipFilesKt.readOrSkipLocalHeader(bufferedSource, (FileMetadata)var1_1);
        Intrinsics.checkNotNull(fileMetadata);
        return fileMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private static final FileMetadata readOrSkipLocalHeader(BufferedSource $this$readOrSkipLocalHeader, FileMetadata basicMetadata) {
        void var3_3;
        void var2_2;
        void var1_1;
        BufferedSource bufferedSource;
        Ref.ObjectRef<Long> lastModifiedAtMillis = new Ref.ObjectRef<Long>();
        FileMetadata fileMetadata = basicMetadata;
        new Ref.ObjectRef<Long>().element = fileMetadata != null ? fileMetadata.getLastModifiedAtMillis() : null;
        Ref.ObjectRef<Long> lastAccessedAtMillis = new Ref.ObjectRef<Long>();
        Ref.ObjectRef<Long> createdAtMillis = new Ref.ObjectRef<Long>();
        int signature = $this$readOrSkipLocalHeader.readIntLe();
        if (signature != 67324752) {
            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(67324752) + " but was " + ZipFilesKt.getHex(signature));
        }
        $this$readOrSkipLocalHeader.skip(2L);
        int bitFlag = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipFilesKt.getHex(bitFlag));
        }
        $this$readOrSkipLocalHeader.skip(18L);
        long fileNameLength = (long)$this$readOrSkipLocalHeader.readShortLe() & 0xFFFFL;
        int extraSize = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        $this$readOrSkipLocalHeader.skip(fileNameLength);
        if (basicMetadata == null) {
            $this$readOrSkipLocalHeader.skip(extraSize);
            return null;
        }
        ZipFilesKt.readExtra($this$readOrSkipLocalHeader, extraSize, (Function2<? super Integer, ? super Long, Unit>)new Function2<Integer, Long, Unit>(bufferedSource, lastModifiedAtMillis, lastAccessedAtMillis, createdAtMillis){
            final /* synthetic */ BufferedSource $this_readOrSkipLocalHeader;
            final /* synthetic */ Ref.ObjectRef<Long> $lastModifiedAtMillis;
            final /* synthetic */ Ref.ObjectRef<Long> $lastAccessedAtMillis;
            final /* synthetic */ Ref.ObjectRef<Long> $createdAtMillis;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$this_readOrSkipLocalHeader = var1_1;
                this.$lastModifiedAtMillis = var2_2;
                this.$lastAccessedAtMillis = var3_3;
                this.$createdAtMillis = $createdAtMillis;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(int headerId, long dataSize) {
                if (headerId == 21589) {
                    void var1_1;
                    long requiredSize;
                    void var2_2;
                    if (dataSize < 1L) {
                        throw new IOException("bad zip: extended timestamp extra too short");
                    }
                    int flags = this.$this_readOrSkipLocalHeader.readByte() & 0xFF;
                    boolean hasLastModifiedAtMillis = (flags & 1) == 1;
                    boolean hasLastAccessedAtMillis = (flags & 2) == 2;
                    boolean hasCreatedAtMillis = (flags & 4) == 4;
                    long result = 1L;
                    if (hasLastModifiedAtMillis) {
                        result = 5L;
                    }
                    if (hasLastAccessedAtMillis) {
                        result += 4L;
                    }
                    if (hasCreatedAtMillis) {
                        result += 4L;
                    }
                    if (var2_2 < (requiredSize = result)) {
                        throw new IOException("bad zip: extended timestamp extra too short");
                    }
                    if (hasLastModifiedAtMillis) {
                        this.$lastModifiedAtMillis.element = (long)this.$this_readOrSkipLocalHeader.readIntLe() * 1000L;
                    }
                    if (hasLastAccessedAtMillis) {
                        this.$lastAccessedAtMillis.element = (long)this.$this_readOrSkipLocalHeader.readIntLe() * 1000L;
                    }
                    if (var1_1 != false) {
                        this.$createdAtMillis.element = (long)this.$this_readOrSkipLocalHeader.readIntLe() * 1000L;
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public final /* synthetic */ Object invoke(Object p1, Object p2) {
                void var2_2;
                void var1_1;
                this.invoke(((Number)var1_1).intValue(), ((Number)var2_2).longValue());
                return Unit.INSTANCE;
            }
        });
        return new FileMetadata(basicMetadata.isRegularFile(), basicMetadata.isDirectory(), null, var1_1.getSize(), (Long)createdAtMillis.element, (Long)var2_2.element, (Long)var3_3.element, null, 128, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Long dosDateTimeToEpochMillis(int date, int time) {
        void var2_2;
        void var1_1;
        int n2;
        void var3_3;
        if (time == -1) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(14, 0);
        int year = 1980 + (date >> 9 & 0x7F);
        int month = date >> 5 & 0xF;
        int day = date & 0x1F;
        int hour = time >> 11 & 0x1F;
        int minute = time >> 5 & 0x3F;
        int second = (time & 0x1F) << 1;
        cal.set((int)var3_3, month - 1, n2, hour, minute, (int)var1_1);
        return var2_2.getTime().getTime();
    }

    private static final String getHex(int $this$hex) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder("0x");
        String string = Integer.toString(n2, CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "");
        return stringBuilder.append(string).toString();
    }
}

