/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.InflaterSource;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.internal.FixedLengthSource;
import okio.internal.ZipEntry;
import okio.internal.ZipFilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010$\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lokio/ZipFileSystem;", "Lokio/FileSystem;", "zipPath", "Lokio/Path;", "fileSystem", "entries", "", "Lokio/internal/ZipEntry;", "comment", "", "(Lokio/Path;Lokio/FileSystem;Ljava/util/Map;Ljava/lang/String;)V", "appendingSink", "Lokio/Sink;", "file", "mustExist", "", "atomicMove", "", "source", "target", "canonicalize", "path", "canonicalizeInternal", "createDirectory", "dir", "mustCreate", "createSymlink", "delete", "list", "", "throwOnFailure", "listOrNull", "metadataOrNull", "Lokio/FileMetadata;", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "sink", "Lokio/Source;", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nZipFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFileSystem.kt\nokio/ZipFileSystem\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,175:1\n52#2,5:176\n52#2,21:181\n60#2,10:202\n57#2,2:212\n71#2,2:214\n52#2,21:216\n*S KotlinDebug\n*F\n+ 1 ZipFileSystem.kt\nokio/ZipFileSystem\n*L\n102#1:176,5\n103#1:181,21\n102#1:202,10\n102#1:212,2\n102#1:214,2\n132#1:216,21\n*E\n"})
public final class ZipFileSystem
extends FileSystem {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Path zipPath;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Map<Path, ZipEntry> entries;
    @Nullable
    private final String comment;
    @NotNull
    private static final Path ROOT = Path.Companion.get$default(Path.Companion, "/", false, 1, null);

    /*
     * WARNING - void declaration
     */
    public ZipFileSystem(@NotNull Path zipPath, @NotNull FileSystem fileSystem, @NotNull Map<Path, ZipEntry> entries, @Nullable String comment) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(zipPath, "");
        Intrinsics.checkNotNullParameter(fileSystem, "");
        Intrinsics.checkNotNullParameter(entries, "");
        this.zipPath = var1_1;
        this.fileSystem = var2_2;
        this.entries = var3_3;
        this.comment = comment;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Path canonicalize(@NotNull Path path) {
        void var2_2;
        Intrinsics.checkNotNullParameter(path, "");
        Path canonical = this.canonicalizeInternal(path);
        if (!this.entries.containsKey(canonical)) {
            void var1_1;
            throw new FileNotFoundException(String.valueOf(var1_1));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final Path canonicalizeInternal(Path path) {
        void var1_1;
        return ROOT.resolve((Path)var1_1, true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public final FileMetadata metadataOrNull(@NotNull Path path) {
        Throwable thrown$iv;
        FileMetadata result$iv;
        block27: {
            Object result$iv22222;
            Intrinsics.checkNotNullParameter(path, "");
            Path canonicalPath = this.canonicalizeInternal(path);
            ZipEntry zipEntry = this.entries.get(canonicalPath);
            if (zipEntry == null) {
                return null;
            }
            ZipEntry entry = zipEntry;
            FileMetadata basicMetadata = new FileMetadata(!entry.isDirectory(), entry.isDirectory(), null, entry.isDirectory() ? null : Long.valueOf(entry.getSize()), null, entry.getLastModifiedAtMillis(), null, null, 128, null);
            if (entry.getOffset() == -1L) {
                return basicMetadata;
            }
            Closeable $this$use$iv = this.fileSystem.openReadOnly(this.zipPath);
            result$iv = null;
            thrown$iv = null;
            try {
                Throwable thrown$iv2;
                block26: {
                    Object object;
                    FileHandle fileHandle = (FileHandle)$this$use$iv;
                    Closeable $this$use$iv2 = Okio.buffer(fileHandle.source(entry.getOffset()));
                    result$iv22222 = null;
                    thrown$iv2 = null;
                    try {
                        void var2_2;
                        object = (BufferedSource)$this$use$iv2;
                        result$iv22222 = ZipFilesKt.readLocalHeader((BufferedSource)object, (FileMetadata)var2_2);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        thrown$iv2 = throwable;
                        try {
                            Closeable closeable = $this$use$iv2;
                            if (closeable != null) {
                                closeable.close();
                            }
                            break block26;
                        }
                        catch (Throwable t$iv) {
                            ExceptionsKt.addSuppressed(thrown$iv2, t$iv);
                        }
                        break block26;
                    }
                    catch (Throwable throwable) {
                        try {
                            void var1_1;
                            void v3 = var1_1;
                            if (v3 == null) throw throwable;
                            v3.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {}
                        throw throwable;
                    }
                    try {
                        Closeable closeable = $this$use$iv2;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        thrown$iv2 = throwable;
                    }
                }
                Throwable throwable = thrown$iv2;
                if (throwable != null) {
                    throw throwable;
                }
                FileMetadata fileMetadata = result$iv22222;
                Intrinsics.checkNotNull(fileMetadata);
                result$iv = fileMetadata;
            }
            catch (Throwable throwable) {
                Throwable result$iv22222 = throwable;
                thrown$iv = throwable;
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                    break block27;
                }
                catch (Throwable t$iv) {
                    ExceptionsKt.addSuppressed(thrown$iv, t$iv);
                }
                break block27;
            }
            catch (Throwable throwable6) {
                try {
                    void var3_3;
                    void v11 = var3_3;
                    if (v11 == null) throw throwable6;
                    v11.close();
                    throw throwable6;
                }
                catch (Throwable throwable) {}
                throw throwable6;
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable throwable) {
                result$iv22222 = throwable;
                thrown$iv = throwable;
            }
        }
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        FileMetadata fileMetadata = result$iv;
        Intrinsics.checkNotNull(fileMetadata);
        return fileMetadata;
    }

    @Override
    @NotNull
    public final FileHandle openReadOnly(@NotNull Path file) {
        Intrinsics.checkNotNullParameter(file, "");
        throw new UnsupportedOperationException("not implemented yet!");
    }

    @Override
    @NotNull
    public final FileHandle openReadWrite(@NotNull Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter(file, "");
        throw new IOException("zip entries are not writable");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final List<Path> list(@NotNull Path dir) {
        void var1_1;
        Intrinsics.checkNotNullParameter(dir, "");
        List<Path> list = this.list((Path)var1_1, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final List<Path> listOrNull(@NotNull Path dir) {
        void var1_1;
        Intrinsics.checkNotNullParameter(dir, "");
        return this.list((Path)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir, boolean throwOnFailure) {
        ZipEntry zipEntry;
        void var3_3;
        Path canonicalDir = this.canonicalizeInternal(dir);
        ZipEntry zipEntry2 = this.entries.get(var3_3);
        if (zipEntry2 == null) {
            void var2_2;
            if (var2_2 != false) {
                throw new IOException("not a directory: " + zipEntry);
            }
            return null;
        }
        zipEntry = zipEntry2;
        return CollectionsKt.toList((Iterable)zipEntry2.getChildren());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public final Source source(@NotNull Path file) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        Throwable thrown$iv;
        ZipEntry entry;
        block14: {
            Object object;
            Intrinsics.checkNotNullParameter(file, "");
            Path canonicalPath = this.canonicalizeInternal(file);
            ZipEntry zipEntry = this.entries.get(canonicalPath);
            if (zipEntry == null) {
                throw new FileNotFoundException("no such file: " + file);
            }
            entry = zipEntry;
            Closeable $this$use$iv = this.fileSystem.openReadOnly(this.zipPath);
            BufferedSource result$iv = null;
            thrown$iv = null;
            try {
                object = (FileHandle)$this$use$iv;
                result$iv = Okio.buffer(((FileHandle)object).source(entry.getOffset()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                thrown$iv = throwable;
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                    break block14;
                }
                catch (Throwable t$iv) {
                    ExceptionsKt.addSuppressed(thrown$iv, t$iv);
                }
                break block14;
            }
            catch (Throwable throwable) {
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable == null) throw throwable;
                    closeable.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                thrown$iv = throwable;
            }
        }
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        void v8 = var3_3;
        Intrinsics.checkNotNull(v8);
        void source2 = v8;
        ZipFilesKt.skipLocalHeader((BufferedSource)v8);
        if (entry.getCompressionMethod() == 0) {
            return new FixedLengthSource((Source)source2, entry.getSize(), true);
        }
        InflaterSource inflaterSource = new InflaterSource(new FixedLengthSource((Source)source2, entry.getCompressedSize(), true), new Inflater(true));
        return new FixedLengthSource((Source)var2_2, var1_1.getSize(), false);
    }

    @Override
    @NotNull
    public final Sink sink(@NotNull Path file, boolean mustCreate) {
        Intrinsics.checkNotNullParameter(file, "");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    @NotNull
    public final Sink appendingSink(@NotNull Path file, boolean mustExist) {
        Intrinsics.checkNotNullParameter(file, "");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public final void createDirectory(@NotNull Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter(dir, "");
        throw new IOException("zip file systems are read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void atomicMove(@NotNull Path source2, @NotNull Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(var2_2, "");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public final void delete(@NotNull Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter(path, "");
        throw new IOException("zip file systems are read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void createSymlink(@NotNull Path source2, @NotNull Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(var2_2, "");
        throw new IOException("zip file systems are read-only");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lokio/ZipFileSystem$Companion;", "", "()V", "ROOT", "Lokio/Path;", "getROOT", "()Lokio/Path;", "okio"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getROOT() {
            return ROOT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

