/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Segment;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u001f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016R\u0011\u0010\u0010\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lokio/HashingSource;", "Lokio/ForwardingSource;", "Lokio/Source;", "source", "digest", "Ljava/security/MessageDigest;", "(Lokio/Source;Ljava/security/MessageDigest;)V", "algorithm", "", "(Lokio/Source;Ljava/lang/String;)V", "mac", "Ljavax/crypto/Mac;", "(Lokio/Source;Ljavax/crypto/Mac;)V", "key", "Lokio/ByteString;", "(Lokio/Source;Lokio/ByteString;Ljava/lang/String;)V", "hash", "()Lokio/ByteString;", "messageDigest", "-deprecated_hash", "read", "", "sink", "Lokio/Buffer;", "byteCount", "Companion", "okio"})
public final class HashingSource
extends ForwardingSource
implements Source {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final MessageDigest messageDigest;
    @Nullable
    private final Mac mac;

    /*
     * WARNING - void declaration
     */
    public HashingSource(@NotNull Source source2, @NotNull MessageDigest digest) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(digest, "");
        super((Source)var1_1);
        this.messageDigest = var2_2;
        this.mac = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSource(@NotNull Source source2, @NotNull String algorithm) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(algorithm, "");
        MessageDigest messageDigest = MessageDigest.getInstance((String)var2_2);
        Intrinsics.checkNotNullExpressionValue(messageDigest, "");
        this((Source)var1_1, messageDigest);
    }

    /*
     * WARNING - void declaration
     */
    public HashingSource(@NotNull Source source2, @NotNull Mac mac) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(mac, "");
        super((Source)var1_1);
        this.mac = var2_2;
        this.messageDigest = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSource(@NotNull Source source2, @NotNull ByteString key, @NotNull String algorithm) {
        void v3;
        HashingSource hashingSource;
        Object object;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(key, "");
        Intrinsics.checkNotNullParameter(algorithm, "");
        Mac mac = object;
        object = this;
        try {
            void var3_3;
            void var2_2;
            void $this$_init__u24lambda_u240;
            HashingSource hashingSource2 = object;
            void v1 = mac;
            object = Mac.getInstance(algorithm);
            mac = object;
            void var6_6 = v1;
            HashingSource hashingSource3 = hashingSource2;
            $this$_init__u24lambda_u240.init(new SecretKeySpec(var2_2.toByteArray(), (String)var3_3));
            hashingSource = hashingSource3;
            v3 = var6_6;
        }
        catch (InvalidKeyException e2) {
            throw new IllegalArgumentException(e2);
        }
        Intrinsics.checkNotNull(object);
        hashingSource((Source)v3, (Mac)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(@NotNull Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter(sink2, "");
        long result = super.read(sink2, byteCount);
        if (result != -1L) {
            long offset;
            long start = sink2.size() - result;
            Segment segment = sink2.head;
            Intrinsics.checkNotNull(segment);
            Segment s2 = segment;
            for (offset = sink2.size(); offset > start; offset -= (long)(s2.limit - s2.pos)) {
                Intrinsics.checkNotNull(s2.prev);
            }
            while (offset < sink2.size()) {
                int pos = (int)((long)s2.pos + start - offset);
                if (this.messageDigest != null) {
                    this.messageDigest.update(s2.data, pos, s2.limit - pos);
                } else {
                    void var3_7;
                    Mac mac = this.mac;
                    Intrinsics.checkNotNull(mac);
                    mac.update(s2.data, pos, s2.limit - var3_7);
                }
                start = offset += (long)(s2.limit - s2.pos);
                Intrinsics.checkNotNull(s2.next);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="hash")
    @NotNull
    public final ByteString hash() {
        void var1_1;
        byte[] byArray;
        if (this.messageDigest != null) {
            byArray = this.messageDigest.digest();
        } else {
            Mac mac = this.mac;
            Intrinsics.checkNotNull(mac);
            byArray = mac.doFinal();
        }
        byte[] result = byArray;
        Intrinsics.checkNotNull(result);
        return new ByteString((byte[])var1_1);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="hash", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_hash")
    @NotNull
    public final ByteString -deprecated_hash() {
        return this.hash();
    }

    @JvmStatic
    @NotNull
    public static final HashingSource md5(@NotNull Source source2) {
        Source source3;
        return Companion.md5(source3);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource sha1(@NotNull Source source2) {
        Source source3;
        return Companion.sha1(source3);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource sha256(@NotNull Source source2) {
        Source source3;
        return Companion.sha256(source3);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource sha512(@NotNull Source source2) {
        Source source3;
        return Companion.sha512(source3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final HashingSource hmacSha1(@NotNull Source source2, @NotNull ByteString key) {
        void var1_1;
        Source source3;
        return Companion.hmacSha1(source3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final HashingSource hmacSha256(@NotNull Source source2, @NotNull ByteString key) {
        void var1_1;
        Source source3;
        return Companion.hmacSha256(source3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final HashingSource hmacSha512(@NotNull Source source2, @NotNull ByteString key) {
        void var1_1;
        Source source3;
        return Companion.hmacSha512(source3, (ByteString)var1_1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lokio/HashingSource$Companion;", "", "()V", "hmacSha1", "Lokio/HashingSource;", "source", "Lokio/Source;", "key", "Lokio/ByteString;", "hmacSha256", "hmacSha512", "md5", "sha1", "sha256", "sha512", "okio"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HashingSource md5(@NotNull Source source2) {
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            return new HashingSource((Source)var1_1, "MD5");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HashingSource sha1(@NotNull Source source2) {
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            return new HashingSource((Source)var1_1, "SHA-1");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HashingSource sha256(@NotNull Source source2) {
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            return new HashingSource((Source)var1_1, "SHA-256");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HashingSource sha512(@NotNull Source source2) {
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            return new HashingSource((Source)var1_1, "SHA-512");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HashingSource hmacSha1(@NotNull Source source2, @NotNull ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            Intrinsics.checkNotNullParameter(key, "");
            return new HashingSource((Source)var1_1, (ByteString)var2_2, "HmacSHA1");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HashingSource hmacSha256(@NotNull Source source2, @NotNull ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            Intrinsics.checkNotNullParameter(key, "");
            return new HashingSource((Source)var1_1, (ByteString)var2_2, "HmacSHA256");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HashingSource hmacSha512(@NotNull Source source2, @NotNull ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            Intrinsics.checkNotNullParameter(key, "");
            return new HashingSource((Source)var1_1, (ByteString)var2_2, "HmacSHA512");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

