/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.Segment;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0001J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0004J\u0012\u0010\u000e\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0014J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\fH\u0014J%\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"Lokio/AsyncTimeout;", "Lokio/Timeout;", "()V", "inQueue", "", "next", "timeoutAt", "", "access$newTimeoutException", "Ljava/io/IOException;", "cause", "enter", "", "exit", "newTimeoutException", "remainingNanos", "now", "sink", "Lokio/Sink;", "source", "Lokio/Source;", "timedOut", "withTimeout", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "Watchdog", "okio"})
public class AsyncTimeout
extends Timeout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean inQueue;
    @Nullable
    private AsyncTimeout next;
    private long timeoutAt;
    @NotNull
    private static final ReentrantLock lock = new ReentrantLock();
    @NotNull
    private static final Condition condition;
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS;
    private static final long IDLE_TIMEOUT_NANOS;
    @Nullable
    private static AsyncTimeout head;

    /*
     * WARNING - void declaration
     */
    public final void enter() {
        void var3_2;
        void var1_1;
        long timeoutNanos = this.timeoutNanos();
        boolean hasDeadline = this.hasDeadline();
        if (timeoutNanos == 0L && !hasDeadline) {
            return;
        }
        okio.AsyncTimeout$Companion.access$scheduleTimeout(Companion, this, (long)var1_1, (boolean)var3_2);
    }

    public final boolean exit() {
        return okio.AsyncTimeout$Companion.access$cancelScheduledTimeout(Companion, this);
    }

    /*
     * WARNING - void declaration
     */
    private final long remainingNanos(long now) {
        void var1_1;
        return this.timeoutAt - var1_1;
    }

    protected void timedOut() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sink sink(@NotNull Sink sink2) {
        void var1_1;
        Intrinsics.checkNotNullParameter(sink2, "");
        return new Sink(this, (Sink)var1_1){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Sink $sink;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$sink = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final void write(@NotNull Buffer source2, long byteCount) {
                long toWrite;
                Intrinsics.checkNotNullParameter(source2, "");
                -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
                for (long remaining = byteCount; remaining > 0L; remaining -= toWrite) {
                    void this_$iv;
                    toWrite = 0L;
                    Intrinsics.checkNotNull(source2.head);
                    while (toWrite < 65536L) {
                        Segment s2;
                        int segmentSize = s2.limit - s2.pos;
                        if ((toWrite += (long)segmentSize) >= remaining) {
                            toWrite = remaining;
                            break;
                        }
                        Intrinsics.checkNotNull(s2.next);
                    }
                    AsyncTimeout segmentSize = this.this$0;
                    Sink sink2 = this.$sink;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        sink2.write(source2, toWrite);
                        throwOnTimeout$iv = true;
                        boolean bl = this_$iv.exit();
                        if (!bl) continue;
                    }
                    catch (IOException e$iv) {
                        try {
                            void var1_2;
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException((IOException)var1_2);
                        }
                        catch (Throwable throwable) {
                            boolean bl = this_$iv.exit();
                            if (bl && throwOnTimeout$iv) {
                                void var3_9;
                                throw var3_9.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void flush() {
                block5: {
                    void this_$iv;
                    AsyncTimeout asyncTimeout = this.this$0;
                    Sink sink2 = this.$sink;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        sink2.flush();
                        throwOnTimeout$iv = true;
                        boolean bl = this_$iv.exit();
                        if (!bl) break block5;
                    }
                    catch (IOException e$iv) {
                        try {
                            void var2_4;
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException((IOException)var2_4);
                        }
                        catch (Throwable throwable) {
                            void var3_6;
                            boolean bl = this_$iv.exit();
                            if (bl && var3_6 != false) {
                                throw asyncTimeout.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
                return;
            }

            /*
             * WARNING - void declaration
             */
            public final void close() {
                block5: {
                    void this_$iv;
                    AsyncTimeout asyncTimeout = this.this$0;
                    Sink sink2 = this.$sink;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        sink2.close();
                        throwOnTimeout$iv = true;
                        boolean bl = this_$iv.exit();
                        if (!bl) break block5;
                    }
                    catch (IOException e$iv) {
                        try {
                            void var2_4;
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException((IOException)var2_4);
                        }
                        catch (Throwable throwable) {
                            void var3_6;
                            boolean bl = this_$iv.exit();
                            if (bl && var3_6 != false) {
                                throw asyncTimeout.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
                return;
            }

            @NotNull
            public final AsyncTimeout timeout() {
                return this.this$0;
            }

            @NotNull
            public final String toString() {
                return "AsyncTimeout.sink(" + this.$sink + ')';
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Source source(@NotNull Source source2) {
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        return new Source(this, (Source)var1_1){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Source $source;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$source = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final long read(@NotNull Buffer sink2, long byteCount) {
                long l2;
                block5: {
                    void this_$iv;
                    Intrinsics.checkNotNullParameter(sink2, "");
                    AsyncTimeout asyncTimeout = this.this$0;
                    Source source2 = this.$source;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        void var2_3;
                        void var1_1;
                        long result$iv = source2.read((Buffer)var1_1, (long)var2_3);
                        throwOnTimeout$iv = true;
                        l2 = result$iv;
                        boolean bl = this_$iv.exit();
                        if (!bl) break block5;
                    }
                    catch (IOException e$iv) {
                        try {
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                        }
                        catch (Throwable throwable) {
                            boolean bl = this_$iv.exit();
                            if (bl && throwOnTimeout$iv) {
                                throw this_$iv.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
                return l2;
            }

            /*
             * WARNING - void declaration
             */
            public final void close() {
                block5: {
                    void this_$iv;
                    AsyncTimeout asyncTimeout = this.this$0;
                    Source source2 = this.$source;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        source2.close();
                        throwOnTimeout$iv = true;
                        boolean bl = this_$iv.exit();
                        if (!bl) break block5;
                    }
                    catch (IOException e$iv) {
                        try {
                            void var2_4;
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException((IOException)var2_4);
                        }
                        catch (Throwable throwable) {
                            void var3_6;
                            boolean bl = this_$iv.exit();
                            if (bl && var3_6 != false) {
                                throw asyncTimeout.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
                return;
            }

            @NotNull
            public final AsyncTimeout timeout() {
                return this.this$0;
            }

            @NotNull
            public final String toString() {
                return "AsyncTimeout.source(" + this.$source + ')';
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T withTimeout(@NotNull Function0<? extends T> block) {
        T t2;
        Intrinsics.checkNotNullParameter(block, "");
        boolean throwOnTimeout = false;
        this.enter();
        try {
            T result = block.invoke();
            throwOnTimeout = true;
            t2 = result;
        }
        catch (IOException e2) {
            try {
                void var1_3;
                throw !this.exit() ? (Throwable)e2 : (Throwable)this.access$newTimeoutException((IOException)var1_3);
            }
            catch (Throwable throwable) {
                void var2_5;
                InlineMarker.finallyStart(1);
                boolean bl = this.exit();
                if (bl && var2_5 != false) {
                    throw this.access$newTimeoutException(null);
                }
                InlineMarker.finallyEnd(1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart(1);
        boolean result = this.exit();
        if (result) {
            throw this.access$newTimeoutException(null);
        }
        InlineMarker.finallyEnd(1);
        return t2;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @NotNull
    public final IOException access$newTimeoutException(@Nullable IOException cause) {
        void var1_1;
        return this.newTimeoutException((IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected IOException newTimeoutException(@Nullable IOException cause) {
        void var2_2;
        InterruptedIOException e2 = new InterruptedIOException("timeout");
        if (cause != null) {
            void var1_1;
            e2.initCause((Throwable)var1_1);
        }
        return (IOException)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long access$remainingNanos(AsyncTimeout $this, long now) {
        void var1_1;
        return $this.remainingNanos((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setNext$p(AsyncTimeout $this, AsyncTimeout asyncTimeout) {
        void var1_1;
        $this.next = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setInQueue$p(AsyncTimeout $this, boolean bl) {
        void var1_1;
        $this.inQueue = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTimeoutAt$p(AsyncTimeout $this, long l2) {
        void var1_1;
        $this.timeoutAt = var1_1;
    }

    static {
        Condition condition = lock.newCondition();
        Intrinsics.checkNotNullExpressionValue(condition, "");
        AsyncTimeout.condition = condition;
        IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
        IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lokio/AsyncTimeout$Companion;", "", "()V", "IDLE_TIMEOUT_MILLIS", "", "IDLE_TIMEOUT_NANOS", "TIMEOUT_WRITE_SIZE", "", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "head", "Lokio/AsyncTimeout;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "awaitTimeout", "awaitTimeout$okio", "cancelScheduledTimeout", "", "node", "scheduleTimeout", "", "timeoutNanos", "hasDeadline", "okio"})
    @SourceDebugExtension(value={"SMAP\nAsyncTimeout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncTimeout.kt\nokio/AsyncTimeout$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n1#2:332\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReentrantLock getLock() {
            return lock;
        }

        @NotNull
        public final Condition getCondition() {
            return condition;
        }

        private final void scheduleTimeout(AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
            Lock lock = Companion.getLock();
            lock.lock();
            try {
                if (!(!((AsyncTimeout)node).inQueue)) {
                    node = "Unbalanced enter/exit";
                    throw new IllegalStateException(node.toString());
                }
                AsyncTimeout.access$setInQueue$p((AsyncTimeout)node, true);
                if (head == null) {
                    head = new AsyncTimeout();
                    new Watchdog().start();
                }
                long now = System.nanoTime();
                if (timeoutNanos != 0L && hasDeadline) {
                    AsyncTimeout.access$setTimeoutAt$p((AsyncTimeout)node, now + Math.min(timeoutNanos, ((Timeout)node).deadlineNanoTime() - now));
                } else if (timeoutNanos != 0L) {
                    AsyncTimeout.access$setTimeoutAt$p((AsyncTimeout)node, now + timeoutNanos);
                } else if (hasDeadline) {
                    Object object = node;
                    AsyncTimeout.access$setTimeoutAt$p((AsyncTimeout)object, ((Timeout)object).deadlineNanoTime());
                } else {
                    throw new AssertionError();
                }
                long remainingNanos = AsyncTimeout.access$remainingNanos((AsyncTimeout)node, now);
                AsyncTimeout asyncTimeout = head;
                Intrinsics.checkNotNull(asyncTimeout);
                AsyncTimeout prev = asyncTimeout;
                while (true) {
                    block16: {
                        block15: {
                            if (prev.next == null) break block15;
                            AsyncTimeout asyncTimeout2 = prev.next;
                            Intrinsics.checkNotNull(asyncTimeout2);
                            if (remainingNanos >= AsyncTimeout.access$remainingNanos(asyncTimeout2, now)) break block16;
                        }
                        AsyncTimeout.access$setNext$p((AsyncTimeout)node, prev.next);
                        AsyncTimeout.access$setNext$p(prev, (AsyncTimeout)node);
                        if (prev != head) break;
                        Companion.getCondition().signal();
                        break;
                    }
                    Intrinsics.checkNotNull(prev.next);
                }
                return;
            }
            finally {
                lock.unlock();
            }
        }

        private final boolean cancelScheduledTimeout(AsyncTimeout node) {
            Lock lock = Companion.getLock();
            lock.lock();
            try {
                if (!node.inQueue) {
                    return false;
                }
                AsyncTimeout.access$setInQueue$p(node, false);
                AsyncTimeout prev = head;
                while (prev != null) {
                    if (prev.next == node) {
                        AsyncTimeout.access$setNext$p(prev, node.next);
                        AsyncTimeout.access$setNext$p(node, null);
                        return false;
                    }
                    prev = prev.next;
                }
                return true;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final AsyncTimeout awaitTimeout$okio() throws InterruptedException {
            void var1_1;
            AsyncTimeout asyncTimeout = head;
            Intrinsics.checkNotNull(asyncTimeout);
            AsyncTimeout node = asyncTimeout.next;
            if (node == null) {
                long startNanos = System.nanoTime();
                this.getCondition().await(IDLE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
                AsyncTimeout asyncTimeout2 = head;
                Intrinsics.checkNotNull(asyncTimeout2);
                if (asyncTimeout2.next == null && System.nanoTime() - startNanos >= IDLE_TIMEOUT_NANOS) {
                    return head;
                }
                return null;
            }
            long waitNanos = AsyncTimeout.access$remainingNanos(node, System.nanoTime());
            if (waitNanos > 0L) {
                void var2_3;
                this.getCondition().await((long)var2_3, TimeUnit.NANOSECONDS);
                return null;
            }
            AsyncTimeout asyncTimeout3 = head;
            Intrinsics.checkNotNull(asyncTimeout3);
            AsyncTimeout.access$setNext$p(asyncTimeout3, node.next);
            AsyncTimeout.access$setNext$p(node, null);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void access$scheduleTimeout(Companion $this, AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
            void var2_2;
            void var1_1;
            $this.scheduleTimeout((AsyncTimeout)var1_1, (long)var2_2, hasDeadline);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$cancelScheduledTimeout(Companion $this, AsyncTimeout node) {
            void var1_1;
            return $this.cancelScheduledTimeout((AsyncTimeout)var1_1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lokio/AsyncTimeout$Watchdog;", "Ljava/lang/Thread;", "()V", "run", "", "okio"})
    private static final class Watchdog
    extends Thread {
        public Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            while (true) {
                try {
                    while (true) {
                        void var1_1;
                        Lock lock = Companion.getLock();
                        lock.lock();
                        try {
                            AsyncTimeout timedOut = Companion.awaitTimeout$okio();
                            if (timedOut == head) {
                                head = null;
                                return;
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                        void v0 = var1_1;
                        if (v0 == null) continue;
                        v0.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

