/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "", "()V", "listRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "publicSuffixExceptionListBytes", "", "publicSuffixListBytes", "readCompleteLatch", "Ljava/util/concurrent/CountDownLatch;", "findMatchingRule", "", "", "domainLabels", "getEffectiveTldPlusOne", "domain", "readTheList", "", "readTheListUninterruptibly", "setListBytes", "splitDomain", "Companion", "okhttp"})
public final class PublicSuffixDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    @NotNull
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;
    @NotNull
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    @NotNull
    private static final byte[] WILDCARD_LABEL;
    @NotNull
    private static final List<String> PREVAILING_RULE;
    private static final char EXCEPTION_MARKER = '!';
    @NotNull
    private static final PublicSuffixDatabase instance;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getEffectiveTldPlusOne(@NotNull String domain) {
        void var2_3;
        void var1_1;
        void var3_4;
        Intrinsics.checkNotNullParameter(domain, "");
        String unicodeDomain = IDN.toUnicode(domain);
        Intrinsics.checkNotNullExpressionValue(unicodeDomain, "");
        List<String> domainLabels = this.splitDomain(unicodeDomain);
        List<String> rule = this.findMatchingRule(domainLabels);
        if (domainLabels.size() == rule.size() && rule.get(0).charAt(0) != '!') {
            return null;
        }
        int firstLabelOffset = rule.get(0).charAt(0) == '!' ? domainLabels.size() - rule.size() : domainLabels.size() - (var3_4.size() + 1);
        return SequencesKt.joinToString$default(SequencesKt.drop(CollectionsKt.asSequence((Iterable)this.splitDomain((String)var1_1)), (int)var2_3), ".", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitDomain(String domain) {
        void var1_1;
        CharSequence charSequence = (CharSequence)domain;
        char[] cArray = new char[1];
        domain = cArray;
        cArray[0] = 46;
        List domainLabels = StringsKt.split$default(charSequence, (char[])domain, false, 0, 6, null);
        if (Intrinsics.areEqual(CollectionsKt.last(domainLabels), "")) {
            return CollectionsKt.dropLast(domainLabels, 1);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findMatchingRule(List<String> domainLabels) {
        List wildcardRuleLabels;
        List exactRuleLabels;
        block28: {
            List list;
            block27: {
                void var3_6;
                char[] cArray;
                block26: {
                    List list2;
                    block25: {
                        void var2_4;
                        String rule;
                        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
                            this.readTheListUninterruptibly();
                        } else {
                            try {
                                this.readCompleteLatch.await();
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (!(this.publicSuffixListBytes != null)) {
                            String string = "Unable to load publicsuffixes.gz resource from the classpath.";
                            throw new IllegalStateException(string.toString());
                        }
                        int n2 = 0;
                        int n3 = domainLabels.size();
                        byte[][] byArrayArray = new byte[n3][];
                        while (n2 < n3) {
                            int n4 = n2++;
                            String string = domainLabels.get(n4);
                            Charset charset = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue(charset, "");
                            Intrinsics.checkNotNullExpressionValue(string.getBytes(charset), "");
                        }
                        byte[][] domainLabelsUtf8Bytes = byArrayArray;
                        String exactMatch = null;
                        int n5 = ((Object[])domainLabelsUtf8Bytes).length;
                        for (int i2 = 0; i2 < n5; ++i2) {
                            String rule2;
                            byte[] byArray = this.publicSuffixListBytes;
                            if (this.publicSuffixListBytes == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("");
                                byArray = null;
                            }
                            if ((rule2 = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, domainLabelsUtf8Bytes, i2)) == null) continue;
                            exactMatch = rule2;
                            break;
                        }
                        String wildcardMatch = null;
                        if (((Object[])domainLabelsUtf8Bytes).length > 1) {
                            byte[][] labelsWithWildcard = (byte[][])((Object[])domainLabelsUtf8Bytes).clone();
                            int n6 = ((Object[])labelsWithWildcard).length - 1;
                            for (int labelIndex = 0; labelIndex < n6; ++labelIndex) {
                                labelsWithWildcard[labelIndex] = WILDCARD_LABEL;
                                byte[] byArray = this.publicSuffixListBytes;
                                if (this.publicSuffixListBytes == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("");
                                    byArray = null;
                                }
                                if ((rule = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, labelsWithWildcard, labelIndex)) == null) continue;
                                wildcardMatch = rule;
                                break;
                            }
                        }
                        String exception = null;
                        if (wildcardMatch != null) {
                            int n7 = ((Object[])domainLabelsUtf8Bytes).length - 1;
                            for (int labelIndex = 0; labelIndex < n7; ++labelIndex) {
                                byte[] byArray = this.publicSuffixExceptionListBytes;
                                if (this.publicSuffixExceptionListBytes == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("");
                                    byArray = null;
                                }
                                if ((rule = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, domainLabelsUtf8Bytes, labelIndex)) == null) continue;
                                exception = rule;
                                break;
                            }
                        }
                        if (exception != null) {
                            String string = "!" + exception;
                            char[] cArray2 = new char[1];
                            char[] labelIndex = cArray2;
                            cArray2[0] = 46;
                            return StringsKt.split$default((CharSequence)string, labelIndex, false, 0, 6, null);
                        }
                        if (exactMatch == null && wildcardMatch == null) {
                            return PREVAILING_RULE;
                        }
                        list2 = var2_4;
                        if (list2 == null) break block25;
                        char[] cArray3 = new char[1];
                        cArray = cArray3;
                        cArray3[0] = 46;
                        if ((list2 = StringsKt.split$default((CharSequence)((Object)list2), cArray, false, 0, 6, null)) != null) break block26;
                    }
                    list2 = exactRuleLabels = CollectionsKt.emptyList();
                }
                if ((list = var3_6) == null) break block27;
                char[] cArray4 = new char[1];
                cArray = cArray4;
                cArray4[0] = 46;
                if ((list = StringsKt.split$default((CharSequence)((Object)list), cArray, false, 0, 6, null)) != null) break block28;
            }
            list = wildcardRuleLabels = CollectionsKt.emptyList();
        }
        if (exactRuleLabels.size() > wildcardRuleLabels.size()) {
            return exactRuleLabels;
        }
        return wildcardRuleLabels;
    }

    /*
     * WARNING - void declaration
     */
    private final void readTheListUninterruptibly() {
        boolean interrupted = false;
        while (true) {
            try {
                this.readTheList();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.interrupted();
                interrupted = true;
                continue;
            }
            catch (IOException e2) {
                void var2_2;
                Platform.Companion.get().log("Failed to read public suffix list", 5, (Throwable)var2_2);
                return;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readTheList() throws IOException {
        try {
            Object object;
            InputStream inputStream2;
            Ref.ObjectRef publicSuffixListBytes = new Ref.ObjectRef();
            Ref.ObjectRef publicSuffixExceptionListBytes = new Ref.ObjectRef();
            if (PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE) == null) {
                return;
            }
            InputStream resource = inputStream2;
            object = Okio.buffer(new GzipSource(Okio.source((InputStream)object)));
            Throwable throwable = null;
            try {
                BufferedSource bufferedSource = (BufferedSource)object;
                int totalBytes = bufferedSource.readInt();
                publicSuffixListBytes.element = bufferedSource.readByteArray(totalBytes);
                int totalExceptionBytes = bufferedSource.readInt();
                publicSuffixExceptionListBytes.element = bufferedSource.readByteArray(totalExceptionBytes);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                    throw throwable4;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            object = this;
            synchronized (object) {
                void var2_3;
                void var1_1;
                Object t2 = var1_1.element;
                Intrinsics.checkNotNull(t2);
                this.publicSuffixListBytes = (byte[])t2;
                Object t3 = var2_3.element;
                Intrinsics.checkNotNull(t3);
                this.publicSuffixExceptionListBytes = (byte[])t3;
            }
            return;
        }
        finally {
            this.readCompleteLatch.countDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setListBytes(@NotNull byte[] publicSuffixListBytes, @NotNull byte[] publicSuffixExceptionListBytes) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(publicSuffixListBytes, "");
        Intrinsics.checkNotNullParameter(publicSuffixExceptionListBytes, "");
        this.publicSuffixListBytes = var1_1;
        this.publicSuffixExceptionListBytes = var2_2;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }

    static {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = 42;
        WILDCARD_LABEL = byArray2;
        PREVAILING_RULE = CollectionsKt.listOf("*");
        instance = new PublicSuffixDatabase();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\fJ)\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase$Companion;", "", "()V", "EXCEPTION_MARKER", "", "PREVAILING_RULE", "", "", "PUBLIC_SUFFIX_RESOURCE", "WILDCARD_LABEL", "", "instance", "Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "get", "binarySearch", "labels", "", "labelIndex", "", "([B[[BI)Ljava/lang/String;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PublicSuffixDatabase get() {
            return instance;
        }

        /*
         * WARNING - void declaration
         */
        private final String binarySearch(byte[] $this$binarySearch, byte[][] labels, int labelIndex) {
            int low = 0;
            int high = $this$binarySearch.length;
            String match = null;
            while (low < high) {
                void var1_1;
                int compareResult;
                int mid;
                for (mid = (low + high) / 2; mid >= 0 && $this$binarySearch[mid] != 10; --mid) {
                }
                ++mid;
                int end = 1;
                while ($this$binarySearch[mid + end] != 10) {
                    ++end;
                }
                int publicSuffixLength = mid + end - mid;
                int currentLabelIndex = labelIndex;
                int currentLabelByteIndex = 0;
                int publicSuffixByteIndex = 0;
                boolean expectDot = false;
                while (true) {
                    int byte0;
                    if (expectDot) {
                        byte0 = 46;
                        expectDot = false;
                    } else {
                        byte0 = Util.and(labels[currentLabelIndex][currentLabelByteIndex], 255);
                    }
                    int byte1 = Util.and($this$binarySearch[mid + publicSuffixByteIndex], 255);
                    compareResult = byte0 - byte1;
                    if (compareResult != 0) break;
                    ++currentLabelByteIndex;
                    if (++publicSuffixByteIndex == publicSuffixLength) break;
                    if (labels[currentLabelIndex].length != currentLabelByteIndex) continue;
                    if (currentLabelIndex == ((Object[])labels).length - 1) break;
                    ++currentLabelIndex;
                    currentLabelByteIndex = -1;
                    expectDot = true;
                }
                if (compareResult < 0) {
                    high = mid - 1;
                    continue;
                }
                if (compareResult > 0) {
                    low = mid + end + 1;
                    continue;
                }
                int publicSuffixBytesLeft = publicSuffixLength - publicSuffixByteIndex;
                int labelBytesLeft = labels[currentLabelIndex].length - currentLabelByteIndex;
                int n2 = ((Object[])labels).length;
                for (int i2 = currentLabelIndex + 1; i2 < n2; ++i2) {
                    labelBytesLeft += labels[i2].length;
                }
                if (labelBytesLeft < publicSuffixBytesLeft) {
                    high = mid - 1;
                    continue;
                }
                if (labelBytesLeft > publicSuffixBytesLeft) {
                    low = mid + end + 1;
                    continue;
                }
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue(charset, "");
                Charset charset2 = charset;
                match = new String((byte[])var1_1, mid, publicSuffixLength, charset2);
                break;
            }
            return match;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ String access$binarySearch(Companion $this, byte[] $receiver, byte[][] labels, int labelIndex) {
            void var3_3;
            void var2_2;
            void var1_1;
            return $this.binarySearch((byte[])var1_1, (byte[][])var2_2, (int)var3_3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

