/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.android.AndroidLogHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokhttp3/internal/platform/android/AndroidLog;", "", "()V", "MAX_LOG_LENGTH", "", "configuredLoggers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljava/util/logging/Logger;", "knownLoggers", "", "", "androidLog", "", "loggerName", "logLevel", "message", "t", "", "androidLog$okhttp", "enable", "enableLogging", "logger", "tag", "loggerTag", "okhttp"})
@SuppressSignatureCheck
public final class AndroidLog {
    @NotNull
    public static final AndroidLog INSTANCE;
    private static final int MAX_LOG_LENGTH = 4000;
    @NotNull
    private static final CopyOnWriteArraySet<Logger> configuredLoggers;
    @NotNull
    private static final Map<String, String> knownLoggers;

    private AndroidLog() {
    }

    public final void androidLog$okhttp(@NotNull String loggerName, int logLevel, @NotNull String message, @Nullable Throwable t2) {
        Intrinsics.checkNotNullParameter(loggerName, "");
        Intrinsics.checkNotNullParameter(message, "");
        String tag = this.loggerTag(loggerName);
        if (Log.isLoggable((String)tag, (int)logLevel)) {
            String logMessage;
            if (t2 != null) {
                logMessage = logMessage + '\n' + Log.getStackTraceString((Throwable)t2);
            }
            int length = logMessage.length();
            for (int i2 = 0; i2 < length; ++i2) {
                int end;
                int newline = StringsKt.indexOf$default((CharSequence)logMessage, '\n', i2, false, 4, null);
                newline = newline != -1 ? newline : length;
                do {
                    end = Math.min(newline, i2 + 4000);
                    String string = logMessage.substring(i2, end);
                    Intrinsics.checkNotNullExpressionValue(string, "");
                    Log.println((int)logLevel, (String)tag, (String)string);
                } while ((i2 = end) < newline);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String loggerTag(String loggerName) {
        String string = knownLoggers.get(loggerName);
        if (string == null) {
            void var1_1;
            string = StringsKt.take((String)var1_1, 23);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void enable() {
        for (Map.Entry<String, String> entry : knownLoggers.entrySet()) {
            void var3_3;
            String logger = entry.getKey();
            String tag = entry.getValue();
            this.enableLogging((String)var3_3, (String)((Object)entry));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void enableLogging(String logger, String tag) {
        if (configuredLoggers.add((Logger)(logger = Logger.getLogger((String)logger)))) {
            void var1_1;
            void var2_2;
            ((Logger)logger).setUseParentHandlers(false);
            ((Logger)logger).setLevel(Log.isLoggable((String)tag, (int)3) ? Level.FINE : (Log.isLoggable((String)var2_2, (int)4) ? Level.INFO : Level.WARNING));
            var1_1.addHandler(AndroidLogHandler.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Map map;
        LinkedHashMap linkedHashMap;
        INSTANCE = new AndroidLog();
        configuredLoggers = new CopyOnWriteArraySet();
        LinkedHashMap $this$knownLoggers_u24lambda_u240 = linkedHashMap = new LinkedHashMap();
        Package package_ = OkHttpClient.class.getPackage();
        String packageName = package_ != null ? package_.getName() : null;
        if (packageName != null) {
            ((Map)$this$knownLoggers_u24lambda_u240).put(map, "OkHttp");
        }
        map = $this$knownLoggers_u24lambda_u240;
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "");
        String string2 = string;
        String string3 = "okhttp.OkHttpClient";
        map.put(string2, string3);
        map = $this$knownLoggers_u24lambda_u240;
        String string4 = Http2.class.getName();
        Intrinsics.checkNotNullExpressionValue(string4, "");
        string2 = string4;
        string3 = "okhttp.Http2";
        map.put(string2, string3);
        map = $this$knownLoggers_u24lambda_u240;
        String string5 = TaskRunner.class.getName();
        Intrinsics.checkNotNullExpressionValue(string5, "");
        string2 = string5;
        string3 = "okhttp.TaskRunner";
        map.put(string2, string3);
        ((Map)var1_1).put("okhttp3.mockwebserver.MockWebServer", "okhttp.MockWebServer");
        knownLoggers = MapsKt.toMap(linkedHashMap);
    }
}

