/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Protocol;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidCertificateChainCleaner;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import okhttp3.internal.platform.android.CloseGuard;
import okhttp3.internal.platform.android.ConscryptSocketAdapter;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import okhttp3.internal.platform.android.StandardAndroidSocketAdapter;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J-\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0011\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00160\u0006H\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00132\b\u0010&\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lokhttp3/internal/platform/AndroidPlatform;", "Lokhttp3/internal/platform/Platform;", "()V", "closeGuard", "Lokhttp3/internal/platform/android/CloseGuard;", "socketAdapters", "", "Lokhttp3/internal/platform/android/SocketAdapter;", "buildCertificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "buildTrustRootIndex", "Lokhttp3/internal/tls/TrustRootIndex;", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "", "protocols", "Lokhttp3/Protocol;", "Lkotlin/jvm/JvmSuppressWildcards;", "connectSocket", "socket", "Ljava/net/Socket;", "address", "Ljava/net/InetSocketAddress;", "connectTimeout", "", "getSelectedProtocol", "getStackTraceForCloseable", "", "closer", "isCleartextTrafficPermitted", "", "logCloseableLeak", "message", "stackTrace", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "Companion", "CustomTrustRootIndex", "okhttp"})
@SuppressSignatureCheck
@SourceDebugExtension(value={"SMAP\nAndroidPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPlatform.kt\nokhttp3/internal/platform/AndroidPlatform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n766#2:164\n857#2,2:165\n1#3:167\n*S KotlinDebug\n*F\n+ 1 AndroidPlatform.kt\nokhttp3/internal/platform/AndroidPlatform\n*L\n52#1:164\n52#1:165,2\n*E\n"})
public final class AndroidPlatform
extends Platform {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<SocketAdapter> socketAdapters;
    @NotNull
    private final CloseGuard closeGuard;
    private static final boolean isSupported;

    /*
     * WARNING - void declaration
     */
    public AndroidPlatform() {
        void var2_3;
        SocketAdapter[] socketAdapterArray = new SocketAdapter[4];
        Object object = socketAdapterArray;
        socketAdapterArray[0] = StandardAndroidSocketAdapter.Companion.buildIfSupported$default(StandardAndroidSocketAdapter.Companion, null, 1, null);
        object[1] = new DeferredSocketAdapter(AndroidSocketAdapter.Companion.getPlayProviderFactory());
        object[2] = new DeferredSocketAdapter(ConscryptSocketAdapter.Companion.getFactory());
        object[3] = new DeferredSocketAdapter(BouncyCastleSocketAdapter.Companion.getFactory());
        object = CollectionsKt.listOfNotNull(object);
        AndroidPlatform androidPlatform = this;
        Collection destination$iv$iv = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_4;
            Object element$iv$iv = object.next();
            SocketAdapter socketAdapter = (SocketAdapter)element$iv$iv;
            if (!socketAdapter.isSupported()) continue;
            destination$iv$iv.add(var3_4);
        }
        androidPlatform.socketAdapters = (List)var2_3;
        this.closeGuard = CloseGuard.Companion.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void connectSocket(@NotNull Socket socket, @NotNull InetSocketAddress address, int connectTimeout) throws IOException {
        Intrinsics.checkNotNullParameter(socket, "");
        Intrinsics.checkNotNullParameter(address, "");
        try {
            void var3_4;
            void var2_3;
            socket.connect((SocketAddress)var2_3, (int)var3_4);
            return;
        }
        catch (ClassCastException e2) {
            void var1_2;
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", e2);
            }
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Object v0;
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter(sslSocketFactory, "");
            object = this.socketAdapters;
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                SocketAdapter socketAdapter = (SocketAdapter)e2;
                if (!socketAdapter.matchesSocketFactory(sslSocketFactory)) continue;
                v0 = e2;
                break block2;
            }
            v0 = null;
        }
        object = v0;
        if (object != null) {
            void var1_1;
            return object.trustManager((SSLSocketFactory)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<Protocol> protocols) {
        Object v0;
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter(sslSocket, "");
            Intrinsics.checkNotNullParameter(protocols, "");
            object = this.socketAdapters;
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                SocketAdapter socketAdapter = (SocketAdapter)e2;
                if (!socketAdapter.matchesSocket(sslSocket)) continue;
                v0 = e2;
                break block2;
            }
            v0 = null;
        }
        object = v0;
        if (object != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            object.configureTlsExtensions((SSLSocket)var1_1, (String)var2_2, (List<? extends Protocol>)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(sslSocket, "");
            Object object = this.socketAdapters;
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                SocketAdapter socketAdapter = (SocketAdapter)e2;
                if (!socketAdapter.matchesSocket(sslSocket)) continue;
                v0 = e2;
                break block2;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        if (socketAdapter != null) {
            void var1_1;
            return socketAdapter.getSelectedProtocol((SSLSocket)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final Object getStackTraceForCloseable(@NotNull String closer) {
        void var1_1;
        Intrinsics.checkNotNullParameter(closer, "");
        return this.closeGuard.createAndOpen((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void logCloseableLeak(@NotNull String message, @Nullable Object stackTrace) {
        void var2_2;
        Intrinsics.checkNotNullParameter(message, "");
        boolean bl = this.closeGuard.warnIfOpen(var2_2);
        if (!bl) {
            void var1_1;
            Platform.log$default(this, (String)var1_1, 5, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isCleartextTrafficPermitted(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter(hostname, "");
        if (Build.VERSION.SDK_INT >= 24) {
            void var1_1;
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted((String)var1_1);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final CertificateChainCleaner buildCertificateChainCleaner(@NotNull X509TrustManager trustManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter(trustManager, "");
        AndroidCertificateChainCleaner androidCertificateChainCleaner = AndroidCertificateChainCleaner.Companion.buildIfSupported(trustManager);
        if (androidCertificateChainCleaner != null) {
            return androidCertificateChainCleaner;
        }
        return super.buildCertificateChainCleaner((X509TrustManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TrustRootIndex buildTrustRootIndex(@NotNull X509TrustManager trustManager) {
        Object object;
        Intrinsics.checkNotNullParameter(trustManager, "");
        try {
            Class[] classArray = new Class[1];
            object = classArray;
            classArray[0] = X509Certificate.class;
            Method method = trustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", (Class<?>)object);
            method.setAccessible(true);
            Intrinsics.checkNotNullExpressionValue(method, "");
            object = new CustomTrustRootIndex(trustManager, (Method)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var1_1;
            object = super.buildTrustRootIndex((X509TrustManager)var1_1);
        }
        return object;
    }

    static {
        boolean bl;
        Companion = new Companion(null);
        if (!Platform.Companion.isAndroid()) {
            bl = false;
        } else if (Build.VERSION.SDK_INT >= 30) {
            bl = false;
        } else {
            if (!(Build.VERSION.SDK_INT >= 21)) {
                String string = "Expected Android API level 21+ but was " + Build.VERSION.SDK_INT;
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        isSupported = bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\b"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$Companion;", "", "()V", "isSupported", "", "()Z", "buildIfSupported", "Lokhttp3/internal/platform/Platform;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupported() {
            return isSupported;
        }

        @Nullable
        public final Platform buildIfSupported() {
            if (this.isSupported()) {
                return new AndroidPlatform();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$CustomTrustRootIndex;", "Lokhttp3/internal/tls/TrustRootIndex;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "findByIssuerAndSignatureMethod", "Ljava/lang/reflect/Method;", "(Ljavax/net/ssl/X509TrustManager;Ljava/lang/reflect/Method;)V", "component1", "component2", "copy", "equals", "", "other", "", "findByIssuerAndSignature", "Ljava/security/cert/X509Certificate;", "cert", "hashCode", "", "toString", "", "okhttp"})
    public static final class CustomTrustRootIndex
    implements TrustRootIndex {
        @NotNull
        private final X509TrustManager trustManager;
        @NotNull
        private final Method findByIssuerAndSignatureMethod;

        /*
         * WARNING - void declaration
         */
        public CustomTrustRootIndex(@NotNull X509TrustManager trustManager, @NotNull Method findByIssuerAndSignatureMethod) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(trustManager, "");
            Intrinsics.checkNotNullParameter(findByIssuerAndSignatureMethod, "");
            this.trustManager = var1_1;
            this.findByIssuerAndSignatureMethod = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public final X509Certificate findByIssuerAndSignature(@NotNull X509Certificate cert) {
            X509Certificate x509Certificate;
            Intrinsics.checkNotNullParameter(cert, "");
            try {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = cert;
                Object object = this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, objectArray2);
                Intrinsics.checkNotNull(object);
                cert = (TrustAnchor)object;
                cert = ((TrustAnchor)cert).getTrustedCert();
            }
            catch (IllegalAccessException e2) {
                void var1_2;
                throw new AssertionError("unable to get issues and signature", (Throwable)var1_2);
            }
            catch (InvocationTargetException invocationTargetException) {
                x509Certificate = null;
            }
            return x509Certificate;
        }

        private final X509TrustManager component1() {
            return this.trustManager;
        }

        private final Method component2() {
            return this.findByIssuerAndSignatureMethod;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CustomTrustRootIndex copy(@NotNull X509TrustManager trustManager, @NotNull Method findByIssuerAndSignatureMethod) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(trustManager, "");
            Intrinsics.checkNotNullParameter(findByIssuerAndSignatureMethod, "");
            return new CustomTrustRootIndex((X509TrustManager)var1_1, (Method)var2_2);
        }

        public static /* synthetic */ CustomTrustRootIndex copy$default(CustomTrustRootIndex customTrustRootIndex, X509TrustManager x509TrustManager, Method method, int n2, Object object) {
            if ((n2 & 1) != 0) {
                x509TrustManager = customTrustRootIndex.trustManager;
            }
            if ((n2 & 2) != 0) {
                method = customTrustRootIndex.findByIssuerAndSignatureMethod;
            }
            return customTrustRootIndex.copy(x509TrustManager, method);
        }

        @NotNull
        public final String toString() {
            return "CustomTrustRootIndex(trustManager=" + this.trustManager + ", findByIssuerAndSignatureMethod=" + this.findByIssuerAndSignatureMethod + ')';
        }

        public final int hashCode() {
            int n2 = this.trustManager.hashCode();
            n2 = n2 * 31 + this.findByIssuerAndSignatureMethod.hashCode();
            return n2;
        }

        public final boolean equals(@Nullable Object other) {
            CustomTrustRootIndex customTrustRootIndex;
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomTrustRootIndex)) {
                return false;
            }
            customTrustRootIndex = customTrustRootIndex;
            if (!Intrinsics.areEqual(this.trustManager, customTrustRootIndex.trustManager)) {
                return false;
            }
            return Intrinsics.areEqual(this.findByIssuerAndSignatureMethod, customTrustRootIndex.findByIssuerAndSignatureMethod);
        }
    }
}

