/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http1.HeadersReader;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 ?2\u00020\u0001:\u0007<=>?@ABB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\b\u0010'\u001a\u00020\u001eH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020)H\u0002J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\u0019H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u0010H\u0016J\u0010\u00105\u001a\u00020!2\u0006\u00101\u001a\u00020\u0019H\u0016J\u000e\u00106\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u0019J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u001a\u00a8\u0006C"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec;", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "connection", "Lokhttp3/internal/connection/RealConnection;", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/connection/RealConnection;Lokio/BufferedSource;Lokio/BufferedSink;)V", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "headersReader", "Lokhttp3/internal/http1/HeadersReader;", "isClosed", "", "()Z", "state", "", "trailers", "Lokhttp3/Headers;", "isChunked", "Lokhttp3/Request;", "(Lokhttp3/Request;)Z", "Lokhttp3/Response;", "(Lokhttp3/Response;)Z", "cancel", "", "createRequestBody", "Lokio/Sink;", "request", "contentLength", "", "detachTimeout", "timeout", "Lokio/ForwardingTimeout;", "finishRequest", "flushRequest", "newChunkedSink", "newChunkedSource", "Lokio/Source;", "url", "Lokhttp3/HttpUrl;", "newFixedLengthSource", "length", "newKnownLengthSink", "newUnknownLengthSource", "openResponseBodySource", "response", "readResponseHeaders", "Lokhttp3/Response$Builder;", "expectContinue", "reportedContentLength", "skipConnectBody", "writeRequest", "headers", "requestLine", "", "writeRequestHeaders", "AbstractSource", "ChunkedSink", "ChunkedSource", "Companion", "FixedLengthSource", "KnownLengthSink", "UnknownLengthSource", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
public final class Http1ExchangeCodec
implements ExchangeCodec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final OkHttpClient client;
    @NotNull
    private final RealConnection connection;
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final BufferedSink sink;
    private int state;
    @NotNull
    private final HeadersReader headersReader;
    @Nullable
    private Headers trailers;
    private static final long NO_CHUNK_YET = -1L;
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;

    /*
     * WARNING - void declaration
     */
    public Http1ExchangeCodec(@Nullable OkHttpClient client, @NotNull RealConnection connection, @NotNull BufferedSource source2, @NotNull BufferedSink sink2) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(connection, "");
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(sink2, "");
        this.client = var1_1;
        this.connection = var2_2;
        this.source = var3_3;
        this.sink = sink2;
        this.headersReader = new HeadersReader(this.source);
    }

    @Override
    @NotNull
    public final RealConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isChunked(Response $this$isChunked) {
        void var1_1;
        return StringsKt.equals("chunked", Response.header$default((Response)var1_1, "Transfer-Encoding", null, 2, null), true);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isChunked(Request $this$isChunked) {
        void var1_1;
        return StringsKt.equals("chunked", var1_1.header("Transfer-Encoding"), true);
    }

    public final boolean isClosed() {
        return this.state == 6;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Sink createRequestBody(@NotNull Request request, long contentLength) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(request, "");
        if (request.body() != null && request.body().isDuplex()) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if (this.isChunked((Request)var1_1)) {
            return this.newChunkedSink();
        }
        if (var2_2 != -1L) {
            return this.newKnownLengthSink();
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public final void cancel() {
        this.getConnection().cancel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeRequestHeaders(@NotNull Request request) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(request, "");
        Proxy.Type type = this.getConnection().route().proxy().type();
        Intrinsics.checkNotNullExpressionValue((Object)type, "");
        String requestLine = RequestLine.INSTANCE.get(request, type);
        this.writeRequest(var1_1.headers(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long reportedContentLength(@NotNull Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter(response, "");
        if (!HttpHeaders.promisesBody(response)) {
            return 0L;
        }
        if (this.isChunked(response)) {
            return -1L;
        }
        return Util.headersContentLength((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Source openResponseBodySource(@NotNull Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter(response, "");
        if (!HttpHeaders.promisesBody(response)) {
            return this.newFixedLengthSource(0L);
        }
        if (this.isChunked(response)) {
            return this.newChunkedSource(response.request().url());
        }
        long contentLength = Util.headersContentLength((Response)var1_1);
        if (contentLength != -1L) {
            void var2_2;
            return this.newFixedLengthSource((long)var2_2);
        }
        return this.newUnknownLengthSource();
    }

    @Override
    @NotNull
    public final Headers trailers() {
        if (!(this.state == 6)) {
            String string = "too early; can't read the trailers yet";
            throw new IllegalStateException(string.toString());
        }
        Headers headers = this.trailers;
        if (headers == null) {
            headers = Util.EMPTY_HEADERS;
        }
        return headers;
    }

    @Override
    public final void flushRequest() {
        this.sink.flush();
    }

    @Override
    public final void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(@NotNull Headers headers, @NotNull String requestLine) {
        Intrinsics.checkNotNullParameter(headers, "");
        Intrinsics.checkNotNullParameter(requestLine, "");
        if (!(this.state == 0)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.sink.writeUtf8(requestLine).writeUtf8("\r\n");
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sink.writeUtf8(headers.name(i2)).writeUtf8(": ").writeUtf8(headers.value(i2)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final Response.Builder readResponseHeaders(boolean expectContinue) {
        if (!(this.state == 1 || this.state == 2 || this.state == 3)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        try {
            int n2;
            StatusLine statusLine = StatusLine.Companion.parse(this.headersReader.readLine());
            Response.Builder responseBuilder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.headersReader.readHeaders());
            if (n2 != 0 && statusLine.code == 100) {
                return null;
            }
            if (statusLine.code == 100) {
                this.state = 3;
                return responseBuilder;
            }
            n2 = statusLine.code;
            boolean bl = 102 <= n2 ? n2 < 200 : false;
            if (bl) {
                this.state = 3;
                return responseBuilder;
            }
            this.state = 4;
            return responseBuilder;
        }
        catch (EOFException e2) {
            void var2_6;
            void var3_4;
            String address = this.getConnection().route().address().url().redact();
            throw new IOException("unexpected end of stream on " + (String)var3_4, (Throwable)var2_6);
        }
    }

    private final Sink newChunkedSink() {
        if (!(this.state == 1)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new ChunkedSink(this);
    }

    private final Sink newKnownLengthSink() {
        if (!(this.state == 1)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new KnownLengthSink(this);
    }

    /*
     * WARNING - void declaration
     */
    private final Source newFixedLengthSource(long length2) {
        void var1_1;
        if (!(this.state == 4)) {
            String length2 = "state: " + this.state;
            throw new IllegalStateException(length2.toString());
        }
        this.state = 5;
        return new FixedLengthSource((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final Source newChunkedSource(HttpUrl url) {
        void var1_1;
        if (!(this.state == 4)) {
            url = "state: " + this.state;
            throw new IllegalStateException(url.toString());
        }
        this.state = 5;
        return new ChunkedSource((HttpUrl)var1_1);
    }

    private final Source newUnknownLengthSource() {
        if (!(this.state == 4)) {
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        this.getConnection().noNewExchanges$okhttp();
        return new UnknownLengthSource();
    }

    /*
     * WARNING - void declaration
     */
    private final void detachTimeout(ForwardingTimeout timeout2) {
        void var2_2;
        void var1_1;
        Timeout oldDelegate = timeout2.delegate();
        var1_1.setDelegate(Timeout.NONE);
        oldDelegate.clearDeadline();
        var2_2.clearTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public final void skipConnectBody(@NotNull Response response) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(response, "");
        long contentLength = Util.headersContentLength(response);
        if (contentLength == -1L) {
            return;
        }
        Source body = this.newFixedLengthSource((long)var2_2);
        Util.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$detachTimeout(Http1ExchangeCodec $this, ForwardingTimeout timeout2) {
        void var1_1;
        $this.detachTimeout((ForwardingTimeout)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setState$p(Http1ExchangeCodec $this, int n2) {
        void var1_1;
        $this.state = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTrailers$p(Http1ExchangeCodec $this, Headers headers) {
        void var1_1;
        $this.trailers = var1_1;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\t\u001a\u00020\u0014H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokio/Source;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "timeout", "Lokio/ForwardingTimeout;", "getTimeout", "()Lokio/ForwardingTimeout;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "responseBodyComplete", "", "Lokio/Timeout;", "okhttp"})
    private abstract class AbstractSource
    implements Source {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;
        final /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public AbstractSource(Http1ExchangeCodec this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.source.timeout());
        }

        @NotNull
        protected final ForwardingTimeout getTimeout() {
            return this.timeout;
        }

        protected final boolean getClosed() {
            return this.closed;
        }

        /*
         * WARNING - void declaration
         */
        protected final void setClosed(boolean bl) {
            void var1_1;
            this.closed = var1_1;
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            long l2;
            Intrinsics.checkNotNullParameter(sink2, "");
            try {
                void var2_3;
                l2 = this.this$0.source.read(sink2, (long)var2_3);
            }
            catch (IOException e2) {
                void var1_2;
                this.this$0.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
                throw var1_2;
            }
            return l2;
        }

        public final void responseBodyComplete() {
            if (this.this$0.state == 6) {
                return;
            }
            if (this.this$0.state != 5) {
                throw new IllegalStateException("state: " + this.this$0.state);
            }
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 6);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0005\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink;", "Lokio/Sink;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "timeout", "Lokio/ForwardingTimeout;", "close", "", "flush", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class ChunkedSink
    implements Sink {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;
        final /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public ChunkedSink(Http1ExchangeCodec this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.sink.timeout());
        }

        @Override
        @NotNull
        public final Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(@NotNull Buffer source2, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            if (!(!this.closed)) {
                source2 = "closed";
                throw new IllegalStateException(source2.toString());
            }
            if (byteCount == 0L) {
                return;
            }
            this.this$0.sink.writeHexadecimalUnsignedLong(byteCount);
            this.this$0.sink.writeUtf8("\r\n");
            this.this$0.sink.write((Buffer)var1_1, (long)var2_2);
            this.this$0.sink.writeUtf8("\r\n");
        }

        @Override
        public final synchronized void flush() {
            if (this.closed) {
                return;
            }
            this.this$0.sink.flush();
        }

        @Override
        public final synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.this$0.sink.writeUtf8("0\r\n\r\n");
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 3);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "url", "Lokhttp3/HttpUrl;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;Lokhttp3/HttpUrl;)V", "bytesRemainingInChunk", "", "hasMoreChunks", "", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "readChunkSize", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class ChunkedSource
    extends AbstractSource {
        @NotNull
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        /*
         * WARNING - void declaration
         */
        public ChunkedSource(HttpUrl url) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(url, "");
            super((Http1ExchangeCodec)var1_1);
            this.url = var2_2;
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(@NotNull Buffer sink2, long byteCount) {
            void var2_2;
            long read;
            Intrinsics.checkNotNullParameter(sink2, "");
            if (!(byteCount >= 0L)) {
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((read = super.read(sink2, Math.min((long)var2_2, this.bytesRemainingInChunk))) == -1L) {
                void var1_1;
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                ProtocolException e2 = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw var1_1;
            }
            this.bytesRemainingInChunk -= read;
            return read;
        }

        /*
         * WARNING - void declaration
         */
        private final void readChunkSize() {
            if (this.bytesRemainingInChunk != -1L) {
                Http1ExchangeCodec.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1ExchangeCodec.this.source.readHexadecimalUnsignedLong();
                String extensions = ((Object)StringsKt.trim((CharSequence)Http1ExchangeCodec.this.source.readUtf8LineStrict())).toString();
                if (this.bytesRemainingInChunk < 0L || ((CharSequence)extensions).length() > 0 && !StringsKt.startsWith$default(extensions, ";", false, 2, null)) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + extensions + '\"');
                }
            }
            catch (NumberFormatException e2) {
                void var1_2;
                throw new ProtocolException(var1_2.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                Http1ExchangeCodec.access$setTrailers$p(Http1ExchangeCodec.this, Http1ExchangeCodec.this.headersReader.readHeaders());
                OkHttpClient okHttpClient = Http1ExchangeCodec.this.client;
                Intrinsics.checkNotNull(okHttpClient);
                CookieJar cookieJar = okHttpClient.cookieJar();
                Headers headers = Http1ExchangeCodec.this.trailers;
                Intrinsics.checkNotNull(headers);
                HttpHeaders.receiveHeaders(cookieJar, this.url, headers);
                this.responseBodyComplete();
            }
        }

        @Override
        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$Companion;", "", "()V", "NO_CHUNK_YET", "", "STATE_CLOSED", "", "STATE_IDLE", "STATE_OPEN_REQUEST_BODY", "STATE_OPEN_RESPONSE_BODY", "STATE_READING_RESPONSE_BODY", "STATE_READ_RESPONSE_HEADERS", "STATE_WRITING_REQUEST_BODY", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "bytesRemaining", "", "(Lokhttp3/internal/http1/Http1ExchangeCodec;J)V", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        /*
         * WARNING - void declaration
         */
        public FixedLengthSource(long bytesRemaining) {
            void var2_2;
            void var1_1;
            super((Http1ExchangeCodec)var1_1);
            this.bytesRemaining = var2_2;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(@NotNull Buffer sink2, long byteCount) {
            void var2_2;
            Intrinsics.checkNotNullParameter(sink2, "");
            if (!(byteCount >= 0L)) {
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long read = super.read(sink2, Math.min(this.bytesRemaining, (long)var2_2));
            if (read == -1L) {
                void var1_1;
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                ProtocolException e2 = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw var1_1;
            }
            this.bytesRemaining -= read;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
            return read;
        }

        @Override
        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0005\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink;", "Lokio/Sink;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "timeout", "Lokio/ForwardingTimeout;", "close", "", "flush", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class KnownLengthSink
    implements Sink {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;
        final /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public KnownLengthSink(Http1ExchangeCodec this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.sink.timeout());
        }

        @Override
        @NotNull
        public final Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(@NotNull Buffer source2, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            if (!(!this.closed)) {
                source2 = "closed";
                throw new IllegalStateException(source2.toString());
            }
            Util.checkOffsetAndCount(((Buffer)source2).size(), 0L, byteCount);
            this.this$0.sink.write((Buffer)var1_1, (long)var2_2);
        }

        @Override
        public final void flush() {
            if (this.closed) {
                return;
            }
            this.this$0.sink.flush();
        }

        @Override
        public final void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 3);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "inputExhausted", "", "close", "", "read", "", "sink", "Lokio/Buffer;", "byteCount", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        /*
         * WARNING - void declaration
         */
        public UnknownLengthSource() {
            void var1_1;
            super((Http1ExchangeCodec)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(@NotNull Buffer sink2, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(sink2, "");
            if (!(byteCount >= 0L)) {
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long read = super.read((Buffer)var1_1, (long)var2_2);
            if (read == -1L) {
                this.inputExhausted = true;
                this.responseBodyComplete();
                return -1L;
            }
            return read;
        }

        @Override
        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }
}

