/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.WasExperimental;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;
import kotlin.time.ExperimentalTime;
import kotlin.time.LongSaturatedMathKt;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lkotlin/time/AbstractLongTimeSource;", "Lkotlin/time/TimeSource$WithComparableMarks;", "unit", "Lkotlin/time/DurationUnit;", "(Lkotlin/time/DurationUnit;)V", "getUnit", "()Lkotlin/time/DurationUnit;", "zero", "", "getZero", "()J", "zero$delegate", "Lkotlin/Lazy;", "adjustedRead", "markNow", "Lkotlin/time/ComparableTimeMark;", "read", "LongTimeMark", "kotlin-stdlib"})
@SinceKotlin(version="1.9")
@WasExperimental(markerClass={ExperimentalTime.class})
public abstract class AbstractLongTimeSource
implements TimeSource.WithComparableMarks {
    @NotNull
    private final DurationUnit unit;
    @NotNull
    private final Lazy zero$delegate;

    /*
     * WARNING - void declaration
     */
    public AbstractLongTimeSource(@NotNull DurationUnit unit) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)unit, "");
        this.unit = var1_1;
        this.zero$delegate = LazyKt.lazy((Function0)new Function0<Long>(this){
            final /* synthetic */ AbstractLongTimeSource this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.read();
            }
        });
    }

    @NotNull
    protected final DurationUnit getUnit() {
        return this.unit;
    }

    protected abstract long read();

    private final long getZero() {
        Lazy lazy = this.zero$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    private final long adjustedRead() {
        return this.read() - this.getZero();
    }

    @Override
    @NotNull
    public ComparableTimeMark markNow() {
        return new LongTimeMark(this.adjustedRead(), this, Duration.Companion.getZERO-UwyO8pc(), null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\n\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001b\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0001H\u0096\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0013\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lkotlin/time/AbstractLongTimeSource$LongTimeMark;", "Lkotlin/time/ComparableTimeMark;", "startedAt", "", "timeSource", "Lkotlin/time/AbstractLongTimeSource;", "offset", "Lkotlin/time/Duration;", "(JLkotlin/time/AbstractLongTimeSource;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "elapsedNow", "elapsedNow-UwyO8pc", "()J", "equals", "", "other", "", "hashCode", "", "minus", "minus-UwyO8pc", "(Lkotlin/time/ComparableTimeMark;)J", "plus", "duration", "plus-LRDsOJo", "(J)Lkotlin/time/ComparableTimeMark;", "toString", "", "kotlin-stdlib"})
    @SourceDebugExtension(value={"SMAP\nTimeSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeSources.kt\nkotlin/time/AbstractLongTimeSource$LongTimeMark\n+ 2 longSaturatedMath.kt\nkotlin/time/LongSaturatedMathKt\n*L\n1#1,199:1\n80#2:200\n*S KotlinDebug\n*F\n+ 1 TimeSources.kt\nkotlin/time/AbstractLongTimeSource$LongTimeMark\n*L\n67#1:200\n*E\n"})
    private static final class LongTimeMark
    implements ComparableTimeMark {
        private final long startedAt;
        @NotNull
        private final AbstractLongTimeSource timeSource;
        private final long offset;

        /*
         * WARNING - void declaration
         */
        private LongTimeMark(long startedAt, AbstractLongTimeSource timeSource, long offset) {
            void var3_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(timeSource, "");
            this.startedAt = var1_1;
            this.timeSource = var3_2;
            this.offset = offset;
        }

        @Override
        public final long elapsedNow-UwyO8pc() {
            return Duration.minus-LRDsOJo(LongSaturatedMathKt.saturatingOriginsDiff(this.timeSource.adjustedRead(), this.startedAt, this.timeSource.getUnit()), this.offset);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public final ComparableTimeMark plus-LRDsOJo(long duration) {
            long newValue;
            void var1_1;
            DurationUnit unit = this.timeSource.getUnit();
            if (Duration.isInfinite-impl(duration)) {
                long newValue2 = LongSaturatedMathKt.saturatingAdd-NuflL3o(this.startedAt, unit, duration);
                return new LongTimeMark(newValue2, this.timeSource, Duration.Companion.getZERO-UwyO8pc(), null);
            }
            long durationInUnit = Duration.truncateTo-UwyO8pc$kotlin_stdlib(duration, unit);
            long rest = Duration.plus-LRDsOJo(Duration.minus-LRDsOJo((long)var1_1, durationInUnit), this.offset);
            long sum = LongSaturatedMathKt.saturatingAdd-NuflL3o(this.startedAt, unit, durationInUnit);
            long restInUnit = Duration.truncateTo-UwyO8pc$kotlin_stdlib(rest, unit);
            sum = LongSaturatedMathKt.saturatingAdd-NuflL3o(sum, unit, restInUnit);
            long restUnderUnit = Duration.minus-LRDsOJo(rest, restInUnit);
            long restUnderUnitNs = Duration.getInWholeNanoseconds-impl(restUnderUnit);
            if (sum != 0L && restUnderUnitNs != 0L && (sum ^ restUnderUnitNs) < 0L) {
                void var3_2;
                long correction = DurationKt.toDuration(MathKt.getSign(restUnderUnitNs), unit);
                sum = LongSaturatedMathKt.saturatingAdd-NuflL3o(sum, (DurationUnit)var3_2, correction);
                restUnderUnit = Duration.minus-LRDsOJo(restUnderUnit, correction);
            }
            long l2 = newValue = sum;
            long newOffset = (newValue - 1L | 1L) == Long.MAX_VALUE ? Duration.Companion.getZERO-UwyO8pc() : restUnderUnit;
            return new LongTimeMark(newValue, this.timeSource, newOffset, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long minus-UwyO8pc(@NotNull ComparableTimeMark other) {
            void var1_1;
            Intrinsics.checkNotNullParameter(other, "");
            if (!(other instanceof LongTimeMark) || !Intrinsics.areEqual(this.timeSource, ((LongTimeMark)other).timeSource)) {
                throw new IllegalArgumentException("Subtracting or comparing time marks from different time sources is not possible: " + this + " and " + other);
            }
            long l2 = LongSaturatedMathKt.saturatingOriginsDiff(this.startedAt, ((LongTimeMark)other).startedAt, this.timeSource.getUnit());
            return Duration.plus-LRDsOJo(l2, Duration.minus-LRDsOJo(this.offset, ((LongTimeMark)var1_1).offset));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object other) {
            void var1_1;
            return other instanceof LongTimeMark && Intrinsics.areEqual(this.timeSource, ((LongTimeMark)other).timeSource) && Duration.equals-impl0(this.minus-UwyO8pc((ComparableTimeMark)var1_1), Duration.Companion.getZERO-UwyO8pc());
        }

        @Override
        public final int hashCode() {
            return Duration.hashCode-impl(this.offset) * 37 + Long.hashCode(this.startedAt);
        }

        @NotNull
        public final String toString() {
            return "LongTimeMark(" + this.startedAt + DurationUnitKt.shortName(this.timeSource.getUnit()) + " + " + Duration.toString-impl(this.offset) + ", " + this.timeSource + ')';
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public final ComparableTimeMark minus-LRDsOJo(long duration) {
            void var1_1;
            return ComparableTimeMark.DefaultImpls.minus-LRDsOJo(this, (long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compareTo(@NotNull ComparableTimeMark other) {
            void var1_1;
            return ComparableTimeMark.DefaultImpls.compareTo(this, (ComparableTimeMark)var1_1);
        }

        @Override
        public final boolean hasPassedNow() {
            return ComparableTimeMark.DefaultImpls.hasPassedNow(this);
        }

        @Override
        public final boolean hasNotPassedNow() {
            return ComparableTimeMark.DefaultImpls.hasNotPassedNow(this);
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ LongTimeMark(long startedAt, AbstractLongTimeSource timeSource, long offset, DefaultConstructorMarker $constructor_marker) {
            this((long)var1_1, (AbstractLongTimeSource)var3_2, offset);
            void var3_2;
            void var1_1;
        }
    }
}

