/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.Arrays;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.ULong;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0004\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a@\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0000\u001a@\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0000\u001a \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u001a,\u0010\u0016\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a,\u0010\u001b\u001a\u00020\u001c*\u00020\u00032\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u001c\u0010!\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002\u001a\u0014\u0010\"\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\tH\u0002\u001a*\u0010#\u001a\u00020$*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010#\u001a\u00020$*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010'\u001a\u00020(*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010'\u001a\u00020(*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010)\u001a\u00020\t*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010)\u001a\u00020\t*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010*\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010*\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a0\u0010+\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\tH\u0003\u001a*\u0010,\u001a\u00020-*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010,\u001a\u00020-*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010.\u001a\u00020\u0003*\u00020(2\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020(2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020\u00062\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020-2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u001c\u0010/\u001a\u00020\u0003*\u00020\u00062\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u00020\tH\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"HEX_DIGITS_TO_DECIMAL", "", "LOWER_CASE_HEX_DIGITS", "", "UPPER_CASE_HEX_DIGITS", "charsPerSet", "", "charsPerElement", "elementsPerSet", "", "elementSeparatorLength", "formattedStringLength", "totalBytes", "bytesPerLine", "bytesPerGroup", "groupSeparatorLength", "byteSeparatorLength", "bytePrefixLength", "byteSuffixLength", "parsedByteArrayMaxSize", "stringLength", "wholeElementsPerSet", "checkContainsAt", "part", "index", "endIndex", "partName", "checkHexLength", "", "startIndex", "maxDigits", "requireMaxLength", "", "checkNewLineAt", "decimalFromHexDigitAt", "hexToByte", "", "format", "Lkotlin/text/HexFormat;", "hexToByteArray", "", "hexToInt", "hexToLong", "hexToLongImpl", "hexToShort", "", "toHexString", "toHexStringImpl", "bits", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nHexExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexExtensions.kt\nkotlin/text/HexExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,591:1\n1#2:592\n1183#3,3:593\n1183#3,3:596\n*S KotlinDebug\n*F\n+ 1 HexExtensions.kt\nkotlin/text/HexExtensionsKt\n*L\n13#1:593,3\n14#1:596,3\n*E\n"})
public final class HexExtensionsKt {
    @NotNull
    private static final String LOWER_CASE_HEX_DIGITS = "0123456789abcdef";
    @NotNull
    private static final String UPPER_CASE_HEX_DIGITS = "0123456789ABCDEF";
    @NotNull
    private static final int[] HEX_DIGITS_TO_DECIMAL;

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString, @NotNull HexFormat format) {
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$toHexString, "");
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.toHexString($this$toHexString, 0, byArray.length, (HexFormat)var1_1);
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(byArray, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString, int startIndex, int endIndex, @NotNull HexFormat format) {
        void i2;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$toHexString, "");
        Intrinsics.checkNotNullParameter(format, "");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$toHexString.length);
        if (startIndex == endIndex) {
            return "";
        }
        String digits = format.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        HexFormat.BytesHexFormat bytesFormat = format.getBytes();
        int bytesPerLine = bytesFormat.getBytesPerLine();
        int bytesPerGroup = bytesFormat.getBytesPerGroup();
        String bytePrefix = bytesFormat.getBytePrefix();
        String byteSuffix = bytesFormat.getByteSuffix();
        String byteSeparator = bytesFormat.getByteSeparator();
        String groupSeparator = bytesFormat.getGroupSeparator();
        int formatLength = HexExtensionsKt.formattedStringLength(endIndex - startIndex, bytesPerLine, bytesPerGroup, groupSeparator.length(), byteSeparator.length(), bytePrefix.length(), byteSuffix.length());
        int indexInLine = 0;
        int indexInGroup = 0;
        StringBuilder $this$toHexString_u24lambda_u243 = stringBuilder = new StringBuilder(formatLength);
        while (i2 < endIndex) {
            int n2 = $this$toHexString[i2] & 0xFF;
            if (indexInLine == bytesPerLine) {
                $this$toHexString_u24lambda_u243.append('\n');
                indexInLine = 0;
                indexInGroup = 0;
            } else if (indexInGroup == bytesPerGroup) {
                $this$toHexString_u24lambda_u243.append(groupSeparator);
                indexInGroup = 0;
            }
            if (indexInGroup != 0) {
                $this$toHexString_u24lambda_u243.append(byteSeparator);
            }
            $this$toHexString_u24lambda_u243.append(bytePrefix);
            $this$toHexString_u24lambda_u243.append(digits.charAt(n2 >> 4));
            $this$toHexString_u24lambda_u243.append(digits.charAt(n2 & 0xF));
            $this$toHexString_u24lambda_u243.append(byteSuffix);
            ++indexInGroup;
            ++indexInLine;
            ++i2;
        }
        boolean bl = formatLength == $this$toHexString_u24lambda_u243.length();
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = byArray.length;
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(byArray, n2, n3, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    public static final int formattedStringLength(int totalBytes, int bytesPerLine22, int bytesPerGroup, int groupSeparatorLength, int byteSeparatorLength, int bytePrefixLength, int byteSuffixLength) {
        int n2;
        void var2_3;
        void var3_4;
        void var1_1;
        int n3;
        int bytesPerLine22;
        boolean bl = totalBytes > 0;
        if (!bl) {
            String bytesPerLine22 = "Failed requirement.";
            throw new IllegalArgumentException(bytesPerLine22.toString());
        }
        int lineSeparators = (totalBytes - 1) / bytesPerLine22;
        int groupSeparatorsPerLine = (bytesPerLine22 - 1) / bytesPerGroup;
        int it = n3 = totalBytes % bytesPerLine22;
        bytesPerLine22 = n3 == 0 ? bytesPerLine22 : it;
        int groupSeparatorsInLastLine = (bytesPerLine22 - 1) / bytesPerGroup;
        int groupSeparators = lineSeparators * groupSeparatorsPerLine + groupSeparatorsInLastLine;
        int byteSeparators = totalBytes - 1 - lineSeparators - groupSeparators;
        long totalLength = (long)lineSeparators + (long)var1_1 * (long)var3_4 + (long)var2_3 * (long)byteSeparatorLength + (long)n2 * ((long)bytePrefixLength + 2L + (long)byteSuffixLength);
        if (!RangesKt.intRangeContains((ClosedRange<Integer>)new IntRange(0, Integer.MAX_VALUE), totalLength)) {
            throw new IllegalArgumentException("The resulting string length is too big: " + ULong.toString-impl(ULong.constructor-impl(totalLength)));
        }
        return (int)totalLength;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final byte[] hexToByteArray(@NotNull String $this$hexToByteArray, @NotNull HexFormat format) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$hexToByteArray, "");
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.hexToByteArray($this$hexToByteArray, 0, string.length(), (HexFormat)var1_1);
    }

    public static /* synthetic */ byte[] hexToByteArray$default(String string, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByteArray(string, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final byte[] hexToByteArray(String $this$hexToByteArray, int startIndex, int endIndex, HexFormat format) {
        int i2;
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$hexToByteArray.length());
        if (startIndex == endIndex) {
            return new byte[0];
        }
        HexFormat.BytesHexFormat bytesFormat = format.getBytes();
        int bytesPerLine = bytesFormat.getBytesPerLine();
        int bytesPerGroup = bytesFormat.getBytesPerGroup();
        String bytePrefix = bytesFormat.getBytePrefix();
        String byteSuffix = bytesFormat.getByteSuffix();
        String byteSeparator = bytesFormat.getByteSeparator();
        String groupSeparator = bytesFormat.getGroupSeparator();
        int n2 = HexExtensionsKt.parsedByteArrayMaxSize(endIndex - startIndex, bytesPerLine, bytesPerGroup, groupSeparator.length(), byteSeparator.length(), bytePrefix.length(), byteSuffix.length());
        byte[] result = new byte[n2];
        int byteIndex = 0;
        int indexInLine = 0;
        int indexInGroup = 0;
        while (i2 < endIndex) {
            if (indexInLine == bytesPerLine) {
                i2 = HexExtensionsKt.checkNewLineAt($this$hexToByteArray, i2, endIndex);
                indexInLine = 0;
                indexInGroup = 0;
            } else if (indexInGroup == bytesPerGroup) {
                i2 = HexExtensionsKt.checkContainsAt($this$hexToByteArray, groupSeparator, i2, endIndex, "group separator");
                indexInGroup = 0;
            } else if (indexInGroup != 0) {
                i2 = HexExtensionsKt.checkContainsAt($this$hexToByteArray, byteSeparator, i2, endIndex, "byte separator");
            }
            ++indexInLine;
            ++indexInGroup;
            int n3 = i2 = HexExtensionsKt.checkContainsAt($this$hexToByteArray, bytePrefix, i2, endIndex, "byte prefix");
            HexExtensionsKt.checkHexLength($this$hexToByteArray, n3, RangesKt.coerceAtMost(n3 + 2, endIndex), 2, true);
            result[byteIndex++] = (byte)(HexExtensionsKt.decimalFromHexDigitAt($this$hexToByteArray, i2++) << 4 | HexExtensionsKt.decimalFromHexDigitAt($this$hexToByteArray, i2++));
            i2 = HexExtensionsKt.checkContainsAt($this$hexToByteArray, byteSuffix, i2, endIndex, "byte suffix");
        }
        if (byteIndex == result.length) {
            return result;
        }
        byte[] byArray = Arrays.copyOf(result, byteIndex);
        Intrinsics.checkNotNullExpressionValue(byArray, "");
        return byArray;
    }

    static /* synthetic */ byte[] hexToByteArray$default(String string, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByteArray(string, n2, n3, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    public static final int parsedByteArrayMaxSize(int stringLength, int bytesPerLine, int bytesPerGroup, int groupSeparatorLength, int byteSeparatorLength, int bytePrefixLength, int byteSuffixLength) {
        int n2;
        void var2_2;
        void var1_1;
        void var3_3;
        long l2;
        boolean bl = stringLength > 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long charsPerByte = (long)bytePrefixLength + 2L + (long)byteSuffixLength;
        long charsPerGroup = HexExtensionsKt.charsPerSet(charsPerByte, bytesPerGroup, byteSeparatorLength);
        if (bytesPerLine <= bytesPerGroup) {
            l2 = HexExtensionsKt.charsPerSet(charsPerByte, bytesPerLine, byteSeparatorLength);
        } else {
            int groupsPerLine = bytesPerLine / bytesPerGroup;
            long result = HexExtensionsKt.charsPerSet(charsPerGroup, groupsPerLine, groupSeparatorLength);
            int bytesPerLastGroupInLine = bytesPerLine % bytesPerGroup;
            if (bytesPerLastGroupInLine != 0) {
                result += (long)groupSeparatorLength;
                result += HexExtensionsKt.charsPerSet(charsPerByte, bytesPerLastGroupInLine, byteSeparatorLength);
            }
            l2 = result;
        }
        long charsPerLine = l2;
        long numberOfChars = stringLength;
        long wholeLines = HexExtensionsKt.wholeElementsPerSet(numberOfChars, charsPerLine, 1);
        long wholeGroupsInLastLine = HexExtensionsKt.wholeElementsPerSet(numberOfChars -= wholeLines * (charsPerLine + 1L), charsPerGroup, groupSeparatorLength);
        long wholeBytesInLastGroup = HexExtensionsKt.wholeElementsPerSet(numberOfChars -= wholeGroupsInLastLine * (charsPerGroup + (long)var3_3), charsPerByte, byteSeparatorLength);
        long l3 = numberOfChars - wholeBytesInLastGroup * (charsPerByte + (long)byteSeparatorLength);
        int spare = l3 > 0L ? 1 : 0;
        return (int)(wholeLines * (long)var1_1 + wholeGroupsInLastLine * (long)var2_2 + wholeBytesInLastGroup + (long)n2);
    }

    /*
     * WARNING - void declaration
     */
    private static final long charsPerSet(long charsPerElement2, int elementsPerSet, int elementSeparatorLength) {
        void var2_2;
        void var3_3;
        long l2;
        boolean bl = elementsPerSet > 0;
        if (!bl) {
            String charsPerElement2 = "Failed requirement.";
            throw new IllegalArgumentException(charsPerElement2.toString());
        }
        return l2 * (long)elementsPerSet + (long)var3_3 * ((long)var2_2 - 1L);
    }

    /*
     * WARNING - void declaration
     */
    private static final long wholeElementsPerSet(long charsPerSet, long charsPerElement, int elementSeparatorLength) {
        void var2_2;
        long l2;
        if (charsPerSet <= 0L || charsPerElement <= 0L) {
            return 0L;
        }
        return (l2 + (long)elementSeparatorLength) / (var2_2 + (long)elementSeparatorLength);
    }

    /*
     * WARNING - void declaration
     */
    private static final int checkNewLineAt(String $this$checkNewLineAt, int index, int endIndex) {
        void var1_1;
        String string;
        if ($this$checkNewLineAt.charAt(index) == '\r') {
            void var2_2;
            if (index + 1 < var2_2 && $this$checkNewLineAt.charAt(index + 1) == '\n') {
                return index + 2;
            }
            return index + 1;
        }
        if ($this$checkNewLineAt.charAt(index) == '\n') {
            return index + 1;
        }
        throw new NumberFormatException("Expected a new line at index " + index + ", but was " + string.charAt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(byte $this$toHexString, @NotNull HexFormat format) {
        void var1_1;
        byte by;
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.toHexStringImpl(by, (HexFormat)var1_1, 8);
    }

    public static /* synthetic */ String toHexString$default(byte by, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(by, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final byte hexToByte(@NotNull String $this$hexToByte, @NotNull HexFormat format) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$hexToByte, "");
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.hexToByte($this$hexToByte, 0, string.length(), (HexFormat)var1_1);
    }

    public static /* synthetic */ byte hexToByte$default(String string, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByte(string, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final byte hexToByte(String $this$hexToByte, int startIndex, int endIndex, HexFormat format) {
        void var3_3;
        void var2_2;
        void var1_1;
        return (byte)HexExtensionsKt.hexToLongImpl($this$hexToByte, (int)var1_1, (int)var2_2, (HexFormat)var3_3, 2);
    }

    static /* synthetic */ byte hexToByte$default(String string, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByte(string, n2, n3, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(short $this$toHexString, @NotNull HexFormat format) {
        void var1_1;
        short s2;
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.toHexStringImpl(s2, (HexFormat)var1_1, 16);
    }

    public static /* synthetic */ String toHexString$default(short s2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(s2, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final short hexToShort(@NotNull String $this$hexToShort, @NotNull HexFormat format) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$hexToShort, "");
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.hexToShort($this$hexToShort, 0, string.length(), (HexFormat)var1_1);
    }

    public static /* synthetic */ short hexToShort$default(String string, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToShort(string, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final short hexToShort(String $this$hexToShort, int startIndex, int endIndex, HexFormat format) {
        void var3_3;
        void var2_2;
        void var1_1;
        return (short)HexExtensionsKt.hexToLongImpl($this$hexToShort, (int)var1_1, (int)var2_2, (HexFormat)var3_3, 4);
    }

    static /* synthetic */ short hexToShort$default(String string, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToShort(string, n2, n3, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(int $this$toHexString, @NotNull HexFormat format) {
        void var1_1;
        int n2;
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.toHexStringImpl(n2, (HexFormat)var1_1, 32);
    }

    public static /* synthetic */ String toHexString$default(int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(n2, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final int hexToInt(@NotNull String $this$hexToInt, @NotNull HexFormat format) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$hexToInt, "");
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.hexToInt($this$hexToInt, 0, string.length(), (HexFormat)var1_1);
    }

    public static /* synthetic */ int hexToInt$default(String string, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToInt(string, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final int hexToInt(String $this$hexToInt, int startIndex, int endIndex, HexFormat format) {
        void var3_3;
        void var2_2;
        void var1_1;
        return (int)HexExtensionsKt.hexToLongImpl($this$hexToInt, (int)var1_1, (int)var2_2, (HexFormat)var3_3, 8);
    }

    static /* synthetic */ int hexToInt$default(String string, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToInt(string, n2, n3, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(long $this$toHexString, @NotNull HexFormat format) {
        void var2_1;
        long l2;
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.toHexStringImpl(l2, (HexFormat)var2_1, 64);
    }

    public static /* synthetic */ String toHexString$default(long l2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(l2, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final long hexToLong(@NotNull String $this$hexToLong, @NotNull HexFormat format) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$hexToLong, "");
        Intrinsics.checkNotNullParameter(format, "");
        return HexExtensionsKt.hexToLong($this$hexToLong, 0, string.length(), (HexFormat)var1_1);
    }

    public static /* synthetic */ long hexToLong$default(String string, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final long hexToLong(String $this$hexToLong, int startIndex, int endIndex, HexFormat format) {
        void var3_3;
        void var2_2;
        void var1_1;
        return HexExtensionsKt.hexToLongImpl($this$hexToLong, (int)var1_1, (int)var2_2, (HexFormat)var3_3, 16);
    }

    static /* synthetic */ long hexToLong$default(String string, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string, n2, n3, hexFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final String toHexStringImpl(long $this$toHexStringImpl, HexFormat format, int bits) {
        void var1_10;
        StringBuilder stringBuilder;
        boolean bl = (bits & 3) == 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String digits = format.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        long value = $this$toHexStringImpl;
        String prefix = format.getNumber().getPrefix();
        String suffix = format.getNumber().getSuffix();
        int formatLength = prefix.length() + (bits >> 2) + suffix.length();
        boolean removeZeros = format.getNumber().getRemoveLeadingZeros();
        StringBuilder $this$toHexStringImpl_u24lambda_u246 = stringBuilder = new StringBuilder(formatLength);
        stringBuilder.append(prefix);
        int shift = bits;
        while (shift > 0) {
            void var3_5;
            int decimal = (int)(value >> (shift -= 4) & 0xFL);
            if (removeZeros = removeZeros && decimal == 0 && shift > 0) continue;
            $this$toHexStringImpl_u24lambda_u246.append(digits.charAt((int)var3_5));
        }
        $this$toHexStringImpl_u24lambda_u246.append((String)var1_10);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final long hexToLongImpl(String $this$hexToLongImpl, int startIndex, int endIndex, HexFormat format, int maxDigits) {
        void i2;
        void var2_2;
        void var3_3;
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$hexToLongImpl.length());
        String prefix = format.getNumber().getPrefix();
        String suffix = format.getNumber().getSuffix();
        if (prefix.length() + suffix.length() >= endIndex - startIndex) {
            StringBuilder stringBuilder = new StringBuilder("Expected a hexadecimal number with prefix \"").append(prefix).append("\" and suffix \"").append(suffix).append("\", but was ");
            String string = $this$hexToLongImpl;
            Intrinsics.checkNotNull(string);
            String string2 = string.substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            throw new NumberFormatException(stringBuilder.append(string2).toString());
        }
        int digitsStartIndex = HexExtensionsKt.checkContainsAt($this$hexToLongImpl, prefix, startIndex, endIndex, "prefix");
        int digitsEndIndex = endIndex - suffix.length();
        HexExtensionsKt.checkContainsAt($this$hexToLongImpl, (String)var3_3, digitsEndIndex, (int)var2_2, "suffix");
        HexExtensionsKt.checkHexLength($this$hexToLongImpl, digitsStartIndex, digitsEndIndex, maxDigits, false);
        long result = 0L;
        while (i2 < digitsEndIndex) {
            result = result << 4 | (long)HexExtensionsKt.decimalFromHexDigitAt($this$hexToLongImpl, (int)i2);
            ++i2;
        }
        return result;
    }

    static /* synthetic */ long hexToLongImpl$default(String string, int n2, int n3, HexFormat hexFormat, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n2 = 0;
        }
        if ((n5 & 2) != 0) {
            n3 = string.length();
        }
        return HexExtensionsKt.hexToLongImpl(string, n2, n3, hexFormat, n4);
    }

    /*
     * WARNING - void declaration
     */
    private static final int checkContainsAt(String $this$checkContainsAt, String part, int index, int endIndex, String partName) {
        int end = index + part.length();
        if (end > endIndex || !StringsKt.regionMatches($this$checkContainsAt, index, part, 0, part.length(), true)) {
            void var2_3;
            String string;
            void var3_4;
            void var1_1;
            StringBuilder stringBuilder = new StringBuilder("Expected ").append(partName).append(" \"").append((String)var1_1).append("\" at index ").append(index).append(", but was ");
            int n2 = RangesKt.coerceAtMost(end, (int)var3_4);
            Intrinsics.checkNotNull(string);
            String string2 = string.substring((int)var2_3, n2);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            throw new NumberFormatException(stringBuilder.append(string2).toString());
        }
        return end;
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkHexLength(String $this$checkHexLength, int startIndex, int endIndex, int maxDigits, boolean requireMaxLength) {
        boolean bl;
        int digitsLength = endIndex - startIndex;
        boolean bl2 = requireMaxLength ? digitsLength == maxDigits : (bl = digitsLength <= maxDigits);
        if (!bl2) {
            String string;
            void var1_1;
            void var3_3;
            void var2_2;
            String specifier = requireMaxLength ? "exactly" : "at most";
            String string2 = $this$checkHexLength;
            Intrinsics.checkNotNull(string2);
            String string3 = string2.substring(startIndex, (int)var2_2);
            Intrinsics.checkNotNullExpressionValue(string3, "");
            String substring = string3;
            throw new NumberFormatException("Expected " + specifier + ' ' + (int)var3_3 + " hexadecimal digits at index " + (int)var1_1 + ", but was " + string + " of length " + digitsLength);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final int decimalFromHexDigitAt(String $this$decimalFromHexDigitAt, int index) {
        void var2_2;
        char code = $this$decimalFromHexDigitAt.charAt(index);
        if (code > '\u007f' || HEX_DIGITS_TO_DECIMAL[code] < 0) {
            void var1_1;
            String string;
            throw new NumberFormatException("Expected a hexadecimal digit at index " + index + ", but was " + string.charAt((int)var1_1));
        }
        return HEX_DIGITS_TO_DECIMAL[var2_2];
    }

    static {
        int index;
        char item$iv;
        int n2;
        int n3 = 0;
        int[] nArray = new int[128];
        while (n3 < 128) {
            int n4 = n3++;
            nArray[n4] = -1;
        }
        int[] nArray2 = nArray;
        int[] $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242 = nArray;
        CharSequence $this$forEachIndexed$iv = LOWER_CASE_HEX_DIGITS;
        int index$iv = 0;
        for (n2 = 0; n2 < $this$forEachIndexed$iv.length(); ++n2) {
            item$iv = $this$forEachIndexed$iv.charAt(n2);
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[char] = index = index$iv++;
        }
        $this$forEachIndexed$iv = UPPER_CASE_HEX_DIGITS;
        index$iv = 0;
        for (n2 = 0; n2 < $this$forEachIndexed$iv.length(); ++n2) {
            item$iv = $this$forEachIndexed$iv.charAt(n2);
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[char] = index = index$iv++;
        }
        HEX_DIGITS_TO_DECIMAL = nArray2;
    }
}

