/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.WasExperimental;
import kotlin.internal.InlineOnly;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.CharsKt__CharJVMKt;
import kotlin.text._OneToManyTitlecaseMappingsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\f\u0010\u0004\u001a\u00020\u0002*\u00020\u0001H\u0007\u001a\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a\u001b\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0002\u0010\u0007\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\n\u0010\f\u001a\u00020\t*\u00020\u0001\u001a\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000eH\u0087\n\u001a\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0001H\u0007\u00a8\u0006\u0010"}, d2={"digitToChar", "", "", "radix", "digitToInt", "digitToIntOrNull", "(C)Ljava/lang/Integer;", "(CI)Ljava/lang/Integer;", "equals", "", "other", "ignoreCase", "isSurrogate", "plus", "", "titlecase", "kotlin-stdlib"}, xs="kotlin/text/CharsKt")
@SourceDebugExtension(value={"SMAP\nChar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Char.kt\nkotlin/text/CharsKt__CharKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1#2:345\n*E\n"})
class CharsKt__CharKt
extends CharsKt__CharJVMKt {
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    public static final int digitToInt(char $this$digitToInt) {
        int n2;
        int n3 = n2 = CharsKt.digitOf($this$digitToInt, 10);
        if (n2 < 0) {
            char c2;
            throw new IllegalArgumentException("Char " + c2 + " is not a decimal digit");
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    public static final int digitToInt(char $this$digitToInt, int radix) {
        void var1_1;
        char c2;
        Integer n2 = CharsKt.digitToIntOrNull($this$digitToInt, radix);
        if (n2 != null) {
            return n2;
        }
        throw new IllegalArgumentException("Char " + c2 + " is not a digit in the given radix=" + (int)var1_1);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @Nullable
    public static final Integer digitToIntOrNull(char $this$digitToIntOrNull) {
        Integer n2 = CharsKt.digitOf($this$digitToIntOrNull, 10);
        int n3 = ((Number)n2).intValue();
        if (n3 >= 0) {
            return n2;
        }
        return null;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @Nullable
    public static final Integer digitToIntOrNull(char $this$digitToIntOrNull, int radix) {
        int n2;
        char c2;
        CharsKt.checkRadix(radix);
        Integer n3 = CharsKt.digitOf(c2, n2);
        n2 = ((Number)n3).intValue();
        if (n2 >= 0) {
            return n3;
        }
        return null;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    public static final char digitToChar(int $this$digitToChar) {
        int n2;
        if (new IntRange(0, 9).contains($this$digitToChar)) {
            return (char)($this$digitToChar + 48);
        }
        throw new IllegalArgumentException("Int " + n2 + " is not a decimal digit");
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    public static final char digitToChar(int $this$digitToChar, int radix) {
        int n2;
        if (!new IntRange(2, 36).contains(radix)) {
            throw new IllegalArgumentException("Invalid radix: " + radix + ". Valid radix values are in range 2..36");
        }
        if ($this$digitToChar < 0 || $this$digitToChar >= radix) {
            void var1_1;
            throw new IllegalArgumentException("Digit " + $this$digitToChar + " does not represent a valid digit in radix " + (int)var1_1);
        }
        if ($this$digitToChar < 10) {
            return (char)($this$digitToChar + 48);
        }
        return (char)((char)(n2 + 65) - 10);
    }

    @SinceKotlin(version="1.5")
    @NotNull
    public static final String titlecase(char $this$titlecase) {
        return _OneToManyTitlecaseMappingsKt.titlecaseImpl($this$titlecase);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final String plus(char $this$plus, String other) {
        void var1_1;
        char c2;
        Intrinsics.checkNotNullParameter(other, "");
        return c2 + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean equals(char $this$equals, char other, boolean ignoreCase) {
        void var1_1;
        char c2;
        char otherUpper;
        void var2_2;
        if ($this$equals == other) {
            return true;
        }
        if (var2_2 == false) {
            return false;
        }
        char thisUpper = Character.toUpperCase($this$equals);
        return thisUpper == (otherUpper = Character.toUpperCase(other)) || Character.toLowerCase(c2) == Character.toLowerCase((char)var1_1);
    }

    public static /* synthetic */ boolean equals$default(char c2, char c3, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return CharsKt.equals(c2, c3, bl);
    }

    public static final boolean isSurrogate(char $this$isSurrogate) {
        char c2;
        return new CharRange('\ud800', '\udfff').contains(c2);
    }
}

