/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.io.Serializable;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;

@SinceKotlin(version="1.4")
public class AdaptedFunctionReference
implements Serializable,
FunctionBase {
    protected final Object receiver;
    private final Class owner;
    private final String name;
    private final String signature;
    private final boolean isTopLevel;
    private final int arity;
    private final int flags;

    /*
     * WARNING - void declaration
     */
    public AdaptedFunctionReference(int arity, Class owner, String name, String signature, int flags) {
        this((int)var1_1, CallableReference.NO_RECEIVER, (Class)var2_2, (String)var3_3, signature, flags);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AdaptedFunctionReference(int arity, Object receiver, Class owner, String name, String signature, int flags) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.receiver = var2_2;
        this.owner = var3_3;
        this.name = name;
        this.signature = signature;
        this.isTopLevel = (flags & 1) == 1;
        this.arity = var1_1;
        this.flags = flags >> 1;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    public KDeclarationContainer getOwner() {
        if (this.owner == null) {
            return null;
        }
        if (this.isTopLevel) {
            return Reflection.getOrCreateKotlinPackage(this.owner);
        }
        return Reflection.getOrCreateKotlinClass(this.owner);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o2) {
        void var1_1;
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof AdaptedFunctionReference)) {
            return false;
        }
        AdaptedFunctionReference other = (AdaptedFunctionReference)o2;
        return this.isTopLevel == other.isTopLevel && this.arity == other.arity && this.flags == other.flags && Intrinsics.areEqual(this.receiver, other.receiver) && Intrinsics.areEqual(this.owner, other.owner) && this.name.equals(other.name) && this.signature.equals(var1_1.signature);
    }

    public int hashCode() {
        int n2 = this.receiver != null ? this.receiver.hashCode() : 0;
        n2 = n2 * 31 + (this.owner != null ? this.owner.hashCode() : 0);
        n2 = n2 * 31 + this.name.hashCode();
        n2 = n2 * 31 + this.signature.hashCode();
        n2 = n2 * 31 + (this.isTopLevel ? 1231 : 1237);
        n2 = n2 * 31 + this.arity;
        n2 = n2 * 31 + this.flags;
        return n2;
    }

    public String toString() {
        return Reflection.renderLambdaToString(this);
    }
}

