/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.encoding;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.collections.AbstractList;
import kotlin.io.encoding.Base64Kt;
import kotlin.io.encoding.ExperimentalEncodingApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 22\u00020\u0001:\u00012B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ%\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J%\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u001bJ\"\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011J\"\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011J0\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J4\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011J4\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011J \u0010 \u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\"\u0010!\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011J4\u0010\"\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011J5\u0010#\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J=\u0010&\u001a\u0002H'\"\f\b\u0000\u0010'*\u00060(j\u0002`)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u0002H'2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010*J\"\u0010+\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011J%\u0010,\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b-J(\u0010.\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J \u00101\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u00063"}, d2={"Lkotlin/io/encoding/Base64;", "", "isUrlSafe", "", "isMimeScheme", "(ZZ)V", "isMimeScheme$kotlin_stdlib", "()Z", "isUrlSafe$kotlin_stdlib", "bytesToStringImpl", "", "source", "", "bytesToStringImpl$kotlin_stdlib", "charsToBytesImpl", "", "startIndex", "", "endIndex", "charsToBytesImpl$kotlin_stdlib", "checkDestinationBounds", "", "destinationSize", "destinationOffset", "capacityNeeded", "checkSourceBounds", "sourceSize", "checkSourceBounds$kotlin_stdlib", "decode", "decodeImpl", "destination", "decodeIntoByteArray", "decodeSize", "encode", "encodeIntoByteArray", "encodeIntoByteArrayImpl", "encodeIntoByteArrayImpl$kotlin_stdlib", "encodeSize", "encodeToAppendable", "A", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "([BLjava/lang/Appendable;II)Ljava/lang/Appendable;", "encodeToByteArray", "encodeToByteArrayImpl", "encodeToByteArrayImpl$kotlin_stdlib", "handlePaddingSymbol", "padIndex", "byteStart", "skipIllegalSymbolsIfMime", "Default", "kotlin-stdlib"})
@SinceKotlin(version="1.8")
@ExperimentalEncodingApi
public class Base64 {
    @NotNull
    public static final Default Default = new Default(null);
    private final boolean isUrlSafe;
    private final boolean isMimeScheme;
    private static final int bitsPerByte = 8;
    private static final int bitsPerSymbol = 6;
    public static final int bytesPerGroup = 3;
    public static final int symbolsPerGroup = 4;
    public static final byte padSymbol = 61;
    public static final int mimeLineLength = 76;
    private static final int mimeGroupsPerLine = 19;
    @NotNull
    private static final byte[] mimeLineSeparatorSymbols;
    @NotNull
    private static final Base64 UrlSafe;
    @NotNull
    private static final Base64 Mime;

    /*
     * WARNING - void declaration
     */
    private Base64(boolean isUrlSafe, boolean isMimeScheme) {
        void var2_3;
        boolean bl;
        this.isUrlSafe = bl;
        this.isMimeScheme = var2_3;
        bl = !this.isUrlSafe || !this.isMimeScheme;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean isUrlSafe$kotlin_stdlib() {
        return this.isUrlSafe;
    }

    public final boolean isMimeScheme$kotlin_stdlib() {
        return this.isMimeScheme;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] encodeToByteArray(@NotNull byte[] source2, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        return this.encodeToByteArrayImpl$kotlin_stdlib((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(Base64 base64, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeToByteArray");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return base64.encodeToByteArray(byArray, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final int encodeIntoByteArray(@NotNull byte[] source2, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(destination, "");
        return this.encodeIntoByteArrayImpl$kotlin_stdlib((byte[])var1_1, (byte[])var2_2, (int)var3_3, startIndex, endIndex);
    }

    public static /* synthetic */ int encodeIntoByteArray$default(Base64 base64, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeIntoByteArray");
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = byArray.length;
        }
        return base64.encodeIntoByteArray(byArray, byArray2, n2, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String encode(@NotNull byte[] source2, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        byte[] byArray;
        Intrinsics.checkNotNullParameter(source2, "");
        byArray = this.encodeToByteArrayImpl$kotlin_stdlib(byArray, (int)var2_2, (int)var3_3);
        return new String(byArray, Charsets.ISO_8859_1);
    }

    public static /* synthetic */ String encode$default(Base64 base64, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encode");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return base64.encode(byArray, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <A extends Appendable> A encodeToAppendable(@NotNull byte[] source2, @NotNull A destination, int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(destination, "");
        source2 = this.encodeToByteArrayImpl$kotlin_stdlib(source2, (int)var3_3, endIndex);
        String stringResult = new String(source2, Charsets.ISO_8859_1);
        destination.append((CharSequence)var1_1);
        return var2_2;
    }

    public static /* synthetic */ Appendable encodeToAppendable$default(Base64 base64, byte[] byArray, Appendable appendable, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeToAppendable");
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byArray.length;
        }
        return base64.encodeToAppendable(byArray, appendable, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] decode(@NotNull byte[] source2, int startIndex, int endIndex) {
        void var3_5;
        void var2_4;
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        this.checkSourceBounds$kotlin_stdlib(source2.length, startIndex, endIndex);
        int n2 = this.decodeSize(source2, startIndex, endIndex);
        byte[] destination = new byte[n2];
        int n3 = this.decodeImpl((byte[])var1_1, destination, 0, (int)var2_4, (int)var3_5);
        if ((n3 = n3 == destination.length ? 1 : 0) == 0) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return destination;
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return base64.decode(byArray, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final int decodeIntoByteArray(@NotNull byte[] source2, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(destination, "");
        this.checkSourceBounds$kotlin_stdlib(source2.length, startIndex, endIndex);
        this.checkDestinationBounds(destination.length, destinationOffset, this.decodeSize(source2, startIndex, endIndex));
        return this.decodeImpl((byte[])var1_1, (byte[])var2_2, (int)var3_3, startIndex, endIndex);
    }

    public static /* synthetic */ int decodeIntoByteArray$default(Base64 base64, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeIntoByteArray");
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = byArray.length;
        }
        return base64.decodeIntoByteArray(byArray, byArray2, n2, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] decode(@NotNull CharSequence source2, int startIndex2, int endIndex) {
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter(source2, "");
        Base64 base64 = this;
        if (source2 instanceof String) {
            base64.checkSourceBounds$kotlin_stdlib(source2.length(), startIndex2, endIndex);
            String string = ((String)source2).substring(startIndex2, endIndex);
            Intrinsics.checkNotNullExpressionValue(string, "");
            source2 = string;
            Charset startIndex2 = Charsets.ISO_8859_1;
            Intrinsics.checkNotNull(source2);
            byte[] byArray2 = ((String)source2).getBytes(startIndex2);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "");
        } else {
            void var3_4;
            void var2_2;
            byArray = base64.charsToBytesImpl$kotlin_stdlib(source2, (int)var2_2, (int)var3_4);
        }
        byte[] byteSource = byArray;
        return Base64.decode$default(this, (byte[])var1_1, 0, 0, 6, null);
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, CharSequence charSequence, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = charSequence.length();
        }
        return base64.decode(charSequence, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final int decodeIntoByteArray(@NotNull CharSequence source2, @NotNull byte[] destination, int destinationOffset, int startIndex2, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(destination, "");
        Base64 base64 = this;
        if (source2 instanceof String) {
            base64.checkSourceBounds$kotlin_stdlib(source2.length(), startIndex2, endIndex);
            String string = ((String)source2).substring(startIndex2, endIndex);
            Intrinsics.checkNotNullExpressionValue(string, "");
            source2 = string;
            Charset startIndex2 = Charsets.ISO_8859_1;
            Intrinsics.checkNotNull(source2);
            byte[] byArray2 = ((String)source2).getBytes(startIndex2);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "");
        } else {
            int startIndex2;
            byArray = base64.charsToBytesImpl$kotlin_stdlib(source2, startIndex2, endIndex);
        }
        byte[] byteSource = byArray;
        return Base64.decodeIntoByteArray$default(this, (byte[])var1_1, (byte[])var2_2, (int)var3_3, 0, 0, 24, null);
    }

    public static /* synthetic */ int decodeIntoByteArray$default(Base64 base64, CharSequence charSequence, byte[] byArray, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeIntoByteArray");
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = charSequence.length();
        }
        return base64.decodeIntoByteArray(charSequence, byArray, n2, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] encodeToByteArrayImpl$kotlin_stdlib(@NotNull byte[] source2, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        this.checkSourceBounds$kotlin_stdlib(source2.length, startIndex, endIndex);
        int n2 = this.encodeSize(endIndex - startIndex);
        byte[] destination = new byte[n2];
        this.encodeIntoByteArrayImpl$kotlin_stdlib((byte[])var1_1, destination, 0, (int)var2_2, (int)var3_3);
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    public final int encodeIntoByteArrayImpl$kotlin_stdlib(@NotNull byte[] source2, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        void var3_3;
        boolean bl;
        int bits;
        int i2;
        int groupsPerLine;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(destination, "");
        this.checkSourceBounds$kotlin_stdlib(source2.length, startIndex, endIndex);
        this.checkDestinationBounds(destination.length, destinationOffset, this.encodeSize(endIndex - startIndex));
        byte[] encodeMap = this.isUrlSafe ? Base64Kt.access$getBase64UrlEncodeMap$p() : Base64Kt.access$getBase64EncodeMap$p();
        int sourceIndex = startIndex;
        int destinationIndex = destinationOffset;
        int n2 = groupsPerLine = this.isMimeScheme ? 19 : Integer.MAX_VALUE;
        while (sourceIndex + 2 < endIndex) {
            int groups2 = Math.min((endIndex - sourceIndex) / 3, groupsPerLine);
            for (i2 = 0; i2 < groups2; ++i2) {
                int byte1 = source2[sourceIndex++] & 0xFF;
                int byte2 = source2[sourceIndex++] & 0xFF;
                int byte3 = source2[sourceIndex++] & 0xFF;
                bits = byte1 << 16 | byte2 << 8 | byte3;
                destination[destinationIndex++] = encodeMap[bits >>> 18];
                destination[destinationIndex++] = encodeMap[bits >>> 12 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits >>> 6 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits & 0x3F];
            }
            if (groups2 != groupsPerLine || sourceIndex == endIndex) continue;
            destination[destinationIndex++] = mimeLineSeparatorSymbols[0];
            destination[destinationIndex++] = mimeLineSeparatorSymbols[1];
        }
        switch (endIndex - sourceIndex) {
            case 1: {
                i2 = source2[sourceIndex++] & 0xFF;
                bits = i2 << 4;
                destination[destinationIndex++] = encodeMap[bits >>> 6];
                destination[destinationIndex++] = encodeMap[bits & 0x3F];
                destination[destinationIndex++] = 61;
                destination[destinationIndex++] = 61;
                break;
            }
            case 2: {
                void var1_1;
                int byte1 = source2[sourceIndex++] & 0xFF;
                int byte2 = var1_1[sourceIndex++] & 0xFF;
                int bits2 = byte1 << 10 | byte2 << 2;
                destination[destinationIndex++] = encodeMap[bits2 >>> 12];
                destination[destinationIndex++] = encodeMap[bits2 >>> 6 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits2 & 0x3F];
                var2_2[destinationIndex++] = 61;
            }
        }
        if (!(bl = sourceIndex == endIndex)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return destinationIndex - var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final int encodeSize(int sourceSize) {
        void var1_1;
        void var2_2;
        int groups2 = (sourceSize + 3 - 1) / 3;
        int lineSeparators = this.isMimeScheme ? (groups2 - 1) / 19 : 0;
        int size = (groups2 << 2) + (var2_2 << 1);
        if (size < 0) {
            throw new IllegalArgumentException("Input is too big");
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeImpl(byte[] source2, byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        void var3_3;
        int symbol;
        int[] decodeMap = this.isUrlSafe ? Base64Kt.access$getBase64UrlDecodeMap$p() : Base64Kt.access$getBase64DecodeMap$p();
        int payload = 0;
        int byteStart = -8;
        int sourceIndex = startIndex;
        int destinationIndex = destinationOffset;
        while (sourceIndex < endIndex) {
            int symbolBits;
            if (byteStart == -8 && sourceIndex + 3 < endIndex) {
                int symbol4;
                int symbol3;
                int bits;
                int symbol1 = decodeMap[source2[sourceIndex++] & 0xFF];
                int symbol2 = decodeMap[source2[sourceIndex++] & 0xFF];
                if ((bits = symbol1 << 18 | symbol2 << 12 | (symbol3 = decodeMap[source2[sourceIndex++] & 0xFF]) << 6 | (symbol4 = decodeMap[source2[sourceIndex++] & 0xFF])) >= 0) {
                    destination[destinationIndex++] = (byte)(bits >> 16);
                    destination[destinationIndex++] = (byte)(bits >> 8);
                    destination[destinationIndex++] = (byte)bits;
                    continue;
                }
                sourceIndex -= 4;
            }
            if ((symbolBits = decodeMap[symbol = source2[sourceIndex] & 0xFF]) < 0) {
                if (symbolBits == -2) {
                    sourceIndex = this.handlePaddingSymbol(source2, sourceIndex, endIndex, byteStart);
                    break;
                }
                if (this.isMimeScheme) {
                    ++sourceIndex;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder("Invalid symbol '").append((char)symbol).append("'(");
                String string = Integer.toString(symbol, CharsKt.checkRadix(8));
                Intrinsics.checkNotNullExpressionValue(string, "");
                throw new IllegalArgumentException(stringBuilder.append(string).append(") at index ").append(sourceIndex).toString());
            }
            ++sourceIndex;
            payload = payload << 6 | symbolBits;
            if ((byteStart += 6) < 0) continue;
            destination[destinationIndex++] = (byte)(payload >>> byteStart);
            payload &= (1 << byteStart) - 1;
            byteStart -= 8;
        }
        if (byteStart == -2) {
            throw new IllegalArgumentException("The last unit of input does not have enough bits");
        }
        if ((sourceIndex = this.skipIllegalSymbolsIfMime(source2, sourceIndex, endIndex)) < endIndex) {
            void var1_1;
            symbol = var1_1[sourceIndex] & 0xFF;
            StringBuilder stringBuilder = new StringBuilder("Symbol '").append((char)symbol).append("'(");
            String string = Integer.toString(symbol, CharsKt.checkRadix(8));
            Intrinsics.checkNotNullExpressionValue(string, "");
            throw new IllegalArgumentException(stringBuilder.append(string).append(") at index ").append(sourceIndex - 1).append(" is prohibited after the pad character").toString());
        }
        return destinationIndex - var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeSize(byte[] source2, int startIndex, int endIndex) {
        int symbols = endIndex - startIndex;
        if (symbols == 0) {
            return 0;
        }
        if (symbols == 1) {
            throw new IllegalArgumentException("Input should have at list 2 symbols for Base64 decoding, startIndex: " + startIndex + ", endIndex: " + endIndex);
        }
        if (this.isMimeScheme) {
            void index;
            while (index < endIndex) {
                int symbol = source2[index] & 0xFF;
                int symbolBits = Base64Kt.access$getBase64DecodeMap$p()[symbol];
                if (symbolBits < 0) {
                    if (symbolBits == -2) {
                        symbols -= endIndex - index;
                        break;
                    }
                    --symbols;
                }
                ++index;
            }
        } else if (source2[endIndex - 1] == 61) {
            void var3_3;
            void var1_1;
            --symbols;
            if (var1_1[var3_3 - 2] == 61) {
                --symbols;
            }
        }
        return (int)((long)symbols * 6L / 8L);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] charsToBytesImpl$kotlin_stdlib(@NotNull CharSequence source2, int startIndex, int endIndex) {
        void index;
        Intrinsics.checkNotNullParameter(source2, "");
        this.checkSourceBounds$kotlin_stdlib(source2.length(), startIndex, endIndex);
        byte[] byteArray = new byte[endIndex - startIndex];
        int length = 0;
        while (index < endIndex) {
            char symbol = source2.charAt((int)index);
            byteArray[length++] = symbol <= '\u00ff' ? (int)symbol : 63;
            ++index;
        }
        return byteArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String bytesToStringImpl$kotlin_stdlib(@NotNull byte[] source2) {
        void var2_2;
        Intrinsics.checkNotNullParameter(source2, "");
        StringBuilder stringBuilder = new StringBuilder(source2.length);
        for (byte by : source2) {
            stringBuilder.append((char)by);
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final int handlePaddingSymbol(byte[] source2, int padIndex, int endIndex, int byteStart) {
        switch (byteStart) {
            case -8: {
                throw new IllegalArgumentException("Redundant pad character at index " + padIndex);
            }
            case -2: {
                return padIndex + 1;
            }
            case -4: {
                void var2_2;
                void var1_1;
                void var3_3;
                int secondPadIndex = this.skipIllegalSymbolsIfMime(source2, padIndex + 1, endIndex);
                if (secondPadIndex == var3_3 || var1_1[secondPadIndex] != 61) {
                    throw new IllegalArgumentException("Missing one pad character at index " + secondPadIndex);
                }
                return (int)(var2_2 + true);
            }
            case -6: {
                void var2_2;
                return (int)(var2_2 + true);
            }
        }
        throw new IllegalStateException("Unreachable".toString());
    }

    /*
     * WARNING - void declaration
     */
    private final int skipIllegalSymbolsIfMime(byte[] source2, int startIndex, int endIndex) {
        void var2_2;
        void sourceIndex;
        if (!this.isMimeScheme) {
            return startIndex;
        }
        while (sourceIndex < endIndex) {
            int symbol = source2[sourceIndex] & 0xFF;
            if (Base64Kt.access$getBase64DecodeMap$p()[symbol] != -1) {
                return (int)sourceIndex;
            }
            ++sourceIndex;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkSourceBounds$kotlin_stdlib(int sourceSize, int startIndex, int endIndex) {
        void var1_1;
        void var3_3;
        void var2_2;
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib((int)var2_2, (int)var3_3, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDestinationBounds(int destinationSize, int destinationOffset, int capacityNeeded) {
        if (destinationOffset < 0 || destinationOffset > destinationSize) {
            throw new IndexOutOfBoundsException("destination offset: " + destinationOffset + ", destination size: " + destinationSize);
        }
        int destinationEndIndex = destinationOffset + capacityNeeded;
        if (destinationEndIndex < 0 || destinationEndIndex > destinationSize) {
            void var3_3;
            void var1_1;
            void var2_2;
            throw new IndexOutOfBoundsException("The destination array does not have enough capacity, destination offset: " + (int)var2_2 + ", destination size: " + (int)var1_1 + ", capacity needed: " + (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Base64(boolean isUrlSafe, boolean isMimeScheme, DefaultConstructorMarker $constructor_marker) {
        this((boolean)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    static {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 13;
        byArray2[1] = 10;
        mimeLineSeparatorSymbols = byArray2;
        UrlSafe = new Base64(true, false);
        Mime = new Base64(false, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkotlin/io/encoding/Base64$Default;", "Lkotlin/io/encoding/Base64;", "()V", "Mime", "getMime", "()Lkotlin/io/encoding/Base64;", "UrlSafe", "getUrlSafe", "bitsPerByte", "", "bitsPerSymbol", "bytesPerGroup", "mimeGroupsPerLine", "mimeLineLength", "mimeLineSeparatorSymbols", "", "getMimeLineSeparatorSymbols$kotlin_stdlib", "()[B", "padSymbol", "", "symbolsPerGroup", "kotlin-stdlib"})
    public static final class Default
    extends Base64 {
        private Default() {
            super(false, false, null);
        }

        @NotNull
        public final byte[] getMimeLineSeparatorSymbols$kotlin_stdlib() {
            return mimeLineSeparatorSymbols;
        }

        @NotNull
        public final Base64 getUrlSafe() {
            return UrlSafe;
        }

        @NotNull
        public final Base64 getMime() {
            return Mime;
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

