/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilePathComponents;
import kotlin.io.FileSystemException;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__FileTreeWalkKt;
import kotlin.io.FilesKt__UtilsKt;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.io.TerminateException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u001a*\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0007\u001a*\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0007\u001a8\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\u001a\b\u0002\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u001a&\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u000f*\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0002*\u00020\u0002\u001a\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d*\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002\u00a2\u0006\u0002\b\u001e\u001a\u0011\u0010\u001c\u001a\u00020\u001f*\u00020\u001fH\u0002\u00a2\u0006\u0002\b\u001e\u001a\u0012\u0010 \u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0012\u0010#\u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010'\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u001b\u0010)\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\b*\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006+"}, d2={"extension", "", "Ljava/io/File;", "getExtension", "(Ljava/io/File;)Ljava/lang/String;", "invariantSeparatorsPath", "getInvariantSeparatorsPath", "nameWithoutExtension", "getNameWithoutExtension", "createTempDir", "prefix", "suffix", "directory", "createTempFile", "copyRecursively", "", "target", "overwrite", "onError", "Lkotlin/Function2;", "Ljava/io/IOException;", "Lkotlin/io/OnErrorAction;", "copyTo", "bufferSize", "", "deleteRecursively", "endsWith", "other", "normalize", "", "normalize$FilesKt__UtilsKt", "Lkotlin/io/FilePathComponents;", "relativeTo", "base", "relativeToOrNull", "relativeToOrSelf", "resolve", "relative", "resolveSibling", "startsWith", "toRelativeString", "toRelativeStringOrNull", "toRelativeStringOrNull$FilesKt__UtilsKt", "kotlin-stdlib"}, xs="kotlin/io/FilesKt")
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nkotlin/io/FilesKt__UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,473:1\n1#2:474\n1284#3,3:475\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nkotlin/io/FilesKt__UtilsKt\n*L\n347#1:475,3\n*E\n"})
class FilesKt__UtilsKt
extends FilesKt__FileTreeWalkKt {
    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Avoid creating temporary directories in the default temp location with this function due to too wide permissions on the newly created directory. Use kotlin.io.path.createTempDirectory instead.")
    @NotNull
    public static final File createTempDir(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) {
        File file;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(prefix, "");
        File dir = File.createTempFile(prefix, (String)var1_1, (File)var2_2);
        dir.delete();
        if (dir.mkdir()) {
            Intrinsics.checkNotNull(dir);
            return dir;
        }
        throw new IOException("Unable to create temporary directory " + file + '.');
    }

    public static /* synthetic */ File createTempDir$default(String string, String string2, File file, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "tmp";
        }
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempDir(string, string2, file);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Avoid creating temporary files in the default temp location with this function due to too wide permissions on the newly created file. Use kotlin.io.path.createTempFile instead or resort to java.io.File.createTempFile.")
    @NotNull
    public static final File createTempFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) {
        void var2_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter(prefix, "");
        File file = File.createTempFile(string, (String)var1_1, (File)var2_2);
        Intrinsics.checkNotNullExpressionValue(file, "");
        return file;
    }

    public static /* synthetic */ File createTempFile$default(String string, String string2, File file, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "tmp";
        }
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempFile(string, string2, file);
    }

    @NotNull
    public static final String getExtension(@NotNull File $this$extension) {
        File file;
        Intrinsics.checkNotNullParameter($this$extension, "");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return StringsKt.substringAfterLast(string, '.', "");
    }

    @NotNull
    public static final String getInvariantSeparatorsPath(@NotNull File $this$invariantSeparatorsPath) {
        File file;
        Intrinsics.checkNotNullParameter($this$invariantSeparatorsPath, "");
        if (File.separatorChar != '/') {
            String string = $this$invariantSeparatorsPath.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "");
            return StringsKt.replace$default(string, File.separatorChar, '/', false, 4, null);
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull File $this$nameWithoutExtension) {
        File file;
        Intrinsics.checkNotNullParameter($this$nameWithoutExtension, "");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return StringsKt.substringBeforeLast$default(string, ".", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toRelativeString(@NotNull File $this$toRelativeString, @NotNull File base) {
        Intrinsics.checkNotNullParameter($this$toRelativeString, "");
        Intrinsics.checkNotNullParameter(base, "");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt($this$toRelativeString, base);
        if (string == null) {
            void var1_1;
            File file;
            throw new IllegalArgumentException("this and base files have different roots: " + file + " and " + var1_1 + '.');
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File relativeTo(@NotNull File $this$relativeTo, @NotNull File base) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$relativeTo, "");
        Intrinsics.checkNotNullParameter(base, "");
        return new File(FilesKt.toRelativeString(file, (File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File relativeToOrSelf(@NotNull File $this$relativeToOrSelf, @NotNull File base) {
        Object object;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$relativeToOrSelf, "");
        Intrinsics.checkNotNullParameter(base, "");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt($this$relativeToOrSelf, (File)var1_1);
        if (string != null) {
            Object p0 = string;
            p0 = string;
            return new File((String)object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final File relativeToOrNull(@NotNull File $this$relativeToOrNull, @NotNull File base) {
        void var1_1;
        Intrinsics.checkNotNullParameter($this$relativeToOrNull, "");
        Intrinsics.checkNotNullParameter(base, "");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt($this$relativeToOrNull, (File)var1_1);
        if (string != null) {
            Object object;
            Object p0 = string;
            p0 = string;
            return new File((String)object);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final String toRelativeStringOrNull$FilesKt__UtilsKt(File $this$toRelativeStringOrNull, File base) {
        void var3_3;
        int i2;
        FilePathComponents thisComponents = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents($this$toRelativeStringOrNull));
        FilePathComponents baseComponents = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents(base));
        if (!Intrinsics.areEqual(thisComponents.getRoot(), baseComponents.getRoot())) {
            return null;
        }
        int baseCount = baseComponents.getSize();
        int thisCount = thisComponents.getSize();
        int maxSameCount = Math.min(thisCount, baseCount);
        for (i2 = 0; i2 < maxSameCount && Intrinsics.areEqual(thisComponents.getSegments().get(i2), baseComponents.getSegments().get(i2)); ++i2) {
        }
        int sameCount = i2;
        StringBuilder res = new StringBuilder();
        int i3 = baseCount - 1;
        if (sameCount <= i3) {
            while (true) {
                if (Intrinsics.areEqual(baseComponents.getSegments().get(i3).getName(), "..")) {
                    return null;
                }
                res.append("..");
                if (i3 != sameCount) {
                    res.append(File.separatorChar);
                }
                if (i3 == sameCount) break;
                --i3;
            }
        }
        if (sameCount < var3_3) {
            FilePathComponents filePathComponents;
            void var2_2;
            if (sameCount < var2_2) {
                res.append(File.separatorChar);
            }
            Iterable iterable = CollectionsKt.drop((Iterable)filePathComponents.getSegments(), sameCount);
            Appendable appendable = res;
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue(string, "");
            CollectionsKt.joinTo$default(iterable, appendable, string, null, null, 0, null, null, 124, null);
        }
        return res.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final File copyTo(@NotNull File $this$copyTo, @NotNull File target, boolean overwrite, int bufferSize) {
        Closeable closeable;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$copyTo, "");
        Intrinsics.checkNotNullParameter(target, "");
        if (!$this$copyTo.exists()) {
            throw new NoSuchFileException($this$copyTo, null, "The source file doesn't exist.", 2, null);
        }
        if (target.exists()) {
            void var2_2;
            if (var2_2 == false) {
                throw new FileAlreadyExistsException($this$copyTo, target, "The destination file already exists.");
            }
            if (!target.delete()) {
                throw new FileAlreadyExistsException($this$copyTo, target, "Tried to overwrite the destination, but failed to delete it.");
            }
        }
        if ($this$copyTo.isDirectory()) {
            if (target.mkdirs()) return var1_1;
            throw new FileSystemException($this$copyTo, target, "Failed to create target directory.");
        }
        File file = target.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        closeable = new FileInputStream((File)((Object)closeable));
        Throwable throwable = null;
        try {
            FileInputStream input = (FileInputStream)closeable;
            Closeable closeable2 = new FileOutputStream(target);
            Throwable throwable2 = null;
            try {
                void var3_4;
                FileOutputStream output = (FileOutputStream)closeable2;
                ByteStreamsKt.copyTo(input, output, (int)var3_4);
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    CloseableKt.closeFinally(closeable2, throwable2);
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally(closeable2, null);
        }
        catch (Throwable throwable4) {
            try {
                Throwable throwable7 = throwable4;
                throwable = throwable4;
                throw throwable7;
            }
            catch (Throwable throwable8) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable8;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return var1_1;
    }

    public static /* synthetic */ File copyTo$default(File file, File file2, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = false;
        }
        if ((n3 & 4) != 0) {
            n2 = 8192;
        }
        return FilesKt.copyTo(file, file2, bl, n2);
    }

    public static final boolean copyRecursively(@NotNull File $this$copyRecursively, @NotNull File target, boolean overwrite, @NotNull Function2<? super File, ? super IOException, ? extends OnErrorAction> onError) {
        Intrinsics.checkNotNullParameter($this$copyRecursively, "");
        Intrinsics.checkNotNullParameter(target, "");
        Intrinsics.checkNotNullParameter(onError, "");
        if (!$this$copyRecursively.exists()) {
            return onError.invoke($this$copyRecursively, new NoSuchFileException($this$copyRecursively, null, "The source file doesn't exist.", 2, null)) != OnErrorAction.TERMINATE;
        }
        try {
            Iterator<File> iterator2 = FilesKt.walkTopDown($this$copyRecursively).onFail((Function2<? super File, ? super IOException, Unit>)new Function2<File, IOException, Unit>(onError){
                final /* synthetic */ Function2<File, IOException, OnErrorAction> $onError;
                {
                    void var1_1;
                    this.$onError = var1_1;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull File f2, @NotNull IOException e2) {
                    void var2_2;
                    Intrinsics.checkNotNullParameter(f2, "");
                    Intrinsics.checkNotNullParameter(e2, "");
                    if (this.$onError.invoke(f2, (IOException)var2_2) == OnErrorAction.TERMINATE) {
                        void var1_1;
                        throw new TerminateException((File)var1_1);
                    }
                }
            }).iterator();
            while (iterator2.hasNext()) {
                File src = iterator2.next();
                if (!src.exists()) {
                    if (onError.invoke(src, new NoSuchFileException(src, null, "The source file doesn't exist.", 2, null)) != OnErrorAction.TERMINATE) continue;
                    return false;
                }
                String relPath = FilesKt.toRelativeString(src, $this$copyRecursively);
                File dstFile = new File(target, relPath);
                if (!(!dstFile.exists() || src.isDirectory() && dstFile.isDirectory())) {
                    boolean bl;
                    boolean bl2 = !overwrite ? true : (dstFile.isDirectory() ? !FilesKt.deleteRecursively(dstFile) : (bl = !dstFile.delete()));
                    if (bl2) {
                        if (onError.invoke(dstFile, new FileAlreadyExistsException(src, dstFile, "The destination file already exists.")) != OnErrorAction.TERMINATE) continue;
                        return false;
                    }
                }
                if (src.isDirectory()) {
                    dstFile.mkdirs();
                    continue;
                }
                if (FilesKt.copyTo$default(src, dstFile, overwrite, 0, 4, null).length() == src.length() || onError.invoke(src, new IOException("Source file wasn't copied completely, length of destination file differs.")) != OnErrorAction.TERMINATE) continue;
                return false;
            }
            return true;
        }
        catch (TerminateException terminateException) {
            return false;
        }
    }

    public static /* synthetic */ boolean copyRecursively$default(File file, File file2, boolean bl, Function2 function2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            function2 = copyRecursively.1.INSTANCE;
        }
        return FilesKt.copyRecursively(file, file2, bl, function2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean deleteRecursively(@NotNull File $this$deleteRecursively) {
        boolean bl;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter($this$deleteRecursively, "");
        Iterator $this$fold$iv = FilesKt.walkBottomUp($this$deleteRecursively);
        boolean accumulator$iv = true;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_3;
            void var1_2;
            Object element$iv = iterator2.next();
            File it = (File)element$iv;
            boolean res = accumulator$iv;
            bl = (it.delete() || !var1_2.exists()) && var2_3 != false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean startsWith(@NotNull File $this$startsWith, @NotNull File other) {
        void var1_1;
        FilePathComponents filePathComponents;
        Intrinsics.checkNotNullParameter($this$startsWith, "");
        Intrinsics.checkNotNullParameter(other, "");
        FilePathComponents components = FilesKt.toComponents($this$startsWith);
        FilePathComponents otherComponents = FilesKt.toComponents(other);
        if (!Intrinsics.areEqual(components.getRoot(), otherComponents.getRoot())) {
            return false;
        }
        if (components.getSize() < otherComponents.getSize()) {
            return false;
        }
        return ((Object)filePathComponents.getSegments().subList(0, otherComponents.getSize())).equals(var1_1.getSegments());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean startsWith(@NotNull File $this$startsWith, @NotNull String other) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$startsWith, "");
        Intrinsics.checkNotNullParameter(other, "");
        return FilesKt.startsWith(file, new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean endsWith(@NotNull File $this$endsWith, @NotNull File other) {
        void var3_4;
        void var2_3;
        void var0_1;
        Intrinsics.checkNotNullParameter($this$endsWith, "");
        Intrinsics.checkNotNullParameter(other, "");
        FilePathComponents components = FilesKt.toComponents($this$endsWith);
        FilePathComponents otherComponents = FilesKt.toComponents(other);
        if (otherComponents.isRooted()) {
            void var1_2;
            return Intrinsics.areEqual($this$endsWith, var1_2);
        }
        int shift = components.getSize() - otherComponents.getSize();
        if (shift < 0) {
            return false;
        }
        return ((Object)components.getSegments().subList((int)var0_1, var2_3.getSize())).equals(var3_4.getSegments());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean endsWith(@NotNull File $this$endsWith, @NotNull String other) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$endsWith, "");
        Intrinsics.checkNotNullParameter(other, "");
        return FilesKt.endsWith(file, new File((String)var1_1));
    }

    @NotNull
    public static final File normalize(@NotNull File $this$normalize) {
        Object object;
        Intrinsics.checkNotNullParameter($this$normalize, "");
        Object $this$normalize_u24lambda_u245 = $this$normalize = FilesKt.toComponents((File)$this$normalize);
        File file = ((FilePathComponents)$this$normalize).getRoot();
        Iterable iterable = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(((FilePathComponents)object).getSegments());
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue(string, "");
        return FilesKt.resolve(file, CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null));
    }

    private static final FilePathComponents normalize$FilesKt__UtilsKt(FilePathComponents $this$normalize) {
        FilePathComponents filePathComponents;
        return new FilePathComponents($this$normalize.getRoot(), FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(filePathComponents.getSegments()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> normalize$FilesKt__UtilsKt(List<? extends File> $this$normalize) {
        void var1_1;
        Iterator<? extends File> iterator2;
        List list = new ArrayList($this$normalize.size());
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            File file = (File)iterator2.next();
            String string = file.getName();
            if (Intrinsics.areEqual(string, ".")) continue;
            if (Intrinsics.areEqual(string, "..")) {
                if (!list.isEmpty() && !Intrinsics.areEqual(((File)CollectionsKt.last(list)).getName(), "..")) {
                    List list2 = list;
                    list2.remove(list2.size() - 1);
                    continue;
                }
                list.add(file);
                continue;
            }
            list.add(var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File resolve(@NotNull File $this$resolve, @NotNull File relative) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$resolve, "");
        Intrinsics.checkNotNullParameter(relative, "");
        if (FilesKt.isRooted(relative)) {
            return relative;
        }
        String string2 = $this$resolve.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "");
        String baseName = string2;
        if (((CharSequence)string2).length() == 0 || StringsKt.endsWith$default((CharSequence)baseName, File.separatorChar, false, 2, null)) {
            return new File((String)baseName + relative);
        }
        return new File((String)string + File.separatorChar + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File resolve(@NotNull File $this$resolve, @NotNull String relative) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$resolve, "");
        Intrinsics.checkNotNullParameter(relative, "");
        return FilesKt.resolve(file, new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File resolveSibling(@NotNull File $this$resolveSibling, @NotNull File relative) {
        void var1_1;
        void var2_2;
        FilePathComponents filePathComponents;
        Intrinsics.checkNotNullParameter($this$resolveSibling, "");
        Intrinsics.checkNotNullParameter(relative, "");
        FilePathComponents components = FilesKt.toComponents($this$resolveSibling);
        File parentSubPath = components.getSize() == 0 ? new File("..") : components.subPath(0, components.getSize() - 1);
        return FilesKt.resolve(FilesKt.resolve(filePathComponents.getRoot(), (File)var2_2), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File resolveSibling(@NotNull File $this$resolveSibling, @NotNull String relative) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$resolveSibling, "");
        Intrinsics.checkNotNullParameter(relative, "");
        return FilesKt.resolveSibling(file, new File((String)var1_1));
    }
}

