/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.internal.InlineOnly;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.ExposingBufferByteArrayOutputStream;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__FilePathComponentsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000z\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a!\u0010\n\u001a\u00020\u000b*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u0087\b\u001a!\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u0087\b\u001aB\u0010\u0010\u001a\u00020\u0001*\u00020\u000226\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00010\u0012\u001aJ\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\r26\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00010\u0012\u001a7\u0010\u0018\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00010\u0019\u001a\r\u0010\u001b\u001a\u00020\u001c*\u00020\u0002H\u0087\b\u001a\r\u0010\u001d\u001a\u00020\u001e*\u00020\u0002H\u0087\b\u001a\u0017\u0010\u001f\u001a\u00020 *\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\tH\u0087\b\u001a\n\u0010!\u001a\u00020\u0004*\u00020\u0002\u001a\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0014\u0010$\u001a\u00020\u0007*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0017\u0010%\u001a\u00020&*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\tH\u0087\b\u001a?\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2\u0018\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070*\u0012\u0004\u0012\u0002H(0\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+\u001a\u0012\u0010,\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010-\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0017\u0010.\u001a\u00020/*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\tH\u0087\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00060"}, d2={"appendBytes", "", "Ljava/io/File;", "array", "", "appendText", "text", "", "charset", "Ljava/nio/charset/Charset;", "bufferedReader", "Ljava/io/BufferedReader;", "bufferSize", "", "bufferedWriter", "Ljava/io/BufferedWriter;", "forEachBlock", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "buffer", "bytesRead", "blockSize", "forEachLine", "Lkotlin/Function1;", "line", "inputStream", "Ljava/io/FileInputStream;", "outputStream", "Ljava/io/FileOutputStream;", "printWriter", "Ljava/io/PrintWriter;", "readBytes", "readLines", "", "readText", "reader", "Ljava/io/InputStreamReader;", "useLines", "T", "block", "Lkotlin/sequences/Sequence;", "(Ljava/io/File;Ljava/nio/charset/Charset;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "writeBytes", "writeText", "writer", "Ljava/io/OutputStreamWriter;", "kotlin-stdlib"}, xs="kotlin/io/FilesKt")
@SourceDebugExtension(value={"SMAP\nFileReadWrite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
class FilesKt__FileReadWriteKt
extends FilesKt__FilePathComponentsKt {
    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final InputStreamReader reader(File $this$reader, Charset charset) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$reader, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new InputStreamReader((InputStream)new FileInputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ InputStreamReader reader$default(File $this$reader_u24default, Charset charset, int n2, Object object) {
        void var1_1;
        File file;
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$reader_u24default, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new InputStreamReader((InputStream)new FileInputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedReader bufferedReader(File $this$bufferedReader, Charset charset, int bufferSize) {
        void var2_2;
        void var1_1;
        Reader reader;
        Intrinsics.checkNotNullParameter($this$bufferedReader, "");
        Intrinsics.checkNotNullParameter(charset, "");
        reader = new InputStreamReader((InputStream)new FileInputStream((File)((Object)reader)), (Charset)var1_1);
        return new BufferedReader(reader, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedReader bufferedReader$default(File $this$bufferedReader_u24default, Charset charset, int bufferSize, int n2, Object object) {
        void var2_2;
        void var1_1;
        File file;
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 2) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$bufferedReader_u24default, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Object object2 = file;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), (Charset)var1_1);
        return new BufferedReader((Reader)object2, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final OutputStreamWriter writer(File $this$writer, Charset charset) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$writer, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ OutputStreamWriter writer$default(File $this$writer_u24default, Charset charset, int n2, Object object) {
        void var1_1;
        File file;
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$writer_u24default, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedWriter bufferedWriter(File $this$bufferedWriter, Charset charset, int bufferSize) {
        void var2_2;
        void var1_1;
        Writer writer;
        Intrinsics.checkNotNullParameter($this$bufferedWriter, "");
        Intrinsics.checkNotNullParameter(charset, "");
        writer = new OutputStreamWriter((OutputStream)new FileOutputStream((File)((Object)writer)), (Charset)var1_1);
        return new BufferedWriter(writer, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedWriter bufferedWriter$default(File $this$bufferedWriter_u24default, Charset charset, int bufferSize, int n2, Object object) {
        void var2_2;
        void var1_1;
        File file;
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 2) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$bufferedWriter_u24default, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Object object2 = file;
        object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), (Charset)var1_1);
        return new BufferedWriter((Writer)object2, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final PrintWriter printWriter(File $this$printWriter, Charset charset) {
        void var1_1;
        Writer writer;
        Intrinsics.checkNotNullParameter($this$printWriter, "");
        Intrinsics.checkNotNullParameter(charset, "");
        writer = new OutputStreamWriter((OutputStream)new FileOutputStream((File)((Object)writer)), (Charset)var1_1);
        return new PrintWriter(new BufferedWriter(writer, 8192));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ PrintWriter printWriter$default(File $this$printWriter_u24default, Charset charset, int n2, Object object) {
        void var1_1;
        Object object2;
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$printWriter_u24default, "");
        Intrinsics.checkNotNullParameter(charset, "");
        File file = object2;
        object2 = file;
        object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), (Charset)var1_1);
        return new PrintWriter(new BufferedWriter((Writer)object2, 8192));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] readBytes(@NotNull File $this$readBytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$readBytes, "");
        Closeable closeable = new FileInputStream($this$readBytes);
        Throwable throwable = null;
        try {
            byte[] byArray2;
            int read;
            long l2;
            FileInputStream input = (FileInputStream)closeable;
            int offset = 0;
            long length = l2 = $this$readBytes.length();
            if (l2 > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("File " + $this$readBytes + " is too big (" + length + " bytes) to fit in memory.");
            }
            int remaining = (int)l2;
            byte[] result = new byte[remaining];
            while (remaining > 0 && (read = input.read(result, offset, remaining)) >= 0) {
                remaining -= read;
                offset += read;
            }
            if (remaining > 0) {
                byte[] byArray3 = Arrays.copyOf(result, offset);
                byArray2 = byArray3;
                Intrinsics.checkNotNullExpressionValue(byArray3, "");
            } else {
                int extraByte = input.read();
                if (extraByte == -1) {
                    byArray2 = result;
                } else {
                    void var3_4;
                    ExposingBufferByteArrayOutputStream extra = new ExposingBufferByteArrayOutputStream(8193);
                    extra.write(extraByte);
                    ByteStreamsKt.copyTo$default(input, extra, 0, 2, null);
                    int resultingSize = result.length + extra.size();
                    if (resultingSize < 0) {
                        File file;
                        throw new OutOfMemoryError("File " + file + " is too big to fit in memory.");
                    }
                    byte[] byArray4 = extra.getBuffer();
                    byte[] byArray5 = Arrays.copyOf(result, (int)var3_4);
                    Intrinsics.checkNotNullExpressionValue(byArray5, "");
                    byArray2 = ArraysKt.copyInto(byArray4, byArray5, result.length, 0, extra.size());
                }
            }
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeBytes(@NotNull File $this$writeBytes, @NotNull byte[] array) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$writeBytes, "");
        Intrinsics.checkNotNullParameter(array, "");
        closeable = new FileOutputStream((File)((Object)closeable));
        Throwable throwable = null;
        try {
            void var1_1;
            FileOutputStream fileOutputStream = (FileOutputStream)closeable;
            fileOutputStream.write((byte[])var1_1);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendBytes(@NotNull File $this$appendBytes, @NotNull byte[] array) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$appendBytes, "");
        Intrinsics.checkNotNullParameter(array, "");
        closeable = new FileOutputStream((File)((Object)closeable), true);
        Throwable throwable = null;
        try {
            void var1_1;
            FileOutputStream fileOutputStream = (FileOutputStream)closeable;
            fileOutputStream.write((byte[])var1_1);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return;
    }

    @NotNull
    public static final String readText(@NotNull File $this$readText, @NotNull Charset charset) {
        Object object;
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$readText, "");
        Intrinsics.checkNotNullParameter(charset, "");
        closeable = new InputStreamReader((InputStream)new FileInputStream((File)((Object)closeable)), (Charset)((Object)throwable));
        throwable = null;
        try {
            object = (InputStreamReader)closeable;
            object = TextStreamsKt.readText((Reader)object);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return object;
    }

    public static /* synthetic */ String readText$default(File file, Charset charset, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FilesKt.readText(file, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeText(@NotNull File $this$writeText, @NotNull String text, @NotNull Charset charset) {
        File file;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$writeText, "");
        Intrinsics.checkNotNullParameter(text, "");
        Intrinsics.checkNotNullParameter(charset, "");
        byte[] byArray = var1_1.getBytes((Charset)var2_2);
        Intrinsics.checkNotNullExpressionValue(byArray, "");
        FilesKt.writeBytes(file, byArray);
    }

    public static /* synthetic */ void writeText$default(File file, String string, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.writeText(file, string, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendText(@NotNull File $this$appendText, @NotNull String text, @NotNull Charset charset) {
        File file;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$appendText, "");
        Intrinsics.checkNotNullParameter(text, "");
        Intrinsics.checkNotNullParameter(charset, "");
        byte[] byArray = var1_1.getBytes((Charset)var2_2);
        Intrinsics.checkNotNullExpressionValue(byArray, "");
        FilesKt.appendBytes(file, byArray);
    }

    public static /* synthetic */ void appendText$default(File file, String string, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.appendText(file, string, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final void forEachBlock(@NotNull File $this$forEachBlock, @NotNull Function2<? super byte[], ? super Integer, Unit> action) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$forEachBlock, "");
        Intrinsics.checkNotNullParameter(action, "");
        FilesKt.forEachBlock(file, 4096, (Function2<? super byte[], ? super Integer, Unit>)var1_1);
    }

    public static final void forEachBlock(@NotNull File $this$forEachBlock, int blockSize, @NotNull Function2<? super byte[], ? super Integer, Unit> action) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$forEachBlock, "");
        Intrinsics.checkNotNullParameter(action, "");
        byte[] arr = new byte[RangesKt.coerceAtLeast(blockSize, 512)];
        closeable = new FileInputStream((File)((Object)closeable));
        Throwable throwable = null;
        try {
            int size;
            FileInputStream input = (FileInputStream)closeable;
            while ((size = input.read(arr)) > 0) {
                action.invoke((byte[])arr, (Integer)size);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static final void forEachLine(@NotNull File $this$forEachLine, @NotNull Charset charset, @NotNull Function1<? super String, Unit> action) {
        void var2_2;
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$forEachLine, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(action, "");
        TextStreamsKt.forEachLine(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), (Charset)var1_1)), (Function1<? super String, Unit>)var2_2);
    }

    public static /* synthetic */ void forEachLine$default(File file, Charset charset, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.forEachLine(file, charset, function1);
    }

    @InlineOnly
    private static final FileInputStream inputStream(File $this$inputStream) {
        File file;
        Intrinsics.checkNotNullParameter($this$inputStream, "");
        return new FileInputStream(file);
    }

    @InlineOnly
    private static final FileOutputStream outputStream(File $this$outputStream) {
        File file;
        Intrinsics.checkNotNullParameter($this$outputStream, "");
        return new FileOutputStream(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> readLines(@NotNull File $this$readLines, @NotNull Charset charset) {
        void var2_2;
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$readLines, "");
        Intrinsics.checkNotNullParameter(charset, "");
        ArrayList<String> result = new ArrayList<String>();
        FilesKt.forEachLine(file, (Charset)var1_1, (Function1<? super String, Unit>)new Function1<String, Unit>(result){
            final /* synthetic */ ArrayList<String> $result;
            {
                void var1_1;
                this.$result = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String it) {
                void var1_1;
                Intrinsics.checkNotNullParameter(it, "");
                this.$result.add((String)var1_1);
            }
        });
        return (List)var2_2;
    }

    public static /* synthetic */ List readLines$default(File file, Charset charset, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FilesKt.readLines(file, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T useLines(@NotNull File $this$useLines, @NotNull Charset charset, @NotNull Function1<? super Sequence<String>, ? extends T> block) {
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$useLines, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(block, "");
        Object object = closeable;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)((Object)throwable));
        closeable = new BufferedReader((Reader)object, 8192);
        throwable = null;
        try {
            void var2_2;
            BufferedReader it = (BufferedReader)closeable;
            object = var2_2.invoke(TextStreamsKt.lineSequence((BufferedReader)object));
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (throwable == null) {
                    closeable.close();
                } else {
                    try {
                        closeable.close();
                    }
                    catch (Throwable throwable4) {}
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Object useLines$default(File $this$useLines_u24default, Charset charset, Function1 block, int n2, Object object) {
        void var1_1;
        Serializable serializable;
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$useLines_u24default, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(block, "");
        Object object2 = object = serializable;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), (Charset)var1_1);
        object = new BufferedReader((Reader)object2, 8192);
        serializable = null;
        try {
            void var2_2;
            BufferedReader it = (BufferedReader)object;
            object2 = var2_2.invoke(TextStreamsKt.lineSequence((BufferedReader)object2));
        }
        catch (Throwable throwable) {
            try {
                object2 = throwable;
                serializable = throwable;
                throw object2;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)serializable);
                } else if (serializable == null) {
                    object.close();
                } else {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable3) {}
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, null);
        } else {
            object.close();
        }
        InlineMarker.finallyEnd(1);
        return object2;
    }
}

