/*
 * Decompiled with CFR 0.152.
 */
package com.sztech.gateway.shared.core.cache.impl;

import com.sztech.gateway.shared.core.cache.impl.AbstractCache;
import com.sztech.gateway.shared.core.cache.impl.CacheObj;
import com.sztech.gateway.shared.core.cache.impl.CacheObjIterator;
import com.sztech.gateway.shared.core.common.CopiedIter;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ReentrantCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 2897849443739409132L;
    protected final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(K key, V object, long timeout2) {
        this.lock.lock();
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            this.putWithoutLock(var1_1, var2_3, (long)var3_4);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(K key) {
        void var1_1;
        return null != this.getOrRemoveExpired(var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        void var2_2;
        void var1_1;
        return this.getOrRemoveExpired(var1_1, (boolean)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        void var1_1;
        this.lock.lock();
        try {
            CopiedIter copiedIterator = CopiedIter.copyOf(this.cacheObjIter());
        }
        finally {
            this.lock.unlock();
        }
        return new CacheObjIterator(var1_1);
    }

    @Override
    public final int prune() {
        this.lock.lock();
        try {
            int n2 = this.pruneCache();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(K key) {
        CacheObj co;
        this.lock.lock();
        try {
            co = this.removeWithoutLock(key);
        }
        finally {
            this.lock.unlock();
        }
        if (co != null) {
            void var1_1;
            this.onRemove(co.key, var1_1.obj);
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.cacheMap.clear();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private V getOrRemoveExpired(K key, boolean isUpdateLastAccess, boolean isUpdateCount) {
        void var2_3;
        void var3_4;
        CacheObj co;
        this.lock.lock();
        try {
            co = this.getWithoutLock(key);
            if (co != null && co.isExpired()) {
                void var1_1;
                this.removeWithoutLock(var1_1);
                co = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (co == null) {
            if (isUpdateCount) {
                this.missCount.increment();
            }
            return null;
        }
        if (var3_4 != false) {
            this.hitCount.increment();
        }
        return co.get((boolean)var2_3);
    }
}

