/*
 * Decompiled with CFR 0.152.
 */
package com.sztech.gateway.shared.core.cache.impl;

import com.sztech.gateway.shared.core.cache.Cache;
import com.sztech.gateway.shared.core.cache.CacheListener;
import com.sztech.gateway.shared.core.cache.impl.CacheObj;
import com.sztech.gateway.shared.core.cache.impl.CacheObjIterator;
import com.sztech.gateway.shared.core.cache.impl.CacheValuesIterator;
import com.sztech.gateway.shared.core.common.Func0;
import com.sztech.gateway.shared.core.common.Mutable;
import com.sztech.gateway.shared.core.common.MutableObj;
import com.sztech.gateway.shared.core.common.SafeConcurrentHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 8585606481050661305L;
    protected Map<Mutable<K>, CacheObj<K, V>> cacheMap;
    protected final SafeConcurrentHashMap<K, Lock> keyLockMap = new SafeConcurrentHashMap();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected LongAdder hitCount = new LongAdder();
    protected LongAdder missCount = new LongAdder();
    protected CacheListener<K, V> listener;

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(K key, V object) {
        void var2_2;
        void var1_1;
        this.put(var1_1, var2_2, this.timeout);
    }

    /*
     * WARNING - void declaration
     */
    protected void putWithoutLock(K key, V object, long timeout2) {
        void var2_2;
        void var1_1;
        MutableObj<K> mKey;
        void var3_3;
        CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout2);
        if (var3_3 != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.cacheMap.containsKey(mKey = MutableObj.of(key))) {
            this.cacheMap.put(mKey, co);
            return;
        }
        if (this.isFull()) {
            this.pruneCache();
        }
        this.cacheMap.put((Mutable<void>)var1_1, (CacheObj<void, void>)var2_2);
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess, Func0<V> supplier) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.get(var1_1, (boolean)var2_2, this.timeout, (Func0<V>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess, long timeout2, Func0<V> supplier) {
        Object v2 = this.get(key, isUpdateLastAccess);
        if (v2 == null && supplier != null) {
            Lock keyLock = this.keyLockMap.computeIfAbsent(key, k2 -> new ReentrantLock());
            keyLock.lock();
            try {
                void var2_2;
                v2 = this.get(key, (boolean)var2_2);
                if (v2 == null) {
                    void var3_4;
                    v2 = supplier.callWithRuntimeException();
                    this.put(key, v2, (long)var3_4);
                }
                keyLock.unlock();
            }
            catch (Throwable throwable) {
                void var1_1;
                keyLock.unlock();
                this.keyLockMap.remove(var1_1);
                throw throwable;
            }
            this.keyLockMap.remove(key);
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    protected CacheObj<K, V> getWithoutLock(K key) {
        void var1_1;
        return this.cacheMap.get(MutableObj.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<V> iterator() {
        void var1_1;
        CacheObjIterator copiedIterator = (CacheObjIterator)this.cacheObjIterator();
        return new CacheValuesIterator(var1_1);
    }

    protected abstract int pruneCache();

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractCache<K, V> setListener(CacheListener<K, V> listener) {
        void var1_1;
        this.listener = var1_1;
        return this;
    }

    public Set<K> keySet() {
        return this.cacheMap.keySet().stream().map(Mutable::get).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    protected void onRemove(K key, V cachedObject) {
        CacheListener<K, V> listener = this.listener;
        if (listener != null) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.onRemove(var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected CacheObj<K, V> removeWithoutLock(K key) {
        void var1_1;
        return this.cacheMap.remove(MutableObj.of(var1_1));
    }

    protected Iterator<CacheObj<K, V>> cacheObjIter() {
        return this.cacheMap.values().iterator();
    }
}

