/*
 * Decompiled with CFR 0.152.
 */
package com.sztech.gateway.shared.core;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class RSAUtil {
    private static final String RSA_ALGORITHM = "RSA";

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(int keySize) {
        try {
            int n2;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_ALGORITHM);
            keyPairGenerator.initialize(n2);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e2) {
            void var1_2;
            throw new RuntimeException("RSA\u7b97\u6cd5\u4e0d\u53ef\u7528", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String encryptWithPublicKey(String data, PublicKey publicKey) {
        try {
            Object object;
            void var1_1;
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, (Key)var1_1);
            Object encryptedData = cipher.doFinal(data.getBytes());
            return Base64.getEncoder().encodeToString((byte[])object);
        }
        catch (Exception e2) {
            void var2_3;
            throw new RuntimeException("\u516c\u94a5\u52a0\u5bc6\u5931\u8d25", (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String decryptWithPrivateKey(String encryptedData, PrivateKey privateKey) {
        try {
            Object object;
            void var1_1;
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, (Key)var1_1);
            Object decryptedData = cipher.doFinal(Base64.getDecoder().decode(encryptedData));
            return new String((byte[])object);
        }
        catch (Exception e2) {
            void var2_3;
            throw new RuntimeException("\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25", (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String sign(String data, PrivateKey privateKey) {
        try {
            String string;
            void var1_1;
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign((PrivateKey)var1_1);
            signature.update(string.getBytes());
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e2) {
            void var2_3;
            throw new RuntimeException("\u7b7e\u540d\u5931\u8d25", (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verify(String data, String sign, PublicKey publicKey) {
        try {
            void var1_1;
            String string;
            void var2_2;
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify((PublicKey)var2_2);
            signature.update(string.getBytes());
            return signature.verify(Base64.getDecoder().decode((String)var1_1));
        }
        catch (Exception e2) {
            void var3_4;
            throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25", (Throwable)var3_4);
        }
    }

    public static String publicKeyToBase64(PublicKey publicKey) {
        PublicKey publicKey2;
        return Base64.getEncoder().encodeToString(publicKey2.getEncoded());
    }

    public static String privateKeyToBase64(PrivateKey privateKey) {
        PrivateKey privateKey2;
        return Base64.getEncoder().encodeToString(privateKey2.getEncoded());
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey getPublicKeyFromString(String base64PublicKey) {
        try {
            Object keyBytes = Base64.getDecoder().decode(base64PublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePublic(new X509EncodedKeySpec((byte[])keyBytes));
        }
        catch (Exception e2) {
            void var0_1;
            throw new RuntimeException("\u516c\u94a5\u89e3\u6790\u5931\u8d25", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey getPrivateKeyFromString(String base64PrivateKey) {
        try {
            Object keyBytes = Base64.getDecoder().decode(base64PrivateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec((byte[])keyBytes));
        }
        catch (Exception e2) {
            void var0_1;
            throw new RuntimeException("\u79c1\u94a5\u89e3\u6790\u5931\u8d25", (Throwable)var0_1);
        }
    }
}

