/*
 * Decompiled with CFR 0.152.
 */
package com.sztech.gateway.shared.core;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class NetworkUtils {
    private static final String ANYHOST_VALUE = "0.0.0.0";
    private static final String LOCALHOST_VALUE = "127.0.0.1";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3}$");
    private static volatile InetAddress LOCAL_ADDRESS = null;

    public static String getIp() {
        return NetworkUtils.getLocalAddress().getHostAddress();
    }

    /*
     * WARNING - void declaration
     */
    public static InetAddress getLocalAddress() {
        void var0;
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetworkUtils.findFirstNonLoopbackAddress();
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress findFirstNonLoopbackAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces == null) {
                return InetAddress.getLocalHost();
            }
            while (interfaces.hasMoreElements()) {
                String name;
                NetworkInterface iface = interfaces.nextElement();
                if (!iface.isUp() || iface.isLoopback() || iface.isVirtual() || (name = iface.getName()).startsWith("docker") || name.startsWith("veth") || name.startsWith("virbr")) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    void var2_2;
                    InetAddress addr = addresses.nextElement();
                    if (!NetworkUtils.isValidV4Address(addr)) continue;
                    return var2_2;
                }
            }
        }
        catch (Exception exception) {}
        try {
            InetAddress fallback = InetAddress.getLocalHost();
            if (NetworkUtils.isValidV4Address(fallback)) {
                void var0;
                return var0;
            }
            return null;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isValidV4Address(InetAddress address) {
        InetAddress inetAddress;
        void var1_1;
        if (address == null || address.isLoopbackAddress() || !(address instanceof Inet4Address)) {
            return false;
        }
        String hostAddress = address.getHostAddress();
        return hostAddress != null && IP_PATTERN.matcher(hostAddress).matches() && !ANYHOST_VALUE.equals(hostAddress) && !LOCALHOST_VALUE.equals(var1_1) && !inetAddress.isLinkLocalAddress();
    }

    private static boolean isPreferIPv6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress normalizeV6Address(Inet6Address address) {
        Inet6Address inet6Address;
        String addr = address.getHostAddress();
        int i2 = addr.lastIndexOf(37);
        if (i2 > 0) {
            try {
                void var2_2;
                void var1_1;
                return InetAddress.getByName(var1_1.substring(0, (int)var2_2) + '%' + address.getScopeId());
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return inet6Address;
    }
}

