/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.util;

import com.alibaba.ttl.threadpool.agent.internal.javassist.util.Trigger;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.Mirror;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HotSwapper {
    private VirtualMachine jvm = null;
    private MethodEntryRequest request = null;
    private Map<ReferenceType, byte[]> newClassFiles = null;
    private Trigger trigger = new Trigger();
    private static final String HOST_NAME = "localhost";
    private static final String TRIGGER_NAME = Trigger.class.getName();

    /*
     * WARNING - void declaration
     */
    public HotSwapper(int port) throws IOException, IllegalConnectorArgumentsException {
        this(Integer.toString((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HotSwapper(String port) throws IOException, IllegalConnectorArgumentsException {
        void var1_1;
        void var3_3;
        void var2_2;
        AttachingConnector connector = (AttachingConnector)this.findConnector("com.sun.jdi.SocketAttach");
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        arguments.get("hostname").setValue(HOST_NAME);
        arguments.get("port").setValue(port);
        this.jvm = var2_2.attach((Map<String, ? extends Connector.Argument>)var3_3);
        EventRequestManager manager = this.jvm.eventRequestManager();
        this.request = HotSwapper.methodEntryRequests((EventRequestManager)var1_1, TRIGGER_NAME);
    }

    /*
     * WARNING - void declaration
     */
    private Connector findConnector(String connector) throws IOException {
        void var1_1;
        Object object = Bootstrap.virtualMachineManager().allConnectors();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Connector con = (Connector)object.next();
            if (!con.name().equals(connector)) continue;
            return var3_3;
        }
        throw new IOException("Not found: " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static MethodEntryRequest methodEntryRequests(EventRequestManager manager, String classpattern) {
        Mirror mirror;
        void var1_1;
        Mirror mereq = manager.createMethodEntryRequest();
        mereq.addClassFilter((String)var1_1);
        mereq.setSuspendPolicy(1);
        return mirror;
    }

    /*
     * WARNING - void declaration
     */
    private void deleteEventRequest(EventRequestManager manager, MethodEntryRequest request) {
        void var2_2;
        manager.deleteEventRequest((EventRequest)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void reload(String className, byte[] classFile) {
        void var1_1;
        void var2_2;
        void var3_3;
        ReferenceType classtype = this.toRefType(className);
        HashMap<ReferenceType, byte[]> map = new HashMap<ReferenceType, byte[]>();
        map.put((ReferenceType)var3_3, (byte[])var2_2);
        this.reload2(map, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void reload(Map<String, byte[]> classFiles) {
        Iterator iterator2;
        HashMap<ReferenceType, byte[]> map = new HashMap<ReferenceType, byte[]>();
        String className = null;
        for (Map.Entry e2 : iterator2.entrySet()) {
            className = (String)e2.getKey();
            map.put(this.toRefType(className), (byte[])e2.getValue());
        }
        if (className != null) {
            void var3_3;
            void var2_2;
            this.reload2((Map<ReferenceType, byte[]>)var2_2, (String)var3_3 + " etc.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private ReferenceType toRefType(String className) {
        void var2_2;
        List<ReferenceType> list = this.jvm.classesByName(className);
        if (list == null || list.isEmpty()) {
            void var1_1;
            throw new RuntimeException("no such class: " + (String)var1_1);
        }
        return (ReferenceType)var2_2.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private void reload2(Map<ReferenceType, byte[]> map, String msg) {
        Trigger trigger = this.trigger;
        synchronized (trigger) {
            Map<ReferenceType, byte[]> map2;
            this.startDaemon();
            this.newClassFiles = map2;
            this.request.enable();
            this.trigger.doSwap();
            this.request.disable();
            map2 = this.newClassFiles;
            if (map2 != null) {
                void var2_3;
                this.newClassFiles = null;
                throw new RuntimeException("failed to reload: " + (String)var2_3);
            }
            return;
        }
    }

    private void startDaemon() {
        new Thread(this){
            final /* synthetic */ HotSwapper this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            private void errorMsg(Throwable e2) {
                void var1_1;
                System.err.print("Exception in thread \"HotSwap\" ");
                var1_1.printStackTrace(System.err);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                EventSet events = null;
                try {
                    events = this.this$0.waitEvent();
                    EventIterator iter = events.eventIterator();
                    while (iter.hasNext()) {
                        Event event = iter.nextEvent();
                        if (!(event instanceof MethodEntryEvent)) continue;
                        this.this$0.hotswap();
                        break;
                    }
                }
                catch (Throwable e2) {
                    this.errorMsg(e2);
                }
                try {
                    if (events != null) {
                        void var1_1;
                        var1_1.resume();
                    }
                    return;
                }
                catch (Throwable e3) {
                    void var2_4;
                    this.errorMsg((Throwable)var2_4);
                    return;
                }
            }
        }.start();
    }

    EventSet waitEvent() throws InterruptedException {
        EventQueue eventQueue = this.jvm.eventQueue();
        return eventQueue.remove();
    }

    /*
     * WARNING - void declaration
     */
    void hotswap() {
        void var1_1;
        Map<ReferenceType, byte[]> map = this.newClassFiles;
        this.jvm.redefineClasses((Map<? extends ReferenceType, byte[]>)var1_1);
        this.newClassFiles = null;
    }
}

