/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.tools.web;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Translator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.web.BadHttpRequest;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.web.ServiceThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class Webserver {
    private ServerSocket socket;
    private ClassPool classPool;
    protected Translator translator;
    private static final byte[] endofline = new byte[]{13, 10};
    private static final int typeHtml = 1;
    private static final int typeClass = 2;
    private static final int typeGif = 3;
    private static final int typeJpeg = 4;
    private static final int typeText = 5;
    public String debugDir = null;
    public String htmlfileBase = null;

    public static void main(String[] args2) throws IOException {
        if (args2.length == 1) {
            Object object;
            object = new Webserver(object[0]);
            object.run();
            return;
        }
        System.err.println("Usage: java javassist.tools.web.Webserver <port number>");
    }

    /*
     * WARNING - void declaration
     */
    public Webserver(String port) throws IOException {
        this(Integer.parseInt((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Webserver(int port) throws IOException {
        void var1_1;
        this.socket = new ServerSocket((int)var1_1);
        this.classPool = null;
        this.translator = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setClassPool(ClassPool loader) {
        void var1_1;
        this.classPool = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addTranslator(ClassPool cp, Translator t2) throws NotFoundException, CannotCompileException {
        void var2_2;
        void var1_1;
        this.classPool = var1_1;
        this.translator = t2;
        var2_2.start(this.classPool);
    }

    public void end() throws IOException {
        this.socket.close();
    }

    /*
     * WARNING - void declaration
     */
    public void logging(String msg) {
        void var1_1;
        System.out.println((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void logging(String msg1, String msg2) {
        void var2_2;
        void var1_1;
        System.out.print((String)var1_1);
        System.out.print(" ");
        System.out.println((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void logging(String msg1, String msg2, String msg3) {
        void var3_3;
        void var2_2;
        void var1_1;
        System.out.print((String)var1_1);
        System.out.print(" ");
        System.out.print((String)var2_2);
        System.out.print(" ");
        System.out.println((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void logging2(String msg) {
        void var1_1;
        System.out.print("    ");
        System.out.println((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        System.err.println("ready to service...");
        while (true) {
            try {
                while (true) {
                    Webserver webserver = this;
                    ServiceThread serviceThread = new ServiceThread(webserver, webserver.socket.accept());
                    serviceThread.start();
                }
            }
            catch (IOException e2) {
                void var1_2;
                this.logging(var1_2.toString());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void process(Socket clnt) throws IOException {
        void var1_1;
        void var2_2;
        BufferedInputStream in = new BufferedInputStream(clnt.getInputStream());
        String cmd = this.readLine(in);
        this.logging(clnt.getInetAddress().getHostName(), new Date().toString(), cmd);
        while (this.skipLine(in) > 0) {
        }
        BufferedOutputStream out = new BufferedOutputStream(clnt.getOutputStream());
        try {
            this.doReply(in, out, cmd);
        }
        catch (BadHttpRequest e2) {
            void var3_4;
            this.replyError(out, (BadHttpRequest)var3_4);
        }
        ((OutputStream)out).flush();
        var2_2.close();
        ((OutputStream)out).close();
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    private String readLine(InputStream in) throws IOException {
        void var2_2;
        void var1_1;
        int c2;
        StringBuilder buf = new StringBuilder();
        while ((c2 = in.read()) >= 0 && c2 != 13) {
            void var3_3;
            buf.append((char)var3_3);
        }
        var1_1.read();
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private int skipLine(InputStream in) throws IOException {
        void var3_2;
        void var1_1;
        void var2_3;
        int c2;
        int len = 0;
        while ((c2 = in.read()) >= 0 && var2_3 != 13) {
            ++len;
        }
        var1_1.read();
        return (int)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public void doReply(InputStream in, OutputStream out, String cmd) throws IOException, BadHttpRequest {
        void fin2;
        File file;
        String urlName;
        if (!cmd.startsWith("GET /")) {
            throw new BadHttpRequest();
        }
        String filename = urlName = cmd.substring(5, cmd.indexOf(32, 5));
        int fileType = filename.endsWith(".class") ? 2 : (filename.endsWith(".html") || filename.endsWith(".htm") ? 1 : (filename.endsWith(".gif") ? 3 : (filename.endsWith(".jpg") ? 4 : 5)));
        int len = filename.length();
        if (fileType == 2 && this.letUsersSendClassfile(out, filename, len)) {
            return;
        }
        this.checkFilename(filename, len);
        if (this.htmlfileBase != null) {
            filename = this.htmlfileBase + filename;
        }
        if (File.separatorChar != '/') {
            filename = filename.replace('/', File.separatorChar);
        }
        if ((file = new File(filename)).canRead()) {
            this.sendHeader(out, file.length(), fileType);
            FileInputStream fin2 = new FileInputStream(file);
            byte[] filebuffer = new byte[4096];
            while ((file = fin2.read(filebuffer)) > 0) {
                out.write(filebuffer, 0, file);
            }
            fin2.close();
            return;
        }
        if (fin2 == 2 && (fin = this.getClass().getResourceAsStream("/" + urlName)) != null) {
            void var3_11;
            void var1_6;
            void var2_7;
            ByteArrayOutputStream barray = new ByteArrayOutputStream();
            byte[] filebuffer = new byte[4096];
            while ((file = fin.read(filebuffer)) > 0) {
                barray.write(filebuffer, 0, file);
            }
            byte[] classfile = barray.toByteArray();
            this.sendHeader(out, classfile.length, 2);
            var2_7.write((byte[])var1_6);
            var3_11.close();
            return;
        }
        throw new BadHttpRequest();
    }

    /*
     * WARNING - void declaration
     */
    private void checkFilename(String filename, int len) throws BadHttpRequest {
        void var1_1;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = filename.charAt(i2);
            if (Character.isJavaIdentifierPart(c2) || c2 == '.' || c2 == '/') continue;
            throw new BadHttpRequest();
        }
        if (var1_1.indexOf("..") >= 0) {
            throw new BadHttpRequest();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean letUsersSendClassfile(OutputStream out, String filename, int length) throws IOException, BadHttpRequest {
        void var2_2;
        void var1_1;
        byte[] classfile;
        if (this.classPool == null) {
            return false;
        }
        String classname = filename.substring(0, length - 6).replace('/', '.');
        try {
            if (this.translator != null) {
                this.translator.onLoad(this.classPool, classname);
            }
            CtClass c2 = this.classPool.get(classname);
            classfile = c2.toBytecode();
            if (this.debugDir != null) {
                c2.writeFile(this.debugDir);
            }
        }
        catch (Exception e2) {
            void var3_5;
            throw new BadHttpRequest((Exception)var3_5);
        }
        this.sendHeader(out, classfile.length, 2);
        var1_1.write((byte[])var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void sendHeader(OutputStream out, long dataLength, int filetype) throws IOException {
        void var1_1;
        void var2_2;
        out.write("HTTP/1.0 200 OK".getBytes());
        out.write(endofline);
        out.write("Content-Length: ".getBytes());
        out.write(Long.toString((long)var2_2).getBytes());
        out.write(endofline);
        if (filetype == 2) {
            out.write("Content-Type: application/octet-stream".getBytes());
        } else if (filetype == 1) {
            out.write("Content-Type: text/html".getBytes());
        } else if (filetype == 3) {
            out.write("Content-Type: image/gif".getBytes());
        } else if (filetype == 4) {
            out.write("Content-Type: image/jpg".getBytes());
        } else if (filetype == 5) {
            out.write("Content-Type: text/plain".getBytes());
        }
        out.write(endofline);
        var1_1.write(endofline);
    }

    /*
     * WARNING - void declaration
     */
    private void replyError(OutputStream out, BadHttpRequest e2) throws IOException {
        void var1_1;
        void var2_2;
        this.logging2("bad request: " + var2_2.toString());
        out.write("HTTP/1.0 400 Bad Request".getBytes());
        out.write(endofline);
        out.write(endofline);
        var1_1.write("<H1>Bad Request</H1>".getBytes());
    }
}

