/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtNewConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtNewMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Translator;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;

public class StubGenerator
implements Translator {
    private static final String fieldImporter = "importer";
    private static final String fieldObjectId = "objectId";
    private static final String accessorObjectId = "_getObjectId";
    private static final String sampleClass = "com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.Sample";
    private ClassPool classPool;
    private Map<String, CtClass> proxyClasses = new Hashtable<String, CtClass>();
    private CtMethod forwardMethod;
    private CtMethod forwardStaticMethod;
    private CtClass[] proxyConstructorParamTypes;
    private CtClass[] interfacesForProxy;
    private CtClass[] exceptionForProxy;

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(ClassPool pool) throws NotFoundException {
        void var1_1;
        void var2_2;
        this.classPool = pool;
        CtClass c2 = pool.get(sampleClass);
        this.forwardMethod = c2.getDeclaredMethod("forward");
        this.forwardStaticMethod = var2_2.getDeclaredMethod("forwardStatic");
        this.proxyConstructorParamTypes = pool.get(new String[]{"com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.ObjectImporter", "int"});
        this.interfacesForProxy = pool.get(new String[]{"java.io.Serializable", "com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.Proxy"});
        this.exceptionForProxy = new CtClass[]{var1_1.get("com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.RemoteException")};
    }

    @Override
    public void onLoad(ClassPool pool, String classname) {
    }

    /*
     * WARNING - void declaration
     */
    public boolean isProxyClass(String name) {
        void var1_1;
        return this.proxyClasses.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean makeProxyClass(Class<?> clazz) throws CannotCompileException, NotFoundException {
        void var1_1;
        void var2_2;
        String classname = clazz.getName();
        if (this.proxyClasses.get(classname) != null) {
            return false;
        }
        StubGenerator stubGenerator = this;
        CtClass ctclazz = stubGenerator.produceProxyClass(stubGenerator.classPool.get(classname), clazz);
        this.proxyClasses.put((String)var2_2, ctclazz);
        this.modifySuperclass((CtClass)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private CtClass produceProxyClass(CtClass orgclass, Class<?> orgRtClass) throws CannotCompileException, NotFoundException {
        void var3_5;
        int modify = orgclass.getModifiers();
        if (Modifier.isAbstract(modify) || Modifier.isNative(modify) || !Modifier.isPublic(modify)) {
            throw new CannotCompileException(orgclass.getName() + " must be public, non-native, and non-abstract.");
        }
        CtClass proxy = this.classPool.makeClass(orgclass.getName(), orgclass.getSuperclass());
        proxy.setInterfaces(this.interfacesForProxy);
        CtField f2 = new CtField(this.classPool.get("com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.ObjectImporter"), fieldImporter, proxy);
        ((CtMember)f2).setModifiers(2);
        proxy.addField(f2, CtField.Initializer.byParameter(0));
        f2 = new CtField(CtClass.intType, fieldObjectId, proxy);
        ((CtMember)f2).setModifiers(2);
        proxy.addField(f2, CtField.Initializer.byParameter(1));
        proxy.addMethod(CtNewMethod.getter(accessorObjectId, f2));
        CtClass ctClass = proxy;
        ctClass.addConstructor(CtNewConstructor.defaultConstructor(ctClass));
        CtConstructor cons = CtNewConstructor.skeleton(this.proxyConstructorParamTypes, null, proxy);
        proxy.addConstructor((CtConstructor)var3_5);
        try {
            void var2_3;
            this.addMethods(proxy, var2_3.getMethods());
            return proxy;
        }
        catch (SecurityException e2) {
            void var1_2;
            throw new CannotCompileException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CtClass toCtClass(Class<?> rtclass) throws NotFoundException {
        void var1_1;
        Object name;
        if (!rtclass.isArray()) {
            name = rtclass.getName();
        } else {
            void var2_2;
            StringBuilder sbuf = new StringBuilder();
            do {
                sbuf.append("[]");
            } while (((Class)(name = ((Class)name).getComponentType())).isArray());
            sbuf.insert(0, ((Class)name).getName());
            name = var2_2.toString();
        }
        return this.classPool.get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private CtClass[] toCtClass(Class<?>[] rtclasses) throws NotFoundException {
        void var3_3;
        int n2 = rtclasses.length;
        CtClass[] ctclasses = new CtClass[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctclasses[i2] = this.toCtClass(rtclasses[i2]);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void addMethods(CtClass proxy, Method[] ms) throws CannotCompileException, NotFoundException {
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Method m2 = ms[i2];
            int mod = m2.getModifiers();
            if (m2.getDeclaringClass() == Object.class || Modifier.isFinal(mod)) continue;
            if (Modifier.isPublic(mod)) {
                void var3_4;
                CtMethod body = Modifier.isStatic(mod) ? this.forwardStaticMethod : this.forwardMethod;
                CtMethod wmethod = CtNewMethod.wrapped(this.toCtClass(m2.getReturnType()), m2.getName(), this.toCtClass(m2.getParameterTypes()), this.exceptionForProxy, body, CtMethod.ConstParameter.integer(i2), proxy);
                ((CtMember)wmethod).setModifiers(mod);
                proxy.addMethod((CtMethod)var3_4);
                continue;
            }
            if (Modifier.isProtected(mod) || Modifier.isPrivate(mod)) continue;
            throw new CannotCompileException("the methods must be public, protected, or private.");
        }
    }

    private void modifySuperclass(CtClass orgclass) throws CannotCompileException, NotFoundException {
        CtClass superclazz;
        while ((superclazz = orgclass.getSuperclass()) != null) {
            try {
                superclazz.getDeclaredConstructor(null);
                return;
            }
            catch (NotFoundException notFoundException) {
                CtClass ctClass = superclazz;
                ctClass.addConstructor(CtNewConstructor.defaultConstructor(ctClass));
            }
        }
    }
}

