/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi;

import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.ObjectNotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.Proxy;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.RemoteException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.RemoteRef;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.net.Socket;
import java.net.URL;

public class ObjectImporter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] endofline = new byte[]{13, 10};
    private String servername;
    private String orgServername;
    private int port;
    private int orgPort;
    protected byte[] lookupCommand = "POST /lookup HTTP/1.0".getBytes();
    protected byte[] rmiCommand = "POST /rmi HTTP/1.0".getBytes();
    private static final Class<?>[] proxyConstructorParamTypes = new Class[]{ObjectImporter.class, Integer.TYPE};

    /*
     * WARNING - void declaration
     */
    public ObjectImporter(Applet applet) {
        void var1_1;
        URL codebase = applet.getCodeBase();
        ObjectImporter objectImporter = this;
        objectImporter.orgServername = objectImporter.servername = codebase.getHost();
        ObjectImporter objectImporter2 = this;
        objectImporter2.orgPort = objectImporter2.port = var1_1.getPort();
    }

    /*
     * WARNING - void declaration
     */
    public ObjectImporter(String servername, int port) {
        void var2_2;
        void var1_1;
        ObjectImporter objectImporter = this;
        objectImporter.orgServername = objectImporter.servername = var1_1;
        ObjectImporter objectImporter2 = this;
        objectImporter2.orgPort = objectImporter2.port = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Object getObject(String name) {
        try {
            void var1_1;
            return this.lookupObject((String)var1_1);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpProxy(String host, int port) {
        void var2_2;
        void var1_1;
        void var3_3;
        String proxyHeader = "POST http://" + this.orgServername + ":" + this.orgPort;
        String cmd = proxyHeader + "/lookup HTTP/1.0";
        this.lookupCommand = cmd.getBytes();
        cmd = (String)var3_3 + "/rmi HTTP/1.0";
        this.rmiCommand = cmd.getBytes();
        this.servername = var1_1;
        this.port = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Object lookupObject(String name) throws ObjectNotFoundException {
        void var1_1;
        try {
            void var3_4;
            Socket sock = new Socket(this.servername, this.port);
            OutputStream out = sock.getOutputStream();
            out.write(this.lookupCommand);
            out.write(this.endofline);
            out.write(this.endofline);
            ObjectOutputStream dout = new ObjectOutputStream(out);
            dout.writeUTF(name);
            dout.flush();
            BufferedInputStream in = new BufferedInputStream(sock.getInputStream());
            this.skipHeader(in);
            ObjectInputStream din = new ObjectInputStream(in);
            int n2 = din.readInt();
            String classname = din.readUTF();
            din.close();
            var3_4.close();
            sock.close();
            if (n2 >= 0) {
                return this.createProxy(n2, classname);
            }
        }
        catch (Exception exception) {
            void var2_3;
            Exception e2 = exception;
            exception.printStackTrace();
            throw new ObjectNotFoundException(name, (Exception)var2_3);
        }
        throw new ObjectNotFoundException((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Object createProxy(int oid, String classname) throws Exception {
        void var1_1;
        GenericDeclaration genericDeclaration = Class.forName(classname);
        genericDeclaration = genericDeclaration.getConstructor(proxyConstructorParamTypes);
        return ((Constructor)genericDeclaration).newInstance(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object call(int objectid, int methodid, Object[] args2) throws RemoteException {
        void var3_6;
        void var1_3;
        try {
            Socket sock = new Socket(this.servername, this.port);
            BufferedOutputStream out = new BufferedOutputStream(sock.getOutputStream());
            ((OutputStream)out).write(this.rmiCommand);
            ((OutputStream)out).write(this.endofline);
            ((OutputStream)out).write(this.endofline);
            ObjectOutputStream dout = new ObjectOutputStream(out);
            dout.writeInt(objectid);
            dout.writeInt(methodid);
            this.writeParameters(dout, args2);
            dout.flush();
            BufferedInputStream ins = new BufferedInputStream(sock.getInputStream());
            this.skipHeader(ins);
            ObjectInputStream din = new ObjectInputStream(ins);
            boolean result = din.readBoolean();
            Object rvalue = null;
            String errmsg = null;
            if (result) {
                rvalue = din.readObject();
            } else {
                errmsg = din.readUTF();
            }
            din.close();
            dout.close();
            sock.close();
            if (rvalue instanceof RemoteRef) {
                Object ref = (RemoteRef)rvalue;
                ref = this.createProxy(((RemoteRef)ref).oid, ((RemoteRef)ref).classname);
            }
        }
        catch (ClassNotFoundException e2) {
            throw new RemoteException(e2);
        }
        catch (IOException e3) {
            throw new RemoteException(e3);
        }
        catch (Exception e4) {
            throw new RemoteException(e4);
        }
        if (var1_3 != false) {
            void var2_5;
            return var2_5;
        }
        throw new RemoteException((String)var3_6);
    }

    /*
     * WARNING - void declaration
     */
    private void skipHeader(InputStream in) throws IOException {
        void var2_2;
        do {
            void var3_3;
            int c2;
            int len = 0;
            while ((c2 = in.read()) >= 0 && var3_3 != 13) {
                ++len;
            }
            in.read();
        } while (var2_2 > 0);
    }

    private void writeParameters(ObjectOutputStream dout, Object[] params) throws IOException {
        int n2 = params.length;
        dout.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (params[i2] instanceof Proxy) {
                Proxy p2 = (Proxy)params[i2];
                dout.writeObject(new RemoteRef(p2._getObjectId()));
                continue;
            }
            dout.writeObject(params[i2]);
        }
    }
}

