/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Translator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.ExportedObject;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.RemoteRef;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.rmi.StubGenerator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.web.BadHttpRequest;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.web.Webserver;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AppletServer
extends Webserver {
    private StubGenerator stubGen;
    private Map<String, ExportedObject> exportedNames = new Hashtable<String, ExportedObject>();
    private List<ExportedObject> exportedObjects = new Vector<ExportedObject>();
    private static final byte[] okHeader = "HTTP/1.0 200 OK\r\n\r\n".getBytes();

    /*
     * WARNING - void declaration
     */
    public AppletServer(String port) throws IOException, NotFoundException, CannotCompileException {
        this(Integer.parseInt((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AppletServer(int port) throws IOException, NotFoundException, CannotCompileException {
        this(ClassPool.getDefault(), new StubGenerator(), (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AppletServer(int port, ClassPool src) throws IOException, NotFoundException, CannotCompileException {
        this(new ClassPool((ClassPool)var2_2), new StubGenerator(), (int)var1_1);
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private AppletServer(ClassPool loader, StubGenerator gen, int port) throws IOException, NotFoundException, CannotCompileException {
        super((int)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.stubGen = gen;
        this.addTranslator((ClassPool)var1_1, (Translator)var2_2);
    }

    @Override
    public void run() {
        super.run();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int exportObject(String name, Object obj) throws CannotCompileException {
        void var2_3;
        Class<?> clazz = obj.getClass();
        ExportedObject eo = new ExportedObject();
        new ExportedObject().object = var2_3;
        eo.methods = clazz.getMethods();
        this.exportedObjects.add(eo);
        eo.identifier = this.exportedObjects.size() - 1;
        if (name != null) {
            this.exportedNames.put(name, eo);
        }
        try {
            void var3_4;
            this.stubGen.makeProxyClass((Class<?>)var3_4);
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new CannotCompileException((NotFoundException)var1_2);
        }
        return eo.identifier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doReply(InputStream in, OutputStream out, String cmd) throws IOException, BadHttpRequest {
        void var3_3;
        void var2_2;
        void var1_1;
        if (cmd.startsWith("POST /rmi ")) {
            this.processRMI(in, out);
            return;
        }
        if (cmd.startsWith("POST /lookup ")) {
            this.lookupName(cmd, in, out);
            return;
        }
        super.doReply((InputStream)var1_1, (OutputStream)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void processRMI(InputStream ins, OutputStream outs) throws IOException {
        void var1_1;
        void var3_4;
        void var2_2;
        ObjectInputStream in = new ObjectInputStream(ins);
        int objectId = in.readInt();
        int methodId = in.readInt();
        Exception err = null;
        Object rvalue = null;
        try {
            ExportedObject eo = this.exportedObjects.get(objectId);
            Object[] args2 = this.readParameters(in);
            rvalue = this.convertRvalue(eo.methods[methodId].invoke(eo.object, args2));
        }
        catch (Exception exception) {
            Exception e2 = exception;
            err = exception;
            this.logging2(e2.toString());
        }
        outs.write(okHeader);
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)var2_2);
        if (err != null) {
            out.writeBoolean(false);
            out.writeUTF(err.toString());
        } else {
            try {
                out.writeBoolean(true);
                out.writeObject(rvalue);
            }
            catch (NotSerializableException e3) {
                this.logging2(e3.toString());
            }
            catch (InvalidClassException e4) {
                this.logging2(e4.toString());
            }
        }
        out.flush();
        var3_4.close();
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    private Object[] readParameters(ObjectInputStream in) throws IOException, ClassNotFoundException {
        void var3_3;
        int n2 = in.readInt();
        Object[] args2 = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Object a2 = in.readObject();
            if (a2 instanceof RemoteRef) {
                RemoteRef ref = (RemoteRef)a2;
                object = this.exportedObjects.get(ref.oid);
                object = ((ExportedObject)object).object;
            }
            args2[i2] = object;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Object convertRvalue(Object rvalue) throws CannotCompileException {
        void var1_1;
        if (rvalue == null) {
            return null;
        }
        String classname = rvalue.getClass().getName();
        if (this.stubGen.isProxyClass(classname)) {
            void var2_2;
            return new RemoteRef(this.exportObject(null, rvalue), (String)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void lookupName(String cmd, InputStream ins, OutputStream outs) throws IOException {
        void var1_1;
        void var3_3;
        ObjectInputStream in = new ObjectInputStream(ins);
        String name = DataInputStream.readUTF(in);
        ExportedObject found = this.exportedNames.get(name);
        outs.write(okHeader);
        ObjectOutputStream out = new ObjectOutputStream(outs);
        if (found == null) {
            this.logging2(name + "not found.");
            out.writeInt(-1);
            out.writeUTF("error");
        } else {
            void var2_2;
            this.logging2((String)var2_2);
            out.writeInt(found.identifier);
            out.writeUTF(found.object.getClass().getName());
        }
        out.flush();
        var3_3.close();
        var1_1.close();
    }
}

