/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.scopedpool;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.LoaderClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.scopedpool.ScopedClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.scopedpool.ScopedClassPoolFactory;
import com.alibaba.ttl.threadpool.agent.internal.javassist.scopedpool.ScopedClassPoolFactoryImpl;
import com.alibaba.ttl.threadpool.agent.internal.javassist.scopedpool.ScopedClassPoolRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class ScopedClassPoolRepositoryImpl
implements ScopedClassPoolRepository {
    private static final ScopedClassPoolRepositoryImpl instance = new ScopedClassPoolRepositoryImpl();
    private boolean prune = true;
    boolean pruneWhenCached;
    protected Map<ClassLoader, ScopedClassPool> registeredCLs = Collections.synchronizedMap(new WeakHashMap());
    protected ClassPool classpool;
    protected ScopedClassPoolFactory factory = new ScopedClassPoolFactoryImpl();

    public static ScopedClassPoolRepository getInstance() {
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    private ScopedClassPoolRepositoryImpl() {
        void var1_1;
        this.classpool = ClassPool.getDefault();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.classpool.insertClassPath(new LoaderClassPath((ClassLoader)var1_1));
    }

    @Override
    public boolean isPrune() {
        return this.prune;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPrune(boolean prune) {
        void var1_1;
        this.prune = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScopedClassPool createScopedClassPool(ClassLoader cl, ClassPool src) {
        void var2_2;
        void var1_1;
        return this.factory.create((ClassLoader)var1_1, (ClassPool)var2_2, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassPool findClassPool(ClassLoader cl) {
        void var1_1;
        if (cl == null) {
            return this.registerClassLoader(ClassLoader.getSystemClassLoader());
        }
        return this.registerClassLoader((ClassLoader)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassPool registerClassLoader(ClassLoader ucl) {
        Map<ClassLoader, ScopedClassPool> map = this.registeredCLs;
        synchronized (map) {
            void var3_4;
            void var1_1;
            if (this.registeredCLs.containsKey(ucl)) {
                return this.registeredCLs.get(ucl);
            }
            ScopedClassPool pool = this.createScopedClassPool(ucl, this.classpool);
            this.registeredCLs.put((ClassLoader)var1_1, pool);
            return var3_4;
        }
    }

    @Override
    public Map<ClassLoader, ScopedClassPool> getRegisteredCLs() {
        this.clearUnregisteredClassLoaders();
        return this.registeredCLs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearUnregisteredClassLoaders() {
        ArrayList<ClassLoader> toUnregister = null;
        Map<ClassLoader, ScopedClassPool> map = this.registeredCLs;
        synchronized (map) {
            for (Map.Entry<ClassLoader, ScopedClassPool> reg : this.registeredCLs.entrySet()) {
                if (!reg.getValue().isUnloadedClassLoader()) continue;
                ClassLoader cl = ((ClassPool)reg.getValue()).getClassLoader();
                if (cl != null) {
                    if (toUnregister == null) {
                        toUnregister = new ArrayList<ClassLoader>();
                    }
                    toUnregister.add(cl);
                }
                this.registeredCLs.remove(reg.getKey());
            }
            if (toUnregister != null) {
                void var1_1;
                for (ClassLoader cl : var1_1) {
                    this.unregisterClassLoader(cl);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unregisterClassLoader(ClassLoader cl) {
        Map<ClassLoader, ScopedClassPool> map = this.registeredCLs;
        synchronized (map) {
            ScopedClassPool pool = this.registeredCLs.remove(cl);
            if (pool != null) {
                void var1_1;
                var1_1.close();
            }
            return;
        }
    }

    public void insertDelegate(ScopedClassPoolRepository delegate) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setClassPoolFactory(ScopedClassPoolFactory factory2) {
        void var1_1;
        this.factory = var1_1;
    }

    @Override
    public ScopedClassPoolFactory getClassPoolFactory() {
        return this.factory;
    }
}

