/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.scopedpool;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.LoaderClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.scopedpool.ScopedClassPoolRepository;
import com.alibaba.ttl.threadpool.agent.internal.javassist.scopedpool.SoftValueHashMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.Map;

public class ScopedClassPool
extends ClassPool {
    protected ScopedClassPoolRepository repository;
    protected Reference<ClassLoader> classLoader;
    protected LoaderClassPath classPath;
    protected Map<String, CtClass> softcache = new SoftValueHashMap<String, CtClass>();
    boolean isBootstrapCl = true;

    /*
     * WARNING - void declaration
     */
    protected ScopedClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        this((ClassLoader)var1_1, (ClassPool)var2_2, (ScopedClassPoolRepository)var3_3, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ScopedClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean isTemp) {
        super((ClassPool)var2_2);
        void var1_1;
        void var3_3;
        void var2_2;
        this.repository = var3_3;
        this.classLoader = new WeakReference<ClassLoader>(cl);
        if (cl != null) {
            this.classPath = new LoaderClassPath(cl);
            ScopedClassPool scopedClassPool = this;
            scopedClassPool.insertClassPath(scopedClassPool.classPath);
        }
        this.childFirstLookup = true;
        if (!isTemp && var1_1 == null) {
            this.isBootstrapCl = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassLoader getClassLoader() {
        void var1_1;
        ClassLoader cl = this.getClassLoader0();
        if (cl == null && !this.isBootstrapCl) {
            throw new IllegalStateException("ClassLoader has been garbage collected");
        }
        return var1_1;
    }

    protected ClassLoader getClassLoader0() {
        return this.classLoader.get();
    }

    public void close() {
        ScopedClassPool scopedClassPool = this;
        scopedClassPool.removeClassPath(scopedClassPool.classPath);
        this.classes.clear();
        this.softcache.clear();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void flushClass(String classname) {
        void var1_1;
        this.classes.remove(classname);
        this.softcache.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void soften(CtClass clazz) {
        void var1_1;
        if (this.repository.isPrune()) {
            clazz.prune();
        }
        this.classes.remove(clazz.getName());
        this.softcache.put(clazz.getName(), (CtClass)var1_1);
    }

    public boolean isUnloadedClassLoader() {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CtClass getCached(String classname) {
        Map<ClassLoader, ScopedClassPool> registeredCLs;
        int lastIndex;
        void var2_3;
        CtClass clazz = this.getCachedLocally(classname);
        if (clazz != null) return var2_3;
        boolean isLocal = false;
        ClassLoader dcl = this.getClassLoader0();
        if (dcl != null) {
            lastIndex = classname.lastIndexOf(36);
            String classResourceName = lastIndex < 0 ? classname.replaceAll("[\\.]", "/") + ".class" : classname.substring(0, lastIndex).replaceAll("[\\.]", "/") + classname.substring(lastIndex) + ".class";
            int n2 = lastIndex = dcl.getResource(classResourceName) != null ? 1 : 0;
        }
        if (lastIndex != false) return var2_3;
        Map<ClassLoader, ScopedClassPool> map = registeredCLs = this.repository.getRegisteredCLs();
        synchronized (registeredCLs) {
            Iterator iterator2;
            for (ScopedClassPool pool : iterator2.values()) {
                if (pool.isUnloadedClassLoader()) {
                    this.repository.unregisterClassLoader(((ClassPool)pool).getClassLoader());
                    continue;
                }
                clazz = pool.getCachedLocally(classname);
                if (clazz == null) continue;
                // ** MonitorExit[var5_7] (shouldn't be in output)
                return clazz;
            }
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void cacheCtClass(String classname, CtClass c2, boolean dynamic) {
        void var2_2;
        void var1_1;
        if (dynamic) {
            void var3_3;
            super.cacheCtClass(classname, c2, (boolean)var3_3);
            return;
        }
        if (this.repository.isPrune()) {
            c2.prune();
        }
        this.softcache.put((String)var1_1, (CtClass)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void lockInCache(CtClass c2) {
        void var1_1;
        super.cacheCtClass(c2.getName(), (CtClass)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    protected CtClass getCachedLocally(String classname) {
        Map<String, CtClass> map;
        CtClass cached = (CtClass)this.classes.get(classname);
        if (cached != null) {
            return map;
        }
        map = this.softcache;
        synchronized (map) {
            void var1_1;
            return this.softcache.get(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized CtClass getLocally(String classname) throws NotFoundException {
        void var2_2;
        this.softcache.remove(classname);
        CtClass clazz = (CtClass)this.classes.get(classname);
        if (clazz == null) {
            void var1_1;
            clazz = this.createCtClass(classname, true);
            if (clazz == null) {
                throw new NotFoundException(classname);
            }
            super.cacheCtClass((String)var1_1, clazz, false);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Class<?> toClass(CtClass ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        void var3_3;
        void var1_1;
        this.lockInCache(ct);
        return super.toClass((CtClass)var1_1, this.getClassLoader0(), (ProtectionDomain)var3_3);
    }

    static {
        ClassPool.doPruning = false;
        ClassPool.releaseUnmodifiedClassFile = false;
    }
}

